/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.load_management.JvbLoadMeasurement;
import org.jitsi.videobridge.load_management.JvbLoadReducer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 #*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002#$B)\b\u0007\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0013\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jitsi/videobridge/load_management/JvbLoadManager;", "T", "Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;", "", "jvbLoadThreshold", "jvbRecoveryThreshold", "loadReducer", "Lorg/jitsi/videobridge/load_management/JvbLoadReducer;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;Lorg/jitsi/videobridge/load_management/JvbLoadReducer;Ljava/time/Clock;)V", "Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;", "lastReducerTime", "Ljava/time/Instant;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "mostRecentLoadMeasurement", "reducerEnabled", "", "getReducerEnabled", "()Z", "reducerEnabled$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "state", "Lorg/jitsi/videobridge/load_management/JvbLoadManager$State;", "canRunReducer", "now", "getCurrentStressLevel", "", "getStats", "Lorg/jitsi/utils/OrderedJsonObject;", "loadUpdate", "", "loadMeasurement", "(Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;)V", "Companion", "State", "jitsi-videobridge"})
public final class JvbLoadManager<T extends JvbLoadMeasurement> {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final T jvbLoadThreshold;
    @NotNull
    private final T jvbRecoveryThreshold;
    @NotNull
    private final JvbLoadReducer loadReducer;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConfigDelegate reducerEnabled$delegate;
    @NotNull
    private Instant lastReducerTime;
    @NotNull
    private State state;
    @Nullable
    private T mostRecentLoadMeasurement;
    @NotNull
    private static final ConfigDelegate<Double> averageParticipantStress$delegate;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public JvbLoadManager(@NotNull T jvbLoadThreshold, @NotNull T jvbRecoveryThreshold, @NotNull JvbLoadReducer loadReducer, @NotNull Clock clock) {
        void supplier$iv;
        ConfigSourceSupplier $this$from$iv;
        Intrinsics.checkNotNullParameter(jvbLoadThreshold, "jvbLoadThreshold");
        Intrinsics.checkNotNullParameter(jvbRecoveryThreshold, "jvbRecoveryThreshold");
        Intrinsics.checkNotNullParameter(loadReducer, "loadReducer");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.jvbLoadThreshold = jvbLoadThreshold;
        this.jvbRecoveryThreshold = jvbRecoveryThreshold;
        this.loadReducer = loadReducer;
        this.clock = clock;
        Level level = Level.ALL;
        Intrinsics.checkNotNullExpressionValue(level, "ALL");
        this.logger = LoggerExtensionsKt.createLogger$default(this, level, null, 2, null);
        String string = "videobridge.load-management.reducer-enabled";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        $this$from$iv = new ConfigSourceSupplier((String)((Object)$this$from$iv), configSource$iv, Reflection.typeOf(Boolean.TYPE), DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        this.reducerEnabled$delegate = new ConfigDelegate((ConfigValueSupplier)supplier$iv);
        this.lastReducerTime = ClockUtils.NEVER;
        this.state = State.NOT_OVERLOADED;
    }

    public /* synthetic */ JvbLoadManager(JvbLoadMeasurement jvbLoadMeasurement, JvbLoadMeasurement jvbLoadMeasurement2, JvbLoadReducer jvbLoadReducer, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(jvbLoadMeasurement, jvbLoadMeasurement2, jvbLoadReducer, clock);
    }

    public final boolean getReducerEnabled() {
        return (Boolean)this.reducerEnabled$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void loadUpdate(@NotNull T loadMeasurement) {
        Logger logger;
        Intrinsics.checkNotNullParameter(loadMeasurement, "loadMeasurement");
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Got a load measurement of " + loadMeasurement);
        }
        this.mostRecentLoadMeasurement = loadMeasurement;
        Instant now = this.clock.instant();
        if (loadMeasurement.getLoad() >= this.jvbLoadThreshold.getLoad()) {
            this.state = State.OVERLOADED;
            if (this.getReducerEnabled()) {
                this.logger.info("Load measurement " + loadMeasurement + " is above threshold of " + this.jvbLoadThreshold);
                Intrinsics.checkNotNullExpressionValue(now, "now");
                if (this.canRunReducer(now)) {
                    this.logger.info("Running load reducer");
                    this.loadReducer.reduceLoad();
                    this.lastReducerTime = now;
                } else {
                    this.logger.info("Load reducer ran at " + this.lastReducerTime + ", which is within " + this.loadReducer.impactTime() + " of now, not running reduce");
                }
            }
        } else {
            this.state = State.NOT_OVERLOADED;
            if (this.getReducerEnabled() && loadMeasurement.getLoad() < this.jvbRecoveryThreshold.getLoad()) {
                boolean $i$f$cdebug2;
                Intrinsics.checkNotNullExpressionValue(now, "now");
                if (this.canRunReducer(now)) {
                    if (this.loadReducer.recover()) {
                        this.logger.info("Recovery ran after a load measurement of " + loadMeasurement + " (which was below threshold of " + this.jvbRecoveryThreshold + ") was received");
                        this.lastReducerTime = now;
                    } else {
                        Logger $this$cdebug$iv2 = this.logger;
                        $i$f$cdebug2 = false;
                        if ($this$cdebug$iv2.isDebugEnabled()) {
                            logger = $this$cdebug$iv2;
                            boolean bl = false;
                            logger.debug("Recovery had no work to do");
                        }
                    }
                } else {
                    Logger $this$cdebug$iv3 = this.logger;
                    $i$f$cdebug2 = false;
                    if ($this$cdebug$iv3.isDebugEnabled()) {
                        logger = $this$cdebug$iv3;
                        boolean bl = false;
                        logger.debug("Load measurement " + loadMeasurement + " is below recovery threshold, but load reducer ran at " + this.lastReducerTime + ", which is within " + this.loadReducer.impactTime() + " of now, not running recover");
                    }
                }
            }
        }
    }

    public final double getCurrentStressLevel() {
        T t = this.mostRecentLoadMeasurement;
        return t != null ? t.div((JvbLoadMeasurement)this.jvbLoadThreshold) : 0.0;
    }

    @NotNull
    public final OrderedJsonObject getStats() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getStats_u24lambda_u2d3 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$getStats_u24lambda_u2d3.put("state", this.state.toString());
        $this$getStats_u24lambda_u2d3.put("stress", String.valueOf(this.getCurrentStressLevel()));
        $this$getStats_u24lambda_u2d3.put("reducer_enabled", String.valueOf(this.getReducerEnabled()));
        $this$getStats_u24lambda_u2d3.put("reducer", this.loadReducer.getStats());
        return orderedJsonObject;
    }

    private final boolean canRunReducer(Instant now) {
        return Duration.between(this.lastReducerTime, now).compareTo(this.loadReducer.impactTime()) >= 0;
    }

    @JvmOverloads
    public JvbLoadManager(@NotNull T jvbLoadThreshold, @NotNull T jvbRecoveryThreshold, @NotNull JvbLoadReducer loadReducer) {
        Intrinsics.checkNotNullParameter(jvbLoadThreshold, "jvbLoadThreshold");
        Intrinsics.checkNotNullParameter(jvbRecoveryThreshold, "jvbRecoveryThreshold");
        Intrinsics.checkNotNullParameter(loadReducer, "loadReducer");
        this((JvbLoadMeasurement)jvbLoadThreshold, (JvbLoadMeasurement)jvbRecoveryThreshold, loadReducer, null, 8, null);
    }

    static {
        SupplierBuilder supplierBuilder;
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(JvbLoadManager.class, "reducerEnabled", "getReducerEnabled()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        boolean $i$f$config = false;
        SupplierBuilder $this$averageParticipantStress_delegate_u24lambda_u2d4 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Double.TYPE));
        boolean bl = false;
        $this$averageParticipantStress_delegate_u24lambda_u2d4.from("videobridge.load-management.average-participant-stress", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        averageParticipantStress$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/videobridge/load_management/JvbLoadManager$State;", "", "(Ljava/lang/String;I)V", "OVERLOADED", "NOT_OVERLOADED", "jitsi-videobridge"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State OVERLOADED = new State();
        public static final /* enum */ State NOT_OVERLOADED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.OVERLOADED, State.NOT_OVERLOADED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jitsi/videobridge/load_management/JvbLoadManager$Companion;", "", "()V", "averageParticipantStress", "", "getAverageParticipantStress", "()D", "averageParticipantStress$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "jitsi-videobridge"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        public final double getAverageParticipantStress() {
            return ((Number)averageParticipantStress$delegate.getValue(this, $$delegatedProperties[0])).doubleValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "averageParticipantStress", "getAverageParticipantStress()D", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

