/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocatorKt;
import org.jitsi.videobridge.cc.allocation.MediaSourceContainer;
import org.jitsi.videobridge.cc.allocation.PrioritizeKt;
import org.jitsi.videobridge.cc.allocation.SingleSourceAllocation;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001@BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u00103\u001a\u00020\u00132\f\u00104\u001a\b\u0012\u0004\u0012\u00020$0\bH\u0002J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001aJ\u001c\u00108\u001a\b\u0012\u0004\u0012\u0002090\b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020$0\bH\u0002J\u0006\u0010:\u001a\u000206J\u0015\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020$H\u0000\u00a2\u0006\u0002\b=J\b\u0010>\u001a\u000206H\u0002J\u0006\u0010?\u001a\u000206J\u000e\u0010?\u001a\u0002062\u0006\u0010\u0017\u001a\u00020\u0018R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8G\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#j\u0002`&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator;", "T", "Lorg/jitsi/videobridge/cc/allocation/MediaSourceContainer;", "", "eventHandler", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;", "endpointsSupplier", "Ljava/util/function/Supplier;", "", "trustBwe", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;Ljava/util/function/Supplier;Ljava/util/function/Supplier;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;Ljava/time/Clock;)V", "<set-?>", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "allocation", "getAllocation", "()Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "availableBandwidth", "", "getAvailableBandwidth", "()J", "bweBps", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "effectiveConstraints", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "eventEmitter", "Lorg/jitsi/utils/event/EventEmitter;", "expired", "lastUpdateTime", "Ljava/time/Instant;", "logger", "selectedSources", "", "getSelectedSources", "()Ljava/util/List;", "updateTask", "Ljava/util/concurrent/ScheduledFuture;", "allocate", "conferenceMediaSources", "bandwidthChanged", "", "newBandwidthBps", "createAllocations", "Lorg/jitsi/videobridge/cc/allocation/SingleSourceAllocation;", "expire", "hasNonZeroEffectiveConstraints", "source", "hasNonZeroEffectiveConstraints$jitsi_videobridge", "rescheduleUpdate", "update", "EventHandler", "jitsi-videobridge"})
public final class BandwidthAllocator<T extends MediaSourceContainer> {
    @NotNull
    private final Supplier<List<T>> endpointsSupplier;
    @NotNull
    private final Supplier<Boolean> trustBwe;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    private long bweBps;
    private boolean expired;
    @NotNull
    private Map<MediaSourceDesc, VideoConstraints> effectiveConstraints;
    @NotNull
    private final EventEmitter<EventHandler> eventEmitter;
    @NotNull
    private AllocationSettings allocationSettings;
    @NotNull
    private Instant lastUpdateTime;
    @NotNull
    private BandwidthAllocation allocation;
    @Nullable
    private ScheduledFuture<?> updateTask;

    /*
     * WARNING - void declaration
     */
    public BandwidthAllocator(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull Supplier<Boolean> trustBwe, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext, @NotNull Clock clock) {
        void $this$eventEmitter_u24lambda_u2d0;
        SyncEventEmitter syncEventEmitter;
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, "endpointsSupplier");
        Intrinsics.checkNotNullParameter(trustBwe, "trustBwe");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.endpointsSupplier = endpointsSupplier;
        this.trustBwe = trustBwe;
        this.diagnosticContext = diagnosticContext;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.bweBps = -1L;
        this.effectiveConstraints = MapsKt.emptyMap();
        SyncEventEmitter syncEventEmitter2 = syncEventEmitter = new SyncEventEmitter();
        BandwidthAllocator bandwidthAllocator = this;
        boolean bl = false;
        $this$eventEmitter_u24lambda_u2d0.addHandler(eventHandler);
        bandwidthAllocator.eventEmitter = syncEventEmitter;
        this.allocationSettings = new AllocationSettings(null, null, null, null, null, 0, new VideoConstraints(BitrateControllerConfig.config.thumbnailMaxHeightPx(), 0.0, 2, null), 63, null);
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        this.lastUpdateTime = instant;
        this.allocation = new BandwidthAllocation(SetsKt.emptySet(), false, 0L, 0L, null, 30, null);
        this.rescheduleUpdate();
    }

    @NotNull
    public final BandwidthAllocation getAllocation() {
        return this.allocation;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    @NotNull
    public final JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        ((Map)debugState).put("trustBwe", this.trustBwe.get());
        ((Map)debugState).put("bweBps", this.bweBps);
        ((Map)debugState).put("allocation", this.allocation.getDebugState());
        ((Map)debugState).put("allocationSettings", this.allocationSettings.toJson());
        ((Map)debugState).put("effectiveConstraints", this.effectiveConstraints);
        return debugState;
    }

    private final long getAvailableBandwidth() {
        Boolean bl = this.trustBwe.get();
        Intrinsics.checkNotNullExpressionValue(bl, "trustBwe.get()");
        return bl != false ? this.bweBps : Long.MAX_VALUE;
    }

    public final void bandwidthChanged(long newBandwidthBps) {
        if (!BandwidthAllocatorKt.access$bweChangeIsLargerThanThreshold(this.bweBps, newBandwidthBps)) {
            this.logger.debug(() -> BandwidthAllocator.bandwidthChanged$lambda-1(newBandwidthBps, this));
        } else {
            this.logger.debug(() -> BandwidthAllocator.bandwidthChanged$lambda-2(newBandwidthBps));
            this.bweBps = newBandwidthBps;
            this.update();
        }
    }

    public final void update(@NotNull AllocationSettings allocationSettings) {
        Intrinsics.checkNotNullParameter(allocationSettings, "allocationSettings");
        this.allocationSettings = allocationSettings;
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void update() {
        boolean effectiveConstraintsChanged;
        void $this$flatMapTo$iv$iv;
        if (this.expired) {
            return;
        }
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        this.lastUpdateTime = instant;
        List<T> list = this.endpointsSupplier.get();
        Intrinsics.checkNotNullExpressionValue(list, "endpointsSupplier.get()");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MediaSourceContainer it = (MediaSourceContainer)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList(it.getMediaSources());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List<MediaSourceDesc> sources = CollectionsKt.toMutableList((List)destination$iv$iv);
        List<MediaSourceDesc> sortedSources = PrioritizeKt.prioritize(sources, this.getSelectedSources());
        Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints = this.effectiveConstraints;
        Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints = PrioritizeKt.getEffectiveConstraints(sortedSources, this.allocationSettings);
        this.effectiveConstraints = newEffectiveConstraints;
        this.logger.trace(() -> BandwidthAllocator.update$lambda-5(sortedSources, newEffectiveConstraints));
        BandwidthAllocation newAllocation = this.allocate(sortedSources);
        boolean allocationChanged2 = !this.allocation.isTheSameAs(newAllocation);
        boolean bl = effectiveConstraintsChanged = !Intrinsics.areEqual(this.effectiveConstraints, oldEffectiveConstraints);
        if (allocationChanged2) {
            this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(newAllocation){
                final /* synthetic */ BandwidthAllocation $newAllocation;
                {
                    this.$newAllocation = $newAllocation;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.allocationChanged(this.$newAllocation);
                }
            });
        }
        this.allocation = newAllocation;
        this.logger.trace(() -> BandwidthAllocator.update$lambda-6(allocationChanged2, effectiveConstraintsChanged));
        if (effectiveConstraintsChanged) {
            this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(oldEffectiveConstraints, this){
                final /* synthetic */ Map<MediaSourceDesc, VideoConstraints> $oldEffectiveConstraints;
                final /* synthetic */ BandwidthAllocator<T> this$0;
                {
                    this.$oldEffectiveConstraints = $oldEffectiveConstraints;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.effectiveVideoConstraintsChanged(this.$oldEffectiveConstraints, BandwidthAllocator.access$getEffectiveConstraints$p(this.this$0));
                }
            });
        }
    }

    private final List<String> getSelectedSources() {
        List<String> selectedSources = CollectionsKt.toMutableList((Collection)this.allocationSettings.getOnStageSources());
        Iterable $this$forEach$iv = this.allocationSettings.getSelectedSources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (selectedSources.contains(it)) continue;
            selectedSources.add(it);
        }
        return selectedSources;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized BandwidthAllocation allocate(List<MediaSourceDesc> conferenceMediaSources) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SingleSourceAllocation it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<SingleSourceAllocation> sourceBitrateAllocations = this.createAllocations(conferenceMediaSources);
        if (sourceBitrateAllocations.isEmpty()) {
            return new BandwidthAllocation(SetsKt.emptySet(), false, 0L, 0L, null, 30, null);
        }
        long remainingBandwidth = this.getAvailableBandwidth();
        long oldRemainingBandwidth = -1L;
        boolean oversending = false;
        block0: while (oldRemainingBandwidth != remainingBandwidth) {
            oldRemainingBandwidth = remainingBandwidth;
            int n = sourceBitrateAllocations.size();
            for (int i = 0; i < n; ++i) {
                SingleSourceAllocation sourceBitrateAllocation = sourceBitrateAllocations.get(i);
                if (sourceBitrateAllocation.getConstraints().isDisabled()) continue;
                if ((remainingBandwidth -= sourceBitrateAllocation.improve(remainingBandwidth, i == 0)) < 0L) {
                    oversending = true;
                }
                if (sourceBitrateAllocation.isOnStage() && !sourceBitrateAllocation.hasReachedPreferred()) continue block0;
            }
        }
        Iterable iterable = sourceBitrateAllocations;
        boolean $i$f$filter = false;
        void var11_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleSourceAllocation)element$iv$iv;
            boolean bl = false;
            if (!it.isSuspended()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SingleSourceAllocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMediaSource().getSourceName());
        }
        List<String> suspendedIds = CollectionsKt.toList((List)destination$iv$iv);
        if (!((Collection)suspendedIds).isEmpty()) {
            this.logger.info("Sources suspended due to insufficient bandwidth (bwe=" + this.getAvailableBandwidth() + " bps): " + suspendedIds);
        }
        Set allocations = new LinkedHashSet();
        long targetBps = 0L;
        long idealBps = 0L;
        for (SingleSourceAllocation sourceBitrateAllocation : sourceBitrateAllocations) {
            allocations.add(sourceBitrateAllocation.getResult());
            targetBps += sourceBitrateAllocation.getTargetBitrate();
            idealBps += sourceBitrateAllocation.getIdealBitrate();
        }
        return new BandwidthAllocation(allocations, oversending, idealBps, targetBps, suspendedIds);
    }

    public final boolean hasNonZeroEffectiveConstraints$jitsi_videobridge(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter(source, "source");
        VideoConstraints videoConstraints = this.effectiveConstraints.get(source);
        if (videoConstraints == null) {
            return false;
        }
        VideoConstraints constraints = videoConstraints;
        return !constraints.isDisabled();
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized List<SingleSourceAllocation> createAllocations(List<MediaSourceDesc> conferenceMediaSources) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = conferenceMediaSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void source;
            MediaSourceDesc mediaSourceDesc = (MediaSourceDesc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = source.getOwner();
            VideoConstraints videoConstraints = this.effectiveConstraints.get(source);
            Intrinsics.checkNotNull(videoConstraints);
            collection.add(new SingleSourceAllocation(string, (MediaSourceDesc)source, videoConstraints, this.allocationSettings.getOnStageSources().contains(source.getSourceName()), this.diagnosticContext, this.clock, this.logger));
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    public final void expire() {
        block0: {
            this.expired = true;
            ScheduledFuture<?> scheduledFuture = this.updateTask;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(false);
        }
    }

    private final void rescheduleUpdate() {
        long l;
        Duration period;
        if (this.expired) {
            return;
        }
        Duration timeSinceLastUpdate = Duration.between(this.lastUpdateTime, this.clock.instant());
        if (timeSinceLastUpdate.compareTo(period = BitrateControllerConfig.config.maxTimeBetweenCalculations()) > 0) {
            this.logger.debug("Running periodic re-allocation.");
            TaskPools.CPU_POOL.execute(() -> BandwidthAllocator.rescheduleUpdate$lambda-11(this));
            l = period.toMillis();
        } else {
            l = period.minus(timeSinceLastUpdate).toMillis();
        }
        long delayMs = l;
        this.updateTask = TaskPools.SCHEDULED_POOL.schedule(() -> BandwidthAllocator.rescheduleUpdate$lambda-12(this), delayMs + (long)5, TimeUnit.MILLISECONDS);
    }

    private static final String bandwidthChanged$lambda-1(long $newBandwidthBps, BandwidthAllocator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "New bwe (" + $newBandwidthBps + ") is not significantly changed from previous bwe (" + this$0.bweBps + "), ignoring.";
    }

    private static final String bandwidthChanged$lambda-2(long $newBandwidthBps) {
        return "new bandwidth is " + $newBandwidthBps + ", updating";
    }

    /*
     * WARNING - void declaration
     */
    private static final String update$lambda-5(List $sortedSources, Map $newEffectiveConstraints) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($sortedSources, "$sortedSources");
        Intrinsics.checkNotNullParameter($newEffectiveConstraints, "$newEffectiveConstraints");
        Iterable $this$map$iv = $sortedSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaSourceDesc mediaSourceDesc = (MediaSourceDesc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSourceName());
        }
        return "Allocating: sortedSources=" + (List)destination$iv$iv + ",  effectiveConstraints=" + $newEffectiveConstraints;
    }

    private static final String update$lambda-6(boolean $allocationChanged, boolean $effectiveConstraintsChanged) {
        return "Finished allocation: allocationChanged=" + $allocationChanged + ", effectiveConstraintsChanged=" + $effectiveConstraintsChanged;
    }

    private static final void rescheduleUpdate$lambda-11(BandwidthAllocator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.update();
    }

    private static final void rescheduleUpdate$lambda-12(BandwidthAllocator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.rescheduleUpdate();
    }

    public static final /* synthetic */ Map access$getEffectiveConstraints$p(BandwidthAllocator $this) {
        return $this.effectiveConstraints;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J8\u0010\u0006\u001a\u00020\u00032\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000bH&\u00a8\u0006\r"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;", "", "allocationChanged", "", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "newEffectiveConstraints", "jitsi-videobridge"})
    public static interface EventHandler {
        public void allocationChanged(@NotNull BandwidthAllocation var1);

        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> var1, @NotNull Map<MediaSourceDesc, VideoConstraints> var2);
    }
}

