/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.AEADBadTagException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.jitsi.srtp.crypto.OpenSslAesCipherSpi;

public final class OpenSslAesGcmCipherSpi
extends OpenSslAesCipherSpi {
    private int tagLen;

    private static native long EVP_aes_128_gcm();

    private static native long EVP_aes_192_gcm();

    private static native long EVP_aes_256_gcm();

    private native boolean EVP_CipherFinal(long var1, byte[] var3, int var4);

    private native boolean CipherSetIVLen(long var1, int var3);

    private native boolean CipherSetTag(long var1, byte[] var3, int var4, int var5);

    private native boolean CipherGetTag(long var1, byte[] var3, int var4, int var5);

    public OpenSslAesGcmCipherSpi() {
        super("GCM");
    }

    @Override
    protected int getOutputSize(int inputLen, boolean forFinal) {
        if (this.opmode == 1) {
            if (forFinal) {
                return inputLen + this.tagLen;
            }
            return inputLen;
        }
        return Math.max(inputLen - this.tagLen, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int newIvLen = 0;
        if (params == null) throw new InvalidAlgorithmParameterException("IV parameter missing");
        if (!(params instanceof GCMParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + params);
        if (((GCMParameterSpec)params).getTLen() != 128) {
            throw new InvalidAlgorithmParameterException("Unsupported GCM tag length: must be 128");
        }
        this.tagLen = ((GCMParameterSpec)params).getTLen() / 8;
        byte[] newIv = ((GCMParameterSpec)params).getIV();
        if (this.iv == null && newIv.length != 12 || this.iv != null && this.iv.length != newIv.length) {
            newIvLen = newIv.length;
        }
        this.iv = newIv;
        if (newIvLen != 0 && !this.CipherSetIVLen(this.ctx.ptr, newIvLen)) {
            throw new InvalidAlgorithmParameterException("Unsupported IV length " + newIvLen);
        }
        this.doEngineInit(opmode, key);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.opmode != 1) {
            throw new UnsupportedOperationException("Update not supported for GCM Decryption");
        }
        return super.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected void engineUpdateAAD(byte[] input, int inputOffset, int inputLen) {
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("Input buffer length " + input.length + " is too short for offset " + inputOffset + " plus length " + inputLen);
        }
        this.doCipherUpdate(input, inputOffset, inputLen, null, 0);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, AEADBadTagException {
        int outLen;
        int needed = this.getOutputSize(inputLen, false);
        if (output.length - outputOffset < needed) {
            throw new ShortBufferException("Output buffer needs at least " + needed + "bytes");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("Input buffer length " + input.length + " is too short for offset " + inputOffset + " plus length " + inputLen);
        }
        if (this.opmode == 1) {
            this.doCipherUpdate(input, inputOffset, inputLen, output, outputOffset);
            outLen = inputLen;
        } else {
            if (inputLen < this.tagLen) {
                throw new AEADBadTagException("Input too short - need tag");
            }
            int ciphertextLen = inputLen - this.tagLen;
            this.doCipherUpdate(input, inputOffset, ciphertextLen, output, outputOffset);
            outLen = ciphertextLen;
            int tagOffset = inputOffset + ciphertextLen;
            if (!this.CipherSetTag(this.ctx.ptr, input, tagOffset, this.tagLen)) {
                throw new IllegalStateException("Failure in EVP_CipherSetTag");
            }
        }
        if (!this.EVP_CipherFinal(this.ctx.ptr, output, outputOffset + outLen)) {
            if (this.opmode == 2) {
                throw new AEADBadTagException("Bad AEAD tag");
            }
            throw new IllegalStateException("Failure in EVP_CipherFinal");
        }
        if (this.opmode == 1) {
            if (!this.CipherGetTag(this.ctx.ptr, output, outputOffset + outLen, this.tagLen)) {
                throw new IllegalStateException("Failure in EVP_CipherGetTag");
            }
            outLen += this.tagLen;
        }
        return outLen;
    }

    @Override
    protected long getOpenSSLCipher(Key key) throws InvalidKeyException {
        switch (key.getEncoded().length) {
            case 16: {
                return OpenSslAesGcmCipherSpi.EVP_aes_128_gcm();
            }
            case 24: {
                return OpenSslAesGcmCipherSpi.EVP_aes_192_gcm();
            }
            case 32: {
                return OpenSslAesGcmCipherSpi.EVP_aes_256_gcm();
            }
        }
        throw new InvalidKeyException("Invalid AES key length: " + key.getEncoded().length + " bytes");
    }
}

