/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/AbsSendTimeHeaderExtension;", "", "()V", "Companion", "rtp"})
public final class AbsSendTimeHeaderExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DATA_SIZE_BYTES = 3;
    private static final int b = 1000000000;

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/AbsSendTimeHeaderExtension$Companion;", "", "()V", "DATA_SIZE_BYTES", "", "b", "getTime", "Ljava/time/Instant;", "buf", "", "dataOffset", "ext", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "setTime", "", "offset", "timestampNanos", "", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final void setTime(@NotNull RtpPacket.HeaderExtension ext, long timestampNanos) {
            Intrinsics.checkNotNullParameter(ext, "ext");
            this.setTime(ext.getBuffer(), ext.getDataOffset(), timestampNanos);
        }

        private final void setTime(byte[] buf, int offset, long timestampNanos) {
            long fraction = timestampNanos % (long)1000000000 * (long)262144 / (long)1000000000;
            long seconds = timestampNanos / (long)1000000000 % (long)64;
            long timestamp = (seconds << 18 | fraction) & 0xFFFFFFL;
            ByteArrayExtensionsKt.put3Bytes(buf, offset, (int)timestamp);
        }

        @NotNull
        public final Instant getTime(@NotNull RtpPacket.HeaderExtension ext) {
            Intrinsics.checkNotNullParameter(ext, "ext");
            return this.getTime(ext.getBuffer(), ext.getDataOffset());
        }

        private final Instant getTime(byte[] buf, int dataOffset) {
            int seconds = FieldParsersKt.getBitsAsInt(buf, dataOffset, 0, 6);
            double fraction = (double)(FieldParsersKt.getBitsAsInt(buf, dataOffset, 6, 2) + FieldParsersKt.getShortAsInt(buf, dataOffset + 1)) / (double)262143;
            Instant instantMillis = Instant.ofEpochSecond(seconds);
            Instant instant = instantMillis.plusNanos((long)(fraction * (double)1000000000));
            Intrinsics.checkNotNullExpressionValue(instant, "instantMillis.plusNanos((fraction * b).toLong())");
            return instant;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

