/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.StatsKeepingNode;
import org.jitsi.nlj.transform.node.debug.PayloadVerificationPlugin;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.NodeStatsBlockExtensionsKt;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0004J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0005 !\"#$\u00a8\u0006%"}, d2={"Lorg/jitsi/nlj/transform/node/StatsKeepingNode;", "Lorg/jitsi/nlj/transform/node/Node;", "name", "", "(Ljava/lang/String;)V", "aggregationKey", "getAggregationKey", "()Ljava/lang/String;", "firstPacketTime", "", "lastPacketTime", "startTime", "stats", "Lorg/jitsi/nlj/transform/node/StatsKeepingNode$NodeStats;", "stopped", "", "doProcessPacket", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "doneProcessing", "packetInfos", "", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "onEntry", "packetDiscarded", "processPacket", "stop", "Companion", "NodeStats", "Lorg/jitsi/nlj/transform/node/NeverDiscardNode;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "Lorg/jitsi/nlj/transform/node/ConsumerNode;", "Lorg/jitsi/nlj/transform/node/MultipleOutputTransformerNode;", "Lorg/jitsi/nlj/transform/node/DemuxerNode;", "jitsi-media-transform"})
public abstract class StatsKeepingNode
extends Node {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long startTime;
    private long firstPacketTime = -1L;
    private long lastPacketTime = -1L;
    @NotNull
    private final NodeStats stats = new NodeStats(0L, 0L, 0L, 0L, 0L, 0L, 63, null);
    private boolean stopped;
    @NotNull
    private final String aggregationKey;
    @NotNull
    private static final Map<String, NodeStatsBlock> globalStats = new ConcurrentHashMap();
    private static boolean enableStatistics = true;

    private StatsKeepingNode(String name) {
        super(name, null);
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue(string, "javaClass.name");
        String[] stringArray = new String[]{"."};
        this.aggregationKey = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null));
    }

    protected abstract void doProcessPacket(@NotNull PacketInfo var1);

    @Override
    public void processPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        this.onEntry(packetInfo);
        if (Node.Companion.getTRACE_ENABLED()) {
            this.trace(new Function0<Unit>(this, packetInfo){
                final /* synthetic */ StatsKeepingNode this$0;
                final /* synthetic */ PacketInfo $packetInfo;
                {
                    this.this$0 = $receiver;
                    this.$packetInfo = $packetInfo;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.doProcessPacket(this.$packetInfo);
                }
            });
        } else {
            this.doProcessPacket(packetInfo);
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d0 = nodeStatsBlock = new NodeStatsBlock("Node " + this.getName() + " " + this.hashCode());
        boolean bl = false;
        this.stats.appendTo($this$getNodeStats_u24lambda_u2d0);
        long numBytes = this.stats.getNumInputBytes();
        Duration duration = Duration.ofNanos(this.lastPacketTime - this.firstPacketTime);
        $this$getNodeStats_u24lambda_u2d0.addNumber("num_input_bytes", numBytes);
        $this$getNodeStats_u24lambda_u2d0.addNumber("duration_ms", duration.toMillis());
        NodeStatsBlockExtensionsKt.addMbps($this$getNodeStats_u24lambda_u2d0, "throughput_mbps", "num_input_bytes", "duration_ms");
        return nodeStatsBlock;
    }

    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        return this.getNodeStats();
    }

    @NotNull
    protected String getAggregationKey() {
        return this.aggregationKey;
    }

    private final void onEntry(PacketInfo packetInfo) {
        if (enableStatistics) {
            this.startTime = System.nanoTime();
            if (this.firstPacketTime == -1L) {
                this.firstPacketTime = this.startTime;
            }
            NodeStats nodeStats = this.stats;
            long l = nodeStats.getNumInputPackets();
            nodeStats.setNumInputPackets(l + 1L);
            nodeStats = this.stats;
            nodeStats.setNumInputBytes(nodeStats.getNumInputBytes() + (long)packetInfo.getPacket().length);
            packetInfo.addEvent(this.getNodeEntryString());
            this.lastPacketTime = this.startTime;
        }
    }

    protected final void doneProcessing(@Nullable PacketInfo packetInfo) {
        block1: {
            if (!enableStatistics) break block1;
            long processingDuration = System.nanoTime() - this.startTime;
            NodeStats nodeStats = this.stats;
            nodeStats.setTotalProcessingDurationNs(nodeStats.getTotalProcessingDurationNs() + processingDuration);
            this.stats.setMaxProcessingDurationNs(Math.max(this.stats.getMaxProcessingDurationNs(), processingDuration));
            PacketInfo packetInfo2 = packetInfo;
            if (packetInfo2 != null) {
                PacketInfo it = packetInfo2;
                boolean bl = false;
                NodeStats nodeStats2 = this.stats;
                long l = nodeStats2.getNumOutputPackets();
                nodeStats2.setNumOutputPackets(l + 1L);
                it.addEvent(this.getNodeExitString());
            }
        }
    }

    protected final void doneProcessing(@NotNull List<? extends PacketInfo> packetInfos) {
        Intrinsics.checkNotNullParameter(packetInfos, "packetInfos");
        if (enableStatistics) {
            long processingDuration = System.nanoTime() - this.startTime;
            NodeStats nodeStats = this.stats;
            nodeStats.setTotalProcessingDurationNs(nodeStats.getTotalProcessingDurationNs() + processingDuration);
            this.stats.setMaxProcessingDurationNs(Math.max(this.stats.getMaxProcessingDurationNs(), processingDuration));
            nodeStats = this.stats;
            nodeStats.setNumOutputPackets(nodeStats.getNumOutputPackets() + (long)packetInfos.size());
            Iterable $this$forEach$iv = packetInfos;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PacketInfo it = (PacketInfo)element$iv;
                boolean bl = false;
                it.addEvent(this.getNodeExitString());
            }
        }
    }

    protected void packetDiscarded(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        NodeStats nodeStats = this.stats;
        long l = nodeStats.getNumDiscardedPackets();
        nodeStats.setNumDiscardedPackets(l + 1L);
        Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
        Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
        function1.invoke(packetInfo.getPacket().buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (enableStatistics && this.stats.getNumInputPackets() > 0L) {
            Map<String, NodeStatsBlock> map = globalStats;
            synchronized (map) {
                boolean bl = false;
                NodeStatsBlock nodeStatsBlock = globalStats.computeIfAbsent(this.getAggregationKey(), arg_0 -> StatsKeepingNode.stop$lambda-4$lambda-3(this, arg_0));
                Intrinsics.checkNotNullExpressionValue(nodeStatsBlock, "globalStats.computeIfAbs\u2026tsBlock(aggregationKey) }");
                NodeStatsBlock classStats = nodeStatsBlock;
                classStats.aggregate(this.getNodeStatsToAggregate());
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private static final NodeStatsBlock stop$lambda-4$lambda-3(StatsKeepingNode this$0, String it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return new NodeStatsBlock(this$0.getAggregationKey());
    }

    public /* synthetic */ StatsKeepingNode(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/nlj/transform/node/StatsKeepingNode$Companion;", "", "()V", "enableStatistics", "", "getEnableStatistics", "()Z", "setEnableStatistics", "(Z)V", "globalStats", "", "", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getStatsJson", "Lorg/json/simple/JSONObject;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getEnableStatistics() {
            return enableStatistics;
        }

        public final void setEnableStatistics(boolean bl) {
            enableStatistics = bl;
        }

        @NotNull
        public final JSONObject getStatsJson() {
            JSONObject jsonObject = new JSONObject();
            Map $this$forEach$iv = globalStats;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                String className = (String)entry.getKey();
                NodeStatsBlock stats = (NodeStatsBlock)entry.getValue();
                ((Map)jsonObject).put(className, stats.toJson());
            }
            ((Map)jsonObject).put("num_payload_verification_failures", PayloadVerificationPlugin.Companion.getNumFailures().get());
            return jsonObject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003JE\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011\u00a8\u0006."}, d2={"Lorg/jitsi/nlj/transform/node/StatsKeepingNode$NodeStats;", "", "totalProcessingDurationNs", "", "numInputPackets", "numOutputPackets", "numInputBytes", "numDiscardedPackets", "maxProcessingDurationNs", "(JJJJJJ)V", "maxProcessingDurationMs", "", "getMaxProcessingDurationMs", "()D", "getMaxProcessingDurationNs", "()J", "setMaxProcessingDurationNs", "(J)V", "getNumDiscardedPackets", "setNumDiscardedPackets", "getNumInputBytes", "setNumInputBytes", "getNumInputPackets", "setNumInputPackets", "getNumOutputPackets", "setNumOutputPackets", "getTotalProcessingDurationNs", "setTotalProcessingDurationNs", "appendTo", "", "block", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    public static final class NodeStats {
        private long totalProcessingDurationNs;
        private long numInputPackets;
        private long numOutputPackets;
        private long numInputBytes;
        private long numDiscardedPackets;
        private long maxProcessingDurationNs;

        public NodeStats(long totalProcessingDurationNs, long numInputPackets, long numOutputPackets, long numInputBytes, long numDiscardedPackets, long maxProcessingDurationNs) {
            this.totalProcessingDurationNs = totalProcessingDurationNs;
            this.numInputPackets = numInputPackets;
            this.numOutputPackets = numOutputPackets;
            this.numInputBytes = numInputBytes;
            this.numDiscardedPackets = numDiscardedPackets;
            this.maxProcessingDurationNs = maxProcessingDurationNs;
        }

        public /* synthetic */ NodeStats(long l, long l2, long l3, long l4, long l5, long l6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                l4 = 0L;
            }
            if ((n & 0x10) != 0) {
                l5 = 0L;
            }
            if ((n & 0x20) != 0) {
                l6 = 0L;
            }
            this(l, l2, l3, l4, l5, l6);
        }

        public final long getTotalProcessingDurationNs() {
            return this.totalProcessingDurationNs;
        }

        public final void setTotalProcessingDurationNs(long l) {
            this.totalProcessingDurationNs = l;
        }

        public final long getNumInputPackets() {
            return this.numInputPackets;
        }

        public final void setNumInputPackets(long l) {
            this.numInputPackets = l;
        }

        public final long getNumOutputPackets() {
            return this.numOutputPackets;
        }

        public final void setNumOutputPackets(long l) {
            this.numOutputPackets = l;
        }

        public final long getNumInputBytes() {
            return this.numInputBytes;
        }

        public final void setNumInputBytes(long l) {
            this.numInputBytes = l;
        }

        public final long getNumDiscardedPackets() {
            return this.numDiscardedPackets;
        }

        public final void setNumDiscardedPackets(long l) {
            this.numDiscardedPackets = l;
        }

        public final long getMaxProcessingDurationNs() {
            return this.maxProcessingDurationNs;
        }

        public final void setMaxProcessingDurationNs(long l) {
            this.maxProcessingDurationNs = l;
        }

        private final double getMaxProcessingDurationMs() {
            return (double)this.maxProcessingDurationNs / 1000000.0;
        }

        public final void appendTo(@NotNull NodeStatsBlock block) {
            NodeStatsBlock nodeStatsBlock;
            Intrinsics.checkNotNullParameter(block, "block");
            NodeStatsBlock $this$appendTo_u24lambda_u2d0 = nodeStatsBlock = block;
            boolean bl = false;
            $this$appendTo_u24lambda_u2d0.addNumber("num_input_packets", this.numInputPackets);
            $this$appendTo_u24lambda_u2d0.addNumber("num_output_packets", this.numOutputPackets);
            $this$appendTo_u24lambda_u2d0.addNumber("num_discarded_packets", this.numDiscardedPackets);
            $this$appendTo_u24lambda_u2d0.addNumber("total_time_spent_ns", this.totalProcessingDurationNs);
            $this$appendTo_u24lambda_u2d0.addCompoundValue("total_time_spent_ms", appendTo.1.1.INSTANCE);
            NodeStatsBlockExtensionsKt.addRatio$default($this$appendTo_u24lambda_u2d0, "average_time_per_packet_ns", "total_time_spent_ns", "num_input_packets", null, 8, null);
            NodeStatsBlockExtensionsKt.addMbps($this$appendTo_u24lambda_u2d0, "processing_throughput_mbps", "num_input_bytes", "total_time_spent_ms");
            $this$appendTo_u24lambda_u2d0.addNumber("max_packet_process_time_ms", this.getMaxProcessingDurationMs());
        }

        public final long component1() {
            return this.totalProcessingDurationNs;
        }

        public final long component2() {
            return this.numInputPackets;
        }

        public final long component3() {
            return this.numOutputPackets;
        }

        public final long component4() {
            return this.numInputBytes;
        }

        public final long component5() {
            return this.numDiscardedPackets;
        }

        public final long component6() {
            return this.maxProcessingDurationNs;
        }

        @NotNull
        public final NodeStats copy(long totalProcessingDurationNs, long numInputPackets, long numOutputPackets, long numInputBytes, long numDiscardedPackets, long maxProcessingDurationNs) {
            return new NodeStats(totalProcessingDurationNs, numInputPackets, numOutputPackets, numInputBytes, numDiscardedPackets, maxProcessingDurationNs);
        }

        public static /* synthetic */ NodeStats copy$default(NodeStats nodeStats, long l, long l2, long l3, long l4, long l5, long l6, int n, Object object) {
            if ((n & 1) != 0) {
                l = nodeStats.totalProcessingDurationNs;
            }
            if ((n & 2) != 0) {
                l2 = nodeStats.numInputPackets;
            }
            if ((n & 4) != 0) {
                l3 = nodeStats.numOutputPackets;
            }
            if ((n & 8) != 0) {
                l4 = nodeStats.numInputBytes;
            }
            if ((n & 0x10) != 0) {
                l5 = nodeStats.numDiscardedPackets;
            }
            if ((n & 0x20) != 0) {
                l6 = nodeStats.maxProcessingDurationNs;
            }
            return nodeStats.copy(l, l2, l3, l4, l5, l6);
        }

        @NotNull
        public String toString() {
            return "NodeStats(totalProcessingDurationNs=" + this.totalProcessingDurationNs + ", numInputPackets=" + this.numInputPackets + ", numOutputPackets=" + this.numOutputPackets + ", numInputBytes=" + this.numInputBytes + ", numDiscardedPackets=" + this.numDiscardedPackets + ", maxProcessingDurationNs=" + this.maxProcessingDurationNs + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.totalProcessingDurationNs);
            result2 = result2 * 31 + Long.hashCode(this.numInputPackets);
            result2 = result2 * 31 + Long.hashCode(this.numOutputPackets);
            result2 = result2 * 31 + Long.hashCode(this.numInputBytes);
            result2 = result2 * 31 + Long.hashCode(this.numDiscardedPackets);
            result2 = result2 * 31 + Long.hashCode(this.maxProcessingDurationNs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NodeStats)) {
                return false;
            }
            NodeStats nodeStats = (NodeStats)other;
            if (this.totalProcessingDurationNs != nodeStats.totalProcessingDurationNs) {
                return false;
            }
            if (this.numInputPackets != nodeStats.numInputPackets) {
                return false;
            }
            if (this.numOutputPackets != nodeStats.numOutputPackets) {
                return false;
            }
            if (this.numInputBytes != nodeStats.numInputBytes) {
                return false;
            }
            if (this.numDiscardedPackets != nodeStats.numDiscardedPackets) {
                return false;
            }
            return this.maxProcessingDurationNs == nodeStats.maxProcessingDurationNs;
        }

        public NodeStats() {
            this(0L, 0L, 0L, 0L, 0L, 0L, 63, null);
        }
    }
}

