/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.stats;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/stats/JitterStats;", "", "()V", "<set-?>", "", "jitter", "getJitter", "()D", "previousPacketReceivedTimestamp", "Ljava/time/Instant;", "previousPacketSentTimestamp", "addPacket", "", "currentPacketSentTimestamp", "currentPacketReceivedTimestamp", "Companion", "jitsi-media-transform"})
public class JitterStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double jitter;
    @Nullable
    private Instant previousPacketReceivedTimestamp;
    @Nullable
    private Instant previousPacketSentTimestamp;

    public final double getJitter() {
        return this.jitter;
    }

    public final void addPacket(@NotNull Instant currentPacketSentTimestamp, @NotNull Instant currentPacketReceivedTimestamp) {
        Intrinsics.checkNotNullParameter(currentPacketSentTimestamp, "currentPacketSentTimestamp");
        Intrinsics.checkNotNullParameter(currentPacketReceivedTimestamp, "currentPacketReceivedTimestamp");
        if (this.previousPacketReceivedTimestamp != null) {
            Instant instant = this.previousPacketSentTimestamp;
            Intrinsics.checkNotNull(instant);
            Instant instant2 = this.previousPacketReceivedTimestamp;
            Intrinsics.checkNotNull(instant2);
            this.jitter = Companion.calculateJitter(this.jitter, instant, instant2, currentPacketSentTimestamp, currentPacketReceivedTimestamp);
        }
        this.previousPacketSentTimestamp = currentPacketSentTimestamp;
        this.previousPacketReceivedTimestamp = currentPacketReceivedTimestamp;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/nlj/stats/JitterStats$Companion;", "", "()V", "calculateJitter", "", "currentJitter", "previousPacketSentTimestamp", "Ljava/time/Instant;", "previousPacketReceivedTimestamp", "currentPacketSentTimestamp", "currentPacketReceivedTimestamp", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final double calculateJitter(double currentJitter, @NotNull Instant previousPacketSentTimestamp, @NotNull Instant previousPacketReceivedTimestamp, @NotNull Instant currentPacketSentTimestamp, @NotNull Instant currentPacketReceivedTimestamp) {
            Intrinsics.checkNotNullParameter(previousPacketSentTimestamp, "previousPacketSentTimestamp");
            Intrinsics.checkNotNullParameter(previousPacketReceivedTimestamp, "previousPacketReceivedTimestamp");
            Intrinsics.checkNotNullParameter(currentPacketSentTimestamp, "currentPacketSentTimestamp");
            Intrinsics.checkNotNullParameter(currentPacketReceivedTimestamp, "currentPacketReceivedTimestamp");
            Duration delta = Duration.between(previousPacketSentTimestamp, previousPacketReceivedTimestamp).minus(Duration.between(currentPacketSentTimestamp, currentPacketReceivedTimestamp));
            return currentJitter + ((double)Math.abs(delta.toMillis()) - currentJitter) / 16.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

