/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsECDSA13Verifier
extends BcTlsVerifier {
    private final int signatureScheme;

    public BcTlsECDSA13Verifier(BcTlsCrypto bcTlsCrypto, ECPublicKeyParameters eCPublicKeyParameters, int n) {
        super(bcTlsCrypto, eCPublicKeyParameters);
        if (!SignatureScheme.isECDSA(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = n;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        int n = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        ECDSASigner eCDSASigner = new ECDSASigner(new HMacDSAKCalculator(this.crypto.createDigest(n)));
        DSADigestSigner dSADigestSigner = new DSADigestSigner(eCDSASigner, new NullDigest());
        dSADigestSigner.init(false, this.publicKey);
        dSADigestSigner.update(byArray, 0, byArray.length);
        return dSADigestSigner.verifySignature(digitallySigned.getSignature());
    }
}

