/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDH;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.util.BigIntegers;

public class BcTlsDHDomain
implements TlsDHDomain {
    protected BcTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameters dhParameters;

    private static byte[] encodeValue(DHParameters dHParameters, boolean bl, BigInteger bigInteger) {
        return bl ? BigIntegers.asUnsignedByteArray(BcTlsDHDomain.getValueLength(dHParameters), bigInteger) : BigIntegers.asUnsignedByteArray(bigInteger);
    }

    private static int getValueLength(DHParameters dHParameters) {
        return (dHParameters.getP().bitLength() + 7) / 8;
    }

    public static BcTlsSecret calculateDHAgreement(BcTlsCrypto bcTlsCrypto, DHPrivateKeyParameters dHPrivateKeyParameters, DHPublicKeyParameters dHPublicKeyParameters, boolean bl) {
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init(dHPrivateKeyParameters);
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHPublicKeyParameters);
        byte[] byArray = BcTlsDHDomain.encodeValue(dHPrivateKeyParameters.getParameters(), bl, bigInteger);
        return bcTlsCrypto.adoptLocalSecret(byArray);
    }

    public static DHParameters getParameters(TlsDHConfig tlsDHConfig) {
        DHGroup dHGroup = TlsDHUtils.getDHGroup(tlsDHConfig);
        if (dHGroup == null) {
            throw new IllegalArgumentException("No DH configuration provided");
        }
        return new DHParameters(dHGroup.getP(), dHGroup.getG(), dHGroup.getQ(), dHGroup.getL());
    }

    public BcTlsDHDomain(BcTlsCrypto bcTlsCrypto, TlsDHConfig tlsDHConfig) {
        this.crypto = bcTlsCrypto;
        this.dhConfig = tlsDHConfig;
        this.dhParameters = BcTlsDHDomain.getParameters(tlsDHConfig);
    }

    public BcTlsSecret calculateDHAgreement(DHPrivateKeyParameters dHPrivateKeyParameters, DHPublicKeyParameters dHPublicKeyParameters) {
        return BcTlsDHDomain.calculateDHAgreement(this.crypto, dHPrivateKeyParameters, dHPublicKeyParameters, this.dhConfig.isPadded());
    }

    public TlsAgreement createDH() {
        return new BcTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] byArray) throws IOException {
        if (this.dhConfig.isPadded() && BcTlsDHDomain.getValueLength(this.dhParameters) != byArray.length) {
            throw new TlsFatalAlert(47);
        }
        return new BigInteger(1, byArray);
    }

    public DHPublicKeyParameters decodePublicKey(byte[] byArray) throws IOException {
        try {
            BigInteger bigInteger = this.decodeParameter(byArray);
            return new DHPublicKeyParameters(bigInteger, this.dhParameters);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(40, (Throwable)runtimeException);
        }
    }

    public byte[] encodeParameter(BigInteger bigInteger) throws IOException {
        return BcTlsDHDomain.encodeValue(this.dhParameters, this.dhConfig.isPadded(), bigInteger);
    }

    public byte[] encodePublicKey(DHPublicKeyParameters dHPublicKeyParameters) throws IOException {
        return BcTlsDHDomain.encodeValue(this.dhParameters, true, dHPublicKeyParameters.getY());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(new DHKeyGenerationParameters(this.crypto.getSecureRandom(), this.dhParameters));
        return dHBasicKeyPairGenerator.generateKeyPair();
    }
}

