/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.treenode.AbstractTypeFileTreeNodeFactoryProvider;
import org.jd.gui.service.treenode.ClassFileTreeNodeFactoryProvider;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.view.component.ModuleInfoFilePage;
import org.jd.gui.view.data.TreeNodeBean;

public class ModuleInfoFileTreeNodeFactoryProvider
extends ClassFileTreeNodeFactoryProvider {
    protected static final ImageIcon MODULE_FILE_ICON;
    protected static final Factory FACTORY;

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*/module-info.class");
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern;
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf(47);
        String label = entry.getPath().substring(lastSlashIndex + 1);
        return (T)new ModuleInfoFileTreeNode(entry, new TreeNodeBean(label, CLASS_FILE_ICON), FACTORY);
    }

    static {
        block2: {
            MODULE_FILE_ICON = new ImageIcon(ClassFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/module_obj.png"));
            FACTORY = new Factory();
            try {
                Class.forName(ModuleInfoFilePage.class.getName());
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block2;
                throw new AssertionError();
            }
        }
    }

    protected static class Factory
    implements AbstractTypeFileTreeNodeFactoryProvider.PageAndTipFactory {
        protected Factory() {
        }

        @Override
        public <T extends JComponent> T makePage(API a, Container.Entry e) {
            return (T)new ModuleInfoFilePage(a, e);
        }

        @Override
        public String makeTip(API api, Container.Entry entry) {
            String location = new File(entry.getUri()).getPath();
            StringBuilder tip = new StringBuilder("<html>Location: ");
            tip.append(location);
            tip.append("</html>");
            return tip.toString();
        }
    }

    protected static class ModuleInfoFileTreeNode
    extends AbstractTypeFileTreeNodeFactoryProvider.FileTreeNode {
        public ModuleInfoFileTreeNode(Container.Entry entry, Object userObject, AbstractTypeFileTreeNodeFactoryProvider.PageAndTipFactory pageAndTipFactory) {
            super(entry, null, userObject, pageAndTipFactory);
        }

        @Override
        public void populateTreeNode(API api) {
            if (!this.initialized) {
                this.removeAllChildren();
                TypeFactory typeFactory = api.getTypeFactory(this.entry);
                if (typeFactory != null) {
                    Collection<Type> types = typeFactory.make(api, this.entry);
                    for (Type type : types) {
                        this.add(new AbstractTypeFileTreeNodeFactoryProvider.BaseTreeNode(this.entry, type.getName(), new TreeNodeBean(type.getDisplayTypeName(), MODULE_FILE_ICON), this.factory));
                    }
                }
                this.initialized = true;
            }
        }
    }
}

