/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.Collection;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.dsl.RepositoryHandlerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Factory;
import org.gradle.plugin.use.internal.PluginArtifactRepository;
import org.gradle.plugin.use.resolve.internal.ArtifactRepositoriesPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginArtifactRepositories;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

class DefaultPluginArtifactRepositories
implements PluginArtifactRepositories {
    private final DependencyResolutionServices dependencyResolutionServices;
    private final RepositoryHandlerInternal sharedRepositories;

    public DefaultPluginArtifactRepositories(Factory<DependencyResolutionServices> factory, RepositoryHandlerInternal sharedRepositories) {
        this.dependencyResolutionServices = (DependencyResolutionServices)factory.create();
        this.sharedRepositories = sharedRepositories;
        JavaEcosystemSupport.configureSchema((AttributesSchema)this.dependencyResolutionServices.getAttributesSchema(), (ObjectFactory)this.dependencyResolutionServices.getObjectFactory());
        RepositoryHandler repositoryHandler = this.dependencyResolutionServices.getResolveRepositoryHandler();
        for (ArtifactRepository repository : sharedRepositories) {
            repositoryHandler.add((ArtifactRepository)new PluginArtifactRepository(repository));
        }
        if (repositoryHandler.isEmpty()) {
            repositoryHandler.gradlePluginPortal();
        }
    }

    @Override
    public PluginResolver getPluginResolver() {
        return new ArtifactRepositoriesPluginResolver(this.dependencyResolutionServices);
    }

    @Override
    public void applyRepositoriesTo(RepositoryHandler repositories) {
        if (this.isExclusiveContentInUse() && !repositories.isEmpty()) {
            throw new InvalidUserCodeException("When using exclusive repository content in 'settings.pluginManagement.repositories', you cannot add repositories to 'buildscript.repositories'.\n" + new DocumentationRegistry().getDocumentationRecommendationFor("information", "declaring_repositories", "declaring_content_exclusively_found_in_one_repository"));
        }
        repositories.addAll((Collection)this.dependencyResolutionServices.getResolveRepositoryHandler());
    }

    private boolean isExclusiveContentInUse() {
        return this.sharedRepositories.isExclusiveContentInUse();
    }
}

