/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.serialize.PlaceholderExceptionSupport;

public class TestReportDataCollector
implements TestListener,
TestOutputListener {
    public static final String EXECUTION_FAILURE = "failed to execute tests";
    private final Map<String, TestClassResult> results;
    private final TestOutputStore.Writer outputWriter;
    private final Map<TestDescriptor, TestMethodResult> currentTestMethods = new HashMap<TestDescriptor, TestMethodResult>();
    private final ListMultimap<Object, TestOutputEvent> pendingOutputEvents = ArrayListMultimap.create();
    private long internalIdCounter = 1L;

    public TestReportDataCollector(Map<String, TestClassResult> results, TestOutputStore.Writer outputWriter) {
        this.results = results;
        this.outputWriter = outputWriter;
    }

    @Override
    public void beforeSuite(TestDescriptor suite) {
    }

    @Override
    public void afterSuite(TestDescriptor suite, TestResult result) {
        List outputEvents = this.pendingOutputEvents.removeAll(((TestDescriptorInternal)suite).getId());
        if (result.getResultType() == TestResult.ResultType.FAILURE && !result.getExceptions().isEmpty()) {
            TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, EXECUTION_FAILURE);
            TestClassResult classResult = new TestClassResult(this.internalIdCounter++, suite.getName(), result.getStartTime());
            for (Throwable throwable : result.getExceptions()) {
                methodResult.addFailure(this.failureMessage(throwable), this.stackTrace(throwable), this.exceptionClassName(throwable));
            }
            for (TestOutputEvent outputEvent : outputEvents) {
                this.outputWriter.onOutput(classResult.getId(), methodResult.getId(), outputEvent);
            }
            methodResult.completed(result);
            classResult.add(methodResult);
            this.results.put(suite.getName(), classResult);
        } else if (result.getResultType() == TestResult.ResultType.SKIPPED) {
            String parentClassName = TestReportDataCollector.findEnclosingClassName(suite.getParent());
            String classDisplayName = ((TestDescriptorInternal)suite).getClassDisplayName();
            if (parentClassName != null) {
                TestClassResult classResult = this.results.get(parentClassName);
                if (classResult == null) {
                    classResult = new TestClassResult(this.internalIdCounter++, parentClassName, classDisplayName, result.getStartTime());
                    this.results.put(parentClassName, classResult);
                }
                TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, suite.getName());
                methodResult.completed(result);
                classResult.add(methodResult);
            }
        }
    }

    @Override
    public void beforeTest(TestDescriptor testDescriptor) {
        TestDescriptorInternal testDescriptorInternal = (TestDescriptorInternal)testDescriptor;
        TestMethodResult methodResult = new TestMethodResult(this.internalIdCounter++, testDescriptorInternal.getName(), testDescriptorInternal.getDisplayName());
        this.currentTestMethods.put(testDescriptor, methodResult);
    }

    @Override
    public void afterTest(TestDescriptor testDescriptor, TestResult result) {
        String className = testDescriptor.getClassName();
        String classDisplayName = ((TestDescriptorInternal)testDescriptor).getClassDisplayName();
        TestMethodResult methodResult = this.currentTestMethods.remove(testDescriptor).completed(result);
        for (Throwable throwable : result.getExceptions()) {
            methodResult.addFailure(this.failureMessage(throwable), this.stackTrace(throwable), this.exceptionClassName(throwable));
        }
        TestClassResult classResult = this.results.get(className);
        if (classResult == null) {
            classResult = new TestClassResult(this.internalIdCounter++, className, classDisplayName, result.getStartTime());
            this.results.put(className, classResult);
        } else if (classResult.getStartTime() == 0L) {
            classResult.setStartTime(result.getStartTime());
        }
        classResult.add(methodResult);
    }

    private String failureMessage(Throwable throwable) {
        try {
            return throwable.toString();
        }
        catch (Throwable t) {
            String exceptionClassName = this.exceptionClassName(throwable);
            return String.format("Could not determine failure message for exception of type %s: %s", exceptionClassName, t);
        }
    }

    private String exceptionClassName(Throwable throwable) {
        return throwable instanceof PlaceholderExceptionSupport ? ((PlaceholderExceptionSupport)throwable).getExceptionClassName() : throwable.getClass().getName();
    }

    private String stackTrace(Throwable throwable) {
        try {
            return this.getStacktrace(throwable);
        }
        catch (Throwable t) {
            return this.getStacktrace(t);
        }
    }

    private String getStacktrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        throwable.printStackTrace(writer);
        writer.close();
        return stringWriter.toString();
    }

    @Override
    public void onOutput(TestDescriptor testDescriptor, TestOutputEvent outputEvent) {
        TestMethodResult methodResult;
        String className = TestReportDataCollector.findEnclosingClassName(testDescriptor);
        if (className == null) {
            this.pendingOutputEvents.put(((TestDescriptorInternal)testDescriptor).getId(), (Object)outputEvent);
            return;
        }
        TestClassResult classResult = this.results.get(className);
        if (classResult == null) {
            classResult = new TestClassResult(this.internalIdCounter++, className, ((TestDescriptorInternal)testDescriptor).getClassDisplayName(), 0L);
            this.results.put(className, classResult);
        }
        if ((methodResult = this.currentTestMethods.get(testDescriptor)) == null) {
            this.outputWriter.onOutput(classResult.getId(), outputEvent);
        } else {
            this.outputWriter.onOutput(classResult.getId(), methodResult.getId(), outputEvent);
        }
    }

    private static String findEnclosingClassName(TestDescriptor testDescriptor) {
        if (testDescriptor == null) {
            return null;
        }
        String className = testDescriptor.getClassName();
        if (className != null) {
            return className;
        }
        return TestReportDataCollector.findEnclosingClassName(testDescriptor.getParent());
    }
}

