/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.api;

import org.gradle.internal.event.ListenerManager;
import org.gradle.launcher.daemon.protocol.Stop;
import org.gradle.launcher.daemon.protocol.StopWhenIdle;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationListener;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;

public class HandleStop
implements DaemonCommandAction {
    private final DaemonExpirationListener listenerBroadcast;
    public static final String EXPIRATION_REASON = "stop command received";

    public HandleStop(ListenerManager listenerManager) {
        this.listenerBroadcast = (DaemonExpirationListener)listenerManager.getBroadcaster(DaemonExpirationListener.class);
    }

    @Override
    public void execute(DaemonCommandExecution execution) {
        if (execution.getCommand() instanceof Stop) {
            this.listenerBroadcast.onExpirationEvent(new DaemonExpirationResult(DaemonExpirationStatus.IMMEDIATE_EXPIRE, EXPIRATION_REASON));
            execution.getConnection().completed(new Success((Object)null));
        } else if (execution.getCommand() instanceof StopWhenIdle) {
            this.hangShutdownForTesting();
            this.listenerBroadcast.onExpirationEvent(new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, EXPIRATION_REASON));
            execution.getConnection().completed(new Success((Object)null));
        } else {
            execution.proceed();
        }
    }

    private void hangShutdownForTesting() {
        int hang = Integer.getInteger("org.gradle.internal.testing.daemon.hang", 0);
        if (hang > 0) {
            try {
                Thread.sleep(hang);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

