/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import org.gradle.api.internal.artifacts.transform.TransformWorkspaceIdentity;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.ValueSnapshot;

class ImmutableTransformWorkspaceIdentity
implements TransformWorkspaceIdentity {
    private final ValueSnapshot inputArtifactPath;
    private final ValueSnapshot inputArtifactSnapshot;
    private final ValueSnapshot secondaryInputsSnapshot;
    private final HashCode dependenciesHash;

    public ImmutableTransformWorkspaceIdentity(ValueSnapshot inputArtifactPath, ValueSnapshot inputArtifactSnapshot, ValueSnapshot secondaryInputsSnapshot, HashCode dependenciesHash) {
        this.inputArtifactPath = inputArtifactPath;
        this.inputArtifactSnapshot = inputArtifactSnapshot;
        this.secondaryInputsSnapshot = secondaryInputsSnapshot;
        this.dependenciesHash = dependenciesHash;
    }

    public String getUniqueId() {
        Hasher hasher = Hashing.newHasher();
        this.inputArtifactPath.appendToHasher(hasher);
        this.inputArtifactSnapshot.appendToHasher(hasher);
        this.secondaryInputsSnapshot.appendToHasher(hasher);
        hasher.putHash(this.dependenciesHash);
        return hasher.hash().toString();
    }

    @Override
    public ValueSnapshot getSecondaryInputsSnapshot() {
        return this.secondaryInputsSnapshot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTransformWorkspaceIdentity that = (ImmutableTransformWorkspaceIdentity)o;
        if (!this.inputArtifactPath.equals(that.inputArtifactPath)) {
            return false;
        }
        if (!this.inputArtifactSnapshot.equals(that.inputArtifactSnapshot)) {
            return false;
        }
        if (!this.secondaryInputsSnapshot.equals(that.secondaryInputsSnapshot)) {
            return false;
        }
        return this.dependenciesHash.equals((Object)that.dependenciesHash);
    }

    public int hashCode() {
        int result = this.inputArtifactPath.hashCode();
        result = 31 * result + this.inputArtifactSnapshot.hashCode();
        result = 31 * result + this.secondaryInputsSnapshot.hashCode();
        result = 31 * result + this.dependenciesHash.hashCode();
        return result;
    }
}

