/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultResolutionResultBuilder;

public class InMemoryResolutionResultBuilder
implements DependencyGraphVisitor {
    private final DefaultResolutionResultBuilder resolutionResultBuilder = new DefaultResolutionResultBuilder();
    private ResolutionResult resolutionResult;

    @Override
    public void start(RootGraphNode root) {
        this.resolutionResultBuilder.setRequestedAttributes((AttributeContainer)root.getResolveState().getAttributes());
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent component = node.getOwner();
        this.resolutionResultBuilder.startVisitComponent(component.getResultId(), component.getSelectionReason(), component.getRepositoryName());
        this.resolutionResultBuilder.visitComponentDetails(component.getComponentId(), component.getModuleVersion());
        for (ResolvedGraphVariant variant : component.getSelectedVariants()) {
            this.resolutionResultBuilder.visitSelectedVariant(variant.getNodeId(), variant.getResolveState().getVariantResult(null));
        }
        this.resolutionResultBuilder.visitComponentVariants(component.getResolveState().getAllSelectableVariantResults());
        this.resolutionResultBuilder.endVisitComponent();
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        this.resolutionResultBuilder.visitOutgoingEdges(node.getOwner().getResultId(), node.getOutgoingEdges());
    }

    @Override
    public void finish(DependencyGraphNode root) {
        this.resolutionResult = this.resolutionResultBuilder.complete(root.getOwner().getResultId());
    }

    public ResolutionResult getResolutionResult() {
        if (this.resolutionResult == null) {
            throw new IllegalStateException("Resolution result not computed yet");
        }
        return this.resolutionResult;
    }
}

