/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

public class BooleanOption
extends AbstractOption<Boolean> {
    private static final Logger logger = Logger.getLogger(BooleanOption.class.getName());
    public static final String TAG = "booleanOption";
    private boolean value;

    public BooleanOption(Specification specification) {
        super(specification);
    }

    public BooleanOption(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public BooleanOption cloneOption() {
        BooleanOption result = new BooleanOption(this.getId(), this.getSpecification());
        result.setValues(this);
        return result;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        boolean oldValue = this.value;
        this.value = value;
        if (this.isDefined && value != oldValue) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.setValue(Boolean.valueOf(valueString != null ? valueString : defaultValueString));
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", Boolean.toString(this.value));
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(" value=").append(this.value).append(']');
        return sb.toString();
    }
}

