/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;

public class BuildingDetailPanel
extends ColopediaGameObjectTypePanel<BuildingType> {
    public BuildingDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.BUILDINGS.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
        HashMap<BuildingType, DefaultMutableTreeNode> buildingHash = new HashMap<BuildingType, DefaultMutableTreeNode>();
        for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
            if (buildingType.getUpgradesFrom() == null) {
                String name = Messages.getName(buildingType);
                Dimension listItemIconSize = this.getListItemIconSize();
                BufferedImage buildingTypeImage = this.getImageLibrary().getBuildingTypeImage(buildingType, new Dimension(-1, listItemIconSize.height));
                BufferedImage centeredImage = ImageUtils.createCenteredImage(buildingTypeImage, listItemIconSize);
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(this, buildingType.getId(), name, new ImageIcon(centeredImage)));
                buildingHash.put(buildingType, item);
                parent.add(item);
                continue;
            }
            buildingTypes.add(buildingType);
        }
        while (!buildingTypes.isEmpty()) {
            Iterator iterator = buildingTypes.iterator();
            while (iterator.hasNext()) {
                BuildingType buildingType;
                buildingType = (BuildingType)iterator.next();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)buildingHash.get(buildingType.getUpgradesFrom());
                if (node == null) continue;
                String name = Messages.getName(buildingType);
                Dimension listItemIconSize = this.getListItemIconSize();
                BufferedImage buildingTypeImage = this.getImageLibrary().getBuildingTypeImage(buildingType, new Dimension(-1, listItemIconSize.height));
                BufferedImage centeredImage = ImageUtils.createCenteredImage(buildingTypeImage, listItemIconSize);
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(this, buildingType.getId(), name, new ImageIcon(centeredImage)));
                node.add(item);
                buildingHash.put(buildingType, item);
                iterator.remove();
            }
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        BuildingType buildingType = this.getSpecification().getBuildingType(id);
        panel.setLayout(new MigLayout("wrap 7, gapx 20", "", ""));
        JLabel name = Utility.localizedHeaderLabel(buildingType, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)name, "span, align center, wrap 40");
        JTextPane textPane = Utility.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        try {
            if (buildingType.getUpgradesFrom() != null) {
                StyleConstants.setComponent(doc.getStyle("button"), this.getButton(buildingType.getUpgradesFrom()));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
            }
            if (buildingType.getRequiredPopulation() > 0) {
                Object template = StringTemplate.template("colopedia.buildings.requiredPopulation").addAmount("%number%", buildingType.getRequiredPopulation());
                doc.insertString(doc.getLength(), Messages.message(template) + "\n", doc.getStyle("regular"));
            }
            CollectionUtils.forEachMapEntry(buildingType.getRequiredAbilities(), e -> this.appendRequiredAbility(doc, (String)e.getKey(), (Boolean)e.getValue()));
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.requires"), "top");
            panel.add((Component)textPane, "span, growx");
        }
        catch (BadLocationException template) {
            // empty catch block
        }
        panel.add(Utility.localizedLabel("colopedia.buildings.cost"));
        if (!buildingType.needsGoodsToBuild()) {
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.autoBuilt"), "span");
        } else {
            List<AbstractGoods> required = buildingType.getRequiredGoodsList();
            Object goodsRequired = CollectionUtils.first(required);
            if (required.size() > 1) {
                panel.add((Component)this.getGoodsButton(((AbstractGoods)goodsRequired).getType(), ((AbstractGoods)goodsRequired).getAmount()), "span, split " + required.size());
                for (int index = 1; index < required.size(); ++index) {
                    goodsRequired = required.get(index);
                    panel.add(this.getGoodsButton(((AbstractGoods)goodsRequired).getType(), ((AbstractGoods)goodsRequired).getAmount()));
                }
            } else {
                panel.add((Component)this.getGoodsButton(((AbstractGoods)goodsRequired).getType(), ((AbstractGoods)goodsRequired).getAmount()), "span");
            }
        }
        if (buildingType.hasAbility("model.ability.teach")) {
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.teaches"), "newline, top");
            int count = 0;
            for (UnitType unitType2 : this.getSpecification().getUnitTypeList()) {
                if (!buildingType.canAdd(unitType2)) continue;
                if (count > 0 && count % 3 == 0) {
                    panel.add((Component)this.getButton(unitType2), "skip, span 2");
                } else {
                    panel.add((Component)this.getButton(unitType2), "span 2");
                }
                ++count;
            }
        } else {
            for (ProductionType pt : buildingType.getAvailableProductionTypes(false)) {
                AbstractGoods output;
                panel.add((Component)Utility.localizedLabel("colopedia.buildings.production"), "newline");
                AbstractGoods input = CollectionUtils.first(pt.getInputs());
                if (input != null) {
                    panel.add((Component)this.getGoodsButton(input), "span, split 3");
                    JLabel arrow = new JLabel("\u2192");
                    Font font = FontLibrary.getScaledFont("simple-bold-small");
                    arrow.setFont(font);
                    panel.add(arrow);
                }
                if ((output = CollectionUtils.first(pt.getOutputs())) == null) continue;
                panel.add(this.getGoodsButton(output));
            }
        }
        int workplaces = buildingType.getWorkPlaces();
        panel.add((Component)Utility.localizedLabel("colopedia.buildings.workplaces"), "newline");
        panel.add((Component)new JLabel(Integer.toString(workplaces)), "span");
        if (workplaces > 0) {
            panel.add((Component)Utility.localizedLabel("colopedia.buildings.specialist"), "newline");
            UnitType unitType = this.getSpecification().getExpertForProducing(buildingType.getProducedGoodsType());
            if (unitType == null) {
                panel.add((Component)Utility.localizedLabel("none"), "span");
            } else {
                panel.add((Component)this.getUnitButton(unitType), "span");
            }
        }
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        CollectionUtils.forEach(buildingType.getModifiers(), m -> {
            JComponent component = this.getModifierComponent((Modifier)m);
            if (component instanceof JButton) {
                labels.add(0, (JLabel)component);
            } else {
                labels.add((JLabel)component);
            }
        });
        for (Ability ability : CollectionUtils.iterable(buildingType.getAbilities())) {
            JComponent component = this.getAbilityComponent(ability);
            if (component == null) continue;
            labels.add((JLabel)component);
        }
        if (!labels.isEmpty()) {
            panel.add((Component)Utility.localizedLabel(StringTemplate.template("colopedia.buildings.modifiers").addAmount("%number%", labels.size())), "newline, top");
            int count = 0;
            for (JComponent component : labels) {
                if (count > 0 && count % 2 == 0) {
                    panel.add((Component)component, "skip, span 3");
                } else {
                    panel.add((Component)component, "span 3");
                }
                ++count;
            }
        }
        panel.add((Component)Utility.localizedLabel("colopedia.buildings.notes"), "newline 20, top");
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(buildingType)), "span, growx");
    }
}

