/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.text.UnicodeSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.w3c.epubcheck.core.Checker;

public final class OCFFilenameChecker
implements Checker {
    private static final UnicodeSet ASCII = new UnicodeSet("[:ascii:]").freeze();
    private static final UnicodeSet DISALLOWED_EPUB2 = new UnicodeSet().add(34).add(42).add(58).add(60).add(62).add(63).add(92).freeze();
    private static final ImmutableMap<String, UnicodeSet> DISALLOWED_EPUB3 = new ImmutableMap.Builder().put((Object)"ASCII", (Object)new UnicodeSet().addAll(DISALLOWED_EPUB2).add(124).freeze()).put((Object)"NON CHARACTER", (Object)new UnicodeSet("[:Noncharacter_Code_Point=Yes:]").freeze()).put((Object)"CONTROL", (Object)new UnicodeSet().add(127).addAll(0, 31).addAll(128, 159).freeze()).put((Object)"PRIVATE USE", (Object)new UnicodeSet().addAll(57344, 63743).addAll(983040, 1048575).addAll(0x100000, 0x10FFFF).freeze()).put((Object)"SPECIALS", (Object)new UnicodeSet().addAll(65520, 65535).freeze()).put((Object)"DEPRECATED", (Object)new UnicodeSet().add(917505).freeze()).build();
    private final Report report;
    private final EPUBVersion version;
    private final EPUBLocation location;
    private final String filename;

    private static String toString(int codepoint, String setName) {
        assert (setName != null);
        StringBuilder result = new StringBuilder().append(String.format("U+%04X ", codepoint));
        if ("ASCII".equals(setName)) {
            result.append('(').append(UCharacter.toString(codepoint)).append(')');
        } else {
            String characterName = UCharacter.getName(codepoint);
            if (characterName != null) {
                result.append(characterName).append(' ');
            }
            result.append('(').append(setName).append(')');
        }
        return result.toString();
    }

    public OCFFilenameChecker(String filename, ValidationContext context) {
        this(filename, context, null);
    }

    public OCFFilenameChecker(String filename, ValidationContext context, EPUBLocation location) {
        Preconditions.checkArgument((filename != null ? 1 : 0) != 0);
        Preconditions.checkArgument((context != null ? 1 : 0) != 0);
        this.filename = filename;
        this.report = context.report;
        this.version = context.version;
        this.location = location != null ? location : EPUBLocation.of(context);
    }

    @Override
    public void check() {
        int codepoint;
        UCharacterIterator chars = UCharacterIterator.getInstance(this.filename);
        LinkedHashSet<String> disallowed = new LinkedHashSet<String>();
        boolean hasSpaces = false;
        boolean isASCIIOnly = true;
        block3: while ((codepoint = chars.nextCodePoint()) != -1) {
            isASCIIOnly = isASCIIOnly && ASCII.contains(codepoint);
            hasSpaces = hasSpaces || UCharacter.isUWhiteSpace(codepoint);
            switch (this.version) {
                case VERSION_2: {
                    if (!DISALLOWED_EPUB2.contains(codepoint)) continue block3;
                    disallowed.add(OCFFilenameChecker.toString(codepoint, "ASCII"));
                    continue block3;
                }
            }
            for (String name : DISALLOWED_EPUB3.keySet()) {
                if (!((UnicodeSet)DISALLOWED_EPUB3.get((Object)name)).contains(codepoint)) continue;
                disallowed.add(OCFFilenameChecker.toString(codepoint, name));
                continue block3;
            }
        }
        if (chars.previousCodePoint() == 46) {
            this.report.message(MessageId.PKG_011, this.location, this.filename);
        }
        if (!disallowed.isEmpty()) {
            this.report.message(MessageId.PKG_009, this.location, this.filename, disallowed.stream().collect(Collectors.joining(", ")));
        }
        if (hasSpaces) {
            this.report.message(MessageId.PKG_010, this.location, this.filename);
        }
        if (!isASCIIOnly) {
            this.report.message(MessageId.PKG_012, this.location, this.filename);
        }
    }
}

