/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public enum Severity {
    SUPPRESSED("SUPPRESSED"),
    USAGE("USAGE"),
    INFO("INFO"),
    WARNING("WARNING"),
    ERROR("ERROR"),
    FATAL("FATAL");

    private final String name;
    private static final Map<String, Severity> map;

    private Severity(String feature) {
        this.name = feature;
    }

    public String toString() {
        return this.name;
    }

    public static Severity fromString(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        throw new NoSuchElementException(name + " not found");
    }

    public int toInt() {
        if (this.equals((Object)SUPPRESSED)) {
            return 0;
        }
        if (this.equals((Object)USAGE)) {
            return 1;
        }
        if (this.equals((Object)INFO)) {
            return 2;
        }
        if (this.equals((Object)WARNING)) {
            return 3;
        }
        if (this.equals((Object)ERROR)) {
            return 4;
        }
        if (this.equals((Object)FATAL)) {
            return 5;
        }
        return -1;
    }

    static {
        map = new HashMap<String, Severity>();
        for (Severity type : Severity.values()) {
            map.put(type.name, type);
        }
    }
}

