/* crypto-vala.vapi generated by valac 0.56.15, do not modify. */

namespace Crypto {
	namespace Srtp {
		[CCode (cheader_filename = "crypto-vala.h")]
		public class Session {
			public Session ();
			public uint8[] decrypt_rtcp (uint8[] data) throws Crypto.Error;
			public uint8[] decrypt_rtp (uint8[] data) throws Crypto.Error;
			public uint8[] encrypt_rtcp (uint8[] data) throws Crypto.Error;
			public uint8[] encrypt_rtp (uint8[] data) throws Crypto.Error;
			public void set_decryption_key (string profile, uint8[] key, uint8[] salt);
			public void set_encryption_key (string profile, uint8[] key, uint8[] salt);
			public bool has_decrypt { get; private set; }
			public bool has_encrypt { get; private set; }
		}
		[CCode (cheader_filename = "crypto-vala.h")]
		public const string AES_CM_128_HMAC_SHA1_32;
		[CCode (cheader_filename = "crypto-vala.h")]
		public const string AES_CM_128_HMAC_SHA1_80;
		[CCode (cheader_filename = "crypto-vala.h")]
		public const string F8_128_HMAC_SHA1_80;
	}
	[CCode (cheader_filename = "crypto-vala.h")]
	public class SymmetricCipher {
		public SymmetricCipher (string algo_name) throws Crypto.Error;
		public void check_tag (uint8[] tag) throws Crypto.Error;
		public void decrypt (uint8[] output, uint8[] input) throws Crypto.Error;
		public void encrypt (uint8[] output, uint8[] input) throws Crypto.Error;
		public uint8[] get_tag (size_t taglen) throws Crypto.Error;
		public void reset () throws Crypto.Error;
		public void set_counter_vector (uint8[] ctr) throws Crypto.Error;
		public void set_iv (uint8[] iv) throws Crypto.Error;
		public void set_key (uint8[] key) throws Crypto.Error;
		public static bool supports (string algo_name);
		public void sync () throws Crypto.Error;
	}
	[CCode (cheader_filename = "crypto-vala.h")]
	public abstract class SymmetricCipherConverter : GLib.Converter, GLib.Object {
		protected SymmetricCipherConverter ();
		public void check_tag (uint8[] tag) throws Crypto.Error;
		public abstract GLib.ConverterResult convert (uint8[] inbuf, uint8[] outbuf, GLib.ConverterFlags flags, out size_t bytes_read, out size_t bytes_written) throws GLib.IOError;
		public uint8[] get_tag (size_t taglen) throws Crypto.Error;
	}
	[CCode (cheader_filename = "crypto-vala.h")]
	public class SymmetricCipherDecrypter : Crypto.SymmetricCipherConverter {
		public SymmetricCipherDecrypter (owned Crypto.SymmetricCipher cipher, size_t attached_taglen = 0);
		public override GLib.ConverterResult convert (uint8[] inbuf, uint8[] outbuf, GLib.ConverterFlags flags, out size_t bytes_read, out size_t bytes_written) throws GLib.IOError;
	}
	[CCode (cheader_filename = "crypto-vala.h")]
	public class SymmetricCipherEncrypter : Crypto.SymmetricCipherConverter {
		public SymmetricCipherEncrypter (owned Crypto.SymmetricCipher cipher, size_t attached_taglen = 0);
		public override GLib.ConverterResult convert (uint8[] inbuf, uint8[] outbuf, GLib.ConverterFlags flags, out size_t bytes_read, out size_t bytes_written) throws GLib.IOError;
	}
	[CCode (cheader_filename = "crypto-vala.h")]
	public errordomain Error {
		ILLEGAL_ARGUMENTS,
		GCRYPT,
		AUTHENTICATION_FAILED,
		UNKNOWN
	}
	[CCode (cheader_filename = "crypto-vala.h")]
	public static void randomize (uint8[] buffer);
}
