# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

CRATES=""

inherit cargo readme.gentoo-r1

DESCRIPTION="NSS plugin for finding Docker containers by their ID or name"
HOMEPAGE="https://github.com/petski/nss-docker-ng"
SRC_URI="https://github.com/petski/nss-docker-ng/archive/v${PV}.tar.gz -> ${P}.tar.gz"
if [[ ${PKGBUMPING} != ${PVR} ]]; then
	SRC_URI+=" https://dev.gentoo.org/~arthurzam/distfiles/sys-auth/${PN}/${P}-crates.tar.xz"
fi

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 LGPL-3 MIT MPL-2.0 Unicode-DFS-2016"
SLOT="0"
KEYWORDS="~amd64"

BDEPEND="dev-util/patchelf"

QA_FLAGS_IGNORED="usr/lib.*/libnss_docker_ng.so.*"

DISABLE_AUTOFORMATTING=1
DOC_CONTENTS='
You must modify your name service switch lookup file to enable nss-docker-ng.
To do so, add 'docker_ng' to the hosts line in /etc/nsswitch.conf

An example hosts line looks like this:
	hosts:      docker_ng resolve [!UNAVAIL=return] files myhostname dns
'

pkg_setup() {
	rust_pkg_setup
	# Requires nightly feature proc-macro2, bug #947565
	export RUSTC_BOOTSTRAP=1
}

src_install() {
	cd "$(cargo_target_dir)" || die
	patchelf --set-soname libnss_docker_ng.so.2 libnss_docker_ng.so || die
	mv libnss_docker_ng.so libnss_docker_ng.so.2 || die
	ln -s libnss_docker_ng.so.2 libnss_docker_ng.so || die
	dolib.so libnss_docker_ng.so*
	readme.gentoo_create_doc
}

pkg_postinst() {
	readme.gentoo_print_elog
}
