/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;
import org.xmlresolver.helpers.DOMUtils;

public class ResourceCache {
    public static final String NS_CACHE = "http://xmlresolver.org/ns/cache";
    private static Logger logger = Logger.getLogger("org.xmlresolver");
    private static GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static GregorianCalendar now = new GregorianCalendar();
    private static DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder = null;
    private Document cache = null;
    private Element catalog = null;
    private File cacheDir = null;
    private File dataDir = null;
    private File entryDir = null;
    private File expiredDir = null;
    private CacheInfo defaultCacheInfo = null;
    private Vector<CacheInfo> cacheInfo = new Vector();
    private long deleteWait = 604800L;
    private long cacheSize = 1000L;
    private long cacheSpace = 10240L;

    public ResourceCache(String dir) {
        this.init(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String dir) {
        DocumentBuilderFactory documentBuilderFactory = dbFactory;
        synchronized (documentBuilderFactory) {
            if (builder == null) {
                dbFactory.setNamespaceAware(true);
                dbFactory.setValidating(false);
                try {
                    builder = dbFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException pce) {
                    throw new UnsupportedOperationException(pce);
                }
            }
        }
        this.defaultCacheInfo = new CacheInfo(".*", true, this.deleteWait, this.cacheSize, this.cacheSpace);
        try {
            FileInputStream controlFile = new FileInputStream(dir + "/control.xml");
            Document cacheControl = builder.parse(controlFile);
            Element control = cacheControl.getDocumentElement();
            if (NS_CACHE.equals(control.getNamespaceURI()) && "cache-control".equals(control.getLocalName())) {
                this.deleteWait = this.parseLong(control, "delete-wait", this.deleteWait);
                this.cacheSize = this.parseLong(control, "size", this.cacheSize);
                this.cacheSpace = this.parseSizeLong(control, "space", this.cacheSpace);
                this.defaultCacheInfo = new CacheInfo(".*", true, this.deleteWait, this.cacheSize, this.cacheSpace);
                Element child = DOMUtils.getFirstElement(control);
                while (child != null) {
                    CacheInfo info;
                    if ("cache".equals(child.getLocalName())) {
                        info = new CacheInfo(child.getAttribute("uri"), true, this.parseLong(child, "delete-wait", this.deleteWait), this.parseLong(child, "size", this.cacheSize), this.parseSizeLong(child, "space", this.cacheSpace));
                        this.cacheInfo.add(info);
                    } else if ("no-cache".equals(child.getLocalName())) {
                        info = new CacheInfo(child.getAttribute("uri"), false, this.parseLong(child, "delete-wait", this.deleteWait), this.parseLong(child, "size", this.cacheSize), this.parseSizeLong(child, "space", this.cacheSpace));
                        this.cacheInfo.add(info);
                    }
                    child = DOMUtils.getNextElement(child);
                }
            }
        }
        catch (SAXException ex) {
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        File fDir = new File(dir);
        try {
            this.cacheDir = fDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            this.cacheDir = null;
        }
    }

    private long parseLong(Element node, String attr, long defVal) {
        if (!node.hasAttribute(attr)) {
            return defVal;
        }
        try {
            long val = Long.parseLong(node.getAttribute(attr));
            return val;
        }
        catch (NumberFormatException nfe) {
            logger.warning("Bad numeric value in cache control file: " + node.getAttribute(attr));
            return defVal;
        }
    }

    private long parseSizeLong(Element node, String attr, long defVal) {
        if (!node.hasAttribute(attr)) {
            return defVal;
        }
        String longStr = node.getAttribute(attr);
        long units = 1L;
        if (Pattern.matches("^[0-9]+[kK]$", longStr)) {
            units = 1024L;
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (Pattern.matches("^[0-9]+[mM]$", longStr)) {
            units = 1024000L;
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (Pattern.matches("^[0-9]+[gG]$", longStr)) {
            units = 1024000000L;
            longStr = longStr.substring(0, longStr.length() - 1);
        }
        try {
            long val = Long.parseLong(longStr);
            return val * units;
        }
        catch (NumberFormatException nfe) {
            logger.warning("Bad numeric value in cache control file: " + longStr);
            return defVal;
        }
    }

    public synchronized Document catalog() {
        if (!this.cacheDir.exists() || !this.cacheDir.isDirectory()) {
            return null;
        }
        if (this.cache == null) {
            this.loadCatalog();
            this.cleanupCache();
        }
        return this.cache;
    }

    private synchronized void cleanupCache() {
        int pos;
        DirectoryLock lock = new DirectoryLock();
        if (!lock.locked()) {
            return;
        }
        File[] files = this.expiredDir.listFiles();
        for (pos = 0; pos < files.length; ++pos) {
            long age = calendar.getTimeInMillis() - files[pos].lastModified();
            if (age <= this.deleteWait * 1000L) continue;
            logger.info("Deleting expired entry: " + files[pos].getName());
            files[pos].delete();
        }
        files = this.dataDir.listFiles();
        for (pos = 0; pos < files.length; ++pos) {
            String entryName = files[pos].getName();
            entryName = entryName.substring(0, entryName.lastIndexOf("."));
            File entry = new File(this.entryDir + "/" + entryName + ".xml");
            if (entry.exists() || (entry = new File(this.expiredDir + "/" + entryName + ".xml")).exists()) continue;
            logger.info("Deleting expired data: " + files[pos].getName());
            files[pos].delete();
        }
        files = this.entryDir.listFiles();
        for (pos = 0; pos < files.length; ++pos) {
            String entryName = files[pos].getName();
            entryName = entryName.substring(0, entryName.lastIndexOf("."));
            boolean found = false;
            File[] dfiles = this.dataDir.listFiles();
            for (int dpos = 0; !found && dpos < dfiles.length; ++dpos) {
                String dataName = dfiles[dpos].getName();
                dataName = dataName.substring(0, dataName.lastIndexOf("."));
                found = dataName.equals(entryName);
            }
            if (found) continue;
            logger.info("Deleting dangling entry: " + files[pos].getName());
            files[pos].delete();
        }
        lock.unlock();
    }

    private synchronized void loadCatalog() {
        this.cache = builder.newDocument();
        this.catalog = this.cache.createElementNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog");
        this.cache.appendChild(this.catalog);
        this.dataDir = new File(this.cacheDir.toString() + "/data");
        this.entryDir = new File(this.cacheDir.toString() + "/entry");
        this.expiredDir = new File(this.cacheDir.toString() + "/expired");
        if (!this.dataDir.exists() && !this.dataDir.mkdir() || !this.entryDir.exists() && !this.entryDir.mkdir() || !this.expiredDir.exists() && !this.expiredDir.mkdir()) {
            return;
        }
        DirectoryLock lock = new DirectoryLock();
        if (!lock.locked()) {
            return;
        }
        File[] files = this.dataDir.listFiles();
        for (int pos = 0; pos < files.length; ++pos) {
            if (!files[pos].canRead()) continue;
            String name = files[pos].getName();
            long lastModified = files[pos].lastModified();
            name = name.substring(0, name.lastIndexOf(".")) + ".xml";
            File entryFile = new File(this.entryDir.toString() + "/" + name);
            if (!entryFile.exists() || !entryFile.canRead()) continue;
            try {
                Document dom = builder.parse(entryFile.toString());
                Element root = dom.getDocumentElement();
                if (DOMUtils.catalogElement(root, "catalog")) {
                    Element cEntry = DOMUtils.getFirstElement(root);
                    while (cEntry != null) {
                        Element entry = (Element)this.cache.importNode(cEntry, true);
                        entry.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:oTime", entry.getAttributeNS("http://xmlresolver.org/ns/catalog", "time"));
                        entry.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:time", "" + lastModified);
                        this.insertSorted(this.catalog, entry);
                        cEntry = DOMUtils.getNextElement(cEntry);
                    }
                    continue;
                }
                Element entry = (Element)this.cache.importNode(root, true);
                entry.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:oTime", entry.getAttributeNS("http://xmlresolver.org/ns/catalog", "time"));
                entry.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:time", "" + lastModified);
                this.insertSorted(this.catalog, entry);
                continue;
            }
            catch (SAXException se) {
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        lock.unlock();
    }

    private void insertSorted(Element catalog, Element entry) {
        Element node = DOMUtils.getFirstElement(catalog);
        if (node == null) {
            catalog.appendChild(entry);
            return;
        }
        long cacheTime = -1L;
        if (entry.hasAttributeNS("http://xmlresolver.org/ns/catalog", "time")) {
            cacheTime = Long.parseLong(entry.getAttributeNS("http://xmlresolver.org/ns/catalog", "time"));
        }
        long nodeTime = -1L;
        if (node.hasAttributeNS("http://xmlresolver.org/ns/catalog", "time")) {
            nodeTime = Long.parseLong(node.getAttributeNS("http://xmlresolver.org/ns/catalog", "time"));
        }
        while (node != null && nodeTime >= cacheTime) {
            if ((node = DOMUtils.getNextElement(node)) == null || !node.hasAttributeNS("http://xmlresolver.org/ns/catalog", "time")) continue;
            nodeTime = Long.parseLong(node.getAttributeNS("http://xmlresolver.org/ns/catalog", "time"));
        }
        if (node == null) {
            catalog.appendChild(entry);
        } else {
            catalog.insertBefore(entry, node);
        }
    }

    public String addURI(String name, String contentType, InputStream resource) {
        logger.info("Caching URI: " + name);
        return this._addNamespaceURI(name, null, null, contentType, resource, null);
    }

    public String addURI(String name, String contentType, InputStream resource, String redirName) {
        logger.info("Caching URI: " + name);
        return this._addNamespaceURI(name, null, null, contentType, resource, redirName);
    }

    public synchronized String addNamespaceURI(String name, String nature, String purpose, String contentType, InputStream resource) {
        logger.info("Caching resource for namespace: " + name + " (nature: " + nature + "; purpose: " + purpose + ")");
        return this._addNamespaceURI(name, nature, purpose, contentType, resource, null);
    }

    private synchronized String _addNamespaceURI(String name, String nature, String purpose, String contentType, InputStream resource, String redirName) {
        if (this.cache == null) {
            this.loadCatalog();
            if (this.cache == null) {
                throw new UnsupportedOperationException("No underlying cache");
            }
        }
        Element entry = DOMUtils.getFirstElement(this.catalog);
        while (entry != null) {
            if (DOMUtils.catalogElement(entry, "uri")) {
                String eName = DOMUtils.attr(entry, "name");
                String eUri = DOMUtils.attr(entry, "uri");
                String eNature = DOMUtils.attr(entry, "nature");
                String ePurpose = DOMUtils.attr(entry, "purpose");
                String eRedir = DOMUtils.attr(entry, "redir");
                if (eName != null && eName.equals(name) && (eNature == null && nature == null || eNature != null && eNature.equals(nature)) && (ePurpose == null && purpose == null || ePurpose != null && ePurpose.equals(purpose)) && eUri != null) {
                    if (eRedir != null) {
                        return eRedir;
                    }
                    return eUri;
                }
            }
            entry = DOMUtils.getNextElement(entry);
        }
        String uri = null;
        String suffix = this.pickSuffix(name, contentType);
        File localFile = null;
        DirectoryLock lock = new DirectoryLock();
        if (!lock.locked()) {
            return null;
        }
        try {
            localFile = File.createTempFile("xrc", suffix, this.dataDir);
            uri = localFile.getPath();
            FileOutputStream fos = new FileOutputStream(localFile);
            byte[] buf = new byte[4096];
            int read = resource.read(buf);
            while (read > 0) {
                fos.write(buf, 0, read);
                read = resource.read(buf);
            }
            fos.close();
            resource.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            lock.unlock();
            throw new UnsupportedOperationException("Cannot create file in cache directory");
        }
        Element root = this.cache.getDocumentElement();
        Element newuri = this.cache.createElementNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "uri");
        newuri.setAttribute("name", name);
        newuri.setAttribute("uri", uri);
        if (nature != null) {
            newuri.setAttributeNS("http://www.rddl.org/", "nature", nature);
        }
        if (purpose != null) {
            newuri.setAttributeNS("http://www.rddl.org/", "purpose", purpose);
        }
        if (contentType != null) {
            newuri.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:contentType", contentType);
        }
        if (redirName != null) {
            newuri.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:redir", redirName);
        }
        newuri.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:time", "" + calendar.getTimeInMillis());
        root.appendChild(this.cache.createTextNode("\n"));
        root.appendChild(newuri);
        root.appendChild(this.cache.createTextNode("\n"));
        try {
            Document wrapper = builder.newDocument();
            wrapper.appendChild(wrapper.importNode(newuri, true));
            String entryfn = localFile.getName();
            entryfn = entryfn.substring(0, entryfn.lastIndexOf("."));
            File entryFile = new File(this.entryDir.toString() + "/" + entryfn + ".xml");
            FileOutputStream fos = new FileOutputStream(entryFile);
            DOMImplementationLS domimpl = (DOMImplementationLS)((Object)this.cache.getImplementation());
            LSSerializer serializer = domimpl.createLSSerializer();
            LSOutput output = domimpl.createLSOutput();
            output.setEncoding("utf-8");
            output.setByteStream(fos);
            serializer.write(wrapper, output);
            fos.close();
        }
        catch (IOException ioe) {
            lock.unlock();
            throw new UnsupportedOperationException("Failed to create entry file");
        }
        lock.unlock();
        return uri;
    }

    public String addSystem(String systemId, String publicId, String contentType, InputStream resource) {
        if (this.cache == null) {
            this.loadCatalog();
            if (this.cache == null) {
                throw new UnsupportedOperationException("No underlying cache");
            }
        }
        logger.info("Caching system identifier: " + systemId);
        Element entry = DOMUtils.getFirstElement(this.catalog);
        while (entry != null) {
            if (DOMUtils.catalogElement(entry, "system")) {
                String eName = DOMUtils.attr(entry, "systemId");
                String eUri = DOMUtils.attr(entry, "uri");
                if (eName != null && eName.equals(systemId) && eUri != null) {
                    return eUri;
                }
            }
            entry = DOMUtils.getNextElement(entry);
        }
        String uri = null;
        String suffix = this.pickSuffix(systemId, contentType);
        File localFile = null;
        DirectoryLock lock = new DirectoryLock();
        if (!lock.locked()) {
            return null;
        }
        try {
            localFile = File.createTempFile("xrc", suffix, this.dataDir);
            uri = localFile.getPath();
            FileOutputStream fos = new FileOutputStream(localFile);
            byte[] buf = new byte[4096];
            int read = resource.read(buf);
            while (read > 0) {
                fos.write(buf, 0, read);
                read = resource.read(buf);
            }
            fos.close();
            resource.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            lock.unlock();
            throw new UnsupportedOperationException("Cannot create file in cache directory");
        }
        Element root = this.cache.getDocumentElement();
        long curTime = calendar.getTimeInMillis();
        Element newuri = this.cache.createElementNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "system");
        newuri.setAttribute("systemId", systemId);
        newuri.setAttribute("uri", uri);
        if (contentType != null) {
            newuri.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:contentType", contentType);
        }
        newuri.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:time", "" + curTime);
        Element newpub = null;
        if (publicId != null) {
            newpub = this.cache.createElementNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "public");
            newpub.setAttribute("publicId", publicId);
            newpub.setAttribute("uri", uri);
            if (contentType != null) {
                newpub.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:contentType", contentType);
            }
            newpub.setAttributeNS("http://xmlresolver.org/ns/catalog", "xr:time", "" + curTime);
            newpub.setAttributeNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "xr:systemId", systemId);
        }
        root.appendChild(this.cache.createTextNode("\n"));
        root.appendChild(newuri);
        root.appendChild(this.cache.createTextNode("\n"));
        if (newpub != null) {
            root.appendChild(newpub);
            root.appendChild(this.cache.createTextNode("\n"));
        }
        try {
            Document wrapper = builder.newDocument();
            Element wcat = wrapper.createElementNS("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog");
            wrapper.appendChild(wcat);
            wcat.appendChild(wrapper.createTextNode("\n"));
            wcat.appendChild(wrapper.importNode(newuri, true));
            wcat.appendChild(wrapper.createTextNode("\n"));
            if (newpub != null) {
                wcat.appendChild(wrapper.importNode(newpub, true));
                wcat.appendChild(wrapper.createTextNode("\n"));
            }
            String entryfn = localFile.getName();
            entryfn = entryfn.substring(0, entryfn.lastIndexOf("."));
            File entryFile = new File(this.entryDir.toString() + "/" + entryfn + ".xml");
            FileOutputStream fos = new FileOutputStream(entryFile);
            DOMImplementationLS domimpl = (DOMImplementationLS)((Object)this.cache.getImplementation());
            LSSerializer serializer = domimpl.createLSSerializer();
            LSOutput output = domimpl.createLSOutput();
            output.setEncoding("utf-8");
            output.setByteStream(fos);
            serializer.write(wrapper, output);
            fos.close();
        }
        catch (IOException ioe) {
            lock.unlock();
            throw new UnsupportedOperationException("Failed to create entry file");
        }
        lock.unlock();
        return uri;
    }

    public boolean cacheURI(String uri) {
        CacheInfo info = null;
        for (int count = 0; info == null && count < this.cacheInfo.size(); ++count) {
            CacheInfo chk = this.cacheInfo.get(count);
            if (!Pattern.matches(chk.pattern() + ".*", uri)) continue;
            info = chk;
        }
        if (info == null) {
            info = this.defaultCacheInfo;
        }
        logger.finer("CacheURI " + uri + ": " + info.cache());
        return info.cache();
    }

    public boolean expired(String origURI, String uri, Element entry) {
        String offline = System.getProperty("xmlresolver.offline");
        if (offline != null && ("true".equals(offline) || "1".equals(offline) || "yes".equals(offline))) {
            return false;
        }
        CacheInfo info = null;
        for (int count = 0; info == null && count < this.cacheInfo.size(); ++count) {
            CacheInfo chk = this.cacheInfo.get(count);
            if (!Pattern.matches(chk.pattern() + ".*", origURI)) continue;
            info = chk;
        }
        if (info == null) {
            info = this.defaultCacheInfo;
        }
        if (!info.cache()) {
            return true;
        }
        Pattern uriPattern = Pattern.compile(info.pattern() + ".*");
        int cacheCount = 0;
        long cacheSize = 0L;
        boolean found = false;
        Element node = DOMUtils.getFirstElement(this.catalog);
        while (node != null) {
            found = found || node == entry;
            String srcuri = null;
            srcuri = node.hasAttribute("systemId") ? node.getAttribute("systemId") : node.getAttribute("name");
            if (uriPattern.matcher(srcuri).matches()) {
                ++cacheCount;
                File lclFile = new File(node.getAttribute("uri"));
                cacheSize += lclFile.length();
            }
            node = DOMUtils.getNextElement(node);
        }
        if (!found) {
            return false;
        }
        long cacheTime = -1L;
        if (entry.hasAttributeNS("http://xmlresolver.org/ns/catalog", "time")) {
            cacheTime = Long.parseLong(entry.getAttributeNS("http://xmlresolver.org/ns/catalog", "time"));
        }
        if ((long)cacheCount > info.cacheSize()) {
            return true;
        }
        if (cacheSize > info.cacheSpace()) {
            return true;
        }
        long lastModified = 0L;
        try {
            URL url = new URL(origURI);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            lastModified = conn.getLastModified();
            if (lastModified == 0L) {
                lastModified = conn.getDate();
            }
            if (conn.getResponseCode() != 200) {
                logger.finer("Expired " + origURI + "? No (HTTP " + conn.getResponseCode() + ").");
                return false;
            }
        }
        catch (MalformedURLException mue) {
            logger.finer("Expired " + origURI + "? No (MalformedURLException).");
            return false;
        }
        catch (IOException ioe) {
            logger.finer("Expired " + origURI + "? No (IOException)");
            return false;
        }
        if (lastModified == 0L) {
            logger.finer("Expired " + origURI + "? Yes (no last-modified header)");
            return true;
        }
        if (lastModified > cacheTime) {
            logger.finer("Expired " + origURI + "? Yes.");
            this.expire(uri);
            return true;
        }
        logger.finer("Expired " + origURI + "? No.");
        return false;
    }

    private synchronized void expire(String localFile) {
        DirectoryLock lock = new DirectoryLock();
        if (!lock.locked()) {
            return;
        }
        String name = localFile;
        int pos = name.lastIndexOf("/");
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        if ((pos = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, pos);
        }
        logger.info("Expiring: " + name);
        File entry = new File(this.entryDir + "/" + name + ".xml");
        if (entry.exists() && entry.isFile()) {
            File renamed = new File(this.expiredDir + "/" + name + ".xml");
            entry.renameTo(renamed);
            renamed.setLastModified(calendar.getTimeInMillis());
        }
        this.cache = null;
        lock.unlock();
    }

    private String pickSuffix(String uri, String contentType) {
        if (contentType == null) {
            return ".bin";
        }
        if (contentType.contains("application/xml")) {
            return ".xml";
        }
        if (contentType.contains("text/html") || contentType.contains("application/html+xml")) {
            return ".html";
        }
        if (contentType.contains("text/plain")) {
            if (uri.endsWith(".dtd")) {
                return ".dtd";
            }
            return ".txt";
        }
        return ".bin";
    }

    class CacheInfo {
        private boolean cache = true;
        private String pattern = "";
        private long deleteWait = -1L;
        private long cacheSize = -1L;
        private long cacheSpace = -1L;

        public CacheInfo(String uriPattern, boolean cache, long deleteWait, long cacheSize, long cacheSpace) {
            this.pattern = uriPattern;
            this.cache = cache;
            this.deleteWait = deleteWait;
            this.cacheSize = cacheSize;
            this.cacheSpace = cacheSpace;
        }

        public String pattern() {
            return this.pattern;
        }

        public boolean cache() {
            return this.cache;
        }

        public long deleteWait() {
            return this.deleteWait;
        }

        public long cacheSize() {
            return this.cacheSize;
        }

        public long cacheSpace() {
            return this.cacheSpace;
        }
    }

    class DirectoryLock {
        private File lockF = null;
        private RandomAccessFile lockFile = null;
        private FileChannel lockChannel = null;
        private FileLock lock = null;
        private boolean locked = false;

        public DirectoryLock() {
            try {
                this.lockF = new File(ResourceCache.this.cacheDir.toString() + "/lock");
                this.lockFile = new RandomAccessFile(this.lockF, "rw");
                this.lockChannel = this.lockFile.getChannel();
                this.lock = this.lockChannel.lock();
                this.locked = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean locked() {
            return this.locked;
        }

        public void unlock() {
            try {
                this.lock.release();
                this.locked = false;
                this.lockFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

