// Code generated by re2c, DO NOT EDIT.
//line "go/submatch/02_mtags.re":1
//go:generate re2go $INPUT -o $OUTPUT
package main

import "reflect"

const (
	mtagRoot int = -1
	tagNone int = -1
)

// An m-tag tree is a way to store histories with an O(1) copy operation.
// Histories naturally form a tree, as they have common start and fork at some
// point. The tree is stored as an array of pairs (tag value, link to parent).
// An m-tag is represented with a single link in the tree (array index).
type mtagElem struct {
	elem int
	pred int
}
type mtagTrie = []mtagElem

type Ver = []int // unbounded number of version components

func s2n(s string) int { // convert pre-parsed string to a number
	n := 0
	for _, c := range s { n = n*10 + int(c-'0') }
	return n
}

// Append a single value to an m-tag history.
func add_mtag(trie *mtagTrie, mtag int, value int) int {
	*trie = append(*trie, mtagElem{value, mtag})
	return len(*trie) - 1
}

// Recursively unwind tag histories and collect version components.
func unwind(trie mtagTrie, x int, y int, str string) Ver {
	// Reached the root of the m-tag tree, stop recursion.
	if x == mtagRoot && y == mtagRoot {
		return []int{}
	}

	// Unwind history further.
	ver := unwind(trie, trie[x].pred, trie[y].pred, str)

	// Get tag values. Tag histories must have equal length.
	if x == mtagRoot || y == mtagRoot {
		panic("tag histories have different length")
	}
	ex := trie[x].elem
	ey := trie[y].elem

	if ex != tagNone && ey != tagNone {
		// Both tags are valid string indices, extract component.
		ver = append(ver, s2n(str[ex:ey]))
	} else if !(ex == tagNone && ey == tagNone) {
		panic("both tags should be tagNone")
	}
	return ver
}

func parse(str string) []int {
	var cur, mar int
	trie := make([]mtagElem, 0)

	// User-defined tag variables that are available in semantic action.
	var t1, t2, t3, t4 int

	// Autogenerated tag variables used by the lexer to track tag values.
	
//line "go/submatch/02_mtags.go":73
var yyt1 int
	var yyt2 int
//line "go/submatch/02_mtags.re":69

	
//line "go/submatch/02_mtags.go":79
	yytm3 := mtagRoot
	yytm4 := mtagRoot
//line "go/submatch/02_mtags.re":70


	
//line "go/submatch/02_mtags.go":86
{
	var yych byte
	yych = str[cur]
	switch (yych) {
	case '0','1','2','3','4','5','6','7','8','9':
		yyt1 = cur
		goto yy3
	default:
		goto yy1
	}
yy1:
	cur += 1
yy2:
//line "go/submatch/02_mtags.re":93
	{ return nil }
//line "go/submatch/02_mtags.go":102
yy3:
	cur += 1
	mar = cur
	yych = str[cur]
	switch (yych) {
	case 0x00:
		yytm4 = add_mtag(&trie, yytm4, tagNone)
		yytm3 = add_mtag(&trie, yytm3, tagNone)
		yyt2 = cur
		goto yy4
	case '.':
		yyt2 = cur
		goto yy5
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy7
	default:
		goto yy2
	}
yy4:
	cur += 1
	t1 = yyt1
	t2 = yyt2
	t3 = yytm3
	t4 = yytm4
//line "go/submatch/02_mtags.re":87
	{
			ver := make([]int, 0)
			ver = append(ver, s2n(str[t1:t2]))
			ver = append(ver, unwind(trie, t3, t4, str)...)
			return ver
		}
//line "go/submatch/02_mtags.go":134
yy5:
	cur += 1
	yych = str[cur]
	switch (yych) {
	case '0','1','2','3','4','5','6','7','8','9':
		yytm3 = add_mtag(&trie, yytm3, cur)
		goto yy8
	default:
		goto yy6
	}
yy6:
	cur = mar
	goto yy2
yy7:
	cur += 1
	yych = str[cur]
	switch (yych) {
	case 0x00:
		yytm4 = add_mtag(&trie, yytm4, tagNone)
		yytm3 = add_mtag(&trie, yytm3, tagNone)
		yyt2 = cur
		goto yy4
	case '.':
		yyt2 = cur
		goto yy5
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy7
	default:
		goto yy6
	}
yy8:
	cur += 1
	yych = str[cur]
	switch (yych) {
	case 0x00:
		yytm4 = add_mtag(&trie, yytm4, cur)
		goto yy4
	case '.':
		yytm4 = add_mtag(&trie, yytm4, cur)
		goto yy5
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy8
	default:
		goto yy6
	}
}
//line "go/submatch/02_mtags.re":94

}

func main() {
	assert_eq := func(x, y []int) {
		if !reflect.DeepEqual(x, y) { panic("error") }
	}
	assert_eq(parse("1\000"), []int{1})
	assert_eq(parse("1.2.3.4.5.6.7\000"), []int{1, 2, 3, 4, 5, 6, 7})
	assert_eq(parse("1.\000"), nil)
}
