/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../../libdrgn/tests/crc32.c.in" instead.
 */

#include <check.h>

#line 1 "../../libdrgn/tests/crc32.c.in"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

#include <stdint.h>

#include "test_util.h"
#include "../crc32.h"

static uint32_t string_crc32(const char *s)
{
	return ~crc32_update(~0, s, strlen(s));
}



START_TEST(empty)
{
#line 19
{
	ck_assert_uint_eq(string_crc32(""), 0);
}

}
END_TEST

START_TEST(simple)
{
#line 24
{
	// https://reveng.sourceforge.io/crc-catalogue/17plus.htm#crc.cat.crc-32-iso-hdlc
	ck_assert_uint_eq(string_crc32("123456789"), 0xcbf43926);
	// http://www.febooti.com/products/filetweak/members/hash-and-crc/test-vectors/
	ck_assert_uint_eq(string_crc32("The quick brown fox jumps over the lazy dog"),
			  0x414fa339);
}

}
END_TEST

START_TEST(update)
{
#line 33
{
	uint32_t crc = ~0;
	crc = crc32_update(crc, "12", 2);
	crc = crc32_update(crc, "345", 3);
	crc = crc32_update(crc, "6789", 4);
	crc = ~crc;
	ck_assert_uint_eq(crc, 0xcbf43926);
}
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("crc32");
    TCase *tc1_1 = tcase_create("crc32");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, empty);
    tcase_add_test(tc1_1, simple);
    tcase_add_test(tc1_1, update);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
