searchData={"items":[{"type":"module","title":"xmerl","doc":"Functions for exporting XML data to an external format.","ref":"xmerl.html"},{"type":"type","title":"xmerl.callback/0","doc":"A callback module or a list of inherited callback modules.","ref":"xmerl.html#t:callback/0"},{"type":"function","title":"xmerl.callbacks/1","doc":"Find the list of inherited callback modules for a given module.","ref":"xmerl.html#callbacks/1"},{"type":"type","title":"xmerl.element/0","doc":"Normal, well-formed, XML content element.","ref":"xmerl.html#t:element/0"},{"type":"function","title":"xmerl.export/2","doc":"Equivalent to  export(Content, Callback, []) .","ref":"xmerl.html#export/2"},{"type":"function","title":"xmerl.export/3","doc":"Export XML content.\n\nExports normal, well-formed XML content, using the specified callback module.\n\n`Element` is any of:\n\n- `#xmlText{}`\n- `#xmlElement{}`\n- `#xmlPI{}`\n- `#xmlComment{}`\n- `#xmlDecl{}`\n\n(See `xmerl.hrl` for the record definitions.) Text in `#xmlText{}` elements can\nbe deep lists of characters and/or binaries.\n\n`RootAttributes` is a list of `#xmlAttribute{}` attributes for the `#root#`\nelement, which implicitly becomes the parent of the given `Content`. The\ntag-handler function for `#root#` is thus called with the complete exported data\nof `Content`. Root attributes can be used to specify e.g. encoding or other\nmetadata of an XML or HTML document.\n\nThe `Callback` module should contain hook functions for all tags present in the\ndata structure. A hook function must have the following format:\n\n```text\n    Tag(Data, Attributes, Parents, E)\n```\n\nwhere `E` is the corresponding `#xmlElement{}`, `Data` is the already-exported\ncontents of `E` and `Attributes` is the list of `#xmlAttribute{}` records of\n`E`. Finally, `Parents` is the list of parent nodes of `E`, on the form\n`[{ParentTag::atom(), ParentPosition::integer()}]`.\n\nThe hook function should return either the data to be exported, or a tuple\n`{'#xml-alias#', NewTag::atom()}`, or a tuple `{'#xml-redefine#', Content}`,\nwhere `Content` is a content list (which can be on simple-form; see\n[`export_simple/2`](`export_simple/2`) for details).\n\nA callback module can inherit definitions from other callback modules, through\nthe required function `'#xml-interitance#'() -> [ModuleName::atom()]`.\n\n_See also:_ `export/2`, `export_simple/3`.","ref":"xmerl.html#export/3"},{"type":"function","title":"xmerl.export_content/2","doc":"Export normal XML content directly, without further context.","ref":"xmerl.html#export_content/2"},{"type":"function","title":"xmerl.export_element/2","doc":"Exports a normal XML element directly, without further context.","ref":"xmerl.html#export_element/2"},{"type":"function","title":"xmerl.export_element/3","doc":"For on-the-fly exporting during parsing (SAX style) of the XML document.","ref":"xmerl.html#export_element/3"},{"type":"function","title":"xmerl.export_simple/2","doc":"Equivalent to  export_simple(Content, Callback, []) .","ref":"xmerl.html#export_simple/2"},{"type":"function","title":"xmerl.export_simple/3","doc":"Export \"simple-form\" XML content.\n\nExports \"simple-form\" XML content, using the specified callback-module.\n\n`Element` is any of:\n\n- `{Tag, Attributes, Content}`\n- `{Tag, Content}`\n- `Tag`\n- `IOString`\n- `#xmlText{}`\n- `#xmlElement{}`\n- `#xmlPI{}`\n- `#xmlComment{}`\n- `#xmlDecl{}`\n\nwhere\n\n- `Tag = atom()`\n- `Attributes = [{Name, Value}]`\n- `Name = atom()`\n- `Value = IOString | atom() | integer()`\n\nNormal-form XML elements can thus be included in the simple-form representation.\nNote that content lists must be flat. An `IOString` is a (possibly deep) list of\ncharacters and/or binaries.\n\n`RootAttributes` is a list of:\n\n- `XmlAttributes = #xmlAttribute{}`\n\nSee [`export/3`](`export/3`) for details on the callback module and the root\nattributes. The XML-data is always converted to normal form before being passed\nto the callback module.\n\n_See also:_ `export/3`, `export_simple/2`.","ref":"xmerl.html#export_simple/3"},{"type":"function","title":"xmerl.export_simple_content/2","doc":"Exports simple XML content directly, without further context.","ref":"xmerl.html#export_simple_content/2"},{"type":"function","title":"xmerl.export_simple_element/2","doc":"Export a simple XML element directly, without further context.","ref":"xmerl.html#export_simple_element/2"},{"type":"type","title":"xmerl.simple_attribute/0","doc":"\"Simple-form\" XML attribute.","ref":"xmerl.html#t:simple_attribute/0"},{"type":"type","title":"xmerl.simple_element/0","doc":"\"Simple-form\" XML content element.","ref":"xmerl.html#t:simple_element/0"},{"type":"type","title":"xmerl.xmlAttribute/0","doc":"Record `#xmlAttribute{}`.","ref":"xmerl.html#t:xmlAttribute/0"},{"type":"type","title":"xmerl.xmlComment/0","doc":"Record `#xmlComment{}`.","ref":"xmerl.html#t:xmlComment/0"},{"type":"type","title":"xmerl.xmlDecl/0","doc":"Record `#xmlDecl{}`.","ref":"xmerl.html#t:xmlDecl/0"},{"type":"type","title":"xmerl.xmlDocument/0","doc":"Record `#xmlDocument{}`.","ref":"xmerl.html#t:xmlDocument/0"},{"type":"type","title":"xmerl.xmlElement/0","doc":"Record `#xmlElement{}`.","ref":"xmerl.html#t:xmlElement/0"},{"type":"type","title":"xmerl.xmlNamespace/0","doc":"Record `#xmlNamespace{}`.","ref":"xmerl.html#t:xmlNamespace/0"},{"type":"type","title":"xmerl.xmlNsNode/0","doc":"Record `#xmlNsNode{}`.","ref":"xmerl.html#t:xmlNsNode/0"},{"type":"type","title":"xmerl.xmlPI/0","doc":"Record `#xmlPI{}`.","ref":"xmerl.html#t:xmlPI/0"},{"type":"type","title":"xmerl.xmlText/0","doc":"Record `#xmlText{}`.","ref":"xmerl.html#t:xmlText/0"},{"type":"module","title":"xmerl_eventp","doc":"Simple event-based processors (front-ends to `m:xmerl_scan`).\n\nImplements processing XML documents in streams for parsing in SAX style.\n\nEach front-end contains more elaborate settings of\n`m:xmerl_scan` that makes usage of the customization functions.","ref":"xmerl_eventp.html"},{"type":"function","title":"xmerl_eventp.file_sax/4","doc":"Parse file containing an XML document, SAX style.\n\nWrapper for a call to the XML parser `m:xmerl_scan` with\na [`hook_fun`](`t:xmerl_scan:option_list/0`) for\nusing Xmerl export functionality directly after an entity is parsed.","ref":"xmerl_eventp.html#file_sax/4"},{"type":"type","title":"xmerl_eventp.option_list/0","doc":"Options allow to customize the behaviour of the scanner.  See also the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).\n\n \nPossible options are:\n \n \n   {acc_fun, Fun}  \n    Call back function to accumulate contents of entity. \n   {continuation_fun, Fun} |\n           {continuation_fun, Fun, ContinuationState}  \n    Call back function to decide what to do if the scanner runs into EOF\n    before the document is complete. \n   {event_fun, Fun} |\n           {event_fun, Fun, EventState}  \n    Call back function to handle scanner events. \n   {fetch_fun, Fun} |\n           {fetch_fun, Fun, FetchState}  \n    Call back function to fetch an external resource. \n   {hook_fun, Fun} |\n           {hook_fun, Fun, HookState}  \n    Call back function to process the document entities once\n    identified. \n   {close_fun, Fun}  \n    Called when document has been completely parsed. \n   {rules, ReadFun, WriteFun, RulesState} |\n           {rules, Rules}  \n    Handles storing of scanner information when parsing. \n   {user_state, UserState}  \n    Global state variable accessible from all customization functions \n\n   {fetch_path, PathList}  \n    PathList is a list of\n    directories to search when fetching files. If the file in question\n    is not in the fetch_path, the URI will be used as a file\n    name. \n   {space, Flag}  \n     preserve  (default) to preserve spaces,\n    normalize  to accumulate consecutive whitespace\n   and replace it with one space. \n   {line, Line}  \n    To specify starting line for scanning in document which contains\n   fragments of XML. \n   {namespace_conformant, Flag}  \n    Controls whether to behave as a namespace conformant XML parser,\n    false  (default) to not otherwise  true . \n   {validation, Flag}  \n    Controls whether to process as a validating XML parser:\n    off  (default) no validation, or validation  dtd \n   by DTD or  schema  by XML Schema.\n    false  and  true  options are obsolete\n   (i.e. they may be removed in a future release), if used  false \n   equals  off  and  true  equals  dtd . \n   {schemaLocation, [{Namespace,Link}|...]}  \n    Tells explicitly which XML Schema documents to use to validate\n   the XML document. Used together with the\n    {validation,schema}  option. \n   {quiet, Flag}  \n    Set to  true  if Xmerl should behave quietly\n   and not output any information to standard output\n   (default  false ). \n   {doctype_DTD, DTD}  \n    Allows to specify DTD name when it isn't available in the XML\n   document. This option has effect only together with\n    {validation, dtd   option. \n   {xmlbase, Dir}  \n    XML Base directory. If using string/1 default is current directory.\n   If using file/1 default is directory of given file. \n   {encoding, Enc}  \n    Set default character set used (default UTF-8).\n   This character set is used only if not explicitly given by the XML\n   declaration.  \n   {document, Flag}  \n    Set to  true  if Xmerl should return a complete XML document\n   as an xmlDocument record (default  false ). \n   {comments, Flag}  \n    Set to  false  if Xmerl should skip comments\n   otherwise they will be returned as xmlComment records\n   (default  true ). \n   {default_attrs, Flag}  \n    Set to  true  if Xmerl should add to elements\n   missing attributes with a defined default value\n   (default  false ).","ref":"xmerl_eventp.html#t:option_list/0"},{"type":"function","title":"xmerl_eventp.stream/2","doc":"Parse file containing an XML document as a stream, DOM style.\n\nWrapper for a call to the XML parser `m:xmerl_scan` with\na [`continuation_fun`](`t:xmerl_scan:option_list/0`) for handling\nstreams of XML data. Note that the `continuation_fun`, `acc_fun`,\n`fetch_fun`, `rules` and `close_fun` options cannot be user defined\nusing this parser.","ref":"xmerl_eventp.html#stream/2"},{"type":"function","title":"xmerl_eventp.stream_sax/4","doc":"Parse file containing an XML document as a stream, SAX style.\n\nWrapper for a call to the XML parser `m:xmerl_scan` with\na [`continuation_fun`](`t:xmerl_scan:option_list/0`) for handling\nstreams of XML data.  Note that the `continuation_fun`, `acc_fun`,\n`fetch_fun`, `rules`, `hook_fun`, `close_fun` and `user_state` options\ncannot be user defined using this parser.","ref":"xmerl_eventp.html#stream_sax/4"},{"type":"function","title":"xmerl_eventp.string_sax/4","doc":"Parse file containing an XML document, SAX style.\n\nWrapper for a call to the XML parser `m:xmerl_scan`\nwith a [`hook_fun`](`t:xmerl_scan:option_list/0`) for using\nXmerl export functionality directly after an entity is parsed.","ref":"xmerl_eventp.html#string_sax/4"},{"type":"type","title":"xmerl_eventp.xmlElement/0","doc":"Record `#xmlElement{}`","ref":"xmerl_eventp.html#t:xmlElement/0"},{"type":"module","title":"xmerl_sax_parser","doc":"XML SAX parser API\n\nA SAX parser for XML that sends the events through a callback interface. SAX is\nthe _Simple API for XML_, originally a Java-only API. SAX was the first widely\nadopted API for XML in Java, and is a _de facto_ standard where there are\nversions for several programming language environments other than Java.","ref":"xmerl_sax_parser.html"},{"type":"type","title":"xmerl_sax_parser.continuation_fun/0","doc":"Callback `t:function/0` that is called whenever\nthe parser runs out if input data.\n\nIf the function can't get hold of more input an empty list or binary\n(depends on start input in stream/2) is returned.  Other types of errors\nare handled through  exceptions. Use `throw/1` to send the following tuple:\n`{Tag = atom(), Reason = string()}` if the continuation function encounters\na fatal error.  [`Tag`](`t:atom/0`) is an atom that identifies\nthe functional entity that sends the exception and [`Reason`](`t:string/0`)\nis a string that describes the problem.","ref":"xmerl_sax_parser.html#t:continuation_fun/0"},{"type":"type","title":"xmerl_sax_parser.continuation_state/0","doc":"","ref":"xmerl_sax_parser.html#t:continuation_state/0"},{"type":"type","title":"xmerl_sax_parser.event/0","doc":"SAX events that are sent to the user via the\n[event callback](`t:event_fun/0`).\n\n- **`startDocument`** - Receive notification of the beginning of a document. The\n  SAX parser will send this event only once before any other event callbacks.\n\n- **`endDocument`** - Receive notification of the end of a document. The SAX\n  parser will send this event only once, and it will be the last event during\n  the parse.\n\n- **`{startPrefixMapping, Prefix, Uri}`** - Begin the scope of a prefix-URI\n  Namespace mapping. Note that `start/endPrefixMapping` events\n  aren't guaranteed to be properly nested relative to each other:\n  all `startPrefixMapping` events will occur immediately before\n  the corresponding `startElement` event, and all `endPrefixMapping` events\n  will occur immediately after the corresponding\n  `endElement` event, but their order is not otherwise guaranteed.\n  There will not be `start/endPrefixMapping` events for the \"xml\" prefix,\n  since it is predeclared and immutable.\n\n- **`{endPrefixMapping, Prefix}`** - End the scope of a prefix-URI mapping.\n\n- **`{startElement, Uri, LocalName, QualifiedName, Attributes}`** - Receive\n  notification of the beginning of an element.  The Parser will send this event\n  at the beginning of every element in the XML document; there will be a\n  corresponding `endElement` event for every `startElement` event\n  (even when the element is empty).  All of the element's content\n  will be reported, in order, before the corresponding `endElement` event.\n\n- **`{endElement, Uri, LocalName, QualifiedName}`** - Receive notification of\n  the end of an element. The SAX parser will send this event at the end of every\n  element in the XML document; there will be a corresponding `startElement`\n  event for every `endElement` event (even when the element is empty).\n\n- **`{characters, string()}`** - Receive notification of character data.\n\n- **`{ignorableWhitespace, string()}`** - Receive notification of ignorable\n  whitespace in element content.\n\n- **`{processingInstruction, Target, Data}`** - Receive notification of a\n  processing instruction. The Parser will send this event once for each\n  processing instruction found: note that processing instructions may occur\n  before or after the main document element.\n\n- **`{comment, string()}`** - Report an XML comment anywhere in the document\n  (both inside and outside of the document element).\n\n- **`startCDATA`** - Report the start of a CDATA section. The contents of the\n  CDATA section will be reported through the regular characters event.\n\n- **`endCDATA`** - Report the end of a CDATA section.\n\n- **`{startDTD, Name, PublicId, SystemId}`** - Report the start of DTD\n  declarations, it's reporting the start of the DOCTYPE declaration. If the\n  document has no DOCTYPE declaration, this event will not be sent.\n\n- **`endDTD`** - Report the end of DTD declarations, it's reporting the end of\n  the DOCTYPE declaration.\n\n- **`{startEntity, SysId}`** - Report the beginning of some internal and\n  external XML entities.\n\n- **`{endEntity, SysId}`** - Report the end of an entity.\n\n- **`{elementDecl, Name, Model}`** - Report an element type declaration. The\n  content model will consist of the string \"EMPTY\", the string \"ANY\", or a\n  parenthesised group, optionally followed by an occurrence indicator. The model\n  will be normalized so that all parameter entities are fully resolved and all\n  whitespace is removed,and will include the enclosing parentheses. Other\n  normalization (such as removing redundant parentheses or simplifying\n  occurrence indicators) is at the discretion of the parser.\n\n- **`{attributeDecl, ElementName, AttributeName, Type, Mode, Value}`** - Report\n  an attribute type declaration.\n\n- **`{internalEntityDecl, Name, Value}`** - Report an internal entity\n  declaration.\n\n- **`{externalEntityDecl, Name, PublicId, SystemId}`** - Report a parsed\n  external entity declaration.\n\n- **`{unparsedEntityDecl, Name, PublicId, SystemId, Ndata}`** - Receive\n  notification of an unparsed entity declaration event.\n\n- **`{notationDecl, Name, PublicId, SystemId}`** - Receive notification of a\n  notation declaration event.","ref":"xmerl_sax_parser.html#t:event/0"},{"type":"type","title":"xmerl_sax_parser.event_fun/0","doc":"Callback `t:function/0` that is called for every event sent by the parser.\n\nThe error handling is done through exceptions. Use `throw/1` to send\nthe following tuple: `{Tag = atom(), Reason = string()}` if the application\nencounters a fatal error.  [`Tag`](`t:atom/0`) is an atom that identifies\nthe functional entity that sends the exception and [`Reason`](`t:string/0`)\nis a string that describes the problem.","ref":"xmerl_sax_parser.html#t:event_fun/0"},{"type":"type","title":"xmerl_sax_parser.event_location/0","doc":"","ref":"xmerl_sax_parser.html#t:event_location/0"},{"type":"type","title":"xmerl_sax_parser.event_state/0","doc":"","ref":"xmerl_sax_parser.html#t:event_state/0"},{"type":"function","title":"xmerl_sax_parser.file/2","doc":"Parse a file containing an XML document.\n\nThis functions uses a default continuation function to read the file in blocks.","ref":"xmerl_sax_parser.html#file/2"},{"type":"type","title":"xmerl_sax_parser.latin1_binary/0","doc":"Binary with characters encoded in iso-latin-1.","ref":"xmerl_sax_parser.html#t:latin1_binary/0"},{"type":"type","title":"xmerl_sax_parser.options/0","doc":"Options used to customize the behaviour of the parser.\n\nPossible options are:\n\n- **`{continuation_fun, ContinuationFun}`** -\n  [ContinuationFun](`t:continuation_fun/0`) is a callback function to decide\n  what to do if the parser runs into EOF before the document is complete.\n\n- **`{continuation_state, ContinuationState}`** - State that is accessible\n  in the continuation callback function.\n\n- **`{event_fun, EventFun}`** - [EventFun](`t:event_fun/0`) is\n  the callback function for parser events.\n\n- **`{event_state, EventState}`** - State that is accessible\n  in the event callback function.\n\n- **`{file_type, FileType}`** - Flag that tells the parser\n  if it's parsing a DTD or a normal XML file (default `normal`).\n\n- **`{encoding, Encoding}`** - Set default character set used\n  (default `utf`, that is: UTF-8).  This character set is used\n  only if not explicitly given by the XML document.\n\n- **`skip_external_dtd`** - Skips the external DTD during parsing. This option\n  is the same as `{external_entities, none}` and `{fail_undeclared_ref, false}`\n  but just for the DTD.\n\n- **`disallow_entities`** - Implies that parsing fails if an ENTITY declaration\n  is found.\n\n- **`{entity_recurse_limit, N}`** - Sets how many levels of recursion that is\n  allowed for entities. Default is 3 levels.\n\n- **`{external_entities, Allowed}`** - Sets which types of external entities\n  that should be allowed; if not allowed it is just skipped. Default is `none`.\n\n- **`{fail_undeclared_ref, Boolean}`** - Decides how the parser should behave\n  when an undeclared reference is found. Can be useful if one has turned of\n  external entities so that an external DTD is not parsed. Default is `true`.\n\n- **`{discard_ws_before_xml_document, Boolean}`** - Discard whitespace before\n  `xml` tag instead of returning a fatal error. Default is `false`.","ref":"xmerl_sax_parser.html#t:options/0"},{"type":"function","title":"xmerl_sax_parser.stream/2","doc":"Parse a stream containing an XML document.","ref":"xmerl_sax_parser.html#stream/2"},{"type":"type","title":"xmerl_sax_parser.unicode_binary/0","doc":"Binary with characters encoded in UTF-8 or UTF-16.","ref":"xmerl_sax_parser.html#t:unicode_binary/0"},{"type":"type","title":"xmerl_sax_parser.unicode_char/0","doc":"Integer representing valid unicode codepoint.","ref":"xmerl_sax_parser.html#t:unicode_char/0"},{"type":"module","title":"xmerl_scan","doc":"Single pass XML scanner.\n\nThis module is the interface to the XML parser, it handles XML 1.0.\nThe XML parser is activated through\n[`xmerl_scan:string/[1,2]`](`string/1`) or\n[`xmerl_scan:file/[1,2]`](`file/1`). It returns records\nof the type defined in `xmerl.hrl`.\n\nSee also the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html"},{"type":"function","title":"xmerl_scan.accumulate_whitespace/4","doc":"Accumulate and normalize whitespace.","ref":"xmerl_scan.html#accumulate_whitespace/4"},{"type":"function","title":"xmerl_scan.cont_state/1","doc":"Fetch the `ContinuationState`.\n\nSee the [\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#cont_state/1"},{"type":"function","title":"xmerl_scan.cont_state/2","doc":"Set the ContinuationState, to be used in a continuation function.\n\nThe continuation function is called when the parser encounters\nthe end of the byte stream. See the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#cont_state/2"},{"type":"type","title":"xmerl_scan.document/0","doc":"An XML document.\n\nThe document returned by [`xmerl_scan:string/[1,2]`](`string/1`) and\n[`xmerl_scan:file/[1,2]`](`file/1`). The type of the returned record\ndepends on the value of the [`document`](`t:option_list/0`) option\npassed to the function.","ref":"xmerl_scan.html#t:document/0"},{"type":"function","title":"xmerl_scan.event_state/1","doc":"Fetch the `EventState`.\n\nSee the [\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#event_state/1"},{"type":"function","title":"xmerl_scan.event_state/2","doc":"Set the EventState, to be used in an event function.\n\nThe event function is called at the beginning and at the end\nof a parsed entity. See the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#event_state/2"},{"type":"function","title":"xmerl_scan.fetch_state/1","doc":"Fetch the `FetchState`.\n\nSee the [\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#fetch_state/1"},{"type":"function","title":"xmerl_scan.fetch_state/2","doc":"Set the FetchState, to be used in a fetch function.\n\nThe fetch function is and called when the parser fetches\nan external resource (eg. a DTD). See the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#fetch_state/2"},{"type":"function","title":"xmerl_scan.file/1","doc":"Equivalent to  file(Filename, []) .","ref":"xmerl_scan.html#file/1"},{"type":"function","title":"xmerl_scan.file/2","doc":"Parse a file containing an XML document","ref":"xmerl_scan.html#file/2"},{"type":"type","title":"xmerl_scan.global_state/0","doc":"The global state of the scanner, represented by the `#xmerl_scanner{}` record.","ref":"xmerl_scan.html#t:global_state/0"},{"type":"function","title":"xmerl_scan.hook_state/1","doc":"Fetch the `HookState`.\n\nSee the [\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#hook_state/1"},{"type":"function","title":"xmerl_scan.hook_state/2","doc":"Set the HookState, to be used in a hook function.\n\nThe hook function is and called when the parser has parsed\na complete entity.  See the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#hook_state/2"},{"type":"type","title":"xmerl_scan.option_list/0","doc":"Options allow to customize the behaviour of the scanner.  See also the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).\n\nPossible options are:\n\n \n   {acc_fun, Fun}  \n    Call back function to accumulate contents of entity. \n   {continuation_fun, Fun} |\n           {continuation_fun, Fun, ContinuationState}  \n    Call back function to decide what to do if the scanner runs into EOF\n    before the document is complete. \n   {event_fun, Fun} |\n           {event_fun, Fun, EventState}  \n    Call back function to handle scanner events. \n   {fetch_fun, Fun} |\n           {fetch_fun, Fun, FetchState}  \n    Call back function to fetch an external resource. \n   {hook_fun, Fun} |\n           {hook_fun, Fun, HookState}  \n    Call back function to process the document entities once\n    identified. \n   {close_fun, Fun}  \n    Called when document has been completely parsed. \n   {rules, ReadFun, WriteFun, RulesState} |\n           {rules, Rules}  \n    Handles storing of scanner information when parsing. \n   {user_state, UserState}  \n    Global state variable accessible from all customization functions \n\n   {fetch_path, PathList}  \n    PathList is a list of\n    directories to search when fetching files. If the file in question\n    is not in the fetch_path, the URI will be used as a file\n    name. \n   {space, Flag}  \n     preserve  (default) to preserve spaces,\n    normalize  to\n   accumulate consecutive whitespace and replace it with one space. \n   {line, Line}  \n    To specify starting line for scanning in document which contains\n   fragments of XML. \n   {namespace_conformant, Flag}  \n    Controls whether to behave as a namespace conformant XML parser,\n    false  (default) to not otherwise  true . \n   {validation, Flag}  \n    Controls whether to process as a validating XML parser:\n    off  (default) no validation, or validation  dtd \n   by DTD or  schema  by XML Schema.\n    false  and  true  options are obsolete\n   (i.e. they may be removed in a future release), if used  false \n   equals  off  and  true  equals  dtd . \n   {schemaLocation, [{Namespace,Link}|...]}  \n    Tells explicitly which XML Schema documents to use to validate\n   the XML document. Used together with the\n    {validation,schema}  option. \n   {quiet, Flag}  \n    Set to  true  if Xmerl should behave quietly\n   and not output any information to standard output\n   (default  false ). \n   {doctype_DTD, DTD}  \n    Allows to specify DTD name when it isn't available in the XML\n   document. This option has effect only together with\n    {validation, dtd }  option. \n   {xmlbase, Dir}  \n    XML Base directory. If using string/1 default is current directory.\n   If using file/1 default is directory of given file. \n   {encoding, Enc}  \n    Set default character set used (default UTF-8).\n   This character set is used only if not explicitly given by the XML\n   declaration.  \n   {document, Flag}  \n    Set to  true  if Xmerl should return a complete XML document\n   as an xmlDocument record (default  false ). \n   {comments, Flag}  \n    Set to  false  if Xmerl should skip comments otherwise\n   they will be returned as xmlComment records\n   (default  true ). \n   {default_attrs, Flag}  \n    Set to  true  if Xmerl should add to elements\n   missing attributes with a defined default value\n   (default  false ). \n   {allow_entities, Flag}  \n    Set to  true  if  xmerl_scan  shouldn't fail\n   when there is an ENTITY declaration in the XML document\n   (default  false ).","ref":"xmerl_scan.html#t:option_list/0"},{"type":"function","title":"xmerl_scan.rules_state/1","doc":"Fetch the `RulesState`.\n\nSee the [\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#rules_state/1"},{"type":"function","title":"xmerl_scan.rules_state/2","doc":"Set the RulesState, to be used in a rules function.\n\nThe rules function is and called when the parser store scanner information\nin a rules database. See the\n[\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#rules_state/2"},{"type":"function","title":"xmerl_scan.string/1","doc":"Equivalent to  string(Text, []) .","ref":"xmerl_scan.html#string/1"},{"type":"function","title":"xmerl_scan.string/2","doc":"Parse a string containing an XML document","ref":"xmerl_scan.html#string/2"},{"type":"function","title":"xmerl_scan.user_state/1","doc":"Fetch the `UserState`.\n\nSee the [\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#user_state/1"},{"type":"function","title":"xmerl_scan.user_state/2","doc":"Set the `UserState`, to be used in a user function.\n\nSee the [\"Customization functions\" tutorial](`e:xmerl:xmerl_examples.html\"`).","ref":"xmerl_scan.html#user_state/2"},{"type":"type","title":"xmerl_scan.xmlDocument/0","doc":"Record `#xmlDocument{}`.\n\nThe record definition is found in `xmerl.hrl`.","ref":"xmerl_scan.html#t:xmlDocument/0"},{"type":"type","title":"xmerl_scan.xmlElement/0","doc":"Record `#xmlElement{}`.\n\nThe record definition is found in `xmerl.hrl`.","ref":"xmerl_scan.html#t:xmlElement/0"},{"type":"module","title":"xmerl_xpath","doc":"Xpath 1.0 search implementation.\n\nThe `xmerl_xpath` module handles the entire XPath 1.0 spec. XPath expressions\ntypically occur in XML attributes and are used to address parts of an XML\ndocument. The grammar is defined in `xmerl_xpath_parse.yrl`. The core functions\nare defined in `xmerl_xpath_pred.erl`.\n\nSome useful shell commands for debugging the XPath parser\n\n```text\n c(xmerl_xpath_scan).\n yecc:yecc(\"xmerl_xpath_parse.yrl\", \"xmerl_xpath_parse\", true, []).\n c(xmerl_xpath_parse).\n\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"position() > -1\")).\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"5 * 6 div 2\")).\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"5 + 6 mod 2\")).\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"5 * 6\")).\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"-----6\")).\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"parent::node()\")).\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"descendant-or-self::node()\")).\n xmerl_xpath_parse:parse(xmerl_xpath_scan:tokens(\"parent::processing-instruction('foo')\")).\n\n```","ref":"xmerl_xpath.html"},{"type":"type","title":"xmerl_xpath.nodeEntity/0","doc":"","ref":"xmerl_xpath.html#t:nodeEntity/0"},{"type":"type","title":"xmerl_xpath.option_list/0","doc":"Options to customize the behaviour of the XPath scanner.\n\nPossible options are:\n\n \n   {namespace, #xmlNamespace}  \n    Set namespace nodes, from XmlNamspace, in xmlContext \n   {namespace, Nodes}  \n    Set namespace nodes in xmlContext.","ref":"xmerl_xpath.html#t:option_list/0"},{"type":"type","title":"xmerl_xpath.parentList/0","doc":"","ref":"xmerl_xpath.html#t:parentList/0"},{"type":"function","title":"xmerl_xpath.string/2","doc":"Equivalent to  string(String, Doc, [], Doc, []) .","ref":"xmerl_xpath.html#string/2"},{"type":"function","title":"xmerl_xpath.string/3","doc":"Equivalent to  string(String, Doc, [], Doc, Options) .","ref":"xmerl_xpath.html#string/3"},{"type":"function","title":"xmerl_xpath.string/5","doc":"Extract nodes from a parsed XML tree.\n\nExtracts the nodes from the parsed XML tree according the XPath `String`.\n\n`Scalar` is an `#xmlObj{}` record record with the fields `type` and `value`,\nwhere `#xmlObj.type` is `boolean | number | string`.","ref":"xmerl_xpath.html#string/5"},{"type":"type","title":"xmerl_xpath.xPathString/0","doc":"","ref":"xmerl_xpath.html#t:xPathString/0"},{"type":"module","title":"xmerl_xs","doc":"XSLT-like XML document transformations.\n\nErlang has similarities to XSLT since both languages have a functional\nprogramming approach. Using `xmerl_xpath` it is possible to write XSLT like\ntransforms in Erlang.\n\nXSLT stylesheets are often used when transforming XML documents, to other XML\ndocuments or (X)HTML for presentation. XSLT contains quite many functions and\nlearning them all may take some effort. This document assumes a basic level of\nunderstanding of XSLT.\n\nSince XSLT is based on a functional programming approach with pattern matching\nand recursion it is possible to write similar style sheets in Erlang. At least\nfor basic transforms. This document describes how to use the XPath\nimplementation together with Erlangs pattern matching and a couple of functions\nto write XSLT like transforms.\n\nThis approach is probably easier for an Erlanger but if you need to use real\nXSLT stylesheets in order to \"comply to the standard\" there is an adapter\navailable to the Sablotron XSLT package which is written i C++. See also the\n[XSLT-like Transformations tutorial](`e:xmerl:xmerl_xs_examples.html`).","ref":"xmerl_xs.html"},{"type":"function","title":"xmerl_xs.built_in_rules/2","doc":"The default fallback behaviour.\n\nTemplate funs should end with:\n`template(E) -> built_in_rules(fun template/1, E)`.","ref":"xmerl_xs.html#built_in_rules/2"},{"type":"function","title":"xmerl_xs.select/2","doc":"Extract the nodes from the xml tree according to XPath.\n\nEquivalent to [`xmerl_xpath:string(Str, E)`](`xmerl_xpath:string/2`).\n\n_See also:_ `value_of/1`.","ref":"xmerl_xs.html#select/2"},{"type":"function","title":"xmerl_xs.value_of/1","doc":"Concatenate all text nodes within the tree.\n\nExample:\n\n```text\n   \n     \n         \n     \n   \n\n```\n\nbecomes:\n\n```text\n   template(E = #xmlElement{name='title'}) ->\n     [\"  \",\n       value_of(select(\".\", E)), \"  \"]\n\n```","ref":"xmerl_xs.html#value_of/1"},{"type":"function","title":"xmerl_xs.xslapply/2","doc":"Lookalike to xsl:apply-templates.\n\nA wrapper to make things look similar to xsl:apply-templates.\n\nExample, original XSLT:\n\n```text\n   \n     \n       \n     \n   \n\n```\n\nbecomes in Erlang:\n\n```text\n  template(E = #xmlElement{ parents=[{'doc',_}|_], name='title'}) ->\n    [\" \",\n     xslapply(fun template/1, E),\n     \" \"];\n\n```","ref":"xmerl_xs.html#xslapply/2"},{"type":"module","title":"xmerl_xsd","doc":"Interface module for XML Schema validation.\n\nIt handles the W3.org [specifications](http://www.w3.org/XML/Schema#dev) of\nXML Schema second edition 28 october 2004.  For an introduction to\nXML Schema please study [part 0](http://www.w3.org/TR/xmlschema-0/).\n\nAn XML structure is validated by [`xmerl_xsd:validate/[2,3]`](`validate/2`).","ref":"xmerl_xsd.html"},{"type":"function","title":"xmerl_xsd.file2state/1","doc":"Read the schema processing state from a file.\n\nReads the schema state with all information of the processed schema from\na file created with `state2file/[1,2]`. The format of this file is internal.\nThe state can then be used validating an XML document.","ref":"xmerl_xsd.html#file2state/1"},{"type":"type","title":"xmerl_xsd.filename/0","doc":"","ref":"xmerl_xsd.html#t:filename/0"},{"type":"function","title":"xmerl_xsd.format_error/1","doc":"Format error descriptions to human readable strings.","ref":"xmerl_xsd.html#format_error/1"},{"type":"type","title":"xmerl_xsd.global_state/0","doc":"The global state of the validator.\n\nIt is represented by the `#xsd_state{}` record.","ref":"xmerl_xsd.html#t:global_state/0"},{"type":"type","title":"xmerl_xsd.option_list/0","doc":"Options that allow to customize the behaviour of the validation.\n\nPossible options are :\n\n \n    {tab2file,boolean()}  \n      Enables saving of abstract structure on file for debugging\n        purpose. \n    {xsdbase,filename()}  \n      XSD Base directory. \n    {fetch_fun,FetchFun}  \n      Call back function to fetch an external resource. \n    {fetch_path,PathList}  \n      PathList is a list of directories to search when fetching files.\n         If the file in question is not in the fetch_path, the URI will\n         be used as a file name. \n    {state,State}  \n      It is possible by this option to provide a state with process\n         information from an earlier validation.","ref":"xmerl_xsd.html#t:option_list/0"},{"type":"function","title":"xmerl_xsd.process_schema/1","doc":"Equivalent to  process_schema(Schema, []) .","ref":"xmerl_xsd.html#process_schema/1"},{"type":"function","title":"xmerl_xsd.process_schema/2","doc":"Read an XML schema and check that it is valid.\n\nReads the referenced XML schema and checks that it is valid. Returns the\n`t:global_state/0` with schema info or an error reason. The error reason\nmay be a list of several errors or a single error encountered\nduring the processing.","ref":"xmerl_xsd.html#process_schema/2"},{"type":"function","title":"xmerl_xsd.process_schemas/1","doc":"Equivalent to  process_schemas(Schemas, []) .","ref":"xmerl_xsd.html#process_schemas/1"},{"type":"function","title":"xmerl_xsd.process_schemas/2","doc":"Read XML schemas and check that they are valid.\n\nReads the referenced XML schemas and controls they are valid. Returns the\n`t:global_state/0` with schema info or an error reason. The error reason may be\na list of several errors or a single error encountered during the processing.","ref":"xmerl_xsd.html#process_schemas/2"},{"type":"function","title":"xmerl_xsd.process_validate/2","doc":"Equivalent to  process_validate(Schema, Element, []) .","ref":"xmerl_xsd.html#process_validate/2"},{"type":"function","title":"xmerl_xsd.process_validate/3","doc":"Validate a parsed well-formed XML element towards an XML schema.\n\nValidates in two steps. First it processes the schema, saves the type and\nstructure info in an ETS table and then validates the element towards the\nschema.\n\nUsage example:\n\n`1>{E,_} = xmerl_scan:file(\"my_XML_document.xml\").`\n`2>{E2,_} = xmerl_xsd:process_validate(\"my_XML_Schema.xsd\",E).`\n\nObserve that E2 may differ from E if for instance there are default values\ndefined in `my_XML_Schema.xsd`.","ref":"xmerl_xsd.html#process_validate/3"},{"type":"function","title":"xmerl_xsd.state2file/1","doc":"Equivalent to [`state2file(State, SchemaName)`](`state2file/2`).\n\n`SchemaName` is the name of the schema in `State`.","ref":"xmerl_xsd.html#state2file/1"},{"type":"function","title":"xmerl_xsd.state2file/2","doc":"Save the schema processing state to a file.\n\nSaves the schema state with all information of the processed schema in a file.\nYou can provide the file name for the saved state. FileName is saved with the\n`.xss` extension added.","ref":"xmerl_xsd.html#state2file/2"},{"type":"function","title":"xmerl_xsd.validate/2","doc":"Equivalent to  validate(Element, State, []) .","ref":"xmerl_xsd.html#validate/2"},{"type":"function","title":"xmerl_xsd.validate/3","doc":"Validate a parsed well-formed XML element (`Element`).\n\nA call to `validate/2` or `validate/3` must provide a well formed\nparsed XML [`Element :: #xmlElement{}`](`t:xmerl:xmlElement/0`)\nand a State, `t:global_state/0`, which holds necessary information\nfrom an already processed schema.  Thus validate enables reuse\nof the schema information and therefore if one shall validate\nseveral times towards the same schema it reduces time consumption.\n\nThe result, `ValidElement`, is the valid element that conforms to the\npost-schema-validation infoset. When the validator finds an error it tries to\ncontinue and reports a list of all errors found. In those cases an unexpected\nerror is found it may cause a single error reason.\n\nUsage example:\n``` erlang\n1>{E,_} = xmerl_scan:file(\"my_XML_document.xml\").\n2>{ok,S} = xmerl_xsd:process_schema(\"my_XML_Schema.xsd\").\n3>{E2,_} = xmerl_xsd:validate(E,S).\n```\n\nObserve that E2 may differ from E if for instance there are default values\ndefined in `my_XML_Schema.xsd`.","ref":"xmerl_xsd.html#validate/3"},{"type":"extras","title":"Xmerl Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Xmerl Release Notes\n\nThis document describes the changes made to the Xmerl application.","ref":"notes.html"},{"type":"extras","title":"Xmerl 2.1.7 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The XSD validation failed due to not handling the optional text blocks correctly in an XSD complex type with attribute `mixed=true`.\n\n  Own Id: OTP-19792 Aux Id: ERERL-1261,[PR-10249]\n\n[PR-10249]: https://github.com/erlang/otp/pull/10249","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Xmerl 2.1.6 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Corrected the bug that comments couldn't be exported.\n  \n  `#xmlComment` elements is now exported when calling `export/3` or `export_simple/3` and similar functions. Top level comments will only be exported if one creates and export elements as a document.\n\n  Own Id: OTP-19757 Aux Id: [PR-9796], [GH-5697]\n\n[PR-9796]: https://github.com/erlang/otp/pull/9796\n[GH-5697]: https://github.com/erlang/otp/issues/5697","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Xmerl 2.1.5 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The type specs of `xmerl_scan:file/2` and `xmerl_scan:string/2`\n  has been updated to return `t:dynamic/0`. Due to hook functions\n  they can return any user defined term.\n\n  Own Id: OTP-19662 Aux Id: [PR-9905], ERIERL-1225\n\n[PR-9905]: https://github.com/erlang/otp/pull/9905","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Xmerl 2.1.4 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- With this change all public functions in xmerl have specs.\n\n  Own Id: OTP-19534 Aux Id: [PR-9327]\n\n[PR-9327]: https://github.com/erlang/otp/pull/9327","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n[PR-9670]: https://github.com/erlang/otp/pull/9670","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Xmerl 2.1.3.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The XSD validation failed due to not handling the optional text blocks correctly in an XSD complex type with attribute `mixed=true`.\n\n  Own Id: OTP-19792 Aux Id: ERERL-1261,[PR-10249]\n\n[PR-10249]: https://github.com/erlang/otp/pull/10249","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Xmerl 2.1.3.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The type specs of `xmerl_scan:file/2` and `xmerl_scan:string/2`\n  has been updated to return `t:dynamic/0`. Due to hook functions\n  they can return any user defined term.\n\n  Own Id: OTP-19662 Aux Id: [PR-9905], ERIERL-1225\n\n[PR-9905]: https://github.com/erlang/otp/pull/9905","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Xmerl 2.1.3 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-3"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- A new option to discard whitespace before the `xml` tag when reading from a stream has been added to the Xmerl SAX parser.\n  \n  * __`{discard_ws_before_xml_document, Boolean}`__ - Discard whitespace before `xml` tag instead of returning a fatal error if set to `true` (`false` is default)\n\n  Own Id: OTP-19602 Aux Id: [PR-9753]\n\n[PR-9753]: https://github.com/erlang/otp/pull/9753","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Xmerl 2.1.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Corrected faulty type specification\n  \n  Corrected type specification for the input parameter of `xmerl_xs:value_of/1`.\n  \n  Also replaced underscore in the return type specifications of `xmerl_xs:select/2`,\n  `xmerl_xpath:string/2` and `xmerl_xpath:string/3` with specified return values to improve documentation.\n\n  Own Id: OTP-19571 Aux Id: ERIERL-1212, [PR-9676]\n\n[PR-9676]: https://github.com/erlang/otp/pull/9676","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Xmerl 2.1.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Some old-style `catch` expressions in the xmerl_sax_parser when the continuation fun was called caused the stack to grow until all free memory was exhausted. These parts have been rewritten so that the parser now runs correctly without growing the stack. At the same time all old-style `catch` expressions in xmerl were replaced with `try`/`catch`.\n\n  Own Id: OTP-19496 Aux Id: [GH-9190], [PR-9463]\n\n[GH-9190]: https://github.com/erlang/otp/issues/9190\n[PR-9463]: https://github.com/erlang/otp/pull/9463","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Xmerl 2.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Corrected export functions from internal structure to XML so xmlText items of type\n  cdata are handled correctly. They were just exported as normal text instead of\n  output in a CDATA section.\n\n  Own Id: OTP-19217 Aux Id: ERIERL-1104","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- The type spec for `xmerl_sax_parser:file/2` has been corrected to indicate that it can return an `{error, _}` tuple.\n\n  Own Id: OTP-19129 Aux Id: [PR-8583]\n\n[PR-8583]: https://github.com/erlang/otp/pull/8583","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Xmerl 2.0 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-2-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Some default values in Xmerl has been changed to avoid XML External Entity (XXE) vulnerabilities if you're parsing untrusted XML.\n  \n  xmerl_scan: the default value for allow_entities has changed to false.\n  xmerl_sax_parser: the default value for external_entities has changed to none.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19079 Aux Id: [GH-7539]\n\n- An event state in xmerl_sax_parser which  was updated in the event callback for a startEntity was not saved.\n\n  Own Id: OTP-19086 Aux Id: [GH-8452]\n\n[GH-7539]: https://github.com/erlang/otp/issues/7539\n[GH-8452]: https://github.com/erlang/otp/issues/8452","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Function specifications and types have been added to all public API functions.\n\n  Own Id: OTP-18913\n\n- As an alternative to `xmerl_xml`, a new export module `xmerl_xml_indent` that provides out-of-the box indented output has been added.\n\n  Own Id: OTP-18922 Aux Id: [PR-7942]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-7942]: https://github.com/erlang/otp/pull/7942\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Xmerl 1.3.34.3 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-34-3"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"* A new option to discard whitespace before the `xml` tag when reading from a stream has been added to the Xmerl SAX parser.\n\n  * __`{discard_ws_before_xml_document, Boolean}`__ - Discard whitespace before `xml` tag instead of returning a fatal error if set to `true` (`false` is default)\n\n  Own Id: OTP-19602 Aux Id: PR-9753","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Xmerl 1.3.34.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-34-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"* Some old-style `catch` expressions in the xmerl_sax_parser when the continuation fun was called caused the stack to grow until all free memory was exhausted. These parts have been rewritten so that the parser now runs correctly without growing the stack. At the same time all old-style `catch` expressions in xmerl were replaced with `try`/`catch`.\n\n  Own Id: OTP-19496 Aux Id: GH-9190, PR-9463","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Xmerl 1.3.34.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-34-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"* Corrected export functions from internal structure to XML so xmlText items of type cdata are handled correctly. They were just exported as normal text instead of output in a CDATA section.\n\n  Own Id: OTP-19217 Aux Id: ERIERL-1104","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Xmerl 1.3.34 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-34"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Update all   html tags to be   instead.\n\n  Own Id: OTP-18799 Aux Id: PR-7695","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Xmerl 1.3.33 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-33"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The xmerl version 1.3.32 was released in OTP 26.0.1, but the incorrect version\n  number of 1.3.31.1 was used for it. This incorrect version number continued to\n  appear in OTP 26.0.2, OTP 26.1, and OTP 26.1.1. The actual xmerl code in these\n  OTP versions however corresponds to xmerl version 1.3.32.\n\n  Own Id: OTP-18803","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Xmerl 1.3.32 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-32"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- New options to `xmerl_scan` and `xmerl_sax_parser` so one can limit the\n  behaviour of the parsers to avoid some XML security issues.\n\n  `xmerl_scan` gets one new option:\n\n  - **`{allow_entities, Boolean}`** - Gives the possibility to disallow entities\n    by setting this option to false (`true` is default)\n\n  `xmerl_sax_parser` gets the following options:\n\n  - **`disallow_entities`** - Don't allow entities in document\n\n  - **`{entity_recurse_limit, N}`** - Set a limit on entity recursion depth\n    (default is 3)\n\n  - **`{external_entities, AllowedType}`** - Specify which types of external\n    entities that are allowed, this also affect external DTD's. The types are\n    `all`(default), `file` and `none`\n\n  - **`{fail_undeclared_ref, Boolean}`** - Sets the behavior for undeclared\n    references due to an external file is not parsed (`true` is default)\n\n  The old option `skip_external_dtd` is still valid and the same as\n  `{external_entities, none}` and `{fail_undeclared_ref, false}` but just\n  affects DTD's and not other external references.\n\n  Own Id: OTP-18595 Aux Id: ERIERL-944","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Xmerl 1.3.31.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-31-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"* Corrected export functions from internal structure to XML so xmlText items of type cdata are handled correctly. They were just exported as normal text instead of output in a CDATA section.\n\n  Own Id: OTP-19217 Aux Id: ERIERL-1104","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Xmerl 1.3.31.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-31-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- New options to `xmerl_scan` and `xmerl_sax_parser` so one can limit the\n  behaviour of the parsers to avoid some XML security issues.\n\n  `xmerl_scan` gets one new option:\n\n  - **\\{allow_entities, Boolean\\}** - Gives the possibility to disallow entities\n    by setting this option to false (`true` is default)\n\n  `xmerl_sax_parser` gets the following options:\n\n  - **`disallow_entities`** - Don't allow entities in document\n\n  - **`{entity_recurse_limit, N}`** - Set a limit on entity recursion depth\n    (default is 3)\n\n  - **`{external_entities, AllowedType}`** - Specify which types of external\n    entities that are allowed, this also affect external DTD's. The types are\n    `all`(default), `file` and `none`\n\n  - **`{fail_undeclared_ref, Boolean}`** - Sets the behavior for undeclared\n    references due to an external file is not parsed (`true` is default)\n\n  The old option `skip_external_dtd` is still valid and the same as\n  `{external_entities, none}` and `{fail_undeclared_ref, false}` but just\n  affects DTD's and not other external references.\n\n  Own Id: OTP-18595 Aux Id: ERIERL-944","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Xmerl 1.3.31 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-31"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Xmerl 1.3.30 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-30"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- There is a new configure option, `--enable-deterministic-build`, which will\n  apply the `deterministic` compiler option when building Erlang/OTP. The\n  `deterministic` option has been improved to eliminate more sources of\n  non-determinism in several applications.\n\n  Own Id: OTP-18165 Aux Id: PR-5965","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Xmerl 1.3.29 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-29"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Fixed misspellings in both documentation, comments and code (internal data\n  structures).\n\n  Own Id: OTP-17935 Aux Id: PR-5590","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Xmerl 1.3.28.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-28-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- New options to `xmerl_scan` and `xmerl_sax_parser` so one can limit the\n  behaviour of the parsers to avoid some XML security issues.\n\n  `xmerl_scan` gets one new option:\n\n  - **\\{allow_entities, Boolean\\}** - Gives the possibility to disallow entities\n    by setting this option to false (`true` is default)\n\n  `xmerl_sax_parser` gets the following options:\n\n  - **`disallow_entities`** - Don't allow entities in document\n\n  - **`{entity_recurse_limit, N}`** - Set a limit on entity recursion depth\n    (default is 3)\n\n  - **`{external_entities, AllowedType}`** - Specify which types of external\n    entities that are allowed, this also affect external DTD's. The types are\n    `all`(default), `file` and `none`\n\n  - **`{fail_undeclared_ref, Boolean}`** - Sets the behavior for undeclared\n    references due to an external file is not parsed (`true` is default)\n\n  The old option `skip_external_dtd` is still valid and the same as\n  `{external_entities, none}` and `{fail_undeclared_ref, false}` but just\n  affects DTD's and not other external references.\n\n  Own Id: OTP-18595 Aux Id: ERIERL-944","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Xmerl 1.3.28 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-28"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fixed a bug that could cause parsing to crash.\n\n  Own Id: OTP-17388 Aux Id: OTP-17123","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Xmerl 1.3.27.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-27-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- New options to `xmerl_scan` and `xmerl_sax_parser` so one can limit the\n  behaviour of the parsers to avoid some XML security issues.\n\n  `xmerl_scan` gets one new option:\n\n  - **`{allow_entities, Boolean}`** - Gives the possibility to disallow entities\n    by setting this option to false (`true` is default)\n\n  `xmerl_sax_parser` gets the following options:\n\n  - **`disallow_entities`** - Don't allow entities in document\n\n  - **`{entity_recurse_limit, N}`** - Set a limit on entity recursion depth\n    (default is 3)\n\n  - **`{external_entities, AllowedType}`** - Specify which types of external\n    entities that are allowed, this also affect external DTD's. The types are\n    `all`(default), `file` and `none`\n\n  - **`{fail_undeclared_ref, Boolean}`** - Sets the behavior for undeclared\n    references due to an external file is not parsed (`true` is default)\n\n  The old option `skip_external_dtd` is still valid and the same as\n  `{external_entities, none}` and `{fail_undeclared_ref, false}` but just\n  affects DTD's and not other external references.\n\n  Own Id: OTP-18595 Aux Id: ERIERL-944","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Xmerl 1.3.27 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-27"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fixed the bug that Xmerl SAX parser couldn't handle files ending with a ^M.\n\n  Own Id: OTP-17308","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Xmerl 1.3.26 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-26"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Corrected namespace and expanded name in the old dom backend example module.\n\n  Own Id: OTP-17060\n\n- Corrected a bug that in some cases didn't allow unresolved references when\n  skip_external_dtd option used.\n\n  Own Id: OTP-17061","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Xmerl 1.3.25 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-25"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fix a bug that the function name didn't get normalized in some case which left\n  white spaces in links.\n\n  Own Id: OTP-16617","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Xmerl 1.3.24 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-24"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fix a performance problem when using internal general references in XML\n  content.\n\n  Own Id: OTP-16578 Aux Id: ERIERL-482","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Xmerl 1.3.23 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-23"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Replace a local floor/1 function with erlang:floor/1.\n\n  Own Id: OTP-16324","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Implement handling of parsed entity content and some other improvements.\n\n  - Updated the SAX test-suite (xmerl_sax_std_SUITE) to more recent version\n  - Test now uses its own data directory since the non-SAX xmerl test suite\n    (xmerl_std_SUITE) uses a different version of the other suite\n  - Canonical XML checks have been added to all tests that apply. Canonical, as\n    it applies here, is regular canonical XML with the addition of notation\n    declarations if any. Output must match byte-for-byte.\n  - External entities implemented, both as markup and replacement text\n  - Cyclic references are checked at the end of the DTD parse; also when a\n    reference is found\n  - Default attributes are reported in events\n  - Attributes are whitespace normalized if their type demands it\n  - External entities can have a different encoding than the base document and\n    will be transcoded to the document encoding\n  - Conditional sections (IGNORE/INCLUDE) handling has been added to DTD parsing\n  - Element content-model is now checked for well-formed-ness\n  - A few missing function clauses have been added\n\n  Own Id: OTP-16339","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Xmerl 1.3.22 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-22"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- `xmerl_sax_parser` crashed during charset detection when the xml declarations\n  attribute values was missing the closing quotation (' or \").\n\n  Own Id: OTP-15826","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Xmerl 1.3.21 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-21"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- A typo in an error printout has been fixed.\n\n  Own Id: OTP-14703 Aux Id: PR-1964","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"Xmerl 1.3.20.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-20-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- `xmerl_sax_parser` crashed during charset detection when the xml declarations\n  attribute values was missing the closing quotation (' or \").\n\n  Own Id: OTP-15826","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Xmerl 1.3.20 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-20"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Handling of character references in attributes are fixed.\n\n  Own Id: OTP-15684 Aux Id: ERL-837\n\n- Normalization of whitespace characters in attributes are fixed so it works\n  when character references are used.\n\n  Own Id: OTP-15685 Aux Id: ERL-475","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Xmerl 1.3.19 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-19"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The charset detection parsing crash in some cases when the XML directive is\n  not syntactic correct.\n\n  Own Id: OTP-15492 Aux Id: ERIERL-283","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"Xmerl 1.3.18 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions-30"},{"type":"extras","title":"Xmerl 1.3.17 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fix typos in documentation.\n\n  Own Id: OTP-15039","ref":"notes.html#fixed-bugs-and-malfunctions-31"},{"type":"extras","title":"Xmerl 1.3.16.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-16-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The charset detection parsing crash in some cases when the XML directive is\n  not syntactic correct.\n\n  Own Id: OTP-15492 Aux Id: ERIERL-283","ref":"notes.html#fixed-bugs-and-malfunctions-32"},{"type":"extras","title":"Xmerl 1.3.16 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions-33"},{"type":"extras","title":"Xmerl 1.3.15 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Improves accumulator fun in xmerl_scan so that only one #xmlText record is\n  returned for strings which have character references.\n\n  (Thanks to Jimmy Zöger)\n\n  Own Id: OTP-14377 Aux Id: PR-1369","ref":"notes.html#fixed-bugs-and-malfunctions-34"},{"type":"extras","title":"Xmerl 1.3.14 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- A couple of bugs are fixed in the sax parser (xmerl_sax_parser).\n\n  - The continuation function was not called correctly when the XML directive\n    was fragmented.\n  - When the event callback modules (xmerl_sax_old_dom and xmerl_sax_simple) got\n    an endDocument event at certain conditions the parser crashed.\n  - Replaced internal ets table with map to avoid table leakage.\n\n  Own Id: OTP-14430","ref":"notes.html#fixed-bugs-and-malfunctions-35"},{"type":"extras","title":"Xmerl 1.3.13 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The namespace_conformant option in xmerl_scan did not work when parsing\n  documents without explicit XML namespace declaration.\n\n  Own Id: OTP-14139\n\n- Fix a \"well-formedness\" bug in the XML Sax parser so it returns an error if\n  there are something more in the file after the matching document. If one using\n  the xmerl_sax_parser:stream() a rest is allowed which then can be sent to a\n  new call of xmerl_sax_parser:stream() to parse next document.\n\n  This is done to be compliant with XML conformance tests.\n\n  Own Id: OTP-14211\n\n- Fixed compiler and dialyzer warnings in the XML SAX parser.\n\n  Own Id: OTP-14212\n\n- Change how to interpret end of document in the XML SAX parser to comply with\n  Tim Brays comment on the standard. This makes it possible to handle more than\n  one doc on a stream, the standard makes it impossible to know when the\n  document is ended without waiting for the next document (and not always even\n  that).\n\n  Tim Brays comment:\n\n  Trailing \"Misc\"  \n  The fact that you're allowed some trailing junk after the root element, I\n  decided (but unfortunately too late) is a real design error in XML. If I'm\n  writing a network client, I'm probably going to close the link as soon as a I\n  see the root element end-tag, and not depend on the other end closing it down\n  properly.  \n  Furthermore, if I want to send a succession of XML documents over a network\n  link, if I find a processing instruction after a root element, is it a trailer\n  on the previous document, or part of the prolog of the next?\n\n  Own Id: OTP-14213","ref":"notes.html#fixed-bugs-and-malfunctions-36"},{"type":"extras","title":"Xmerl 1.3.12 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fix a number of broken links in the xmerl documentation.\n\n  Own Id: OTP-13880","ref":"notes.html#fixed-bugs-and-malfunctions-37"},{"type":"extras","title":"Xmerl 1.3.11 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-11"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Internal changes\n\n  Own Id: OTP-13551","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Xmerl 1.3.10 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-10"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Suppress Dialyzer warnings.\n\n  Own Id: OTP-12862","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Xmerl 1.3.9 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Removed the built-in definitions of xml.xsd from the xmerl_xsd module.\n\n  Own Id: OTP-13070","ref":"notes.html#fixed-bugs-and-malfunctions-38"},{"type":"extras","title":"Xmerl 1.3.8 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Remove compiler warnings in xmerl.\n\n  Own Id: OTP-12689","ref":"notes.html#fixed-bugs-and-malfunctions-39"},{"type":"extras","title":"Xmerl 1.3.7 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions-40"},{"type":"extras","title":"Xmerl 1.3.6 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fixed a problem in the SAX parser when the header of the next document was\n  appearing in the buffer when using xmerl_sax_parser:stream/2 function.\n\n  Own Id: OTP-11551 Aux Id: seq12505","ref":"notes.html#fixed-bugs-and-malfunctions-41"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- The default encoding of Erlang files has been changed from ISO-8859-1 to\n  UTF-8.\n\n  The encoding of XML files has also been changed to UTF-8.\n\n  Own Id: OTP-10907","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Xmerl 1.3.5 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-5"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Teach xmerl_xpath to resolve context namespaces in more cases. Thanks to\n  Daniel White.\n\n  Own Id: OTP-11461\n\n- Avoid serialization on code_server in xmerl:export(). Thanks to Richard\n  Carlsson.\n\n  Own Id: OTP-11463","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Xmerl 1.3.4 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-4"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Fixed various typos in xmerl documentation. Thanks to David Welton.\n\n  Own Id: OTP-11224","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Xmerl 1.3.3 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-3"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Xmerl 1.3.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fix a continuation bug when a new block of bytes is to be read during parsing\n  of a default declaration.\n\n  Own Id: OTP-10063 Aux Id: seq12049","ref":"notes.html#fixed-bugs-and-malfunctions-42"},{"type":"extras","title":"Xmerl 1.3.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Add missing spaces in xmerl doc (Thanks to Ricardo Catalinas Jiménez)\n\n  Own Id: OTP-9873\n\n- Fixed a continuation error in the sax parser and added latin1 as recognized\n  encoding (not only the iso-8859 variants).\n\n  Own Id: OTP-9961\n\n- Removed the unused file xmerl_xlink.hrl. Thanks to Vlad Dumitrescu for\n  informing us about it.\n\n  Own Id: OTP-9965\n\n- xmerl couldn't handle comments inside a type specification.\n\n  Own Id: OTP-10023\n\n- Fix some small errors in the sax parser: error message bug, removal of\n  trailing blanks in DTD element definitions and an documentation error of the\n  startDTD event in xmerl_sax_parser module.\n\n  Own Id: OTP-10026","ref":"notes.html#fixed-bugs-and-malfunctions-43"},{"type":"extras","title":"Xmerl 1.3 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fix character check of non-characters due to change in unicode module.\n\n  Own Id: OTP-9670\n\n- Treat , as special in xmerl_xpath_scan. (Thanks to Anneli Cuss)\n\n  Own Id: OTP-9753\n\n- Fix bug in namespace handling for attributes when the `namespace_conformant`\n  flag is set to true.\n\n  Own Id: OTP-9821","ref":"notes.html#fixed-bugs-and-malfunctions-44"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Updates to the xml scanner\n\n  - xmerl_scan is now returning xmlComment records in the output.  \n    Functions `xmerl_scan:file/2` and `xmerl_scan:string/2` now accepts a new\n    option `{comments, Flag}` for filtering of comments.  \n    Default (`true`) is that `#xmlComment` records are returned from the scanner\n    and this flag should be set to false if one don't want comments in the\n    output.\n  - Add _default_attrs_ option  \n    When _default_attrs_ is `true` any attribute with a default value defined in\n    the doctype but not in the attribute axis of the currently scanned element\n    is added to it.\n  - Allow whole documents to be returned  \n    Functions `xmerl_scan:file/2` and `xmerl_scan:string/2` now accepts a new\n    option `{document, true}` to produce a whole document as a `xmlDocument`\n    record instead of just the root element node.  \n    This option is the only way to get to the top-level comments and processing\n    instructions without hooking through the customization functions. Those\n    nodes are needed to implement \\[Canonical XML]\\[c14n-xml] support.  \n    \\[c14n-xml]: http://www.w3.org/TR/2008/PR-xml-c14n11-20080129/ _Canonical\n    XML_\n  - Parents and namespace are tracked in `#xmlAttribute` nodes\n  - Parents are tracked in `#xmlPI` nodes\n  - Set `vsn` field in `#xmlDecl` record\n  - Fix namespace-conformance constraints  \n    See \\[Namespaces in XML 1.0 (Third Edition)]\\[1]: The prefix xml is by\n    definition bound to the namespace name http://www.w3.org/XML/1998/namespace.\n    It MAY, but need not, be declared, and MUST NOT be bound to any other\n    namespace name. Other prefixes MUST NOT be bound to this namespace name, and\n    it MUST NOT be declared as the default namespace.  \n    The prefix xmlns is used only to declare namespace bindings and is by\n    definition bound to the namespace name http://www.w3.org/2000/xmlns/. It\n    MUST NOT be declared . Other prefixes MUST NOT be bound to this namespace\n    name, and it MUST NOT be declared as the default namespace. Element names\n    MUST NOT have the prefix xmlns.  \n    In XML documents conforming to this specification, no tag may contain two\n    attributes which have identical names, or have qualified names with the same\n    local part and with prefixes which have been bound to namespace names that\n    are identical.  \n    \\[1] http://www.w3.org/TR/REC-xml-names/\n\n  Updates of xmerl's Xpath functionality.\n\n  - Add `#xmlPI` support to xmerl_xpath:write_node/1\n  - Fix processing-instruction(name?)\n  - Fix path filters, support more top-level primary expressions\n  - Accumulate comments in element nodes\n  - Implement namespace axis  \n    Namespace nodes are represented as `#xmlNsNode` records. Now that the\n    namespace axis is correctly implemented, attributes nodes corresponding to\n    attributes that declare namespaces are ignored.  \n    See \\[5.3 Attribute Nodes]\\[xpath-5.3]:  \n    There are no attribute nodes corresponding to attributes that declare\n    namespaces.  \n    \\[xpath-5.3]: http://www.w3.org/TR/xpath/#attribute-nodes\n\n  (Thanks to Anthony Ramine)\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9664\n\n- Eliminate use of deprecated regexp module\n\n  Own Id: OTP-9810","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Xmerl 1.2.10 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fixed a schema search bug in xmerl_xsd.\n\n  A new flag was needed in the xsd_state record so if the state is saved there\n  is an incompatibility and a state conversion is needed.\n\n  \\*** INCOMPATIBILITY with R14B03 \\***\n\n  Own Id: OTP-9410\n\n- Fixed xmerl_scan problems with entities in attribute values.\n\n  Own Id: OTP-9411\n\n- Streaming bug in xmerl_scan.\n\n  If the continuation_fun runs out of input at the end of an attribute value\n  then it crashed. (Thanks to Simon Cornish)\n\n  Own Id: OTP-9457\n\n- Fixed xmerl_ucs UCS2 little endian en/decoding\n\n  Corrected number of shift bytes in xmerl_ucs:char_to_ucs2le and recursive call\n  from from_ucs2le to from_ucs4le. (Thanks to Michal Ptaszek)\n\n  Own Id: OTP-9548\n\n- Add latin9 (iso-8859-15) support in xmerl_ucs (Thanks to David Julien)\n\n  Own Id: OTP-9552\n\n- Improve spelling throughout documentation, code comments and error messages\n\n  Own Id: OTP-9555","ref":"notes.html#fixed-bugs-and-malfunctions-45"},{"type":"extras","title":"Xmerl 1.2.9 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fix minor typos and improve punctuation in the xmerl_xpath @doc comment\n  (Thanks to Marcus Marinelli)\n\n  Own Id: OTP-9187\n\n- Prevent xmerl from over-normalizing character references in attributes\n\n  Section 3.3.3 of the XML Recommendation gives the rules for attribute-value\n  normalization. One of those rules requires that character references not be\n  re-normalized after being replaced with the referenced characters. (Thanks to\n  Tom Moertel)\n\n  Own Id: OTP-9274\n\n- Fixed the default encoding option in SAX parser.\n\n  Own Id: OTP-9288","ref":"notes.html#fixed-bugs-and-malfunctions-46"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Added the xmerl test suites and examples to the open source distribution.\n\n  Own Id: OTP-9228","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Xmerl 1.2.8 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The function xmerl_lib:expand_content/1 is mainly for expanding Simple XML,\n  but can also handle xmerl records. This patch fixes an omission that caused\n  expand_content/1 to not maintain the parents list when expanding\n  #xmlElement\\{\\} records. (Thanks to Ulf Wiger)\n\n  Own Id: OTP-9034","ref":"notes.html#fixed-bugs-and-malfunctions-47"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Removed some dialyzer warnings.\n\n  Own Id: OTP-9074","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Xmerl 1.2.7 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- An empty element declared as simpleContent was not properly validated.\n\n  Own Id: OTP-8599\n\n- Fix format_man_pages so it handles all man sections and remove warnings/errors\n  in various man pages.\n\n  Own Id: OTP-8600","ref":"notes.html#fixed-bugs-and-malfunctions-48"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Fix entity checking so there are no fatal errors for undefined entities when\n  option skip_external_dtd is used.\n\n  Own Id: OTP-8947","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Xmerl 1.2.6 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fixed problem with hex entities in UTF-8 documents: When a document was in\n  UTF-8 encoding, xmerl_scan improperly replaced hex entities by the UTF-8 bytes\n  instead of returning the character, as it does with inline UTF-8 text and\n  decimal entities. (Thanks to Paul Guyot.)\n\n  Own Id: OTP-8697","ref":"notes.html#fixed-bugs-and-malfunctions-49"},{"type":"extras","title":"Xmerl 1.2.5 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-5"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- All Erlang files are now built by the test server instead of the test\n  directory Makefile.\n\n  Erlang files in data directories are now built by the test suites instead of\n  using prebuilt versions under version control.\n\n  Removed a number of obsolete guards.\n\n  Own Id: OTP-8537\n\n- An empty element declared as a simpleContent was not properly validated.\n\n  Own Id: OTP-8599","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Xmerl 1.2.4 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-4"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Updated the documentation Makefile to work with the new documentation build\n  process.\n\n  Own Id: OTP-8343","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Xmerl 1.2.3 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- A continuation clause of `parse_reference/3` had its parameters in wrong\n  order.\n\n  Own Id: OTP-8251 Aux Id: seq11429","ref":"notes.html#fixed-bugs-and-malfunctions-50"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- A new option to turn off the parsing of an external DTD is added to\n  `xmerl_sax_parser:file/2` and `xmerl_sax_parser:stream/2`\n  (`skip_external_dtd`).\n\n  Own Id: OTP-8252 Aux Id: seq11432\n\n- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8253","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Xmerl 1.2.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- `xmerl_sax_parse:stream/2` failed with\n  `{fatal_error,_, \"Continuation function undefined, and more data needed\",_,_}`\n  when no continuation function was defined even though it was a complete\n  document as input.\n\n  Own Id: OTP-8213\n\n- The namespace URI supplied on unprefixed attributes in startElement tuples is\n  the same as the URI for the default namespace. According to the standard the\n  namespace for an unprefixed attribute should always has no value.\n\n  Own Id: OTP-8214","ref":"notes.html#fixed-bugs-and-malfunctions-51"},{"type":"extras","title":"Xmerl 1.2.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- `xmerl/include/xmerl.hrl` contained internal debug macros (`dbg/2` and\n  `DBG/0`) which now is moved to `xmerl_internal.hrl`.\n\n  Own Id: OTP-8084\n\n- The function `xmerl_uri:parse/1` couldn't handle FTP URIs containing username\n  and password. The default FTP port constant was also wrong. (Thanks to Steve\n  Vinoski)\n\n  Own Id: OTP-8156","ref":"notes.html#fixed-bugs-and-malfunctions-52"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- The SAX parser couldn't handle consecutive documents on the same stream. The\n  return values are now changed so they return a rest value instead of giving an\n  error about \"erranous information after the end tag\".\n\n  This means that the functions `file/2` and `stream/2` now returns\n  `{ok, EventState, Rest}` when the parsing is correct. The rest can then be\n  used as input to a new call to `xmerl_sax_parse:stream/2`. If one know that\n  it's just one document the rest value in the result tuple can be matched\n  against `<<>>` or `[]` depending on if the input is in binary form or not.\n\n  Own Id: OTP-8153 Aux Id: seq11388","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Xmerl 1.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-2"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"In xmerl-1.2 we have added the first Beta version of the new SAX parser (module:\nxmerl_sax_parser), it supports XML 1.0. We call it Beta due to that the\nvalidation part is not ready yet and that the parser still has some known\nlimitations (mostly in the DTD area).\n\nKnown limitations:\n\n- the external DTD in the DOCTYPE declaration is handled but other external\n  entities are not supported.\n- the general entity values are just checked in the structure after replacement.\n- parsed entities are supported on markup declaration level (e.g. partly\n  replacement of markup declaration with PEReference is not supported).\n- conditionalSect in external DTD's are not supported.\n- recursive loops in entity declarations are not detected.\n\nThe version is increased from 1.1.12 to 1.2 is due to that the new parser is\ndependent on the Unicode support that was added in OTP R13B. The old xmerl\nfunctionality is not changed.\n\nOwn Id: OTP-6635","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Xmerl 1.1.12 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-12"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Updated copyright notice in source files\n\n  Own Id: OTP-7847","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Xmerl 1.1.11 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- An empty element with a complexType and simpleContent was not properly\n  validated. This error is now corrected.\n\n  Own Id: OTP-7736","ref":"notes.html#fixed-bugs-and-malfunctions-53"},{"type":"extras","title":"Xmerl 1.1.10 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Changed the examples in Customization Functions Tutorial to correct Erlang\n  code.\n\n  Own Id: OTP-6053\n\n- Some XPath errors solved, typo in compare function '\\!=', error in `id()`\n  function.\n\n  Own Id: OTP-6792 Aux Id: seq10570\n\n- The XPath function `contains()` now implemented. See XPath 1.0 section 4.2.\n\n  Own Id: OTP-6873\n\n- Fixed that xmerl_xsd:process_schema/2 with \\{xsdbase, Dirname\\} failed with\n  enoent and a number of inor documentation bugs in xmerl_xsd reference manual.\n\n  Own Id: OTP-7165\n\n- Fixed xmerl_scan's problem with numeric character references followed by UTF-8\n  characters in the contents.\n\n  Own Id: OTP-7430\n\n- Fixed an incorrect guard for xmerl_scan:to_ucs/2.\n\n  Own Id: OTP-7473\n\n- Some bug corrections of xmerl XPath implementation, most provided by Matthew\n  Dempsky.\n\n  Own Id: OTP-7496\n\n- Now with `t:string/0` and `name()` all XPath functions are implemented. The\n  string representation of QName by `name()` is \"\\{Namespace URI\\}local-name\".\n\n  Own Id: OTP-7510","ref":"notes.html#fixed-bugs-and-malfunctions-54"},{"type":"extras","title":"Xmerl 1.1.9 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- A number of minor scanner faults have got more clear error messages.\n\n  Own Id: OTP-5998, Aux Id: seq9803\n\n- An example error in the Xmerl Users Guide is corrected.\n\n  Own Id: OTP-6947\n\n- When xmerl_xsd:validate was executed the schema table in the state was deleted\n  and next execution would fail. This is now corrected.\n\n  Own Id: OTP-7288","ref":"notes.html#fixed-bugs-and-malfunctions-55"},{"type":"extras","title":"Xmerl 1.1.8 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- A Kleene Closure child in a sequence consumed all following children. This\n  problem has been fixed.\n\n  Own Id: OTP-7211\n\n- Now validating xhtml1-transitional.dtd. A certain contentspec with a\n  succeeding choice, that didn't match all content, followed by other child\n  elements caused a failure. This is now corrected.\n\n  Own Id: OTP-7214","ref":"notes.html#fixed-bugs-and-malfunctions-56"},{"type":"extras","title":"Xmerl 1.1.7 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-7"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- xmerl's schema validation now takes default facets into account\n\n  Own Id: OTP-7190","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Xmerl 1.1.6 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Parsing XML with option `{validation,schema}` is now corrected.\n\n  Own Id: OTP-6773\n\n- union type is now supported\n\n  Own Id: OTP-6877 Aux Id: seq10755\n\n- Now xmerl validates as expected when a sequence has a present group member and\n  a following element.\n\n  Own Id: OTP-6910","ref":"notes.html#fixed-bugs-and-malfunctions-57"},{"type":"extras","title":"Xmerl 1.1.5 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- The head of a substitutionGroup may have type anyType and thus allow members\n  of any type. This was an oversight, but is now corrected.\n\n  Own Id: OTP-6720\n\n- A recursive group reference in a redefine refers to the definition in the\n  redefined schema. See 4.2.2 in XMLSchema part1 \"Schema Representation\n  Constraint: Individual Component Redefinition\" bullet 2.\n\n  Own Id: OTP-6739\n\n- Solved some content model problems, for instance in some cases failed when\n  more than one choice.\n\n  Own Id: OTP-6752","ref":"notes.html#fixed-bugs-and-malfunctions-58"},{"type":"extras","title":"Xmerl 1.1.4 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-4"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- An additional format is possible for the simple syntax: `{Fun, State}`. The\n  fun should retrieve the replacement in simple syntax format. The semantics of\n  fun:\n  `fun(State) -> code that creates replacement, then returns {SimpleSyntax,NewState} | done`\n\n  Own Id: OTP-6679","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Xmerl 1.1.3 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-3"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Memory consumption decreased: moved transforming from utf-8 to unicode from an\n  extra pass of the document to the occasion when a character is parsed. Removed\n  use of lists:subtract. Those changes also speeds up parsing in some scenarios.\n\n  Own Id: OTP-6599 Aux Id: seq10552","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Xmerl 1.1.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Schema processor reprocessed schemas that already were processed, using\n  process_schemas on a system of schemas with circular dependencies.\n\n  Own Id: OTP-6460 Aux Id: seq10564","ref":"notes.html#fixed-bugs-and-malfunctions-59"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- Dialyzer warnings now removed, i.e. dead code have been removed.\n\n  Own Id: OTP-6507","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Xmerl 1.1.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Bug in xmerl removed so that simple syntax element content is exported\n  correctly.\n\n  Own Id: OTP-6402 Aux Id: OTP-6099","ref":"notes.html#fixed-bugs-and-malfunctions-60"},{"type":"extras","title":"Xmerl 1.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Xmerl failed to parse and export with the sax_file front-end. Therefore hook\n  function calls were added in the parser and handling of text content were\n  changed.\n\n  Own Id: OTP-6043\n\n- Bug in xmerl removed so that simple syntax element content is exported\n  correctly.\n\n  Own Id: OTP-6099","ref":"notes.html#fixed-bugs-and-malfunctions-61"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- xmerl now supports XMLSchema validation. Documentation in reference manual for\n  xmerl. The release of XMLSchema validation should be considered as a beta\n  release. The user interface may still be adjusted in a coming release.\n  Opinions and evaluations are welcome.\n\n  Own Id: OTP-6401","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"xmerl 1.0.5 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Code that caused compiler warnings has been reviewed.","ref":"notes.html#fixed-bugs-and-malfunctions-62"},{"type":"extras","title":"xmerl 1.0.4 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- xmerl behaved strange parsing a XML-document with a copyright sign in a\n  comment.\n\n  Own Id: OTP-5599\n\n- Line count for error messages in DTD improved, still problem because of ENTITY\n  expansions. Didn't delete digraphs after recursion test. Now correctly parsing\n  of declaration separators \\[28a-b].\n\n  Own Id: OTP-5718\n\n- Failed to validate a XML file with a content spec that had a choice of which\n  one element was a sequence with optional elements, and all elements of that\n  sequence were missing\n\n  Own Id: OTP-5734\n\n- Location paths for document root and attributes is now working as expected.\n\n  Own Id: OTP-5895\n\n- Now has the last() predicate in the XPATH modules the properties specified in\n  ch 2.4 in the XPATH spec, i.e. if last() evaluates to a number other than the\n  context position it is false, otherwise true.\n\n  Own Id: OTP-5902\n\n- The location path of a single wildcard now only selects element nodes.\n\n  Own Id: OTP-5905","ref":"notes.html#fixed-bugs-and-malfunctions-63"},{"type":"extras","title":"Xmerl 1.0.3 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Removed call of undefined function in xmerl_lib.\n\n  Own Id: OTP-5587","ref":"notes.html#fixed-bugs-and-malfunctions-64"},{"type":"extras","title":"Xmerl 1.0.2 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Better identification of errors in xml code.\n\n  Own Id: OTP-5498 Aux Id: seq9803\n\n- Some minor bugs fixed.\n\n  Own Id: OTP-5500\n\n- Parser failed on PE reference as EnumeratedType AttType, now corrected.\n\n  Own Id: OTP-5531","ref":"notes.html#fixed-bugs-and-malfunctions-65"},{"type":"extras","title":"Xmerl 1.0.1 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Xmerl Release Notes","doc":"- Fixed bug in xmerl_xpath. Xpath expressions that select nodes of type text()\n  didn't work, like \"context/text()\", \"child::text()\", \"descendant::text()\".\n\n  Own Id: OTP-5268 Aux Id: seq9656\n\n- Minor bugs fixed.\n\n  Own Id: OTP-5301","ref":"notes.html#fixed-bugs-and-malfunctions-66"},{"type":"extras","title":"Xmerl 1.0 - Xmerl Release Notes","doc":"","ref":"notes.html#xmerl-1-0"},{"type":"extras","title":"Improvements and New Features - Xmerl Release Notes","doc":"- The OTP release of xmerl 1.0 is mainly the same as xmerl-0.20 of\n  http://sowap.sourceforge.net/. It is capable of parsing XML 1.0. There have\n  only been minor improvements: Some bugs that caused an unexpected crash when\n  parsing bad XML. Failure report that also tells which file that caused an\n  error.\n\n  Own Id: OTP-5174","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"Xmerl","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Xmerl","ref":"xmerl_ug.html"},{"type":"extras","title":"Introduction - Xmerl","doc":"","ref":"xmerl_ug.html#introduction"},{"type":"extras","title":"Features - Xmerl","doc":"The _Xmerl_ XML parser is able to parse XML documents according to the XML 1.0\nstandard. As default it performs well-formed parsing, (syntax checks and checks\nof well-formed constraints). Optionally one can also use Xmerl as a validating\nparser, (validate according to referenced DTD and validating constraints). By\nmeans of for example the xmerl_xs module it is possible to transform the parsed\nresult to other formats, e.g. text, HTML, XML etc.","ref":"xmerl_ug.html#features"},{"type":"extras","title":"Overview - Xmerl","doc":"This document does not give an introduction to XML. There are a lot of books\navailable that describe XML from different views. At the\n[www.W3.org](http://www.w3.org) site you will find the\n[XML 1.0 specification](http://www.w3.org/TR/REC-xml/) and other related specs.\nOne site were you can find tutorials on XML and related specs is\n[ZVON.org](http://www.zvon.org).\n\nHowever, here you will find some examples of how to use and to what you can use\nXmerl. A detailed description of the user interface can be found in the\nreference manual.\n\nThere are two known shortcomings in Xmerl:\n\n- It cannot retrieve external entities on the Internet by a URL reference, only\n  resources in the local file system.\n- Xmerl can parse Unicode encoded data. But, it fails on tag names, attribute\n  names and other mark-up names that are encoded Unicode characters not mapping\n  on ASCII.\n\nBy parsing an XML document you will get a record, displaying the structure of\nthe document, as return value. The record also holds the data of the document.\nXmerl is convenient to use in for instance the following scenarios:\n\nYou need to retrieve data from XML documents. Your Erlang software can handle\ninformation from the XML document by extracting data from the data structure\nreceived by parsing.\n\nIt is also possible to do further processing of parsed XML with Xmerl. If you\nwant to change format of the XML document to for instance HTML, text or other\nXML format you can transform it. There is support for such transformations in\nXmerl.\n\nOne may also convert arbitrary data to XML. So it for instance is easy to make\nit readable by humans. In this case you first create Xmerl data structures out\nof your data, then transform it to XML.\n\nYou can find examples of these three examples of usage below.","ref":"xmerl_ug.html#overview"},{"type":"extras","title":"Xmerl User Interface Data Structure - Xmerl","doc":"The following records used by Xmerl to save the parsed data are defined in\n`xmerl.hrl`\n\nThe result of a successful parsing is a tuple `{DataStructure,M}`. `M` is the\nXML production Misc, which is the mark-up that comes after the element of the\ndocument. It is returned \"as is\". `DataStructure` is an `#xmlElement{}` record,\nthat among others have the fields `name`, `parents`, `attributes` and `content`\nlike:\n\n```text\n#xmlElement{name=Name,\n            ...\n            parents=Parents,\n            ...\n            attributes=Attrs,\n            content=Content,\n            ...}\n```\n\nThe name of the element is found in the `name` field. In the `parents` field is\nthe names of the parent elements saved. Parents is a list of tuples where the\nfirst element in each tuple is the name of the parent element. The list is in\nreverse order.\n\nThe record `#xmlAttribute{}` holds the name and value of an attribute\nin the fields `name` and `value`. All attributes of an element is a list of\n`#xmlAttribute{}` in the field `attributes` of the `#xmlElement{}` record.\n\nThe `content` field of the top element is a list of records that shows the\nstructure and data of the document. If it is a simple document like:\n\n```text\n<?xml version=\"1.0\"?>\n \nGrand Danois\n \n```\n\nThe parse result will be:\n\n```erlang\n#xmlElement{name = dog,\n            ...\n            parents = [],\n            ...\n            attributes = [],\n            content = [{xmlText,[{dog,1}],1,[],\"\\\nGrand Danois\\\n\",text}],\n            ...\n            }\n```\n\nWhere the content of the top element is:\n`[{xmlText,[{dog,1}],1,[],\"\\ Grand Danois\\ \",text}]`. Text will be returned in\n`xmlText` records. Though, usually documents are more complex, and the content\nof the top element will in that case be a nested structure with `#xmlElement{}`\nrecords that in turn may have complex content. All of this reflects the\nstructure of the XML document.\n\nSpace characters between mark-up as `space`, `tab` and `line feed` are\nnormalized and returned as xmlText records.","ref":"xmerl_ug.html#xmerl-user-interface-data-structure"},{"type":"extras","title":"Errors - Xmerl","doc":"An unsuccessful parse results in an error, which may be a tuple `{error,Reason}`\nor an exit: `{'EXIT',Reason}`. According to the XML 1.0 standard there are\n`fatal error` and `error` situations. The fatal errors _must_ be detected by a\nconforming parser while an error _may_ be detected. Both categories of errors\nare reported as fatal errors by this version of Xmerl, most often as an exit.","ref":"xmerl_ug.html#errors"},{"type":"extras","title":"Getting Started - Xmerl","doc":"In the following examples we use the XML file \"motorcycles.xml\" and the\ncorresponding DTD \"motorcycles.dtd\". motorcycles.xml looks like:[](){:\n#motorcyclesxml }\n\n```text\n\n<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<!DOCTYPE motorcycles SYSTEM \"motorcycles.dtd\">\n \n   \n     \n       Suzuki \n       Suzuki VL 1500 \n       Intruder \n     \n     V-engine, 2-cylinders, 1500 cc \n     custom \n     cardan \n     Sissy bar, luggage carrier,V&amp;H exhaust pipes \n   \n   2004.08.25 \n   \n     \n       Yamaha \n       XJ 400 \n     \n     4 cylinder, 400 cc \n     alround \n     chain \n     Good shape! \n   \n \n```\n\nand motorcycles.dtd looks like:\n\n```text\n\n<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<!ELEMENT motorcycles (bike,date?)+ >\n<!ELEMENT bike        (name,engine,kind,drive, accessories?,comment?) >\n<!ELEMENT name        (manufacturer,brandName,additionalName?) >\n<!ELEMENT manufacturer       (#PCDATA)>\n<!ELEMENT brandName         (#PCDATA)>\n<!ELEMENT additionalName    (#PCDATA)>\n<!ELEMENT engine             (#PCDATA)>\n<!ELEMENT kind               (#PCDATA)>\n<!ELEMENT drive              (#PCDATA)>\n<!ELEMENT comment            (#PCDATA)>\n<!ELEMENT accessories        (#PCDATA)>\n\n<!-- Date of the format yyyy.mm.dd -->\n<!ELEMENT date              (#PCDATA)>\n<!ATTLIST  bike year NMTOKEN #REQUIRED\n                color NMTOKENS #REQUIRED\n                condition (useless | bad | serviceable | moderate | good |\n                           excellent | new | outstanding) \"excellent\" >\n```\n\nIf you want to parse the XML file motorcycles.xml you run it in the Erlang shell\nlike:\n\n```erlang\n3> {ParseResult,Misc}=xmerl_scan:file(\"motorcycles.xml\").\n{{xmlElement,motorcycles,\n             motorcycles,\n             [],\n             {xmlNamespace,[],[]},\n             [],\n             1,\n             [],\n             [{xmlText,[{motorcycles,1}],1,[],\"\\\n  \",text},\n              {xmlElement,bike,\n                          bike,\n                          [],\n                          {xmlNamespace,[],[]},\n                          [{motorcycles,1}],\n                          2,\n                          [{xmlAttribute,year,[],[],[],[]|...},\n                           {xmlAttribute,color,[],[],[]|...}],\n                          [{xmlText,[{bike,2},{motorcycles|...}],\n                                    1,\n                                    []|...},\n                           {xmlElement,name,name,[]|...},\n                           {xmlText,[{...}|...],3|...},\n                           {xmlElement,engine|...},\n                           {xmlText|...},\n                           {...}|...],\n                          [],\n                          \".\",\n                          undeclared},\n              ...\n              ],\n             [],\n             \".\",\n             undeclared},\n []}\n4>\n```\n\nIf you instead receives the XML doc as a string you can parse it by\n`xmerl_scan:string/1`. Both file/2 and string/2 exists where the second argument\nis a list of options to the parser, see the [reference manual](`m:xmerl_scan`).","ref":"xmerl_ug.html#getting-started"},{"type":"extras","title":"Example: Extracting Data From XML Content - Xmerl","doc":"In this example consider the situation where you want to examine a particular\ndata in the XML file. For instance, you want to check for how long each\nmotorcycle have been recorded.\n\nTake a look at the DTD and observe that the structure of an XML document that is\nconformant to this DTD must have one motorcycles element (the root element). The\nmotorcycles element must have at least one bike element. After each bike element\nit may be a date element. The content of the date element is #PCDATA (Parsed\nCharacter DATA), i.e. raw text. Observe that if #PCDATA must have a `\"<\"` or a\n`\"&\"` character it must be written as `\"&lt;\"` and `\"&amp;\"` respectively. Also\nother character entities exists similar to the ones in HTML and SGML.\n\nIf you successfully parse the XML file with the validation on as in:\n`xmerl_scan:file('motorcycles.xml',[{validation,true}])` you know that the XML\ndocument is valid and has the structure according to the DTD.\n\nThus, knowing the allowed structure it is easy to write a program that traverses\nthe data structure and picks the information in the `#xmlElements{}` records\nwith name date.\n\nObserve that white space: each space, tab or line feed, between mark-up results\nin an `#xmlText{}` record.","ref":"xmerl_ug.html#example-extracting-data-from-xml-content"},{"type":"extras","title":"Example: Create XML Out Of Arbitrary Data - Xmerl","doc":"For this task there are more than one way to go. The \"brute force\" method is to\ncreate the records you need and feed your data in the content and attribute\nfields of the appropriate element.\n\nThere is support for this in Xmerl by the \"simple-form\" format. You can put your\ndata in a simple-form data structure and feed it into\n`xmerl:export_simple(Content,Callback,RootAttributes)`. Content may be a mixture\nof simple-form and Xmerl records as `#xmlElement{}` and `#xmlText{}`.\n\nThe Types are:\n\n- Content = \\[Element]\n- Callback = atom()\n- RootAttributes = \\[Attributes]\n\nElement is any of:\n\n- \\{Tag, Attributes, Content\\}\n- \\{Tag, Content\\}\n- Tag\n- IOString\n- \\#xmlText\\{\\}\n- \\#xmlElement\\{\\}\n- \\#xmlPI\\{\\}\n- \\#xmlComment\\{\\}\n- \\#xmlDecl\\{\\}\n\nThe simple-form structure is any of `{Tag, Attributes, Content}`,\n`{Tag, Content}` or `Tag` where:\n\n- Tag = atom()\n- Attributes = \\[\\{Name, Value\\}| #xmlAttribute\\{\\}]\n- Name = atom()\n- Value = IOString | atom() | integer()\n\nSee also reference manual for [xmerl](`xmerl:export_simple/3`)\n\nIf you want to add the information about a black Harley Davidsson 1200 cc\nSportster motorcycle from 2003 that is in shape as new in the motorcycles.xml\ndocument you can put the data in a simple-form data structure like:\n\n```erlang\nData =\n  {bike,\n     [{year,\"2003\"},{color,\"black\"},{condition,\"new\"}],\n     [{name,\n         [{manufacturer,[\"Harley Davidsson\"]},\n          {brandName,[\"XL1200C\"]},\n          {additionalName,[\"Sportster\"]}]},\n      {engine,\n         [\"V-engine, 2-cylinders, 1200 cc\"]},\n      {kind,[\"custom\"]},\n      {drive,[\"belt\"]}]}\n```\n\nIn order to append this data to the end of the motorcycles.xml document you have\nto parse the file and add Data to the end of the root element content.\n\n```erlang\n    {RootEl,Misc}=xmerl_scan:file('motorcycles.xml'),\n    #xmlElement{content=Content} = RootEl,\n    NewContent=Content++lists:flatten([Data]),\n    NewRootEl=RootEl#xmlElement{content=NewContent},\n```\n\nThen you can run it through the export_simple/2 function:\n\n```erlang\n    {ok,IOF}=file:open('new_motorcycles.xml',[write]),\n    Export=xmerl:export_simple([NewRootEl],xmerl_xml),\n    io:format(IOF,\"~s~n\",[lists:flatten(Export)]),\n```\n\n[](){: #new_motorcyclesxml }\n\nThe result would be:\n\n```text\n\n<?xml version=\"1.0\"?> \n   \n     \n       Suzuki \n       Suzuki VL 1500 \n       Intruder \n     \n     V-engine, 2-cylinders, 1500 cc \n     custom \n     cardan \n     Sissy bar, luggage carrier,V&amp;H exhaust pipes \n   \n   2004.08.25 \n   \n     \n       Yamaha \n       XJ 400 \n     \n     4 cylinder, 400 cc \n     alround \n     chain \n     Good shape! \n   \n   Harley Davidsson  XL1200C  Sportster   V-engine, 2-cylinders, 1200 cc  custom  belt   \n```\n\nIf it is important to get similar indentation and newlines as in the original\ndocument you have to add `#xmlText{}` records with space and newline values in\nappropriate places. It may also be necessary to keep the original prolog where\nthe DTD is referenced. If so, it is possible to pass a RootAttribute\n`{prolog,Value}` to `export_simple/3`. The following example code fixes those\nchanges in the previous example:\n\n```erlang\n    Data =\n      [#xmlText{value=\"  \"},\n       {bike,[{year,\"2003\"},{color,\"black\"},{condition,\"new\"}],\n             [#xmlText{value=\"\\\n    \"},\n              {name,[#xmlText{value=\"\\\n      \"},\n                     {manufacturer,[\"Harley Davidsson\"]},\n                     #xmlText{value=\"\\\n      \"},\n                     {brandName,[\"XL1200C\"]},\n                     #xmlText{value=\"\\\n      \"},\n                     {additionalName,[\"Sportster\"]},\n                     #xmlText{value=\"\\\n    \"}]},\n              {engine,[\"V-engine, 2-cylinders, 1200 cc\"]},\n              #xmlText{value=\"\\\n    \"},\n              {kind,[\"custom\"]},\n              #xmlText{value=\"\\\n    \"},\n              {drive,[\"belt\"]},\n              #xmlText{value=\"\\\n  \"}]},\n       #xmlText{value=\"\\\n\"}],\n    ...\n    NewContent=Content++lists:flatten([Data]),\n    NewRootEl=RootEl#xmlElement{content=NewContent},\n    ...\n    Prolog = [\"<?xml version=\\\\\"1.0\\\\\" encoding=\\\\\"utf-8\\\\\" ?>\n<!DOCTYPE motorcycles SYSTEM \\\\\"motorcycles.dtd\\\\\">\\\n\"],\n    Export=xmerl:export_simple([NewRootEl],xmerl_xml,[{prolog,Prolog}]),\n    ...\n```\n\nThe result will be:\n\n```text\n\n<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<!DOCTYPE motorcycles SYSTEM \"motorcycles.dtd\">\n \n   \n     \n       Suzuki \n       Suzuki VL 1500 \n       Intruder \n     \n     V-engine, 2-cylinders, 1500 cc \n     custom \n     cardan \n     Sissy bar, luggage carrier,V&amp;H exhaust pipes \n   \n   2004.08.25 \n   \n     \n       Yamaha \n       XJ 400 \n     \n     4 cylinder, 400 cc \n     alround \n     chain \n     Good shape! \n   \n   \n     \n       Harley Davidsson \n       XL1200C \n       Sportster \n      V-engine, 2-cylinders, 1200 cc \n     custom \n     belt \n   \n \n```\n\nThe generated XML above was formatted for readability. Another exporter which\nindents the code with 2 spaces can also be used. In order to use it one only\nneeds to change the export-module:\n\n```text\n      ...\n        Export=xmerl:export_simple([NewRootEl],xmerl_xml_indent,[{prolog,Prolog}]),\n      ...\n```","ref":"xmerl_ug.html#example-create-xml-out-of-arbitrary-data"},{"type":"extras","title":"Example: Transforming XML To HTML - Xmerl","doc":"Assume that you want to transform the\n[motorcycles.xml](xmerl_ug.md#motorcyclesxml) document to HTML. If you want the\nsame structure and tags of the resulting HTML document as of the XML document\nthen you can use the `xmerl:export/2` function. The following:\n\n```erlang\n2> {Doc,Misc}=xmerl_scan:file('motorcycles.xml').\n{{xmlElement,motorcycles,\n             motorcycles,\n             [],\n             {xmlNamespace,[],[]},\n             [],\n             1,\n             [],\n             [{xmlText,[{motorcycles,1}],1,[],\"\\\n  \",text},\n              {xmlElement,bike,\n...\n3> DocHtml=xmerl:export([Doc],xmerl_html).\n[\"<!DOCTYPE HTML PUBLIC \\\\\"\",\n \"-//W3C//DTD HTML 4.01 Transitional//EN\",\n \"\\\\\"\",\n [],\n \">\\\n\",\n [[[\"<\",\"motorcycles\",\">\"],\n   [\"\\\n  \",\n    [[\"<\",\n      \"bike\",\n      [[\" \",\"year\",\"=\\\\\"\",\"2000\",\"\\\\\"\"],[\" \",\"color\",\"=\\\\\"\",\"black\",\"\\\\\"\"]],\n      \">\"],\n...\n```\n\nWill give the result [result_export.html](assets/result_export.html)\n\nPerhaps you want to do something more arranged for human reading. Suppose that\nyou want to list all different brands in the beginning with links to each group\nof motorcycles. You also want all motorcycles sorted by brand, then some flashy\ncolors on top of it. Thus you rearrange the order of the elements and put in\narbitrary HTML tags. This is possible to do by means of the\n[XSL Transformation (XSLT)](http://www.w3.org/Style/XSL/) like functionality in\nXmerl.\n\nEven though the following example shows one way to transform data from XML to\nHTML it also applies to transformations to other formats.\n\n`xmerl_xs` does not implement the entire XSLT specification but the basic\nfunctionality. For all details see the [reference manual](`m:xmerl_xs`)\n\nFirst, some words about the xmerl_xs functionality:\n\nYou need to write template functions to be able to control what kind of output\nyou want. Thus if you want to encapsulate a `bike` element in   tags you\nsimply write a function:\n\n```erlang\ntemplate(E = #xmlElement{name='bike'}) ->\n    [\" \",xslapply(fun template/1,E),\" \"];\n```\n\nWith `xslapply` you tell the XSLT processor in which order it should traverse\nthe XML structure. By default it goes in preorder traversal, but with the\nfollowing we make a deliberate choice to break that order:\n\n```erlang\ntemplate(E = #xmlElement{name='bike'}) ->\n    [\" \",xslapply(fun template/1,select(\"bike/name/manufacturer\")),\" \"];\n```\n\nIf you want to output the content of an XML element or an attribute you will get\nthe value as a string by the `value_of` function:\n\n```erlang\ntemplate(E = #xmlElement{name='motorcycles'}) ->\n    [\" \",value_of(select(\"bike/name/manufacturer\",E),\" \"];\n```\n\nIn the xmerl_xs functions you can provide a select(String) call, which is an\n[XPath](http://www.w3.org/TR/xpath) functionality. For more details see the\nxmerl_xs [tutorial](`e:xmerl:xmerl_xs_examples.html`).\n\nNow, back to the example where we wanted to make the output more arranged. With\nthe template:\n\n```c\ntemplate(E = #xmlElement{name='motorcycles'}) ->\n    [    \" \\\n motorcycles \\\n \\\n\",\n         \" \\\n\",\n\\011 \" Used Motorcycles \\\n\",\n\\011 \" \\\n\",\n\\011 remove_duplicates(value_of(select(\"bike/name/manufacturer\",E))),\n\\011 \"\\\n \\\n\",\n\\011 sort_by_manufacturer(xslapply(fun template/1, E)),\n         \" \\\n\",\n\\011 \" \\\n\"];\n```\n\nWe match on the top element and embed the inner parts in an HTML body. Then we\nextract the string values of all motorcycle brands, sort them and removes\nduplicates by\n`remove_duplicates(value_of(select(\"bike/name/manufacturer\", E)))`. We also\nprocess the substructure of the top element and pass it to a function that sorts\nall motorcycle information by brand according to the task formulation in the\nbeginning of this example.\n\nThe next template matches on the `bike` element:\n\n```erlang\ntemplate(E = #xmlElement{name='bike'}) ->\n    {value_of(select(\"name/manufacturer\",E)),[\" \",xslapply(fun template/1,select(\"name\",E)),\" \",\n    \"  \\\n\",\n    \" Manufacturing year: \",xslapply(fun template/1,select(\"@year\",E)),\" \\\n\",\n    \" Color: \",xslapply(fun template/1,select(\"@color\",E)),\" \\\n\",\n    \" Shape : \",xslapply(fun template/1,select(\"@condition\",E)),\" \\\n\",\n    \"  \\\n\"]};\n```\n\nThis creates a tuple with the brand of the motorcycle and the output format. We\nuse the brand name only for sorting purpose. We have to end the template\nfunction with the \"built in clause\"\n`template(E) -> built_in_rules(fun template/1, E).`\n\nThe entire program is motorcycles2html.erl:\n\n```erlang\n\n%%%-------------------------------------------------------------------\n%%% File    : motorcycles2html.erl\n%%% Author  : Bertil Karlsson  \n%%% Description :\n%%%\n%%% Created :  2 Sep 2004 by Bertil Karlsson  \n%%%-------------------------------------------------------------------\n-module(motorcycles2html).\n\n-include_lib(\"xmerl/include/xmerl.hrl\").\n\n-import(xmerl_xs,\n\t[ xslapply/2, value_of/1, select/2, built_in_rules/2 ]).\n\n-export([process_xml/1,process_to_file/2,process_to_file/1]).\n\nprocess_xml(Doc) ->\n    template(Doc).\n\nprocess_to_file(FileName) ->\n    process_to_file(FileName,'motorcycles.xml').\n\nprocess_to_file(FileName,XMLDoc) ->\n    case file:open(FileName,[write]) of\n\t{ok,IOF} ->\n\t    {XMLContent,_} = xmerl_scan:file(XMLDoc),\n\t    TransformedXML=process_xml(XMLContent),\n\t    io:format(IOF,\"~s\",[TransformedXML]),\n\t    file:close(IOF);\n\t{error,Reason} ->\n\t    io:format(\"could not open file due to ~p.~n\",[Reason])\n    end.\n\n%%% templates\ntemplate(E = #xmlElement{name='motorcycles'}) ->\n    [    \" \\n motorcycles \\n \\n\",\n         \" \\n\",\n\t \" Used Motorcycles \\n\",\n\t \" \\n\",\n\t remove_duplicates(value_of(select(\"bike/name/manufacturer\",E))),\n\t \"\\n \\n\",\n\t sort_by_manufacturer(xslapply(fun template/1, E)),\n         \" \\n\",\n\t \" \\n\"];\ntemplate(E = #xmlElement{name='bike'}) ->\n    {value_of(select(\"name/manufacturer\",E)),[\" \",xslapply(fun template/1,select(\"name\",E)),\" \",\n    \"  \\n\",\n    \" Manufacturing year: \",xslapply(fun template/1,select(\"@year\",E)),\" \\n\",\n    \" Color: \",xslapply(fun template/1,select(\"@color\",E)),\" \\n\",\n    \" Shape : \",xslapply(fun template/1,select(\"@condition\",E)),\" \\n\",\n    \"  \\n\"]};\ntemplate(E) -> built_in_rules(fun template/1, E).\n\n\n%%%%%%%%%%% helper routines\n\n%% sorts on the bike name element, unwraps the bike information and\n%% inserts a line feed and indentation on each bike element.\nsort_by_manufacturer(L) ->\n    Tuples=[X1||X1={_,_} <- L],\n    SortedTS = lists:keysort(1,Tuples),\n    InsertRefName_UnWrap=\n\tfun([{[Name],V}|Rest],Name,F)->\n\t\t[V|F(Rest,Name,F)];\n\t   ([{[Name],V}|Rest],_PreviousName,F) ->\n\t\t[[\" </>\"],V|F(Rest,Name,F)];\n\t   ([],_,_) -> []\n\tend,\n    SortedRefed=InsertRefName_UnWrap(SortedTS,no_name,InsertRefName_UnWrap),\n%    SortedTs=[Y||{X,Y}<-lists:keysort(1,Tuples)],\n    WS = \"\\n    \",\n    Fun=fun([H|T],Acc,F)->\n\t\tF(T,[H,WS|Acc],F);\n\t   ([],Acc,_F)->\n\t\tlists:reverse([WS|Acc])\n\tend,\n    if length(SortedRefed) > 0 ->\n\t    Fun(SortedRefed,[],Fun);\n       true -> []\n    end.\n\n\n%% removes all but the first of an element in L and inserts a html\n%% reference for each list element.\nremove_duplicates(L) ->\n    remove_duplicates(L,[]).\n\nremove_duplicates([],Acc) ->\n    make_ref(lists:sort(lists:reverse(Acc)));\nremove_duplicates([A|L],Acc) ->\n    case lists:delete(A,L) of\n\tL ->\n\t    remove_duplicates(L,[A|Acc]);\n\tL1 ->\n\t    remove_duplicates([A|L1],[Acc])\n    end.\n\nmake_ref([]) -> [];\nmake_ref([H]) when is_atom(H) ->\n    \"  \"++atom_to_list(H)++\"  \";\nmake_ref([H]) when is_list(H) ->\n    \"  \\s\"++H++\"  \";\nmake_ref([H|T]) when is_atom(H) ->\n    [\"  \\s\"++atom_to_list(H)++\",\\n  \"\n     |make_ref(T)];\nmake_ref([H|T]) when is_list(H) ->\n    [\"  \\s\"++H++\",\\n  \"|make_ref(T)].\n```\n\nIf we run it like this:\n`motorcycles2html:process_to_file('result_xs.html', 'motorcycles2.xml').` The\nresult will be [result_xs.html](assets/result_xs.html). When the input file is of the\nsame structure as the previous \"motorcycles\" XML files but it has a little more\n'bike' elements and the 'manufacturer' elements are not in order.","ref":"xmerl_ug.html#example-transforming-xml-to-html"},{"type":"extras","title":"Customization functions","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2024-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n# Customization functions","ref":"xmerl_examples.html"},{"type":"extras","title":"1 Description - Customization functions","doc":"The XML processor offers a number of hooks for customization. These hooks are\ndefined as function objects, and can be provided by the caller.\n\nThe following customization functions are available. If they also have access to\ntheir own state variable, the access function for this state is identified\nwithin parentheses:\n\n-   event function ( `xmerl_scan:event_state/[1,2]` )\n-   hook function ( `xmerl_scan:hook_state/[1,2]` )\n-   fetch function ( `xmerl_scan:fetch_state/[1,2]` )\n-   continuation function ( `xmerl_scan:cont_state/[1,2]` )\n-   rules function ( `xmerl_scan:rules_state/[1,2]` )\n-   accumulator function\n-   close function\n\nFor all of the above state access functions, the function with one argument\n(e.g. `event_state(GlobalState)`) will read the state variable, while the\nfunction with two arguments (e.g.: `event_state(NewEventState, GlobalState)`)\nwill modify it.\n\nFor each function, the description starts with the syntax for specifying the\nfunction in the [`Option_list`](`t:xmerl_scan:option_list/0`). The general\nforms are `{Tag, Fun}`, or `{Tag, Fun, LocalState}`. The second form can be used\nto initialize the state variable in question.\n\n#### 1.1 User State\n\nAll customization functions are free to access a \"User state\" variable. Care\nmust of course be taken to coordinate the use of this state. It is recommended\nthat functions, which do not really have anything to contribute to the \"global\"\nuser state, use their own state variable instead. Another option (used in e.g.\n`xmerl_eventp.erl`) is for customization functions to share one of the local\nstates (in `xmerl_eventp.erl`, the continuation function and the fetch function\nboth access the cont_state.)\n\nFunctions to access user state:\n\n-   `xmerl_scan:user_state(GlobalState)`\n-   `xmerl_scan:user_state(UserState, GlobalState)`\n\n#### 1.2 Event Function\n\n``` erlang\n{event_fun, fun()} | {event_fun, fun(), EventState}\n```\n\nThe event function is called at the beginning and at the end of a parsed entity.\nIt has the following format and semantics:\n\n``` erlang\nfun(Event, GlobalState) ->\n   EventState = xmerl_scan:event_state(GlobalState),\n   EventState2 = foo(Event, EventState),\n   GlobalState2 = xmerl_scan:event_state(EventState2, GlobalState)\nend.\n```\n\n#### 1.3 Hook Function\n\n``` erlang\n{hook_fun, fun()} | {hook_fun, fun(), HookState}\n```\n\nThe hook function is called when the processor has parsed a complete entity.\nFormat and semantics:\n\n``` erlang\nfun(Entity, GlobalState) ->\n   HookState = xmerl_scan:hook_state(GlobalState),\n   {TransformedEntity, HookState2} = foo(Entity, HookState),\n   GlobalState2 = xmerl_scan:hook_state(HookState2, GlobalState),\n   {TransformedEntity, GlobalState2}\nend.\n```\n\nThe relationship between the event function, the hook function and the\naccumulator function is as follows:\n\n1.  The event function is first called with an 'ended' event for the parsed\n    entity.\n2.  The hook function is called, possibly re-formatting the entity.\n3.  The acc function is called in order to (optionally) add the re-formatted\n    entity to the contents of its parent element.\n\n#### 1.4 Fetch Function\n\n``` erlang\n{fetch_fun, fun()} | {fetch_fun, fun(), FetchState}\n```\n\nThe fetch function is called in order to fetch an external resource (e.g. a\nDTD).\n\nThe fetch function can respond with three different return values:\n\n``` erlang\nResult ::=\n   {ok, {file, Filename}, NewGlobalState} |\n   {ok, {string, String}, NewGlobalState} |\n   {ok, not_fetched, NewGlobalState}\n```\n\nFormat and semantics:\n\n``` erlang\nfun(URI, GlobalState) ->\n   FetchState = xmerl_scan:fetch_state(GlobalState),\n   Result = foo(URI, FetchState).  % Result being one of the above\nend.\n```\n\n#### 1.5 Continuation Function\n\n``` erlang\n{continuation_fun, fun()} | {continuation_fun, fun(), ContinuationState}\n```\n\nThe continuation function is called when the parser encounters the end of the\nbyte stream. Format and semantics:\n\n``` erlang\nfun(Continue, Exception, GlobalState) ->\n   ContState = xmerl_scan:cont_state(GlobalState),\n   {Result, ContState2} = get_more_bytes(ContState),\n   case Result of\n      [] ->\n         GlobalState2 = xmerl_scan:cont_state(ContState2, GlobalState),\n         Exception(GlobalState2);\n      MoreBytes ->\n         {MoreBytes2, Rest} = end_on_whitespace_char(MoreBytes),\n         ContState3 = update_cont_state(Rest, ContState2),\n         GlobalState3 = xmerl_scan:cont_state(ContState3, GlobalState),\n         Continue(MoreBytes2, GlobalState3)\n   end\nend.\n```\n\n#### 1.6 Rules Functions\n\n``` erlang\n{rules, ReadFun : fun(), WriteFun : fun(), RulesState} |\n{rules, Table : ets()}\n```\n\nThe rules functions take care of storing scanner information in a rules\ndatabase. User-provided rules functions may opt to store the information in\nmnesia, or perhaps in the user_state(RulesState).\n\nThe following modes exist:\n\n-   If the user doesn't specify an option, the scanner creates an ets table, and\n    uses built-in functions to read and write data to it. When the scanner is\n    done, the ets table is deleted.\n-   If the user specifies an ets table via the `{rules, Table}` option, the\n    scanner uses this table. When the scanner is done, it does _not_ delete the\n    table.\n-   If the user specifies read and write functions, the scanner will use them\n    instead.\n\nThe format for the read and write functions are as follows:\n\n     WriteFun(Context, Name, Definition, ScannerState) -> NewScannerState.\n     ReadFun(Context, Name, ScannerState) -> Definition | undefined.\n\nHere is a summary of the data objects currently being written by the scanner:\n\n| Context          | Key Value    | Definition                           |\n| ---------------- | ------------ | ------------------------------------ |\n| notation         | NotationName | `{system, SL} \\| {public, PIDL, SL}` |\n| elem_def         | ElementName  | `#xmlElement{content = ContentSpec}` |\n| parameter_entity | PEName       | `PEDef`                              |\n| entity           | EntityName   | `EntityDef`                          |\n** Table 1:** Scanner data objects\n\nwhere\n\n``` erlang\nContentSpec ::= empty | any | ElemContent\nElemContent ::= {Mode, Elems}\nMode        ::= seq | choice\nElems       ::= [Elem]\nElem        ::= '#PCDATA' | Name | ElemContent | {Occurrence, Elems}\nOccurrence  ::= '*' | '?' | '+'\n```\n\nNOTE: _When   is not wrapped with  , (Occurrence = once) is\nimplied._\n\n#### 1.7 Accumulator Function\n\n``` erlang\n{acc_fun, fun()}\n```\n\nThe accumulator function is called to accumulate the contents of an entity.When\nparsing very large files, it may not be desirable to do so.In this case, an acc\nfunction can be provided that simply doesn't accumulate.\n\nNote that it is possible to even modify the parsed entity before accumulating\nit, but this must be done with care. xmerl_scan performs post-processing of the\nelement for namespace management. Thus, the element must keep its original\nstructure for this to work.\n\nThe acc function has the following format and semantics:\n\n``` erlang\n%% default accumulating acc fun\nfun(ParsedEntity, Acc, GlobalState) ->\n   {[ParsedEntity|Acc], GlobalState}.\n\n%% non-accumulating acc fun\nfun(ParsedEntity, Acc, GlobalState) ->\n   {Acc, GlobalState}.\n```\n\n#### 1.8 Close Function\n\nThe close function is called when a document (either the main document or an\nexternal DTD) has been completely parsed. When xmerl_scan was started using\n`xmerl_scan:file/[1,2]`, the file will be read in full, and closed immediately,\nbefore the parsing starts, so when the close function is called, it will not\nneed to actually close the file. In this case, the close function will be a good\nplace to modify the state variables.\n\nFormat and semantics:\n\n``` erlang\nfun(GlobalState) ->\n   GlobalState1 = ....  % state variables may be altered\n```","ref":"xmerl_examples.html#1-description"},{"type":"extras","title":"2 Examples - Customization functions","doc":"See `xmerl_test.erl` for more examples.\n\n#### 2.1 Handling spaces\n\nThe following sample program illustrates three ways of scanning a document:\n\n1.  the default scan, which leaves whitespace untouched\n2.  normalizing spaces\n3.  normalizing spaces, then removing text elements that only contain one space.\n\n``` erlang\n-module(tmp).\n\n-include(\"xmerl.hrl\").\n\n-export([file1/1, file2/1, file3/1]).\n\nfile1(F) -> xmerl_scan:file(F).\n\nfile2(F) -> xmerl_scan:file(F, [{space,normalize}]).\n\nfile3(F) -> Acc = fun(#xmlText{value = \" \", pos = P}, Acc, S) -> {Acc, P,\nS}; % new return format (X, Acc, S) -> {[X|Acc], S} end, xmerl_scan:file(F,\n[{space,normalize}, {acc_fun, Acc}]).\n```","ref":"xmerl_examples.html#2-examples"},{"type":"extras","title":"XSLT-like transformations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2024-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n# XSLT-like transformations","ref":"xmerl_xs_examples.html"},{"type":"extras","title":"Examples - XSLT-like transformations","doc":"---\n\n#### Example 1 Using xslapply\n\noriginal XSLT:\n\n     \n         \n           \n         \n     \n\nbecomes in Erlang:\n\n    template(E = #xmlElement{ parents=[{'doc',_}|_], name='title'}) ->\n        [\" \",\n             xslapply(fun template/1, E),\n         \" \"];\n\n---\n\n---\n\n#### Example 2 Using value_of and select\n\n     \n           \n     \n\nbecomes:\n\n    template(E = #xmlElement{name='title'}) ->\n        [\"  \", value_of(select(\".\", E)), \"  \"];\n\n---\n\n---\n\n#### Example 3 Simple xsl stylesheet\n\nA complete example with the XSLT sheet in the xmerl distribution.\n\n     \n\n       \n       \n\n       \n         \n           \n             \n               \n             \n           \n           \n             \n           \n         \n       \n\n       \n         \n           \n         \n       \n\n       \n         \n           \n         \n       \n\n       \n         \n           \n         \n       \n\n       \n         \n           \n         \n       \n\n       \n         \n           NOTE:  \n           \n         \n       \n\n       \n         \n           \n         \n       \n\n     \n\n---\n\n---\n\n#### Example 4 Erlang version\n\nErlang transformation of previous example:\n\n    -include(\"xmerl.hrl\").\n\n    -import(xmerl_xs,\n    \t[ xslapply/2, value_of/1, select/2, built_in_rules/2 ]).\n\n    doctype()->\n        \"<!DOCTYPE html PUBLIC \\\"-//W3C//DTD XHTML 1.0 Transitional//EN\\\"\\\n     \\\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd \\\">\".\n\n    process_xml(Doc)->\n    \ttemplate(Doc).\n\n    template(E = #xmlElement{name='doc'})->\n        [ \"<\\?xml version=\\\"1.0\\\" encoding=\\\"iso-8859-1\\\"\\?>\",\n          doctype(),\n          \" \"\n          \" \"\n          \" \", value_of(select(\"title\",E)), \" \"\n          \" \"\n          \" \",\n          xslapply( fun template/1, E),\n          \" \"\n          \" \" ];\n\n\n    template(E = #xmlElement{ parents=[{'doc',_}|_], name='title'}) ->\n        [\" \",\n         xslapply( fun template/1, E),\n         \" \"];\n\n    template(E = #xmlElement{ parents=[{'chapter',_}|_], name='title'}) ->\n        [\" \",\n         xslapply( fun template/1, E),\n         \" \"];\n\n    template(E = #xmlElement{ parents=[{'section',_}|_], name='title'}) ->\n        [\" \",\n         xslapply( fun template/1, E),\n         \" \"];\n\n    template(E = #xmlElement{ name='para'}) ->\n        [\" \", xslapply( fun template/1, E), \" \"];\n\n    template(E = #xmlElement{ name='note'}) ->\n        [\" \"\n         \" NOTE:  \",\n         xslapply( fun template/1, E),\n         \" \"];\n\n    template(E = #xmlElement{ name='emph'}) ->\n        [\" \", xslapply( fun template/1, E), \" \"];\n\n    template(E)->\n        built_in_rules( fun template/1, E).\n\nIt is important to end with a call to `xmerl_xs:built_in_rules/2` if you want any\ntext to be written in \"push\" transforms. That are the ones using a lot `xslapply(\nfun template/1, E )` instead of `value_of(select(\"xpath\",E))`, which is pull...\n\n---\n\nThe largest example is the stylesheet to transform this document from the\nSimplified Docbook XML format to xhtml. The source file is sdocbook2xhtml.erl.","ref":"xmerl_xs_examples.html#examples"},{"type":"extras","title":"Tips and tricks - XSLT-like transformations","doc":"#### for-each\n\nThe function for-each is quite common in XSLT stylesheets. It can often be\nrewritten and replaced by select/1. Since select/1 returns a list of\n#xmlElements and xslapply/2 traverses them it is more or less the same as to\nloop over all the elements.\n\n#### position()\n\nThe XSLT position() and #xmlElement.pos are not the same. One has to make an own\nposition in Erlang.\n\n---\n\n#### Example 5 Counting positions\n\n     \n         \n     \n\n     \n       &#160;&#160; \n        \n     \n\nCan be written as\n\n    template(E = #xmlElement{name='stanza'}) ->\n        {Lines,LineNo} = lists:mapfoldl(fun template_pos/2, 1, select(\"line\", E)),\n        [\" \", Lines, \" \"].\n\n    template_pos(E = #xmlElement{name='line'}, P) ->\n        {[indent_line(P rem 2), value_of(E#xmlElement.content), \" \"], P + 1 }.\n\n    indent_line(0)->\"&#160;&#160;\";\n    indent_line(_)->\"\".\n\n---\n\n#### Global tree awareness\n\nIn XSLT you have \"root\" access to the top of the tree with XPath, even though\nyou are somewhere deep in your tree.\n\nThe xslapply/2 function only carries back the child part of the tree to the\ntemplate fun. But it is quite easy to write template funs that handles both the\nchild and top tree.\n\n---\n\n#### Example 6 Passing the root tree\n\nThe following example piece will prepend the article title to any section title\n\n    template(E = #xmlElement{name='title'}, ETop ) ->\n        [\" \", value_of(select(\"title\", ETop)),\" - \",\n         xslapply( fun(A) -> template(A, ETop) end, E),\n         \" \"];\n\n---","ref":"xmerl_xs_examples.html#tips-and-tricks"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}