//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Controls the blit operation
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlblitoption?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLBlitOption(pub NSUInteger);
bitflags::bitflags! {
    impl MTLBlitOption: NSUInteger {
        #[doc(alias = "MTLBlitOptionNone")]
        const None = 0;
        #[doc(alias = "MTLBlitOptionDepthFromDepthStencil")]
        const DepthFromDepthStencil = 1<<0;
        #[doc(alias = "MTLBlitOptionStencilFromDepthStencil")]
        const StencilFromDepthStencil = 1<<1;
        #[doc(alias = "MTLBlitOptionRowLinearPVRTC")]
        const RowLinearPVRTC = 1<<2;
    }
}

unsafe impl Encode for MTLBlitOption {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLBlitOption {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A command encoder that performs basic copies and blits between buffers and textures.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlblitcommandencoder?language=objc)
    #[cfg(feature = "MTLCommandEncoder")]
    pub unsafe trait MTLBlitCommandEncoder: MTLCommandEncoder {
        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Flush any copy of this resource from the device's caches, and invalidate any CPU caches if needed.
        ///
        /// Parameter `resource`: The resource to page off.
        ///
        /// When the device writes to a resource with a storage mode of MTLResourceStorageModeManaged, those writes may be cached (for example, in VRAM or on chip renderer cache),
        /// making any CPU access (either MTLBuffer.contents or -[MTLTexture getBytes:...] and -[MTLTexture replaceRegion:]) produce undefined results.  To allow the CPU to see what the device
        /// has written, a CommandBuffer containing this synchronization must be executed.  After completion of the CommandBuffer, the CPU can access the contents of the resource safely.
        #[unsafe(method(synchronizeResource:))]
        #[unsafe(method_family = none)]
        fn synchronizeResource(&self, resource: &ProtocolObject<dyn MTLResource>);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Flush any copy of this image from the device's caches, and invalidate CPU caches if needed.
        ///
        /// Parameter `texture`: The texture to page off.
        ///
        /// Parameter `slice`: The slice of the texture to page off.
        ///
        /// Parameter `level`: The mipmap level of the texture to flush.
        ///
        /// See the discussion of -synchronizeResource.   -synchronizeTexture:slice:mipmapLevel performs the same role, except it may flush only a subset of the texture storage, rather than the entire texture.
        #[unsafe(method(synchronizeTexture:slice:level:))]
        #[unsafe(method_family = none)]
        unsafe fn synchronizeTexture_slice_level(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            slice: NSUInteger,
            level: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Copy a rectangle of pixels between textures.
        #[unsafe(method(copyFromTexture:sourceSlice:sourceLevel:sourceOrigin:sourceSize:toTexture:destinationSlice:destinationLevel:destinationOrigin:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin(
            &self,
            source_texture: &ProtocolObject<dyn MTLTexture>,
            source_slice: NSUInteger,
            source_level: NSUInteger,
            source_origin: MTLOrigin,
            source_size: MTLSize,
            destination_texture: &ProtocolObject<dyn MTLTexture>,
            destination_slice: NSUInteger,
            destination_level: NSUInteger,
            destination_origin: MTLOrigin,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Copy an image from a buffer into a texture.
        #[unsafe(method(copyFromBuffer:sourceOffset:sourceBytesPerRow:sourceBytesPerImage:sourceSize:toTexture:destinationSlice:destinationLevel:destinationOrigin:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromBuffer_sourceOffset_sourceBytesPerRow_sourceBytesPerImage_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin(
            &self,
            source_buffer: &ProtocolObject<dyn MTLBuffer>,
            source_offset: NSUInteger,
            source_bytes_per_row: NSUInteger,
            source_bytes_per_image: NSUInteger,
            source_size: MTLSize,
            destination_texture: &ProtocolObject<dyn MTLTexture>,
            destination_slice: NSUInteger,
            destination_level: NSUInteger,
            destination_origin: MTLOrigin,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Copy an image from a buffer into a texture.
        #[unsafe(method(copyFromBuffer:sourceOffset:sourceBytesPerRow:sourceBytesPerImage:sourceSize:toTexture:destinationSlice:destinationLevel:destinationOrigin:options:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromBuffer_sourceOffset_sourceBytesPerRow_sourceBytesPerImage_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin_options(
            &self,
            source_buffer: &ProtocolObject<dyn MTLBuffer>,
            source_offset: NSUInteger,
            source_bytes_per_row: NSUInteger,
            source_bytes_per_image: NSUInteger,
            source_size: MTLSize,
            destination_texture: &ProtocolObject<dyn MTLTexture>,
            destination_slice: NSUInteger,
            destination_level: NSUInteger,
            destination_origin: MTLOrigin,
            options: MTLBlitOption,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Copy an image from a texture into a buffer.
        #[unsafe(method(copyFromTexture:sourceSlice:sourceLevel:sourceOrigin:sourceSize:toBuffer:destinationOffset:destinationBytesPerRow:destinationBytesPerImage:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toBuffer_destinationOffset_destinationBytesPerRow_destinationBytesPerImage(
            &self,
            source_texture: &ProtocolObject<dyn MTLTexture>,
            source_slice: NSUInteger,
            source_level: NSUInteger,
            source_origin: MTLOrigin,
            source_size: MTLSize,
            destination_buffer: &ProtocolObject<dyn MTLBuffer>,
            destination_offset: NSUInteger,
            destination_bytes_per_row: NSUInteger,
            destination_bytes_per_image: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Copy an image from a texture into a buffer.
        #[unsafe(method(copyFromTexture:sourceSlice:sourceLevel:sourceOrigin:sourceSize:toBuffer:destinationOffset:destinationBytesPerRow:destinationBytesPerImage:options:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toBuffer_destinationOffset_destinationBytesPerRow_destinationBytesPerImage_options(
            &self,
            source_texture: &ProtocolObject<dyn MTLTexture>,
            source_slice: NSUInteger,
            source_level: NSUInteger,
            source_origin: MTLOrigin,
            source_size: MTLSize,
            destination_buffer: &ProtocolObject<dyn MTLBuffer>,
            destination_offset: NSUInteger,
            destination_bytes_per_row: NSUInteger,
            destination_bytes_per_image: NSUInteger,
            options: MTLBlitOption,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Generate mipmaps for a texture from the base level up to the max level.
        #[unsafe(method(generateMipmapsForTexture:))]
        #[unsafe(method_family = none)]
        fn generateMipmapsForTexture(&self, texture: &ProtocolObject<dyn MTLTexture>);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Fill a buffer with a fixed value in each byte.
        #[unsafe(method(fillBuffer:range:value:))]
        #[unsafe(method_family = none)]
        fn fillBuffer_range_value(
            &self,
            buffer: &ProtocolObject<dyn MTLBuffer>,
            range: NSRange,
            value: u8,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Copy whole surfaces between textures.
        ///
        /// Convenience function to copy sliceCount * levelCount whole surfaces between textures
        /// The source and destination pixel format must be identical.
        /// The source and destination sample count must be identical.
        /// The sourceLevel mip in sourceTexture must have the same dimension as the destinationLevel mip in destinationTexture.
        /// The sourceTexture must have at least sourceLevel + levelCount mips
        /// The destinationTexture must have at least destinationLevel + levelCount mips
        /// The sourceTexture must have at least sourceSlice + sliceCount array slices
        /// The destinationTexture must have at least destinationSlice + sliceCount array slices
        #[unsafe(method(copyFromTexture:sourceSlice:sourceLevel:toTexture:destinationSlice:destinationLevel:sliceCount:levelCount:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromTexture_sourceSlice_sourceLevel_toTexture_destinationSlice_destinationLevel_sliceCount_levelCount(
            &self,
            source_texture: &ProtocolObject<dyn MTLTexture>,
            source_slice: NSUInteger,
            source_level: NSUInteger,
            destination_texture: &ProtocolObject<dyn MTLTexture>,
            destination_slice: NSUInteger,
            destination_level: NSUInteger,
            slice_count: NSUInteger,
            level_count: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Copy as many whole surfaces as possible between textures.
        ///
        /// Convenience function that calls copyFromTexture:sourceSlice:sourceLevel:toTexture:destinationSlice:destinationLevel:sliceCount:levelCount:
        /// The source and destination pixel format must be identical.
        /// The source and destination sample count must be identical.
        /// Either:
        /// - sourceTexture must have a mip M with identical dimensions as the first mip of destinationTexture: sourceLevel = M, destinationLevel = 0
        /// - destinationTexture must have a mip M with identical dimensions as the first mip of sourceTexture: sourceLevel = 0, destinationLevel = M
        /// Computes: levelCount = min(sourceTexture.mipmapLevelCount - sourceLevel, destinationTexture.mipmapLevelCount - destinationLevel)
        /// sliceCount = min(sourceTexture.arrayLength, destinationTexture.arrayLength)
        /// Then invokes the method above using the computed parameters.
        #[unsafe(method(copyFromTexture:toTexture:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromTexture_toTexture(
            &self,
            source_texture: &ProtocolObject<dyn MTLTexture>,
            destination_texture: &ProtocolObject<dyn MTLTexture>,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Basic memory copy between buffers.
        #[unsafe(method(copyFromBuffer:sourceOffset:toBuffer:destinationOffset:size:))]
        #[unsafe(method_family = none)]
        unsafe fn copyFromBuffer_sourceOffset_toBuffer_destinationOffset_size(
            &self,
            source_buffer: &ProtocolObject<dyn MTLBuffer>,
            source_offset: NSUInteger,
            destination_buffer: &ProtocolObject<dyn MTLBuffer>,
            destination_offset: NSUInteger,
            size: NSUInteger,
        );

        #[cfg(feature = "MTLFence")]
        /// Update the fence to capture all GPU work so far enqueued by this encoder.
        ///
        /// The fence is updated at kernel submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[unsafe(method(updateFence:))]
        #[unsafe(method_family = none)]
        fn updateFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(feature = "MTLFence")]
        /// Prevent further GPU work until the fence is reached.
        ///
        /// The fence is evaluated at kernel submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[unsafe(method(waitForFence:))]
        #[unsafe(method_family = none)]
        fn waitForFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Copies tile access counters within specified region into provided buffer
        #[optional]
        #[unsafe(method(getTextureAccessCounters:region:mipLevel:slice:resetCounters:countersBuffer:countersBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn getTextureAccessCounters_region_mipLevel_slice_resetCounters_countersBuffer_countersBufferOffset(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            region: MTLRegion,
            mip_level: NSUInteger,
            slice: NSUInteger,
            reset_counters: bool,
            counters_buffer: &ProtocolObject<dyn MTLBuffer>,
            counters_buffer_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Resets tile access counters within specified region
        #[optional]
        #[unsafe(method(resetTextureAccessCounters:region:mipLevel:slice:))]
        #[unsafe(method_family = none)]
        unsafe fn resetTextureAccessCounters_region_mipLevel_slice(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            region: MTLRegion,
            mip_level: NSUInteger,
            slice: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Optimizes the texture data to ensure the best possible performance when accessing content on the GPU at the expense of CPU-access performance.
        #[unsafe(method(optimizeContentsForGPUAccess:))]
        #[unsafe(method_family = none)]
        fn optimizeContentsForGPUAccess(&self, texture: &ProtocolObject<dyn MTLTexture>);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Optimizes a subset of the texture data to ensure the best possible performance when accessing content on the GPU at the expense of CPU-access performance.
        #[unsafe(method(optimizeContentsForGPUAccess:slice:level:))]
        #[unsafe(method_family = none)]
        unsafe fn optimizeContentsForGPUAccess_slice_level(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            slice: NSUInteger,
            level: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Optimizes the texture data to ensure the best possible performance when accessing content on the CPU at the expense of GPU-access performance.
        #[unsafe(method(optimizeContentsForCPUAccess:))]
        #[unsafe(method_family = none)]
        unsafe fn optimizeContentsForCPUAccess(&self, texture: &ProtocolObject<dyn MTLTexture>);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Optimizes a subset of the texture data to ensure the best possible performance when accessing content on the CPU at the expense of GPU-access performance.
        #[unsafe(method(optimizeContentsForCPUAccess:slice:level:))]
        #[unsafe(method_family = none)]
        unsafe fn optimizeContentsForCPUAccess_slice_level(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            slice: NSUInteger,
            level: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// reset commands in a indirect command buffer using the GPU
        #[unsafe(method(resetCommandsInBuffer:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn resetCommandsInBuffer_withRange(
            &self,
            buffer: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// copy a region of a buffer into a destination buffer starting at destinationIndex using the GPU
        #[unsafe(method(copyIndirectCommandBuffer:sourceRange:destination:destinationIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn copyIndirectCommandBuffer_sourceRange_destination_destinationIndex(
            &self,
            source: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            source_range: NSRange,
            destination: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            destination_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// Optimizes a subset of the texture data to ensure the best possible performance when accessing content on the CPU at the expense of GPU-access performance.
        #[unsafe(method(optimizeIndirectCommandBuffer:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn optimizeIndirectCommandBuffer_withRange(
            &self,
            indirect_command_buffer: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            range: NSRange,
        );

        #[cfg(feature = "MTLCounters")]
        /// Sample hardware counters at this point in the blit encoder and
        /// store the counter sample into the sample buffer at the specified index.
        ///
        /// Parameter `sampleBuffer`: The sample buffer to sample into
        ///
        /// Parameter `sampleIndex`: The index into the counter buffer to write the sample.
        ///
        /// Parameter `barrier`: Insert a barrier before taking the sample.  Passing
        /// YES will ensure that all work encoded before this operation in the encoder is
        /// complete but does not isolate the work with respect to other encoders.  Passing
        /// NO will allow the sample to be taken concurrently with other operations in this
        /// encoder.
        /// In general, passing YES will lead to more repeatable counter results but
        /// may negatively impact performance.  Passing NO will generally be higher performance
        /// but counter results may not be repeatable.
        ///
        /// On devices where MTLCounterSamplingPointAtBlitBoundary is unsupported,
        /// this method is not available and will generate an error if called.
        #[unsafe(method(sampleCountersInBuffer:atSampleIndex:withBarrier:))]
        #[unsafe(method_family = none)]
        unsafe fn sampleCountersInBuffer_atSampleIndex_withBarrier(
            &self,
            sample_buffer: &ProtocolObject<dyn MTLCounterSampleBuffer>,
            sample_index: NSUInteger,
            barrier: bool,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLCounters",
            feature = "MTLResource"
        ))]
        /// Parameter `sampleBuffer`: The sample buffer to resolve.
        ///
        /// Parameter `range`: The range of indices to resolve.
        ///
        /// Parameter `destinationBuffer`: The buffer to resolve values into.
        ///
        /// Parameter `destinationOffset`: The offset to begin writing values out to.  This must be a multiple of
        /// the minimum constant buffer alignment.
        ///
        /// Resolve the counters from the raw buffer to a processed buffer.
        ///
        /// Samples that encountered an error during resolve will be set to
        /// MTLCounterErrorValue.
        #[unsafe(method(resolveCounters:inRange:destinationBuffer:destinationOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn resolveCounters_inRange_destinationBuffer_destinationOffset(
            &self,
            sample_buffer: &ProtocolObject<dyn MTLCounterSampleBuffer>,
            range: NSRange,
            destination_buffer: &ProtocolObject<dyn MTLBuffer>,
            destination_offset: NSUInteger,
        );
    }
);
