// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2017 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=New_Tai_Lue`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v10.0.0
  Emoji v5.0 (UTR51)
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x001980, 0x0019AB],
    [0x0019B0, 0x0019C9],
    [0x0019D0, 0x0019DA],
    [0x0019DE, 0x0019DF]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=New_Tai_Lue}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=New_Tai_Lue}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Talu}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Talu}"
);
testPropertyEscapes(
  /^\p{scx=New_Tai_Lue}+$/u,
  matchSymbols,
  "\\p{scx=New_Tai_Lue}"
);
testPropertyEscapes(
  /^\p{scx=Talu}+$/u,
  matchSymbols,
  "\\p{scx=Talu}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00197F],
    [0x0019AC, 0x0019AF],
    [0x0019CA, 0x0019CF],
    [0x0019DB, 0x0019DD],
    [0x0019E0, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=New_Tai_Lue}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=New_Tai_Lue}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Talu}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Talu}"
);
testPropertyEscapes(
  /^\P{scx=New_Tai_Lue}+$/u,
  nonMatchSymbols,
  "\\P{scx=New_Tai_Lue}"
);
testPropertyEscapes(
  /^\P{scx=Talu}+$/u,
  nonMatchSymbols,
  "\\P{scx=Talu}"
);

reportCompare(0, 0);
