# tcl_lang

## Generating `tclConfig.h`

Note that the `tclConfig` headers are not generated by default on unix and will require a patch to get working.
Once the patch is applied, simply run `autoconf` and then follow the normal `configure` workflow to generate the file.

### 8.X

```diff
diff --git a/unix/configure.in b/unix/configure.in
index e88ec3c..e116e56 100644
--- a/unix/configure.in
+++ b/unix/configure.in
@@ -6,6 +6,8 @@ dnl     to configure the system for the local environment.
 AC_INIT([tcl],[8.6])
 AC_PREREQ([2.59])

+m4_define(SC_USE_CONFIG_HEADERS)
+
 dnl This is only used when included from macosx/configure.ac
 m4_ifdef([SC_USE_CONFIG_HEADERS], [
     AC_CONFIG_HEADERS([tclConfig.h:../unix/tclConfig.h.in])
```

### 9.X

```diff
diff --git a/unix/configure.ac b/unix/configure.ac
index 7f012d4..f927d0a 100644
--- a/unix/configure.ac
+++ b/unix/configure.ac
@@ -6,6 +6,8 @@ dnl     to configure the system for the local environment.
 AC_INIT([tcl],[9.0])
 AC_PREREQ([2.69])

+m4_define(SC_USE_CONFIG_HEADERS)
+
 dnl This is only used when included from macosx/configure.ac
 m4_ifdef([SC_USE_CONFIG_HEADERS], [
     AC_CONFIG_HEADERS([tclConfig.h:../unix/tclConfig.h.in])
```
