/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_shn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_xbb = "ယူႇၼိတ်ႉၵၢၼ်ငိုၼ်းတွင်းယူးရူပ်ႉ";
        final Object[][] data = new Object[][] {
            { "adp", "ပေႇသႄႇတႃႇဢႅၼ်ႇတူဝ်ႇရႃႇ" },
            { "aed", "တီႇရမ်ႇမိူင်းႁူမ်ႈတုမ် ၸဝ်ႈၾႃႉ ဢႃႇရၢပ်ႈ" },
            { "afa", "ဢႃႇၾၵၢၼ်ႇၼီႇဢႃႇၾၵၢၼ်ႇ (1927–2002)" },
            { "afn", "ဢႃႇၾၵၢၼ်ႇၼီႇဢႃႇၾၵၢၼ်ႇ" },
            { "alk", "လႅၵ်ႈဢႃႇပႃးၼီးယႃး (1946–1965)" },
            { "all", "လႅၵ်ႈဢႃႇပႃးၼီးယႃး" },
            { "amd", "တရၢမ်ႇဢႃႇမေးၼီးယႃး" },
            { "ang", "ၵဵဝ်းတႃႇၼႄႇတႃႇလႅၼ်ႇ ဢၼ်ထေးလ်လိသ်" },
            { "aoa", "ၶႂၼ်ႇၸႃႇဢႅၼ်ႇၵူဝ်ႇလႃႇ" },
            { "aok", "ၶႂၼ်ႇၸႃႇဢႅၼ်ႇၵူဝ်ႇလႃႇ (1977–1991)" },
            { "aon", "ၶႂၼ်ႇၸႃႇမႂ်ႇဢႅၼ်ႇၵူဝ်ႇလႃႇ (1990–2000)" },
            { "aor", "ၶႂၼ်ႇၸႃႇဢႅၼ်ႇၵူဝ်ႇလႃႇ ဢၼ်ၶိုၼ်းမူၼ်ႉမႄးဝႆႉ (1995–1999)" },
            { "ara", "ဢေႃႉသထရႄႇလ်ဢႃႇၵျႅၼ်ႇတီးၼႃး" },
            { "arl", "ပေႇသူဝ်ႇလေးဢႃႇၵျႅၼ်ႇတီးၼႃး (1970–1983)" },
            { "arm", "ပေႇသူဝ်ႇဢႃႇၵျႅၼ်ႇတီးၼႃး (1881–1970)" },
            { "arp", "ပေႇသူဝ်ႇဢႃႇၵျႅၼ်ႇတီးၼႃး (1983–1985)" },
            { "ars", "ပေႇသူဝ်ႇဢႃႇၵျႅၼ်ႇတီးၼႃး" },
            { "ats", "သျီႇလင်ႇဢေႃးသထရီးယႃး" },
            { "aud", "တေႃႇလႃႇဢေႃႉသထရေးလီးယႃး" },
            { "awg", "ၽလေႃးရိၼ်ႇဢႃႇရူးပႃး" },
            { "azm", "မၼတ်ႉဢႃႇၸႃႇပၢႆႇၸၼ်ႇ (1993–2006)" },
            { "azn", "မၼတ်ႉဢႃႇၸႃႇပၢႆႇၸၼ်ႇ" },
            { "bad", "တီႇၼႃႇပေႃးသၼီးယႃး လႄႈ ႁႃႇၸီႇၵူဝ်းဝီးၼႃး (1992–1994)" },
            { "bam", "မၢၵ်ႉၶ်ပေႃးသၼီးယႃး လႄႈ ႁႃႇၸီႇၵူဝ်းဝီးၼႃး ဢၼ်လႅၵ်ႈလႆႈ" },
            { "ban", "တီႇၼႃႇမႂ်ႇပေႃးသၼီးယႃး လႄႈ ႁႃႇၸီႇၵူဝ်းဝီးၼႃး (1994–1997)" },
            { "bbd", "တေႃႇလႃႇပႃးပေႇတူတ်ႈ" },
            { "bdt", "တႃႇၵႃႇပင်းၵလႃးတဵတ်ႈ" },
            { "bec", "ၾရၼ်ႉပႄႇၵျီႇယမ်ႇ (ဢၼ်လႅၵ်ႈလႆႈ)" },
            { "bef", "ၾရၼ်ႉပႄႇၵျီႇယမ်ႇ" },
            { "bel", "ၾရၼ်ႉပႄႇၵျီႇယမ်ႇ (ၵၢၼ်ငိုၼ်းတွင်း)" },
            { "bgl", "လႅပ်ႉၾ်ၶႅင်ပူႇၵႃႇရီႇယႃႇ" },
            { "bgm", "လႅပ်ႉၾ်သူဝ်ႇသျႄႇလိတ်ႉပူႇၵႃႇရီႇယႃႇ" },
            { "bgn", "လႅပ်ႉၾ်ပူႇၵႃႇရီႇယႃႇ" },
            { "bgo", "လႅပ်ႉၾ်ပူႇၵႃႇရီႇယႃႇ (1879–1952)" },
            { "bhd", "တီႇၼႃႇပႃႇရဵၼ်း" },
            { "bif", "ၾရၼ်ႉပူႇရုၼ်းတီႇ" },
            { "bmd", "တေႃႇလႃႇပႃႇမိဝ်းတႃး" },
            { "bnd", "တေႃႇလႃႇပရူႇၼၢႆး" },
            { "bob", "ပူဝ်ႇလီႇဝီႇယႃႇၼူဝ်ႇပူဝ်ႇလီးပီးယႃး" },
            { "bol", "ပူဝ်ႇလီႇဝီႇယႃႇၼူဝ်ႇပူဝ်ႇလီးပီးယႃး (1863–1963)" },
            { "bop", "ပေႇသူဝ်ႇပူဝ်ႇလီးပီးယႃး" },
            { "bov", "ဢႅမ်ႇဝီႇတေႃးပူဝ်ႇလီးပီးယႃး" },
            { "brb", "ၶရူႇၸႄရူဝ်ႇမႂ်ႇပရႃႇၸီး (1967–1986)" },
            { "brc", "ၶရူႇၸႃတူဝ်ႇပရႃႇၸီး (1986–1989)" },
            { "bre", "ၶရူႇၸႄရူဝ်ႇပရႃႇၸီး (1990–1993)" },
            { "brl", "ရီးဢႄႇလ်ပရႃႇၸီး" },
            { "brn", "ၶရူႇၸႃတူဝ်ႇမႂ်ႇပရႃႇၸီး (1989–1990)" },
            { "brr", "ၶရူႇၸႄရူဝ်ႇပရႃႇၸီး (1993–1994)" },
            { "brz", "ၶရူႇၸႄရူဝ်ႇပရႃႇၸီး (1942–1967)" },
            { "bsd", "တေႃႇလႃႇပႃႇႁႃးမႃး" },
            { "btn", "ဢိၼ်ၵူးလ်ထရမ်ႇၽူႇတၢၼ်ႇ" },
            { "buk", "ၵျၢပ်ႈမၢၼ်ႈ" },
            { "bwp", "ပူႇလႃႇပွတ်ႉသဝႃႇၼႃႇ" },
            { "byb", "ရူႇပႄႇပႄႇလႃႇရုတ်ႈ (1994–1999)" },
            { "byn", "ရူႇပႄႇပႄႇလႃႇရုတ်ႈ" },
            { "byr", "ရူႇပႄႇပႄႇလႃႇရုတ်ႈ (2000–2016)" },
            { "bzd", "တေႃႇလႃႇပႄႇလိတ်ႈ" },
            { "cad", "တေႃႇလႃႇၶႅၼ်ႇၼေႇတႃႇ" },
            { "cdf", "ၾရၼ်ႉၶွင်ႇၵူဝ်ႇ" },
            { "che", "ယူႇရူဝ်ႇ WIR" },
            { "chf", "ၾရၼ်ႉသဝိတ်ႈၸႃႇလႅၼ်ႇ" },
            { "chw", "ၾရၼ်ႉ WIR" },
            { "cle", "ဢႅတ်ႉသၵူႇတူဝ်ႇၶျီႇလီႇ" },
            { "clf", "ယူႇၼီႉၶွင်ဢၶွင်ႉၶျီႇလီႇ" },
            { "clp", "ပေႇသူဝ်ႇၶျီႇလီႇ" },
            { "cnh", "ယွၼ်ႇၶႄႇ (ၼွၵ်ႈၽၢင်ႇပၢင်ႇလၢႆႇ)" },
            { "cnx", "တေႃႇလႃႇယေးငိုၼ်းၵူၼ်းမိူင်းၶႄႇ" },
            { "cny", "ယွၼ်ႇၶႄႇ" },
            { "cop", "ပေႇသူဝ်ႇၵူဝ်ႇလမ်ႇပီႇယႃႇ" },
            { "cou", "ယူႇၼိတ်ႉၵႃႈၶၼ်တႄႉတႄႉၵူဝ်ႇလမ်ႇပီႇယႃႇ" },
            { "crc", "ၵူဝ်ႇလူၼ်ႇၵေႃးသတႃႇရိၵႃႇ" },
            { "csd", "တီႇၼႃႇသႃးပီးယႃး (2002–2006)" },
            { "csk", "ၵူဝ်ႇရူႇၼႃႇၶႅင်ၶျႅၵ်ႈ" },
            { "cuc", "ပေႇသူဝ်ႇၵူးပႃး ဢၼ်လႅၵ်ႈလႆႈ" },
            { "cup", "ပေႇသူဝ်ႇၵူးပႃး" },
            { "cve", "ဢိသ်ၵူႇတူဝ်ႇၶဵပ်ႉဝႄႇတီႇ" },
            { "cyp", "ပွၼ်းသၢႆႉပရႅတ်ႈ" },
            { "czk", "ၵူဝ်ႇရူႇၼႃႇၶျႅၵ်ႈ" },
            { "ddm", "မၢၵ်ႉၶ်ၵျႃႇမၼ်ႇပွတ်းဢွၵ်ႇ" },
            { "dem", "မၢၵ်ႉၶ်ၵျႃႇမၼ်ႇ" },
            { "djf", "ၾရၼ်ႉၵျီႇပူးတီႇ" },
            { "dkk", "ၶရူၼ်းတႅၼ်းမၢၵ်ႈ" },
            { "dop", "ပေႇသူဝ်ႇတူဝ်ႇမီႇၼီႇၵၼ်ႇ" },
            { "dzd", "တီႇၼႃႇဢႄးၵျီးရီးယႃး" },
            { "ecs", "သုၶရေႇဢေႇၵႂႃႇတေႃႇ" },
            { "ecv", "ယူးၼိတ်ႉၵႃႈၶၼ်ဢေႇၵႂႃႇတေႃႇ ဢၼ်ဢမ်ႇလႅၵ်ႈလၢႆႈ" },
            { "eek", "ၶရူၼ်းဢႄႇသတူဝ်းၼီးယႃး" },
            { "egp", "ပွၼ်းဢီးၵျိပ်ႈ" },
            { "ern", "ၼၢၵ်ႉၾႃႉဢႄႇရီႇထရီးယႃး" },
            { "esa", "ပေႇသႄႇတႃႇသပဵၼ်ႇ (ဢၶွင်ႉ)" },
            { "esb", "ပေႇသႄႇတႃႇသပဵၼ်ႇ (ဢၶွင်ႉဢၼ်လႅၵ်ႈလႆႈ)" },
            { "esp", "ပေႇသႄႇတႃႇသပဵၼ်ႇ" },
            { "etb", "ပႄးရ်ဢီႇတီႇယူဝ်းပီးယႃး" },
            { "eur", "ယူႇရူဝ်ႇ" },
            { "fim", "မႃႇၶႃႇၾိၼ်ႇလႅၼ်ႇ" },
            { "fjd", "တေႃႇလႃႇၾီႇၵျီႇ" },
            { "fkp", "ပွၼ်းမူႇၵုၼ်ၾွၵ်ႉလႅၼ်ႇ" },
            { "frf", "ၾရၼ်ႉၾရၢင်ႇသဵတ်ႈ" },
            { "gbp", "ပွၼ်းဢိင်းၵလဵတ်ႈ" },
            { "gek", "ၵူႇပုၼ်ႇလႃႇရိတ်ႉၵျေႃႇၵျႃႇ" },
            { "gel", "လႃႇရီႇၵျေႃႇၵျႃႇ" },
            { "ghc", "သေႇတီႇၵႃႇၼႃႇ (1979–2007)" },
            { "ghs", "သေႇတီႇၵႃႇၼႃႇ" },
            { "gip", "ပွၼ်း ၵျီႇပရေႃးတႃး" },
            { "gmd", "တႃႇလႃႇသီႇၵမ်ႇပီးယႃး" },
            { "gnf", "ၾရၼ်ႉၵီးၼီး" },
            { "gns", "သီႇလီႇၵီးၼီး" },
            { "gqe", "ဢႅၵ်ႉဝႄႇလႄႇဢီႇၵူၺ်ႇတေႃႇရီႇယႃႇၵီးၼီး" },
            { "grd", "တရၢၵ်ႉမႃႇၵရိတ်ႈ" },
            { "gtq", "ၶႅတ်ႉၸႄးလ်ၵႂႃႇတမႃႇလႃႇ" },
            { "gwe", "ဢႅတ်ႉၵူႇတူဝ်ႇၵီးၼီးပေႃးတူႉၵၢဝ်ႇ" },
            { "gwp", "ပေႇသူဝ်ႇၵီးၼီး-ပိတ်ႈသၢဝ်ႇ" },
            { "gyd", "တေႃႇလႃႇၵၢႆႇယႃးၼႃႇ" },
            { "hkd", "တေႃႇလႃႇႁွင်းၵွင်း" },
            { "hnl", "လႅမ်းပီႇရႃႇႁွၼ်ႇတူးရႅတ်ႈ" },
            { "hrd", "တီႇၼႃႇၶရူဝ်ႇဢေးသျႃး" },
            { "hrk", "ၵူႇၼႃႇၶရူဝ်ႇဢေးသျႃး" },
            { "htg", "ၵုတ်ႉထ်ႁေးတီႇ" },
            { "huf", "ၾူဝ်ႇရိၼ်ႇႁၢင်ႇၵေႇရီႇ" },
            { "idr", "ရူႇပီးယႃးဢိၼ်ႇတူဝ်ႇၼီးသျႃး" },
            { "iep", "ပွၼ်းဢၢႆႇယႃႇလႅၼ်ႇ" },
            { "ilp", "ပွၼ်းဢိတ်ႇသရေး" },
            { "ilr", "သျႅၵ်ႈၵႄႇလ်ဢိတ်ႇသရေး (1980–1985)" },
            { "ils", "သျႅၵ်ႈၵႄႇလ်မႂ်ႇဢိတ်ႇသရေး" },
            { "inr", "ရူႇပီးဢိၼ်းတီးယႃး" },
            { "iqd", "တီႇၼႃႇဢီႇရၢၵ်ႈ" },
            { "irr", "ရီဢႄလ်ဢီႇရၢၼ်း" },
            { "isj", "ၶရူဝ်ႇၼႃႇဢၢႆးသလႅၼ်ႇ (1918–1981)" },
            { "isk", "ၶရူဝ်ႇၼႃႇဢၢႆးသလႅၼ်ႇ" },
            { "itl", "လီႇရႃႇဢီႇတႃႇလီႇ" },
            { "jmd", "တေႃႇလႃႇၵျႃႇမေႇၵႃႇ" },
            { "jod", "တီႇၼႃႇၵျေႃႇတၼ်ႇ" },
            { "jpy", "ယႅၼ်းၵျႃႇပၢၼ်ႇ" },
            { "kes", "သျီႇလိင်ႇၶႅၼ်ႇၺႃႇ" },
            { "kgs", "သွမ်ႇၵႃႇၵိတ်ႈသတၼ်ႇ" },
            { "khr", "ရိဢႄလ်ၵမ်ႇပေႃးတီးယႃး" },
            { "kmf", "ၽရၼ်ႉၶူဝ်ႇမူဝ်ႇရူတ်ႈ" },
            { "kpw", "ဝွၼ်ႇၵၢဝ်းလီႁွင်ႇ" },
            { "krh", "ဝွၼ်ႇၵၢဝ်းလီၸၢၼ်း (1953–1962)" },
            { "kro", "ဝွၼ်ႇၵၢဝ်းလီၸၢၼ်း (1945–1953)" },
            { "krw", "ဝွၼ်ႇၵၢဝ်းလီၸၢၼ်း" },
            { "kwd", "တီႇၼႃႇၶူႇဝဵတ်ႈ" },
            { "kyd", "တေႃႇလႃႇမူႇၵုၼ်ၶေးမႅၼ်း" },
            { "kzt", "ထႅင်ၵႄႇၵႃႇၸၢၵ်ႈသတၼ်ႇ" },
            { "lak", "ၵိပ်ႇလၢဝ်း" },
            { "lbp", "ပွၼ်းလႄႇပႃႇၼွၼ်ႇ" },
            { "lkr", "ရူႇပီးသီႇရိလင်းၵႃ" },
            { "lrd", "တေႃႇလႃႇလၢႆႇပေးရီးယႃး" },
            { "lsl", "လူဝ်ႇတီႇလႄႇသူဝ်းတူဝ်ႇ" },
            { "ltl", "လိတတ်ႉသ်လီႉတူႇဝေးၼီးယႃး" },
            { "ltt", "တႄႇလူဝ်ႇၼတ်ႉလီႉတူႇဝေးၼီးယႃး" },
            { "luc", "ၾရၼ်ႉလၢၵ်ႈၸိမ်ႇပၢၵ်ႈ ဢၼ်လႅၵ်ႈလႆႈ" },
            { "luf", "ၾရၼ်ႉလၢၵ်ႈၸိမ်ႇပၢၵ်ႈ" },
            { "lul", "ၾရၼ်ႉၵၢၼ်ငိုၼ်းတွင်း လၢၵ်ႈၸိမ်ႇပၢၵ်ႈ" },
            { "lvl", "လတ်ႉသ်လၢတ်ႈဝီႇယႃႇ" },
            { "lvr", "ရူႇပႄႇလၢတ်ႉဝီႇယႃႇ" },
            { "lyd", "တီႇၼႃႇလိပ်ႉပျႃး" },
            { "mad", "တီႇရမ်ႇမေႃႇရူဝ်ႇၵူဝ်ႇ" },
            { "maf", "ၾရၼ်ႉမေႃႇရူဝ်ႇၵူဝ်ႇ" },
            { "mcf", "ၾရၼ်ႉမူဝ်ႇၼႃႉၶူဝ်ႇ" },
            { "mdc", "ၶူႇပွၼ်ႇမေႃႇတူဝ်းဝႃး" },
            { "mdl", "လဵဝ်းမေႃႇတူဝ်းဝႃး" },
            { "mga", "ဢႃႇရီႇယႃႇရီႇမၢတ်ႈတႃႇၵၢတ်ႈသၵႃႇ" },
            { "mgf", "ၾရၼ်ႉမၢတ်ႈတႃႇၵၢတ်ႈသၵႃႇ" },
            { "mkd", "တႅၼ်ႇၼႃႇမႄႇၶေႇတူဝ်းၼီးယႃးႁွင်ႇ" },
            { "mkn", "တႅၼ်ႇၼႃႇမႄႇၶေႇတူဝ်းၼီးယႃးႁွင်ႇ (1992–1993)" },
            { "mlf", "ၾရၼ်ႉမႃႇလီႇ" },
            { "mmk", "ၵျၢပ်ႈမျၢၼ်ႇမႃႇ" },
            { "mnt", "တူႉၵရိၵ်ႉမူင်ႇၵူဝ်းလီးယႃး" },
            { "mop", "ပႃႇတႃႇၵႃႇမႃႇၵၢဝ်ႈ" },
            { "mro", "ဢူးၵီႇယႃႇမေႃႇရီႇတေးၼီးယႃး (1973–2017)" },
            { "mru", "ဢူးၵီႇယႃႇမေႃႇရီႇတေးၼီးယႃး" },
            { "mtl", "လီႇရႃႇမေႃးတႃႇ" },
            { "mtp", "ပွၼ်းမေႃးတႃႇ" },
            { "mur", "ရူႇပီးမေႃးရီႇသႃႇ" },
            { "mvp", "ရူႇၾီႇယႃႇမေႃႇတိပ်ႈ (1947–1981)" },
            { "mvr", "ရူႇၾီႇယႃႇမေႃႇတိပ်ႈ" },
            { "mwk", "ၶႂႃႇၶျႃႇမႃႇလႃႇဝီႇ" },
            { "mxn", "ပေႇသူဝ်ႇမႅၵ်ႇသီႇၵူဝ်ႇ" },
            { "mxp", "ပေႇသူဝ်ႇငိုၼ်းမႅၵ်ႇသီႇၵူဝ်ႇ (1861–1992)" },
            { "mxv", "ယူႇၼိတ်ႉလူင်းတိုၼ်းမႅၵ်ႇသီႇၵူဝ်ႇ" },
            { "myr", "ရိင်းၵိတ်ႉမလေးသျႃး" },
            { "mze", "ဢႅတ်ႉသၵူတူဝ်ႇမူဝ်ႇၸမ်းပိၵ်ႈ" },
            { "mzm", "မႅတ်ႉတိၵ်ႉၵႄႇလ်မူဝ်ႇၸမ်းပိၵ်ႈ (1980–2006)" },
            { "mzn", "မႅတ်ႉတိၵ်ႉၵႄႇလ်မူဝ်ႇၸမ်းပိၵ်ႈ" },
            { "nad", "တေႃႇလႃႇၼႃႇမီးပီးယႃး" },
            { "ngn", "ၼေးရႃႇၼၢႆႇၵျီးရီးယႃး" },
            { "nic", "ၵေႃႇတူဝ်ႇပႃႇၼီႇၵႃႇရႃႇၵႂႃႇ (1988–1991)" },
            { "nio", "ၵေႃႇတူဝ်ႇပႃႇၼီႇၵႃႇရႃႇၵႂႃႇ" },
            { "nlg", "ၵိလ်တႃႇတၢတ်ႉၶျ်" },
            { "nok", "ၶရူၼ်းၼေႃႇဝူၺ်း" },
            { "npr", "ရူႇပီးၼေႇပေႃး" },
            { "nzd", "တေႃႇလႃႇၼိဝ်းၸီႇလႅၼ်ႇ" },
            { "omr", "ရီဢႄလ်ဢူဝ်ႇမၢၼ်ႇ" },
            { "pab", "ပႄးလ်ပူဝ်ႇဢႃႇပႃႈၼႃးမႃး" },
            { "pei", "ဢိၼ်ႇတီႇပေႇရူႉ" },
            { "pen", "သူဝ်းလ်ပေႇရူႉ" },
            { "pes", "သူဝ်းလ်ပေႇရူႉ (1863–1965)" },
            { "pgk", "ၶိၼႃႇပႃးပႂႃႇၼိဝ်းၵီးၼီး" },
            { "php", "ပေႇသူဝ်ႇၾီလိပ်ႈပိၼ်း" },
            { "pkr", "ရူႇပီးပႃႇၵိတ်ႈသတၼ်ႇ" },
            { "pln", "ၸလူဝ်ႇတီႇပူဝ်ႇလႅၼ်ႇ" },
            { "plz", "ၸလူဝ်ႇတီႇပူဝ်ႇလႅၼ်ႇ (1950–1995)" },
            { "pte", "ဢိသ်ၵူႇတူဝ်ႇ တိူဝ်ႇၵီႇ" },
            { "pyg", "ၵႂႃႇရႃႇၼီပႃႇရႃႇၵူၺ်း" },
            { "qar", "ရီယႄႇလ်ၶႃႇတႃႇ" },
            { "rhd", "တေႃႇလႃႇရူဝ်ႇတႄႇသီႇယႅၼ်ႇ" },
            { "rol", "လဵဝ်းရူဝ်ႇမေးၼီးယႃး (1952–2006)" },
            { "ron", "လဵဝ်းရူဝ်ႇမေးၼီးယႃး" },
            { "rsd", "တီႇၼႃႇ သႃးပီးယႃး" },
            { "rub", "ရူႇပႄႇရတ်ႈသျႃး" },
            { "rur", "ရူႇပႄႇရတ်ႈသျႃး (1991–1998)" },
            { "rwf", "ၾရၼ်ႉရဝၢၼ်းတႃႇ" },
            { "sar", "ရီယႄႇလ်သေႃႇတီႇ" },
            { "sbd", "တေႃႇလႃႇမူႇၵုၼ်သေႃႇလေႃႇမၼ်ႇ" },
            { "scr", "ရူႇပီးသေးသျႄႇ" },
            { "sdd", "တီႇၼႃႇသူႇတၼ်ႇ (1992–2007)" },
            { "sdg", "ပွၼ်းသူႇတၼ်ႇ" },
            { "sdp", "ပွၼ်းသူႇတၼ်ႇ (1957–1998)" },
            { "sek", "ၶရူဝ်ႇၼႃႇသုၺ်ႇတိၼ်ႇ" },
            { "sgd", "တေႃႇလႃႇသိင်ႇၵႃႇပူဝ်ႇ" },
            { "shp", "ပွၼ်းသဵင်ႉႁႄးလႄးၼႃႇ" },
            { "sit", "တူဝ်ႇလႃႇ သလူဝ်ႇဝေးၼီးယႃး" },
            { "skk", "ၶူဝ်ႇရူႇၼႃႇသလူဝ်ႇဝႃးၵီးယႃး" },
            { "sle", "လီႇယူၼ်ႇသီႇဢႄႇရႃႇလီႇယူၼ်ႇ" },
            { "sll", "လီႇယူၼ်ႇသီႇဢႄႇရႃႇလီႇယူၼ်ႇ (1964–2022)" },
            { "sos", "သျီႇလိင်ႇသူဝ်ႇမႃးလီးယႃး" },
            { "srd", "တေႃႇလႃသျူးရီးၼႃႇမႄႇ" },
            { "srg", "ၵိလ်တႃႇသျူးရီးၼႃႇမႄႇ" },
            { "ssp", "ပွၼ်းသူႇတၼ်ႇၸၢၼ်း" },
            { "std", "တူဝ်ပရႃႇ သူၼ်ႇတူဝ်ႇမေး လႄႈ ပရိၼ်ႇသီႇပေႇ (1997–2017)" },
            { "stn", "တူဝ်ႇပရႃႇသူၼ်ႇတူဝ်ႇမေး လႄႈ ပရိၼ်ႇသီႇပေႇ" },
            { "sur", "ရူႇပႄႇသူဝ်ႇဝီႇယႅတ်ႉ" },
            { "svc", "ၵူဝ်ႇလူၼ်ႇဢႄႇသႃႇဝႃႇတေႃႇ" },
            { "syp", "ပွၼ်းသီးရီးယႃး" },
            { "szl", "လီႇလႅၼ်ႇၵျႅၼ်ႇၼီႇဢႅတ်ႇသ်ဝႃႇတီးၼီႇ" },
            { "thb", "ဝၢတ်ႇထႆး" },
            { "tjr", "ရူႇပႄႇတႃႇၵျီႇၵီႇသတၼ်ႇ" },
            { "tjs", "သူဝ်ႇမူဝ်ႇၼီႇတႃႇၵျီႇၵီႇသတၼ်ႇ" },
            { "tmm", "မၼတ်ႉတၢၵ်ႈမႅၼ်ႇၼီႇသတၼ်ႇ (1993–2009)" },
            { "tmt", "မၼတ်ႉတၢၵ်ႈမႅၼ်ႇၼီႇသတၼ်ႇ" },
            { "tnd", "တီႇၼႃႇတူႇၼီးသျႃး" },
            { "top", "ပႃဢင်ၵႃႉထွင်းၵႃႇ" },
            { "tpe", "ဢႅတ်ႉၵူႇတူဝ်ႇတီႇမေႃး" },
            { "trl", "လီႇရႃႇတိူဝ်ႇၵီႇ (1922–2005)" },
            { "try", "လီႇရႃႇတိူဝ်ႇၵီႇ" },
            { "ttd", "တေႃႇလႃႇထရီႇၼီႇတၢတ်ႈ လႄႈ ထူဝ်ႇပေးၵူဝ်ႇ" },
            { "twd", "တေႃႇလႃႇထၢႆႇဝၢၼ်းမႂ်ႇ" },
            { "tzs", "သျီႇလိင်ႇထၼ်ႇၸၼ်းၼီးယႃး" },
            { "uah", "ႁရီႇဝၼီႇယႃႇယူႇၶရဵၼ်း" },
            { "uak", "ၶႃႇပူဝ်ႇဝႅၼ်ႇၼႅတ်ႉယူႇၶရဵၼ်း" },
            { "ugs", "သျီႇလိင်ႇယူႇၵၼ်ႇတႃႇ (2966–1987)" },
            { "ugx", "သျီႇလိင်ႇယူႇၵၼ်ႇတႃႇ" },
            { "usd", "တေႃႇလႃႇဢမႄႇရိၵၢၼ်ႇ" },
            { "usn", "တေႃႇလႃႇဢမႄႇရိၵၢၼ်ႇ (ထႅင်ႈဝၼ်းၼိုင်ႈ)" },
            { "uss", "တေႃႇလႃႇဢမႄႇရိၵၢၼ်ႇ (ဝၼ်းလဵဝ်ၵၼ်)" },
            { "uyi", "ပေႇသူဝ်ဢုရုၵူၺ်း(ယူႇၼိတ်ႉဢၼ်ၼႄဝႆႉ)" },
            { "uyp", "ပေႇသူဝ်ႇဢုရုၵူၺ်း (1975–1993)" },
            { "uyu", "ပေႇသူဝ်ဢုရုၵူၺ်း" },
            { "uyw", "ယူႇၼိတ်ႉဢၼ်ၼႄဝႆႉ ငိုၼ်းလိူၼ်ဢုရုၵူၺ်း" },
            { "uzs", "သွမ်ႇဢူႇၸပႄႉၵိတ်ႇသတၼ်ႇ" },
            { "veb", "ပူဝ်ႇလီႇဝႃႇဝႄႇၼေႇၸွႆးလႃး (1871–2008)" },
            { "ved", "ပူဝ်ႇလီႇဝႃႇသူဝ်ႇပႃႇရႃႇၼူဝ်ႇ" },
            { "vef", "Venezuelan Bolívar (2008–2018)" },
            { "ves", "ပူဝ်ႇလီႇဝႃႇဝႄႇၼေႇၸွႆးလႃး" },
            { "vnd", "တွင်ႇဝႅတ်ႉၼမ်း" },
            { "vnn", "တွင်ႇဝႅတ်ႉၼမ်း (1978–1985)" },
            { "vuv", "ဝႃႇထူႇဝႅၼ်ႇၼူးဝႃႇထူႇ" },
            { "wst", "တႃလႃႉသႃႇမူဝ်းဝႃႇ" },
            { "xaf", "ၾရၼ်ႉၸီႇဢႅပ်ႉဢေႇ ဢႃႇၾရိၵ ပွတ်းၵၢင်" },
            { "xag", "ငိုၼ်း" },
            { "xau", "ၶမ်း" },
            { "xba", "ယူႇၼိတ်ႉၶွမ်းပူဝ်းသိတ်ႉယူးရူပ်ႉ" },
            { "xbb", metaValue_xbb },
            { "xbc", "ယူႇၼိတ်ႉဢၶွင်ႉယူးရူပ်ႉ (XBC)" },
            { "xbd", "ယူႇၼိတ်ႉဢၶွင်ႉယူးရူပ်ႉ (XBD)" },
            { "xcd", "တေႃႇလႃႇၶႃႇရိပ်ႈပီႇယၼ်ႇပွတ်းဢွၵ်ႇ" },
            { "xcg", "ၵဵဝ်းတႃႇၶႃႇရိပ်ႈပီႇယၼ်ႇ" },
            { "xdr", "သုၼ်ႇထွၼ်ငိုၼ်းၶိုၵ်ႉတွၼ်း" },
            { "xeu", metaValue_xbb },
            { "xfo", "ၾရၼ်ႉၶမ်းၾရၢင်ႇသဵတ်ႈ" },
            { "xfu", "ၾရၼ်ႉ-UIC ၾရၢင်ႇသဵတ်ႈ" },
            { "xof", "ၾရၼ်ႉ ၸီႇဢႅပ်ႉဢေႇ ဢႃႇၾရိၵ ပွတ်းတူၵ်း" },
            { "xpd", "ပႄႇလတ်ႇတီႇယမ်ႇ" },
            { "xpf", "ၾရၼ်ႉၼိဝ်းၶႄႇလီႇတူဝ်းၼီးယႃး" },
            { "xpt", "ပလတ်ႇတီႇၼမ်ႇ" },
            { "xre", "ငိုၼ်းၵွင်ၵၢင် RINET" },
            { "xsu", "သုၶရေႇ" },
            { "xts", "မၢႆငိုၼ်းတွင်းဢၼ်တိုၵ်ႉၸၢမ်းယူႇ" },
            { "xua", "ယူႇၼိတ်ႉဢၶွင်ႉ ADB" },
            { "xxx", "ငိုၼ်းဢၼ်ဢမ်ႇႁူႉၸိုဝ်ႈ" },
            { "ydd", "တီႇၼႃႇယႄႇမႅၼ်ႇ" },
            { "yer", "ရီဢႄလ်ယႄႇမႅၼ်ႇ" },
            { "yud", "တီႇၼႃႇၶႅင် ယူႇၵူဝ်ႇသလႃးဝီးယႃး(1966–1990)" },
            { "yum", "တီႇၼႃႇမႂ်ႇ ယူႇၵူဝ်ႇသလႃးဝီးယႃး (1994–2002)" },
            { "yun", "တီႇၼႃႇဢၼ်လႅၵ်ႈလႆႈ ယူႇၵူဝ်ႇသလႃးဝီးယႃး (1990–1992)" },
            { "yur", "တီႇၼႃႇဢၼ်ၶိုၼ်းမႄးဝႆႉ ယူႇၵူဝ်ႇသလႃးဝီးယႃး (1992–1993)" },
            { "zal", "ရၼ်းဢႃႇၾရိၵၸၢၼ်း (ၵၢၼ်ငိုၼ်းတွင်း)" },
            { "zar", "ရၼ်းဢႃႇၾရိၵၸၢၼ်း" },
            { "zmk", "ၶႂႃႇၶျႃႇၸမ်းပီးယႃး (1968–2012)" },
            { "zmw", "ၶႂႃႇၶျႃႇၸမ်းပီးယႃး" },
            { "zrn", "ၸၢႆႇရႄႇမႂ်ႇၸၢႆႇရႄႇယႅၼ်ႇ (1993–1998)" },
            { "zrz", "ၸၢႆႇရႄႇၸၢႆႇရႄႇယႅၼ်ႇ (1971–1993)" },
            { "zwd", "တေႃႇလႃႇၸိမ်ႇပႃႇပူၺ်ႇ (1980–2008)" },
            { "zwg", "ၶမ်းၸိမ်ႇပႃႇပူၺ်ႇ" },
            { "zwl", "တေႃႇလႃႇၸိမ်ႇပႃႇပူၺ်ႇ (2009–2024)" },
            { "zwr", "တေႃႇလႃႇၸိမ်ႇပႃႇပူၺ်ႇ (2008)" },
        };
        return data;
    }
}
