/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.AbstractPatternVisitor;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.NameClassSplitter;
import com.thaiopensource.relaxng.output.dtd.AttlistMapper;
import com.thaiopensource.relaxng.output.dtd.AttributeType;
import com.thaiopensource.relaxng.output.dtd.ContentType;
import com.thaiopensource.relaxng.output.dtd.Datatypes;
import com.thaiopensource.relaxng.output.dtd.GrammarPart;
import com.thaiopensource.relaxng.output.dtd.NamespaceManager;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.Naming;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Analysis {
    private final NamespaceManager nsm = new NamespaceManager();
    private final AttlistMapper am = new AttlistMapper();
    private final ErrorReporter er;
    private final Map<Pattern, ContentType> contentTypes = new HashMap<Pattern, ContentType>();
    private final Map<Pattern, AttributeType> attributeTypes = new HashMap<Pattern, AttributeType>();
    private final Map<Pattern, Set<Name>> attributeAlphabets = new HashMap<Pattern, Set<Name>>();
    private final Map<Pattern, Set<String>> attributeNamespaces = new HashMap<Pattern, Set<String>>();
    private Map<String, Pattern> defines = null;
    private final Set<String> attlists = new HashSet<String>();
    private final Map<String, GrammarPart> parts = new HashMap<String, GrammarPart>();
    private final Map<Pattern, Pattern> seenTable = new HashMap<Pattern, Pattern>();
    private final Map<Name, ElementPattern> elementDecls = new HashMap<Name, ElementPattern>();
    private ContentType startType = ContentType.ERROR;
    private GrammarPart mainPart;
    private final SchemaCollection schemas;
    private GrammarPattern grammarPattern;
    private final AttributeTyper attributeTyper = new AttributeTyper();
    private final AttributeAlphabetComputer attributeAlphabetComputer = new AttributeAlphabetComputer();
    private final AttributeNamespacesComputer attributeNamespacesComputer = new AttributeNamespacesComputer();
    private final IncludeContentChecker includeContentChecker = new IncludeContentChecker();
    private static final Set<String> EMPTY_STRING_SET = Collections.emptySet();
    private static final Set<Name> EMPTY_NAME_SET = Collections.emptySet();

    private boolean seen(Pattern pattern) {
        if (this.seenTable.get(pattern) != null) {
            return true;
        }
        this.seenTable.put(pattern, pattern);
        return false;
    }

    Analysis(SchemaCollection schemaCollection, ErrorReporter errorReporter) {
        this.schemas = schemaCollection;
        this.er = errorReporter;
        new Analyzer().analyzeContentType(this.getPattern());
        this.checkAttlists();
        if (!errorReporter.getHadError()) {
            this.nsm.assignPrefixes();
        }
    }

    private void checkAttlists() {
        for (String string : this.attlists) {
            if (this.getParamEntityElementName(string) != null) continue;
            this.er.error("not_attlist", string, this.getBody(string).getSourceLocation());
        }
    }

    Pattern getPattern() {
        return this.schemas.getSchemaDocumentMap().get(this.schemas.getMainUri()).getPattern();
    }

    String getPrefixForNamespaceUri(String string) {
        return this.nsm.getPrefixForNamespaceUri(string);
    }

    String getElementPrefixForNamespaceUri(String string) {
        if (string.equals("") || string.equals(this.nsm.getDefaultNamespaceUri()) || string == NameClass.INHERIT_NS) {
            return null;
        }
        return this.nsm.getPrefixForNamespaceUri(string);
    }

    String getParamEntityElementName(String string) {
        NameNameClass nameNameClass = this.am.getParamEntityElementName(string);
        if (nameNameClass == null) {
            return null;
        }
        String string2 = this.getElementPrefixForNamespaceUri(nameNameClass.getNamespaceUri());
        String string3 = nameNameClass.getLocalName();
        if (string2 == null) {
            return string3;
        }
        return string2 + ":" + string3;
    }

    ContentType getContentType(Pattern pattern) {
        return this.contentTypes.get(pattern);
    }

    AttributeType getAttributeType(Pattern pattern) {
        AttributeType attributeType = this.attributeTypes.get(pattern);
        if (attributeType == null) {
            attributeType = pattern.accept(this.attributeTyper);
            this.attributeTypes.put(pattern, attributeType);
        }
        return attributeType;
    }

    Set<Name> getAttributeAlphabet(Pattern pattern) {
        Set<Name> set = this.attributeAlphabets.get(pattern);
        if (set == null) {
            set = Collections.unmodifiableSet(pattern.accept(this.attributeAlphabetComputer));
            this.attributeAlphabets.put(pattern, set);
        }
        return set;
    }

    Set<String> getAttributeNamespaces(Pattern pattern) {
        Set<String> set = this.attributeNamespaces.get(pattern);
        if (set == null) {
            set = pattern.accept(this.attributeNamespacesComputer);
            this.attributeNamespaces.put(pattern, set);
        }
        return set;
    }

    Pattern getBody(String string) {
        return this.defines.get(string);
    }

    GrammarPattern getGrammarPattern() {
        return this.grammarPattern;
    }

    String getMainUri() {
        return this.schemas.getMainUri();
    }

    GrammarPart getGrammarPart(String string) {
        if (string.equals(this.schemas.getMainUri())) {
            return this.mainPart;
        }
        return this.parts.get(string);
    }

    Pattern getSchema(String string) {
        return this.schemas.getSchemaDocumentMap().get(string).getPattern();
    }

    String getEncoding(String string) {
        return this.schemas.getSchemaDocumentMap().get(string).getEncoding();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeNamespacesComputer
    extends AbstractPatternVisitor<Set<String>> {
        private AttributeNamespacesComputer() {
        }

        @Override
        public Set<String> visitPattern(Pattern pattern) {
            return EMPTY_STRING_SET;
        }

        @Override
        public Set<String> visitMixed(MixedPattern mixedPattern) {
            return Analysis.this.getAttributeNamespaces(mixedPattern.getChild());
        }

        @Override
        public Set<String> visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return Analysis.this.getAttributeNamespaces(oneOrMorePattern.getChild());
        }

        @Override
        public Set<String> visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return Analysis.this.getAttributeNamespaces(zeroOrMorePattern.getChild());
        }

        @Override
        public Set<String> visitOptional(OptionalPattern optionalPattern) {
            return Analysis.this.getAttributeNamespaces(optionalPattern.getChild());
        }

        @Override
        public Set<String> visitComposite(CompositePattern compositePattern) {
            Set<Object> set = EMPTY_STRING_SET;
            boolean bl = false;
            for (Pattern pattern : compositePattern.getChildren()) {
                Set<String> set2 = Analysis.this.getAttributeNamespaces(pattern);
                if (set2 == EMPTY_STRING_SET || set.containsAll(set2)) continue;
                if (set == EMPTY_STRING_SET) {
                    set = set2;
                    continue;
                }
                if (!bl) {
                    set = new HashSet<Object>(set);
                    bl = true;
                }
                set.addAll(set2);
            }
            if (bl) {
                set = Collections.unmodifiableSet(set);
            }
            return set;
        }

        @Override
        public Set<String> visitAttribute(AttributePattern attributePattern) {
            HashSet<String> hashSet = null;
            List<NameNameClass> list = NameClassSplitter.split(attributePattern.getNameClass());
            for (NameNameClass nameNameClass : list) {
                String string = nameNameClass.getNamespaceUri();
                if (string.length() == 0 || string == NameClass.INHERIT_NS || string.equals("http://www.w3.org/XML/1998/namespace")) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(string);
            }
            if (hashSet == null) {
                return EMPTY_STRING_SET;
            }
            return Collections.unmodifiableSet(hashSet);
        }

        @Override
        public Set<String> visitRef(RefPattern refPattern) {
            return Analysis.this.getAttributeNamespaces(Analysis.this.getBody(refPattern.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeAlphabetComputer
    extends AbstractPatternVisitor<Set<Name>> {
        private AttributeAlphabetComputer() {
        }

        @Override
        public Set<Name> visitPattern(Pattern pattern) {
            return EMPTY_NAME_SET;
        }

        @Override
        public Set<Name> visitMixed(MixedPattern mixedPattern) {
            return Analysis.this.getAttributeAlphabet(mixedPattern.getChild());
        }

        @Override
        public Set<Name> visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return Analysis.this.getAttributeAlphabet(oneOrMorePattern.getChild());
        }

        @Override
        public Set<Name> visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return Analysis.this.getAttributeAlphabet(zeroOrMorePattern.getChild());
        }

        @Override
        public Set<Name> visitOptional(OptionalPattern optionalPattern) {
            return Analysis.this.getAttributeAlphabet(optionalPattern.getChild());
        }

        @Override
        public Set<Name> visitComposite(CompositePattern compositePattern) {
            List<Pattern> list = compositePattern.getChildren();
            HashSet<Name> hashSet = new HashSet<Name>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                hashSet.addAll(Analysis.this.getAttributeAlphabet(list.get(i)));
            }
            return hashSet;
        }

        @Override
        public Set<Name> visitAttribute(AttributePattern attributePattern) {
            HashSet<Name> hashSet = new HashSet<Name>();
            List<NameNameClass> list = NameClassSplitter.split(attributePattern.getNameClass());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                NameNameClass nameNameClass = list.get(i);
                String string = nameNameClass.getNamespaceUri();
                if (string == NameClass.INHERIT_NS) {
                    string = "";
                }
                hashSet.add(new Name(string, nameNameClass.getLocalName()));
            }
            return hashSet;
        }

        @Override
        public Set<Name> visitRef(RefPattern refPattern) {
            return Analysis.this.getAttributeAlphabet(Analysis.this.getBody(refPattern.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeTyper
    extends AbstractPatternVisitor<AttributeType> {
        private AttributeTyper() {
        }

        @Override
        public AttributeType visitPattern(Pattern pattern) {
            return AttributeType.EMPTY;
        }

        @Override
        public AttributeType visitMixed(MixedPattern mixedPattern) {
            return Analysis.this.getAttributeType(mixedPattern.getChild());
        }

        @Override
        public AttributeType visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return Analysis.this.getAttributeType(oneOrMorePattern.getChild());
        }

        @Override
        public AttributeType visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return Analysis.this.getAttributeType(zeroOrMorePattern.getChild());
        }

        @Override
        public AttributeType visitOptional(OptionalPattern optionalPattern) {
            return Analysis.this.getAttributeType(optionalPattern.getChild());
        }

        @Override
        public AttributeType visitComposite(CompositePattern compositePattern) {
            List<Pattern> list = compositePattern.getChildren();
            AttributeType attributeType = Analysis.this.getAttributeType(list.get(0));
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                attributeType = AttributeType.group(attributeType, Analysis.this.getAttributeType(list.get(i)));
            }
            return attributeType;
        }

        @Override
        public AttributeType visitAttribute(AttributePattern attributePattern) {
            return AttributeType.SINGLE;
        }

        @Override
        public AttributeType visitEmpty(EmptyPattern emptyPattern) {
            return AttributeType.MULTI;
        }

        @Override
        public AttributeType visitRef(RefPattern refPattern) {
            return Analysis.this.getAttributeType(Analysis.this.getBody(refPattern.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IncludeContentChecker
    implements ComponentVisitor<VoidValue> {
        IncludeContentChecker() {
        }

        public VoidValue visitContainer(Container container) {
            List<Component> list = container.getComponents();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitDefine(DefineComponent defineComponent) {
            Analysis.this.er.error("sorry_include_override", defineComponent.getSourceLocation());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitDiv(DivComponent divComponent) {
            return this.visitContainer(divComponent);
        }

        @Override
        public VoidValue visitInclude(IncludeComponent includeComponent) {
            return VoidValue.VOID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Analyzer
    implements PatternVisitor<ContentType>,
    ComponentVisitor<VoidValue>,
    NameClassVisitor<VoidValue> {
        private ElementPattern ancestorPattern;
        private final Set<String> pendingRefs;

        public Analyzer() {
            this.pendingRefs = new HashSet<String>();
        }

        private Analyzer(ElementPattern elementPattern) {
            this.ancestorPattern = elementPattern;
            this.pendingRefs = new HashSet<String>();
        }

        private Analyzer(Set<String> set) {
            this.pendingRefs = set;
        }

        @Override
        public ContentType visitEmpty(EmptyPattern emptyPattern) {
            return ContentType.EMPTY;
        }

        @Override
        public ContentType visitData(DataPattern dataPattern) {
            return ContentType.SIMPLE_TYPE;
        }

        @Override
        public ContentType visitValue(ValuePattern valuePattern) {
            Datatypes.Info info = Datatypes.getInfo(valuePattern.getDatatypeLibrary(), valuePattern.getType());
            if (info.usesTokenEquality() && Naming.isNmtoken(valuePattern.getValue())) {
                return ContentType.ENUM;
            }
            if (info.usesCdataEquality()) {
                return ContentType.VALUE;
            }
            return ContentType.SIMPLE_TYPE;
        }

        @Override
        public ContentType visitElement(ElementPattern elementPattern) {
            int n;
            if (Analysis.this.seen(elementPattern)) {
                n = NameClassSplitter.split(elementPattern.getNameClass()).size();
            } else {
                new Analyzer(elementPattern).analyzeContentType(elementPattern.getChild());
                List<NameNameClass> list = this.noteNames(elementPattern.getNameClass(), true);
                n = list.size();
                for (int i = 0; i < n; ++i) {
                    NameNameClass nameNameClass = list.get(i);
                    String string = nameNameClass.getNamespaceUri();
                    if (string == NameClass.INHERIT_NS) {
                        string = "";
                    }
                    Name name = new Name(string, nameNameClass.getLocalName());
                    ElementPattern elementPattern2 = (ElementPattern)Analysis.this.elementDecls.get(name);
                    if (elementPattern2 != null) {
                        Analysis.this.er.error("sorry_multiple_element", string, name.getLocalName(), elementPattern.getSourceLocation());
                        Analysis.this.er.error("other_element", elementPattern2.getSourceLocation());
                        continue;
                    }
                    Analysis.this.elementDecls.put(name, elementPattern);
                }
            }
            return n == 1 ? ContentType.DIRECT_SINGLE_ELEMENT : ContentType.ELEMENT_CLASS;
        }

        @Override
        public ContentType visitAttribute(AttributePattern attributePattern) {
            this.noteNames(attributePattern.getNameClass(), false);
            ContentType contentType = this.analyzeContentType(attributePattern.getChild());
            if (contentType.isA(ContentType.MODEL_GROUP) || contentType == ContentType.MIXED_ELEMENT_CLASS || contentType == ContentType.MIXED_MODEL) {
                Analysis.this.er.error("bad_attribute_type", attributePattern.getSourceLocation());
            }
            if (this.ancestorPattern != null) {
                Analysis.this.am.noteAttribute(this.ancestorPattern);
            }
            return ContentType.EMPTY;
        }

        private List<NameNameClass> noteNames(NameClass nameClass, boolean bl) {
            nameClass.accept(this);
            List<NameNameClass> list = NameClassSplitter.split(nameClass);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Analysis.this.nsm.noteName(list.get(i), bl);
            }
            return list;
        }

        @Override
        public ContentType visitNotAllowed(NotAllowedPattern notAllowedPattern) {
            return ContentType.NOT_ALLOWED;
        }

        @Override
        public ContentType visitText(TextPattern textPattern) {
            return ContentType.TEXT;
        }

        @Override
        public ContentType visitList(ListPattern listPattern) {
            return ContentType.SIMPLE_TYPE;
        }

        @Override
        public ContentType visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return this.checkContentType("sorry_one_or_more", ContentType.oneOrMore(this.analyzeContentTypeNullAncestorPattern(oneOrMorePattern.getChild())), oneOrMorePattern);
        }

        @Override
        public ContentType visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return this.checkContentType("sorry_zero_or_more", ContentType.zeroOrMore(this.analyzeContentTypeNullAncestorPattern(zeroOrMorePattern.getChild())), zeroOrMorePattern);
        }

        @Override
        public ContentType visitChoice(ChoicePattern choicePattern) {
            List<Pattern> list = choicePattern.getChildren();
            Iterator<Pattern> iterator = list.iterator();
            ContentType contentType = this.analyzeContentType(iterator.next());
            while (iterator.hasNext()) {
                contentType = this.checkContentType("sorry_choice", ContentType.choice(contentType, this.analyzeContentType(iterator.next())), choicePattern);
            }
            if (Analysis.this.getAttributeType(choicePattern) == AttributeType.MULTI) {
                HashSet<Name> hashSet = new HashSet<Name>();
                for (Pattern pattern : list) {
                    Set<Name> set = Analysis.this.getAttributeAlphabet(pattern);
                    for (Name name : set) {
                        if (hashSet.contains(name)) {
                            Analysis.this.er.error("sorry_choice_attribute_name", name.getNamespaceUri(), name.getLocalName(), choicePattern.getSourceLocation());
                            continue;
                        }
                        hashSet.add(name);
                    }
                }
            }
            return contentType;
        }

        @Override
        public ContentType visitInterleave(InterleavePattern interleavePattern) {
            List<Pattern> list = interleavePattern.getChildren();
            ContentType contentType = this.analyzeContentType(list.get(0));
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                contentType = this.checkContentType("sorry_interleave", ContentType.interleave(contentType, this.analyzeContentType(list.get(i))), interleavePattern);
            }
            return contentType;
        }

        @Override
        public ContentType visitGroup(GroupPattern groupPattern) {
            List<Pattern> list = groupPattern.getChildren();
            ContentType contentType = this.analyzeContentType(list.get(0));
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                contentType = this.checkContentType("sorry_group", ContentType.group(contentType, this.analyzeContentType(list.get(i))), groupPattern);
            }
            return contentType;
        }

        @Override
        public ContentType visitRef(RefPattern refPattern) {
            String string = refPattern.getName();
            Pattern pattern = Analysis.this.getBody(string);
            if (pattern == null) {
                Analysis.this.er.error("undefined_ref", refPattern.getSourceLocation());
                return ContentType.ERROR;
            }
            if (this.pendingRefs.contains(string)) {
                Analysis.this.er.error("ref_loop", refPattern.getSourceLocation());
                return ContentType.ERROR;
            }
            this.pendingRefs.add(string);
            ContentType contentType = ContentType.ref(new Analyzer(this.pendingRefs).analyzeContentType(pattern));
            this.pendingRefs.remove(string);
            if (contentType.isA(ContentType.EMPTY)) {
                Analysis.this.am.noteAttributeGroupRef(this.ancestorPattern, refPattern.getName());
            }
            return ContentType.ref(contentType);
        }

        @Override
        public ContentType visitParentRef(ParentRefPattern parentRefPattern) {
            Analysis.this.er.error("sorry_parent_ref", parentRefPattern.getSourceLocation());
            return null;
        }

        @Override
        public ContentType visitGrammar(GrammarPattern grammarPattern) {
            if (Analysis.this.defines != null) {
                Analysis.this.er.error("sorry_nested_grammar", grammarPattern.getSourceLocation());
                return ContentType.ERROR;
            }
            Analysis.this.defines = new HashMap();
            try {
                Analysis.this.mainPart = new GrammarPart(Analysis.this.er, Analysis.this.defines, Analysis.this.attlists, Analysis.this.schemas, Analysis.this.parts, grammarPattern);
            }
            catch (GrammarPart.IncludeLoopException includeLoopException) {
                Analysis.this.er.error("include_loop", includeLoopException.getInclude().getSourceLocation());
                return ContentType.ERROR;
            }
            Analysis.this.grammarPattern = grammarPattern;
            this.visitContainer(grammarPattern);
            return Analysis.this.startType;
        }

        @Override
        public ContentType visitExternalRef(ExternalRefPattern externalRefPattern) {
            Analysis.this.er.error("sorry_external_ref", externalRefPattern.getSourceLocation());
            return null;
        }

        @Override
        public ContentType visitMixed(MixedPattern mixedPattern) {
            return this.checkContentType("sorry_mixed", ContentType.mixed(this.analyzeContentType(mixedPattern.getChild())), mixedPattern);
        }

        @Override
        public ContentType visitOptional(OptionalPattern optionalPattern) {
            return this.checkContentType("sorry_optional", ContentType.optional(this.analyzeContentTypeNullAncestorPattern(optionalPattern.getChild())), optionalPattern);
        }

        public VoidValue visitContainer(Container container) {
            List<Component> list = container.getComponents();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitDiv(DivComponent divComponent) {
            return this.visitContainer(divComponent);
        }

        @Override
        public VoidValue visitDefine(DefineComponent defineComponent) {
            if (defineComponent.getName() == DefineComponent.START) {
                Analysis.this.startType = this.analyzeContentType(defineComponent.getBody());
            } else {
                new Analyzer().analyzeContentType(defineComponent.getBody());
            }
            if (Analysis.this.attlists.contains(defineComponent.getName()) && Analysis.this.getContentType(defineComponent.getBody()) != ContentType.EMPTY) {
                Analysis.this.er.error("not_attlist", defineComponent.getName(), defineComponent.getSourceLocation());
                Analysis.this.attlists.remove(defineComponent.getName());
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInclude(IncludeComponent includeComponent) {
            Analysis.this.includeContentChecker.visitContainer(includeComponent);
            this.visitContainer((GrammarPattern)Analysis.this.schemas.getSchemaDocumentMap().get(includeComponent.getUri()).getPattern());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitChoice(ChoiceNameClass choiceNameClass) {
            List<NameClass> list = choiceNameClass.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitAnyName(AnyNameNameClass anyNameNameClass) {
            Analysis.this.er.error("sorry_wildcard", anyNameNameClass.getSourceLocation());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitNsName(NsNameNameClass nsNameNameClass) {
            Analysis.this.er.error("sorry_wildcard", nsNameNameClass.getSourceLocation());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitName(NameNameClass nameNameClass) {
            Analysis.this.nsm.noteName(nameNameClass, true);
            return VoidValue.VOID;
        }

        ContentType checkContentType(String string, ContentType contentType, Pattern pattern) {
            if (contentType != null) {
                return contentType;
            }
            Analysis.this.er.error(string, pattern.getSourceLocation());
            return ContentType.ERROR;
        }

        ContentType analyzeContentType(Pattern pattern) {
            ContentType contentType = (ContentType)Analysis.this.contentTypes.get(pattern);
            if (contentType == null) {
                contentType = pattern.accept(this);
                Analysis.this.contentTypes.put(pattern, contentType);
            }
            return contentType;
        }

        ContentType analyzeContentTypeNullAncestorPattern(Pattern pattern) {
            return (this.ancestorPattern == null ? this : new Analyzer(this.pendingRefs)).analyzeContentType(pattern);
        }
    }
}

