// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetObject`](crate::operation::get_object::builders::GetObjectFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name containing the object.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must follow the format <code> <i>bucket-base-name</i>--<i>zone-id</i>--x-s3</code> (for example, <code> <i>amzn-s3-demo-bucket</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point for general purpose buckets, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When you use this action with an access point for directory buckets, you must provide the access point name in place of the bucket name. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Object Lambda access points</b> - When you use this action with an Object Lambda access point, you must direct requests to the Object Lambda access point hostname. The Object Lambda access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p><note>  <p>Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts, the destination bucket must be the Outposts access point ARN or the access point alias. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`if_match(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::if_match) / [`set_if_match(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_if_match):<br>required: **false**<br><p>Return the object only if its entity tag (ETag) is the same as the one specified in this header; otherwise, return a <code>412 Precondition Failed</code> error.</p> <p>If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows: <code>If-Match</code> condition evaluates to <code>true</code>, and; <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>; then, S3 returns <code>200 OK</code> and the data requested.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`if_modified_since(DateTime)`](crate::operation::get_object::builders::GetObjectFluentBuilder::if_modified_since) / [`set_if_modified_since(Option<DateTime>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_if_modified_since):<br>required: **false**<br><p>Return the object only if it has been modified since the specified time; otherwise, return a <code>304 Not Modified</code> error.</p> <p>If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:<code> If-None-Match</code> condition evaluates to <code>false</code>, and; <code>If-Modified-Since</code> condition evaluates to <code>true</code>; then, S3 returns <code>304 Not Modified</code> status code.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`if_none_match(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::if_none_match) / [`set_if_none_match(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_if_none_match):<br>required: **false**<br><p>Return the object only if its entity tag (ETag) is different from the one specified in this header; otherwise, return a <code>304 Not Modified</code> error.</p> <p>If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:<code> If-None-Match</code> condition evaluates to <code>false</code>, and; <code>If-Modified-Since</code> condition evaluates to <code>true</code>; then, S3 returns <code>304 Not Modified</code> HTTP status code.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`if_unmodified_since(DateTime)`](crate::operation::get_object::builders::GetObjectFluentBuilder::if_unmodified_since) / [`set_if_unmodified_since(Option<DateTime>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_if_unmodified_since):<br>required: **false**<br><p>Return the object only if it has not been modified since the specified time; otherwise, return a <code>412 Precondition Failed</code> error.</p> <p>If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows: <code>If-Match</code> condition evaluates to <code>true</code>, and; <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>; then, S3 returns <code>200 OK</code> and the data requested.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_key):<br>required: **true**<br><p>Key of the object to get.</p><br>
    ///   - [`range(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::range) / [`set_range(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_range):<br>required: **false**<br><p>Downloads the specified byte range of an object. For more information about the HTTP Range header, see <a href="https://www.rfc-editor.org/rfc/rfc9110.html#name-range">https://www.rfc-editor.org/rfc/rfc9110.html#name-range</a>.</p><note>  <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p> </note><br>
    ///   - [`response_cache_control(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::response_cache_control) / [`set_response_cache_control(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_response_cache_control):<br>required: **false**<br><p>Sets the <code>Cache-Control</code> header of the response.</p><br>
    ///   - [`response_content_disposition(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::response_content_disposition) / [`set_response_content_disposition(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_response_content_disposition):<br>required: **false**<br><p>Sets the <code>Content-Disposition</code> header of the response.</p><br>
    ///   - [`response_content_encoding(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::response_content_encoding) / [`set_response_content_encoding(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_response_content_encoding):<br>required: **false**<br><p>Sets the <code>Content-Encoding</code> header of the response.</p><br>
    ///   - [`response_content_language(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::response_content_language) / [`set_response_content_language(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_response_content_language):<br>required: **false**<br><p>Sets the <code>Content-Language</code> header of the response.</p><br>
    ///   - [`response_content_type(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::response_content_type) / [`set_response_content_type(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_response_content_type):<br>required: **false**<br><p>Sets the <code>Content-Type</code> header of the response.</p><br>
    ///   - [`response_expires(DateTime)`](crate::operation::get_object::builders::GetObjectFluentBuilder::response_expires) / [`set_response_expires(Option<DateTime>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_response_expires):<br>required: **false**<br><p>Sets the <code>Expires</code> header of the response.</p><br>
    ///   - [`version_id(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::version_id) / [`set_version_id(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_version_id):<br>required: **false**<br><p>Version ID used to reference a specific version of the object.</p> <p>By default, the <code>GetObject</code> operation returns the current version of an object. To return a different version, use the <code>versionId</code> subresource.</p><note>  <ul>   <li>    <p>If you include a <code>versionId</code> in your request header, you must have the <code>s3:GetObjectVersion</code> permission to access a specific version of an object. The <code>s3:GetObject</code> permission is not required in this scenario.</p></li>   <li>    <p>If you request the current version of an object without a specific <code>versionId</code> in the request header, only the <code>s3:GetObject</code> permission is required. The <code>s3:GetObjectVersion</code> permission is not required in this scenario.</p></li>   <li>    <p><b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets. For this API operation, only the <code>null</code> value of the version ID is supported by directory buckets. You can only specify <code>null</code> to the <code>versionId</code> query parameter in the request.</p></li>  </ul> </note> <p>For more information about versioning, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html">PutBucketVersioning</a>.</p><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when decrypting the object (for example, <code>AES256</code>).</p> <p>If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:</p> <ul>  <li>   <p><code>x-amz-server-side-encryption-customer-algorithm</code></p></li>  <li>   <p><code>x-amz-server-side-encryption-customer-key</code></p></li>  <li>   <p><code>x-amz-server-side-encryption-customer-key-MD5</code></p></li> </ul> <p>For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key that you originally provided for Amazon S3 to encrypt the data before storing it. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p> <p>If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:</p> <ul>  <li>   <p><code>x-amz-server-side-encryption-customer-algorithm</code></p></li>  <li>   <p><code>x-amz-server-side-encryption-customer-key</code></p></li>  <li>   <p><code>x-amz-server-side-encryption-customer-key-MD5</code></p></li> </ul> <p>For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p> <p>If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:</p> <ul>  <li>   <p><code>x-amz-server-side-encryption-customer-algorithm</code></p></li>  <li>   <p><code>x-amz-server-side-encryption-customer-key</code></p></li>  <li>   <p><code>x-amz-server-side-encryption-customer-key-MD5</code></p></li> </ul> <p>For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::get_object::builders::GetObjectFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`part_number(i32)`](crate::operation::get_object::builders::GetObjectFluentBuilder::part_number) / [`set_part_number(Option<i32>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_part_number):<br>required: **false**<br><p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`checksum_mode(ChecksumMode)`](crate::operation::get_object::builders::GetObjectFluentBuilder::checksum_mode) / [`set_checksum_mode(Option<ChecksumMode>)`](crate::operation::get_object::builders::GetObjectFluentBuilder::set_checksum_mode):<br>required: **false**<br><p>To retrieve the checksum, this mode must be enabled.</p><br>
    /// - On success, responds with [`GetObjectOutput`](crate::operation::get_object::GetObjectOutput) with field(s):
    ///   - [`body(ByteStream)`](crate::operation::get_object::GetObjectOutput::body): <p>Object data.</p>
    ///   - [`delete_marker(Option<bool>)`](crate::operation::get_object::GetObjectOutput::delete_marker): <p>Indicates whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.</p><note>  <ul>   <li>    <p>If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and includes <code>x-amz-delete-marker: true</code> in the response.</p></li>   <li>    <p>If the specified version in the request is a delete marker, the response returns a <code>405 Method Not Allowed</code> error and the <code>Last-Modified: timestamp</code> response header.</p></li>  </ul> </note>
    ///   - [`accept_ranges(Option<String>)`](crate::operation::get_object::GetObjectOutput::accept_ranges): <p>Indicates that a range of bytes was specified in the request.</p>
    ///   - [`expiration(Option<String>)`](crate::operation::get_object::GetObjectOutput::expiration): <p>If the object expiration is configured (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html"> <code>PutBucketLifecycleConfiguration</code> </a>), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs providing object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p><note>  <p>Object expiration information is not returned in directory buckets and this header returns the value "<code>NotImplemented</code>" in all responses for directory buckets.</p> </note>
    ///   - [`restore(Option<String>)`](crate::operation::get_object::GetObjectOutput::restore): <p>Provides information about object restoration action and expiration time of the restored object copy.</p><note>  <p>This functionality is not supported for directory buckets. Directory buckets only support <code>EXPRESS_ONEZONE</code> (the S3 Express One Zone storage class) in Availability Zones and <code>ONEZONE_IA</code> (the S3 One Zone-Infrequent Access storage class) in Dedicated Local Zones.</p> </note>
    ///   - [`last_modified(Option<DateTime>)`](crate::operation::get_object::GetObjectOutput::last_modified): <p>Date and time when the object was last modified.</p> <p><b>General purpose buckets </b> - When you specify a <code>versionId</code> of the object in your request, if the specified version in the request is a delete marker, the response returns a <code>405 Method Not Allowed</code> error and the <code>Last-Modified: timestamp</code> response header.</p>
    ///   - [`content_length(Option<i64>)`](crate::operation::get_object::GetObjectOutput::content_length): <p>Size of the body in bytes.</p>
    ///   - [`e_tag(Option<String>)`](crate::operation::get_object::GetObjectOutput::e_tag): <p>An entity tag (ETag) is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    ///   - [`checksum_crc32(Option<String>)`](crate::operation::get_object::GetObjectOutput::checksum_crc32): <p>The Base64 encoded, 32-bit <code>CRC32</code> checksum of the object. This checksum is only present if the object was uploaded with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_crc32_c(Option<String>)`](crate::operation::get_object::GetObjectOutput::checksum_crc32_c): <p>The Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object. This will only be present if the object was uploaded with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_crc64_nvme(Option<String>)`](crate::operation::get_object::GetObjectOutput::checksum_crc64_nvme): <p>The Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity in the Amazon S3 User Guide</a>.</p>
    ///   - [`checksum_sha1(Option<String>)`](crate::operation::get_object::GetObjectOutput::checksum_sha1): <p>The Base64 encoded, 160-bit <code>SHA1</code> digest of the object. This will only be present if the object was uploaded with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_sha256(Option<String>)`](crate::operation::get_object::GetObjectOutput::checksum_sha256): <p>The Base64 encoded, 256-bit <code>SHA256</code> digest of the object. This will only be present if the object was uploaded with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_type(Option<ChecksumType>)`](crate::operation::get_object::GetObjectOutput::checksum_type): <p>The checksum type, which determines how part-level checksums are combined to create an object-level checksum for multipart objects. You can use this header response to verify that the checksum type that is received is the same checksum type that was specified in the <code>CreateMultipartUpload</code> request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`missing_meta(Option<i32>)`](crate::operation::get_object::GetObjectOutput::missing_meta): <p>This is set to the number of metadata entries not returned in the headers that are prefixed with <code>x-amz-meta-</code>. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`version_id(Option<String>)`](crate::operation::get_object::GetObjectOutput::version_id): <p>Version ID of the object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`cache_control(Option<String>)`](crate::operation::get_object::GetObjectOutput::cache_control): <p>Specifies caching behavior along the request/reply chain.</p>
    ///   - [`content_disposition(Option<String>)`](crate::operation::get_object::GetObjectOutput::content_disposition): <p>Specifies presentational information for the object.</p>
    ///   - [`content_encoding(Option<String>)`](crate::operation::get_object::GetObjectOutput::content_encoding): <p>Indicates what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    ///   - [`content_language(Option<String>)`](crate::operation::get_object::GetObjectOutput::content_language): <p>The language the content is in.</p>
    ///   - [`content_range(Option<String>)`](crate::operation::get_object::GetObjectOutput::content_range): <p>The portion of the object returned in the response.</p>
    ///   - [`content_type(Option<String>)`](crate::operation::get_object::GetObjectOutput::content_type): <p>A standard MIME type describing the format of the object data.</p>
    ///   - [`website_redirect_location(Option<String>)`](crate::operation::get_object::GetObjectOutput::website_redirect_location): <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::get_object::GetObjectOutput::server_side_encryption): <p>The server-side encryption algorithm used when you store this object in Amazon S3 or Amazon FSx.</p><note>  <p>When accessing data stored in Amazon FSx file systems using S3 access points, the only valid server side encryption option is <code>aws:fsx</code>.</p> </note>
    ///   - [`metadata(Option<HashMap::<String, String>>)`](crate::operation::get_object::GetObjectOutput::metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::operation::get_object::GetObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::operation::get_object::GetObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_key_id(Option<String>)`](crate::operation::get_object::GetObjectOutput::ssekms_key_id): <p>If present, indicates the ID of the KMS key that was used for object encryption.</p>
    ///   - [`bucket_key_enabled(Option<bool>)`](crate::operation::get_object::GetObjectOutput::bucket_key_enabled): <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).</p>
    ///   - [`storage_class(Option<StorageClass>)`](crate::operation::get_object::GetObjectOutput::storage_class): <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p><note>  <p><b>Directory buckets </b> - Directory buckets only support <code>EXPRESS_ONEZONE</code> (the S3 Express One Zone storage class) in Availability Zones and <code>ONEZONE_IA</code> (the S3 One Zone-Infrequent Access storage class) in Dedicated Local Zones.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::get_object::GetObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html">Using Requester Pays buckets for storage transfers and usage</a> in the <i>Amazon Simple Storage Service user guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`replication_status(Option<ReplicationStatus>)`](crate::operation::get_object::GetObjectOutput::replication_status): <p>Amazon S3 can return this if your request involves a bucket that is either a source or destination in a replication rule.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`parts_count(Option<i32>)`](crate::operation::get_object::GetObjectOutput::parts_count): <p>The count of parts this object has. This value is only returned if you specify <code>partNumber</code> in your request and the object was uploaded as a multipart upload.</p>
    ///   - [`tag_count(Option<i32>)`](crate::operation::get_object::GetObjectOutput::tag_count): <p>The number of tags, if any, on the object, when you have the relevant permission to read object tags.</p> <p>You can use <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html">GetObjectTagging</a> to retrieve the tag set associated with an object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`object_lock_mode(Option<ObjectLockMode>)`](crate::operation::get_object::GetObjectOutput::object_lock_mode): <p>The Object Lock mode that's currently in place for this object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`object_lock_retain_until_date(Option<DateTime>)`](crate::operation::get_object::GetObjectOutput::object_lock_retain_until_date): <p>The date and time when this object's Object Lock will expire.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::operation::get_object::GetObjectOutput::object_lock_legal_hold_status): <p>Indicates whether this object has an active legal hold. This field is only returned if you have permission to view an object's legal hold status.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`expires(Option<DateTime>)`](crate::operation::get_object::GetObjectOutput::expires): <p>The date and time at which the object is no longer cacheable.</p>
    ///   - [`expires_string(Option<String>)`](crate::operation::get_object::GetObjectOutput::expires_string): <p>The date and time at which the object is no longer cacheable.</p>
    /// - On failure, responds with [`SdkError<GetObjectError>`](crate::operation::get_object::GetObjectError)
    pub fn get_object(&self) -> crate::operation::get_object::builders::GetObjectFluentBuilder {
        crate::operation::get_object::builders::GetObjectFluentBuilder::new(self.handle.clone())
    }
}
