// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>After you call <code>SubscribeToShard</code>, Kinesis Data Streams sends events of this type over an HTTP/2 connection to your consumer.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct SubscribeToShardEvent {
    /// <p></p>
    pub records: ::std::vec::Vec<crate::types::Record>,
    /// <p>Use this as <code>SequenceNumber</code> in the next call to <code>SubscribeToShard</code>, with <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. Use <code>ContinuationSequenceNumber</code> for checkpointing because it captures your shard progress even when no data is written to the shard.</p>
    pub continuation_sequence_number: ::std::string::String,
    /// <p>The number of milliseconds the read records are from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.</p>
    pub millis_behind_latest: i64,
    /// <p>The list of the child shards of the current shard, returned only at the end of the current shard.</p>
    pub child_shards: ::std::option::Option<::std::vec::Vec<crate::types::ChildShard>>,
}
impl SubscribeToShardEvent {
    /// <p></p>
    pub fn records(&self) -> &[crate::types::Record] {
        use std::ops::Deref;
        self.records.deref()
    }
    /// <p>Use this as <code>SequenceNumber</code> in the next call to <code>SubscribeToShard</code>, with <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. Use <code>ContinuationSequenceNumber</code> for checkpointing because it captures your shard progress even when no data is written to the shard.</p>
    pub fn continuation_sequence_number(&self) -> &str {
        use std::ops::Deref;
        self.continuation_sequence_number.deref()
    }
    /// <p>The number of milliseconds the read records are from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.</p>
    pub fn millis_behind_latest(&self) -> i64 {
        self.millis_behind_latest
    }
    /// <p>The list of the child shards of the current shard, returned only at the end of the current shard.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.child_shards.is_none()`.
    pub fn child_shards(&self) -> &[crate::types::ChildShard] {
        self.child_shards.as_deref().unwrap_or_default()
    }
}
impl SubscribeToShardEvent {
    /// Creates a new builder-style object to manufacture [`SubscribeToShardEvent`](crate::types::SubscribeToShardEvent).
    pub fn builder() -> crate::types::builders::SubscribeToShardEventBuilder {
        crate::types::builders::SubscribeToShardEventBuilder::default()
    }
}

/// A builder for [`SubscribeToShardEvent`](crate::types::SubscribeToShardEvent).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SubscribeToShardEventBuilder {
    pub(crate) records: ::std::option::Option<::std::vec::Vec<crate::types::Record>>,
    pub(crate) continuation_sequence_number: ::std::option::Option<::std::string::String>,
    pub(crate) millis_behind_latest: ::std::option::Option<i64>,
    pub(crate) child_shards: ::std::option::Option<::std::vec::Vec<crate::types::ChildShard>>,
}
impl SubscribeToShardEventBuilder {
    /// Appends an item to `records`.
    ///
    /// To override the contents of this collection use [`set_records`](Self::set_records).
    ///
    /// <p></p>
    pub fn records(mut self, input: crate::types::Record) -> Self {
        let mut v = self.records.unwrap_or_default();
        v.push(input);
        self.records = ::std::option::Option::Some(v);
        self
    }
    /// <p></p>
    pub fn set_records(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Record>>) -> Self {
        self.records = input;
        self
    }
    /// <p></p>
    pub fn get_records(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Record>> {
        &self.records
    }
    /// <p>Use this as <code>SequenceNumber</code> in the next call to <code>SubscribeToShard</code>, with <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. Use <code>ContinuationSequenceNumber</code> for checkpointing because it captures your shard progress even when no data is written to the shard.</p>
    /// This field is required.
    pub fn continuation_sequence_number(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.continuation_sequence_number = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Use this as <code>SequenceNumber</code> in the next call to <code>SubscribeToShard</code>, with <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. Use <code>ContinuationSequenceNumber</code> for checkpointing because it captures your shard progress even when no data is written to the shard.</p>
    pub fn set_continuation_sequence_number(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.continuation_sequence_number = input;
        self
    }
    /// <p>Use this as <code>SequenceNumber</code> in the next call to <code>SubscribeToShard</code>, with <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. Use <code>ContinuationSequenceNumber</code> for checkpointing because it captures your shard progress even when no data is written to the shard.</p>
    pub fn get_continuation_sequence_number(&self) -> &::std::option::Option<::std::string::String> {
        &self.continuation_sequence_number
    }
    /// <p>The number of milliseconds the read records are from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.</p>
    /// This field is required.
    pub fn millis_behind_latest(mut self, input: i64) -> Self {
        self.millis_behind_latest = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of milliseconds the read records are from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.</p>
    pub fn set_millis_behind_latest(mut self, input: ::std::option::Option<i64>) -> Self {
        self.millis_behind_latest = input;
        self
    }
    /// <p>The number of milliseconds the read records are from the tip of the stream, indicating how far behind current time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records to process at this moment.</p>
    pub fn get_millis_behind_latest(&self) -> &::std::option::Option<i64> {
        &self.millis_behind_latest
    }
    /// Appends an item to `child_shards`.
    ///
    /// To override the contents of this collection use [`set_child_shards`](Self::set_child_shards).
    ///
    /// <p>The list of the child shards of the current shard, returned only at the end of the current shard.</p>
    pub fn child_shards(mut self, input: crate::types::ChildShard) -> Self {
        let mut v = self.child_shards.unwrap_or_default();
        v.push(input);
        self.child_shards = ::std::option::Option::Some(v);
        self
    }
    /// <p>The list of the child shards of the current shard, returned only at the end of the current shard.</p>
    pub fn set_child_shards(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::ChildShard>>) -> Self {
        self.child_shards = input;
        self
    }
    /// <p>The list of the child shards of the current shard, returned only at the end of the current shard.</p>
    pub fn get_child_shards(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ChildShard>> {
        &self.child_shards
    }
    /// Consumes the builder and constructs a [`SubscribeToShardEvent`](crate::types::SubscribeToShardEvent).
    /// This method will fail if any of the following fields are not set:
    /// - [`records`](crate::types::builders::SubscribeToShardEventBuilder::records)
    /// - [`continuation_sequence_number`](crate::types::builders::SubscribeToShardEventBuilder::continuation_sequence_number)
    /// - [`millis_behind_latest`](crate::types::builders::SubscribeToShardEventBuilder::millis_behind_latest)
    pub fn build(self) -> ::std::result::Result<crate::types::SubscribeToShardEvent, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::SubscribeToShardEvent {
            records: self.records.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "records",
                    "records was not specified but it is required when building SubscribeToShardEvent",
                )
            })?,
            continuation_sequence_number: self.continuation_sequence_number.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "continuation_sequence_number",
                    "continuation_sequence_number was not specified but it is required when building SubscribeToShardEvent",
                )
            })?,
            millis_behind_latest: self.millis_behind_latest.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "millis_behind_latest",
                    "millis_behind_latest was not specified but it is required when building SubscribeToShardEvent",
                )
            })?,
            child_shards: self.child_shards,
        })
    }
}
