// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Orchestration and serialization glue logic for `GetObject`.
#[derive(::std::clone::Clone, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetObject;
impl GetObject {
    /// Creates a new `GetObject`
    pub fn new() -> Self {
        Self
    }
    pub(crate) async fn orchestrate(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::get_object::GetObjectInput,
    ) -> ::std::result::Result<
        crate::operation::get_object::GetObjectOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_object::GetObjectError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let map_err = |err: ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >| {
            err.map_service_error(|err| {
                err.downcast::<crate::operation::get_object::GetObjectError>()
                    .expect("correct error type")
            })
        };
        let context = Self::orchestrate_with_stop_point(runtime_plugins, input, ::aws_smithy_runtime::client::orchestrator::StopPoint::None)
            .await
            .map_err(map_err)?;
        let output = context.finalize().map_err(map_err)?;
        ::std::result::Result::Ok(
            output
                .downcast::<crate::operation::get_object::GetObjectOutput>()
                .expect("correct output type"),
        )
    }

    pub(crate) async fn orchestrate_with_stop_point(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::get_object::GetObjectInput,
        stop_point: ::aws_smithy_runtime::client::orchestrator::StopPoint,
    ) -> ::std::result::Result<
        ::aws_smithy_runtime_api::client::interceptors::context::InterceptorContext,
        ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = ::aws_smithy_runtime_api::client::interceptors::context::Input::erase(input);
        ::aws_smithy_runtime::client::orchestrator::invoke_with_stop_point("s3", "GetObject", input, runtime_plugins, stop_point).await
    }

    pub(crate) fn operation_runtime_plugins(
        client_runtime_plugins: ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        client_config: &crate::config::Config,
        config_override: ::std::option::Option<crate::config::Builder>,
    ) -> ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins {
        let mut runtime_plugins = client_runtime_plugins.with_operation_plugin(Self::new());
        runtime_plugins = runtime_plugins.with_client_plugin(crate::auth_plugin::DefaultAuthOptionsPlugin::new(vec![
            ::aws_runtime::auth::sigv4::SCHEME_ID,
            #[cfg(feature = "sigv4a")]
            {
                ::aws_runtime::auth::sigv4a::SCHEME_ID
            },
            crate::s3_express::auth::SCHEME_ID,
            ::aws_smithy_runtime::client::auth::no_auth::NO_AUTH_SCHEME_ID,
        ]));
        if let ::std::option::Option::Some(config_override) = config_override {
            for plugin in config_override.runtime_plugins.iter().cloned() {
                runtime_plugins = runtime_plugins.with_operation_plugin(plugin);
            }
            runtime_plugins = runtime_plugins.with_operation_plugin(crate::config::ConfigOverrideRuntimePlugin::new(
                config_override,
                client_config.config.clone(),
                &client_config.runtime_components,
            ));
        }
        runtime_plugins
    }
}
impl ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugin for GetObject {
    fn config(&self) -> ::std::option::Option<::aws_smithy_types::config_bag::FrozenLayer> {
        let mut cfg = ::aws_smithy_types::config_bag::Layer::new("GetObject");

        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedRequestSerializer::new(
            GetObjectRequestSerializer,
        ));
        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedResponseDeserializer::new(
            GetObjectResponseDeserializer,
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::auth::AuthSchemeOptionResolverParams::new(
            ::aws_smithy_runtime_api::client::auth::static_resolver::StaticAuthSchemeOptionResolverParams::new(),
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::orchestrator::SensitiveOutput);
        cfg.store_put(::aws_smithy_runtime_api::client::orchestrator::Metadata::new("GetObject", "s3"));
        let mut signing_options = ::aws_runtime::auth::SigningOptions::default();
        signing_options.double_uri_encode = false;
        signing_options.content_sha256_header = true;
        signing_options.normalize_uri_path = false;
        signing_options.payload_override = None;

        cfg.store_put(::aws_runtime::auth::SigV4OperationSigningConfig {
            signing_options,
            ..::std::default::Default::default()
        });

        ::std::option::Option::Some(cfg.freeze())
    }

    fn runtime_components(
        &self,
        _: &::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder,
    ) -> ::std::borrow::Cow<'_, ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder> {
        #[allow(unused_mut)]
        let mut rcb = ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder::new("GetObject")
            .with_interceptor(::aws_smithy_runtime::client::stalled_stream_protection::StalledStreamProtectionInterceptor::default())
            .with_interceptor(GetObjectEndpointParamsInterceptor)
            .with_interceptor(crate::s3_expires_interceptor::S3ExpiresInterceptor)
            .with_interceptor(crate::http_response_checksum::ResponseChecksumInterceptor::new(
                ["crc64nvme", "crc32", "crc32c", "sha256", "sha1"].as_slice(),
                |input: &::aws_smithy_runtime_api::client::interceptors::context::Input| {
                    let input: &crate::operation::get_object::GetObjectInput = input.downcast_ref().expect("correct type");
                    matches!(input.checksum_mode(), ::std::option::Option::Some(crate::types::ChecksumMode::Enabled))
                },
                |input: &mut ::aws_smithy_runtime_api::client::interceptors::context::Input, cfg: &::aws_smithy_types::config_bag::ConfigBag| {
                    let input = input
                        .downcast_mut::<crate::operation::get_object::GetObjectInput>()
                        .ok_or("failed to downcast to crate::operation::get_object::GetObjectInput")?;

                    let request_validation_enabled = matches!(input.checksum_mode(), Some(crate::types::ChecksumMode::Enabled));

                    if !request_validation_enabled {
                        // This value is set by the user on the SdkConfig to indicate their preference
                        let response_checksum_validation = cfg
                            .load::<::aws_smithy_types::checksum_config::ResponseChecksumValidation>()
                            .unwrap_or(&::aws_smithy_types::checksum_config::ResponseChecksumValidation::WhenSupported);

                        let is_presigned_req = cfg.load::<crate::presigning::PresigningMarker>().is_some();

                        // For presigned requests we do not enable the checksum-mode header.
                        if is_presigned_req {
                            return ::std::result::Result::Ok(());
                        }

                        // If validation setting is WhenSupported (or unknown) we enable response checksum
                        // validation. If it is WhenRequired we do not enable (since there is no way to
                        // indicate that a response checksum is required).
                        #[allow(clippy::wildcard_in_or_patterns)]
                        match response_checksum_validation {
                            ::aws_smithy_types::checksum_config::ResponseChecksumValidation::WhenRequired => {}
                            ::aws_smithy_types::checksum_config::ResponseChecksumValidation::WhenSupported | _ => {
                                input.checksum_mode = Some(crate::types::ChecksumMode::Enabled);
                            }
                        }
                    }

                    ::std::result::Result::Ok(())
                },
            ))
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::TransientErrorClassifier::<
                crate::operation::get_object::GetObjectError,
            >::new())
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::ModeledAsRetryableClassifier::<
                crate::operation::get_object::GetObjectError,
            >::new())
            .with_retry_classifier(
                ::aws_runtime::retries::classifiers::AwsErrorCodeClassifier::<crate::operation::get_object::GetObjectError>::builder()
                    .transient_errors({
                        let mut transient_errors: Vec<&'static str> = ::aws_runtime::retries::classifiers::TRANSIENT_ERRORS.into();
                        transient_errors.push("InternalError");
                        ::std::borrow::Cow::Owned(transient_errors)
                    })
                    .build(),
            );

        ::std::borrow::Cow::Owned(rcb)
    }
}

#[derive(Debug)]
struct GetObjectResponseDeserializer;
impl ::aws_smithy_runtime_api::client::ser_de::DeserializeResponse for GetObjectResponseDeserializer {
    fn deserialize_streaming(
        &self,
        response: &mut ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
    ) -> ::std::option::Option<::aws_smithy_runtime_api::client::interceptors::context::OutputOrError> {
        #[allow(unused_mut)]
        let mut force_error = false;
        ::tracing::debug!(extended_request_id = ?crate::s3_request_id::RequestIdExt::extended_request_id(response));
        ::tracing::debug!(request_id = ?::aws_types::request_id::RequestId::request_id(response));

        // If this is an error, defer to the non-streaming parser
        if (!response.status().is_success() && response.status().as_u16() != 200) || force_error {
            return ::std::option::Option::None;
        }
        ::std::option::Option::Some(crate::protocol_serde::type_erase_result(
            crate::protocol_serde::shape_get_object::de_get_object_http_response(response),
        ))
    }

    fn deserialize_nonstreaming(
        &self,
        response: &::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
    ) -> ::aws_smithy_runtime_api::client::interceptors::context::OutputOrError {
        // For streaming operations, we only hit this case if its an error
        let body = response.body().bytes().expect("body loaded");
        crate::protocol_serde::type_erase_result(crate::protocol_serde::shape_get_object::de_get_object_http_error(
            response.status().as_u16(),
            response.headers(),
            body,
        ))
    }
}
#[derive(Debug)]
struct GetObjectRequestSerializer;
impl ::aws_smithy_runtime_api::client::ser_de::SerializeRequest for GetObjectRequestSerializer {
    #[allow(unused_mut, clippy::let_and_return, clippy::needless_borrow, clippy::useless_conversion)]
    fn serialize_input(
        &self,
        input: ::aws_smithy_runtime_api::client::interceptors::context::Input,
        _cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<::aws_smithy_runtime_api::client::orchestrator::HttpRequest, ::aws_smithy_runtime_api::box_error::BoxError> {
        let input = input.downcast::<crate::operation::get_object::GetObjectInput>().expect("correct type");
        let _header_serialization_settings = _cfg
            .load::<crate::serialization_settings::HeaderSerializationSettings>()
            .cloned()
            .unwrap_or_default();
        let mut request_builder = {
            fn uri_base(
                _input: &crate::operation::get_object::GetObjectInput,
                output: &mut ::std::string::String,
            ) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::BuildError> {
                use ::std::fmt::Write as _;
                let input_1 = &_input.key;
                let input_1 = input_1
                    .as_ref()
                    .ok_or_else(|| ::aws_smithy_types::error::operation::BuildError::missing_field("key", "cannot be empty or unset"))?;
                let key = ::aws_smithy_http::label::fmt_string(input_1, ::aws_smithy_http::label::EncodingStrategy::Greedy);
                if key.is_empty() {
                    return ::std::result::Result::Err(::aws_smithy_types::error::operation::BuildError::missing_field(
                        "key",
                        "cannot be empty or unset",
                    ));
                }
                ::std::write!(output, "/{Key}", Key = key).expect("formatting should succeed");
                ::std::result::Result::Ok(())
            }
            fn uri_query(
                _input: &crate::operation::get_object::GetObjectInput,
                mut output: &mut ::std::string::String,
            ) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::BuildError> {
                let mut query = ::aws_smithy_http::query::Writer::new(output);
                query.push_kv("x-id", "GetObject");
                if let ::std::option::Option::Some(inner_2) = &_input.response_cache_control {
                    {
                        query.push_kv("response-cache-control", &::aws_smithy_http::query::fmt_string(inner_2));
                    }
                }
                if let ::std::option::Option::Some(inner_3) = &_input.response_content_disposition {
                    {
                        query.push_kv("response-content-disposition", &::aws_smithy_http::query::fmt_string(inner_3));
                    }
                }
                if let ::std::option::Option::Some(inner_4) = &_input.response_content_encoding {
                    {
                        query.push_kv("response-content-encoding", &::aws_smithy_http::query::fmt_string(inner_4));
                    }
                }
                if let ::std::option::Option::Some(inner_5) = &_input.response_content_language {
                    {
                        query.push_kv("response-content-language", &::aws_smithy_http::query::fmt_string(inner_5));
                    }
                }
                if let ::std::option::Option::Some(inner_6) = &_input.response_content_type {
                    {
                        query.push_kv("response-content-type", &::aws_smithy_http::query::fmt_string(inner_6));
                    }
                }
                if let ::std::option::Option::Some(inner_7) = &_input.response_expires {
                    {
                        query.push_kv(
                            "response-expires",
                            &::aws_smithy_http::query::fmt_timestamp(inner_7, ::aws_smithy_types::date_time::Format::HttpDate)?,
                        );
                    }
                }
                if let ::std::option::Option::Some(inner_8) = &_input.version_id {
                    {
                        query.push_kv("versionId", &::aws_smithy_http::query::fmt_string(inner_8));
                    }
                }
                if let ::std::option::Option::Some(inner_9) = &_input.part_number {
                    {
                        query.push_kv("partNumber", ::aws_smithy_types::primitive::Encoder::from(*inner_9).encode());
                    }
                }
                ::std::result::Result::Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::operation::get_object::GetObjectInput,
                builder: ::http::request::Builder,
            ) -> ::std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
                let mut uri = ::std::string::String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::protocol_serde::shape_get_object::ser_get_object_headers(input, builder)?;
                ::std::result::Result::Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&input, ::http::request::Builder::new())?;
            builder
        };
        let body = ::aws_smithy_types::body::SdkBody::from("");

        ::std::result::Result::Ok(request_builder.body(body).expect("valid request").try_into().unwrap())
    }
}
#[derive(Debug)]
struct GetObjectEndpointParamsInterceptor;

impl ::aws_smithy_runtime_api::client::interceptors::Intercept for GetObjectEndpointParamsInterceptor {
    fn name(&self) -> &'static str {
        "GetObjectEndpointParamsInterceptor"
    }

    fn read_before_execution(
        &self,
        context: &::aws_smithy_runtime_api::client::interceptors::context::BeforeSerializationInterceptorContextRef<
            '_,
            ::aws_smithy_runtime_api::client::interceptors::context::Input,
            ::aws_smithy_runtime_api::client::interceptors::context::Output,
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
        >,
        cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<(), ::aws_smithy_runtime_api::box_error::BoxError> {
        let _input = context
            .input()
            .downcast_ref::<GetObjectInput>()
            .ok_or("failed to downcast to GetObjectInput")?;

        let params = crate::config::endpoint::Params::builder()
            .set_region(cfg.load::<::aws_types::region::Region>().map(|r| r.as_ref().to_owned()))
            .set_use_fips(cfg.load::<::aws_types::endpoint_config::UseFips>().map(|ty| ty.0))
            .set_use_dual_stack(cfg.load::<::aws_types::endpoint_config::UseDualStack>().map(|ty| ty.0))
            .set_endpoint(cfg.load::<::aws_types::endpoint_config::EndpointUrl>().map(|ty| ty.0.clone()))
            .set_force_path_style(cfg.load::<crate::config::ForcePathStyle>().map(|ty| ty.0))
            .set_use_arn_region(cfg.load::<crate::config::UseArnRegion>().map(|ty| ty.0))
            .set_disable_multi_region_access_points(cfg.load::<crate::config::DisableMultiRegionAccessPoints>().map(|ty| ty.0))
            .set_accelerate(cfg.load::<crate::config::Accelerate>().map(|ty| ty.0))
            .set_disable_s3_express_session_auth(cfg.load::<crate::config::DisableS3ExpressSessionAuth>().map(|ty| ty.0))
            .set_bucket(Some(
                _input
                    .bucket
                    .clone()
                    .filter(|f| !AsRef::<str>::as_ref(f).trim().is_empty())
                    .ok_or_else(|| ::aws_smithy_types::error::operation::BuildError::missing_field("bucket", "A required field was not set"))?,
            ))
            .set_key(Some(
                _input
                    .key
                    .clone()
                    .filter(|f| !AsRef::<str>::as_ref(f).trim().is_empty())
                    .ok_or_else(|| ::aws_smithy_types::error::operation::BuildError::missing_field("key", "A required field was not set"))?,
            ))
            .build()
            .map_err(|err| {
                ::aws_smithy_runtime_api::client::interceptors::error::ContextAttachedError::new("endpoint params could not be built", err)
            })?;
        cfg.interceptor_state()
            .store_put(::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams::new(params));
        ::std::result::Result::Ok(())
    }
}

// The get_* functions below are generated from JMESPath expressions in the
// operationContextParams trait. They target the operation's input shape.

#[allow(unreachable_code, unused_variables)]
#[cfg(test)]
mod get_object_test {

    /// https://github.com/awslabs/aws-sdk-rust/issues/818
    /// Test ID: GetObjectIfModifiedSince
    #[::tokio::test]
    #[::tracing_test::traced_test]
    async fn get_object_if_modified_since_request() {
        let (http_client, request_receiver) = ::aws_smithy_http_client::test_util::capture_request(None);
        let config_builder = crate::config::Config::builder().with_test_defaults().endpoint_url("https://example.com");
        let config_builder = config_builder.region(::aws_types::region::Region::new("us-east-1"));
        let mut config_builder = config_builder;
        config_builder.set_region(Some(crate::config::Region::new("us-east-1")));

        let config = config_builder.http_client(http_client).build();
        let client = crate::Client::from_conf(config);
        let result = client
            .get_object()
            .set_bucket(::std::option::Option::Some("test-bucket".to_owned()))
            .set_key(::std::option::Option::Some("object.txt".to_owned()))
            .set_if_modified_since(::std::option::Option::Some(::aws_smithy_types::DateTime::from_fractional_secs(
                1626452453, 0.123_f64,
            )))
            .send()
            .await;
        let _ = dbg!(result);
        let http_request = request_receiver.expect_request();
        let expected_headers = [("if-modified-since", "Fri, 16 Jul 2021 16:20:53 GMT")];
        ::aws_smithy_protocol_test::assert_ok(::aws_smithy_protocol_test::validate_headers(http_request.headers(), expected_headers));
        let uri: ::http::Uri = http_request.uri().parse().expect("invalid URI sent");
        ::pretty_assertions::assert_eq!(http_request.method(), "GET", "method was incorrect");
        ::pretty_assertions::assert_eq!(uri.path(), "/object.txt", "path was incorrect");
    }

    /// S3 clients should not remove dot segments from request paths.
    ///
    /// Test ID: S3PreservesLeadingDotSegmentInUriLabel
    #[::tokio::test]
    #[::tracing_test::traced_test]
    async fn s3_preserves_leading_dot_segment_in_uri_label_request() {
        let (http_client, request_receiver) = ::aws_smithy_http_client::test_util::capture_request(None);
        let config_builder = crate::config::Config::builder()
            .with_test_defaults()
            .endpoint_url("https://s3.us-west-2.amazonaws.com");

        let mut config_builder = config_builder;
        config_builder.set_region(Some(crate::config::Region::new("us-east-1")));

        let config = config_builder.http_client(http_client).build();
        let client = crate::Client::from_conf(config);
        let result = client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket".to_owned()))
            .set_key(::std::option::Option::Some("../key.txt".to_owned()))
            .send()
            .await;
        let _ = dbg!(result);
        let http_request = request_receiver.expect_request();
        let body = http_request.body().bytes().expect("body should be strict");
        // No body.
        ::pretty_assertions::assert_eq!(&body, &bytes::Bytes::new());
        let uri: ::http::Uri = http_request.uri().parse().expect("invalid URI sent");
        ::pretty_assertions::assert_eq!(http_request.method(), "GET", "method was incorrect");
        ::pretty_assertions::assert_eq!(uri.path(), "/../key.txt", "path was incorrect");
        ::pretty_assertions::assert_eq!(uri.host().expect("host should be set"), "mybucket.s3.us-west-2.amazonaws.com");
    }

    /// S3 clients should not remove dot segments from request paths.
    ///
    /// Test ID: S3PreservesEmbeddedDotSegmentInUriLabel
    #[::tokio::test]
    #[::tracing_test::traced_test]
    async fn s3_preserves_embedded_dot_segment_in_uri_label_request() {
        let (http_client, request_receiver) = ::aws_smithy_http_client::test_util::capture_request(None);
        let config_builder = crate::config::Config::builder()
            .with_test_defaults()
            .endpoint_url("https://s3.us-west-2.amazonaws.com");

        let mut config_builder = config_builder;
        config_builder.set_region(Some(crate::config::Region::new("us-east-1")));

        let config = config_builder.http_client(http_client).build();
        let client = crate::Client::from_conf(config);
        let result = client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket".to_owned()))
            .set_key(::std::option::Option::Some("foo/../key.txt".to_owned()))
            .send()
            .await;
        let _ = dbg!(result);
        let http_request = request_receiver.expect_request();
        let body = http_request.body().bytes().expect("body should be strict");
        // No body.
        ::pretty_assertions::assert_eq!(&body, &bytes::Bytes::new());
        let uri: ::http::Uri = http_request.uri().parse().expect("invalid URI sent");
        ::pretty_assertions::assert_eq!(http_request.method(), "GET", "method was incorrect");
        ::pretty_assertions::assert_eq!(uri.path(), "/foo/../key.txt", "path was incorrect");
        ::pretty_assertions::assert_eq!(uri.host().expect("host should be set"), "mybucket.s3.us-west-2.amazonaws.com");
    }
}

/// Error type for the `GetObjectError` operation.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum GetObjectError {
    /// <p>Object is archived and inaccessible until restored.</p>
    /// <p>If the object you are retrieving is stored in the S3 Glacier Flexible Retrieval storage class, the S3 Glacier Deep Archive storage class, the S3 Intelligent-Tiering Archive Access tier, or the S3 Intelligent-Tiering Deep Archive Access tier, before you can retrieve the object you must first restore a copy using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this operation returns an <code>InvalidObjectState</code> error. For information about restoring archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a> in the <i>Amazon S3 User Guide</i>.</p>
    InvalidObjectState(crate::types::error::InvalidObjectState),
    /// <p>The specified key does not exist.</p>
    NoSuchKey(crate::types::error::NoSuchKey),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-GetObjectError) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl GetObjectError {
    /// Creates the `GetObjectError::Unhandled` variant from any error type.
    pub fn unhandled(
        err: impl ::std::convert::Into<::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.into(),
            meta: ::std::default::Default::default(),
        })
    }

    /// Creates the `GetObjectError::Unhandled` variant from an [`ErrorMetadata`](::aws_smithy_types::error::ErrorMetadata).
    pub fn generic(err: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.clone().into(),
            meta: err,
        })
    }
    ///
    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    ///
    pub fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::InvalidObjectState(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::NoSuchKey(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::Unhandled(e) => &e.meta,
        }
    }
    /// Returns `true` if the error kind is `GetObjectError::InvalidObjectState`.
    pub fn is_invalid_object_state(&self) -> bool {
        matches!(self, Self::InvalidObjectState(_))
    }
    /// Returns `true` if the error kind is `GetObjectError::NoSuchKey`.
    pub fn is_no_such_key(&self) -> bool {
        matches!(self, Self::NoSuchKey(_))
    }
}
impl ::std::error::Error for GetObjectError {
    fn source(&self) -> ::std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Self::InvalidObjectState(_inner) => ::std::option::Option::Some(_inner),
            Self::NoSuchKey(_inner) => ::std::option::Option::Some(_inner),
            Self::Unhandled(_inner) => ::std::option::Option::Some(&*_inner.source),
        }
    }
}
impl ::std::fmt::Display for GetObjectError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            Self::InvalidObjectState(_inner) => _inner.fmt(f),
            Self::NoSuchKey(_inner) => _inner.fmt(f),
            Self::Unhandled(_inner) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl ::aws_smithy_types::retry::ProvideErrorKind for GetObjectError {
    fn code(&self) -> ::std::option::Option<&str> {
        ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self)
    }
    fn retryable_error_kind(&self) -> ::std::option::Option<::aws_smithy_types::retry::ErrorKind> {
        ::std::option::Option::None
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for GetObjectError {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::InvalidObjectState(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::NoSuchKey(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::Unhandled(_inner) => &_inner.meta,
        }
    }
}
impl ::aws_smithy_runtime_api::client::result::CreateUnhandledError for GetObjectError {
    fn create_unhandled_error(
        source: ::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>,
        meta: ::std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source,
            meta: meta.unwrap_or_default(),
        })
    }
}
impl crate::s3_request_id::RequestIdExt for crate::operation::get_object::GetObjectError {
    fn extended_request_id(&self) -> Option<&str> {
        self.meta().extended_request_id()
    }
}
impl ::aws_types::request_id::RequestId for crate::operation::get_object::GetObjectError {
    fn request_id(&self) -> Option<&str> {
        self.meta().request_id()
    }
}

pub use crate::operation::get_object::_get_object_output::GetObjectOutput;

pub use crate::operation::get_object::_get_object_input::GetObjectInput;

mod _get_object_input;

mod _get_object_output;

/// Builders
pub mod builders;
