/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.AbstractLinkStrategy;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.CubicCurve;

public class CurvedLineLink<T>
extends AbstractLinkStrategy<T> {
    @Override
    protected ArrayList<Node> drawLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, double startX, double startY, double endX, double endY, double vgap, double hgap) {
        CubicCurve curve;
        double arrowRotation = switch (direction) {
            case TreeNodeView.LayoutDirection.TOP_TO_BOTTOM -> {
                curve = this.createCurve(startX, startY, startX, startY + vgap / 2.0, endX, startY + vgap / 2.0, endX, endY);
                yield this.getTangentAngle(curve, 0.95);
            }
            case TreeNodeView.LayoutDirection.BOTTOM_TO_TOP -> {
                curve = this.createCurve(startX, startY, startX, startY - vgap / 2.0, endX, endY + vgap / 2.0, endX, endY);
                yield this.getTangentAngle(curve, 0.05);
            }
            case TreeNodeView.LayoutDirection.LEFT_TO_RIGHT -> {
                curve = this.createCurve(startX, startY, startX + hgap / 2.0, startY, endX - hgap / 2.0, endY, endX, endY);
                yield this.getTangentAngle(curve, 0.95);
            }
            case TreeNodeView.LayoutDirection.RIGHT_TO_LEFT -> {
                curve = this.createCurve(startX, startY, startX - hgap / 2.0, startY, endX + hgap / 2.0, endY, endX, endY);
                yield this.getTangentAngle(curve, 0.05);
            }
            default -> throw new IllegalArgumentException("Unsupported direction: " + direction);
        };
        Node arrow = this.createSimpleArrow();
        arrow.setRotate(arrowRotation);
        return new ArrayList<Node>(List.of(curve, arrow));
    }

    private CubicCurve createCurve(double startX, double startY, double controlX1, double controlY1, double controlX2, double controlY2, double endX, double endY) {
        CubicCurve curve = new CubicCurve(startX, startY, controlX1, controlY1, controlX2, controlY2, endX, endY);
        curve.getStyleClass().add((Object)"link-curve");
        return curve;
    }
}

