/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview;

import com.dlsc.gemsfx.treeview.TreeNode;
import com.dlsc.gemsfx.treeview.TreeNodeCell;
import com.dlsc.gemsfx.treeview.TreeNodeViewSkin;
import com.dlsc.gemsfx.treeview.link.LinkStrategy;
import com.dlsc.gemsfx.treeview.link.StraightLineLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class TreeNodeView<T>
extends Control {
    private static final int DEFAULT_CELL_WIDTH = 60;
    private static final int DEFAULT_CELL_HEIGHT = 30;
    private static final double DEFAULT_VGAP = 50.0;
    private static final double DEFAULT_HGAP = 20.0;
    private static final double DEFAULT_NODE_LINE_GAP = 10.0;
    private static final VPos DEFAULT_ROW_ALIGNMENT = VPos.CENTER;
    private static final HPos DEFAULT_COLUMN_ALIGNMENT = HPos.CENTER;
    private static final LayoutType DEFAULT_LAYOUT_TYPE = LayoutType.REGULAR;
    private static final LayoutDirection DEFAULT_LAYOUT_DIRECTION = LayoutDirection.TOP_TO_BOTTOM;
    private static final PseudoClass LTR_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"ltr");
    private static final PseudoClass RTL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"rtl");
    private static final PseudoClass TTB_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"ttb");
    private static final PseudoClass BTT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"btt");
    private static final String DEFAULT_STYLE_CLASS = "tree-node-view";
    private final ObjectProperty<Callback<T, TreeNodeCell<T>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory", TreeNodeCell::new);
    private final ObjectProperty<TreeNode<T>> root = new SimpleObjectProperty((Object)this, "root");
    private final StyleableObjectProperty<VPos> rowAlignment = new StyleableObjectProperty<VPos>(DEFAULT_ROW_ALIGNMENT){

        public CssMetaData<? extends Styleable, VPos> getCssMetaData() {
            return StyleableProperties.ROW_ALIGNMENT;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "rowAlignment";
        }
    };
    private final StyleableObjectProperty<HPos> columnAlignment = new StyleableObjectProperty<HPos>(DEFAULT_COLUMN_ALIGNMENT){

        public CssMetaData<? extends Styleable, HPos> getCssMetaData() {
            return StyleableProperties.COLUMN_ALIGNMENT;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "columnAlignment";
        }
    };
    private final DoubleProperty cellWidth = new StyleableDoubleProperty(60.0){

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return StyleableProperties.CELL_WIDTH;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "cellWidth";
        }
    };
    private final DoubleProperty cellHeight = new StyleableDoubleProperty(30.0){

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return StyleableProperties.CELL_HEIGHT;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "cellHeight";
        }
    };
    private final DoubleProperty hgap = new StyleableDoubleProperty(20.0){

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return StyleableProperties.H_GAP;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "hgap";
        }
    };
    private final DoubleProperty vgap = new StyleableDoubleProperty(50.0){

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return StyleableProperties.V_GAP;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "vgap";
        }
    };
    private final DoubleProperty nodeLineGap = new StyleableDoubleProperty(10.0){

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return StyleableProperties.NODE_LINE_GAP;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "nodeLineGap";
        }
    };
    private final ObjectProperty<Node> placeholder = new SimpleObjectProperty((Object)this, "placeholder", (Object)this.createDefaultPlaceholder());
    private final ObjectProperty<LinkStrategy<T>> linkStrategy = new SimpleObjectProperty((Object)this, "linkStrategy", new StraightLineLink());
    private final ObjectProperty<LayoutType> layoutType = new StyleableObjectProperty<LayoutType>(DEFAULT_LAYOUT_TYPE){

        public CssMetaData<? extends Styleable, LayoutType> getCssMetaData() {
            return StyleableProperties.LAYOUT_TYPE;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "layoutType";
        }
    };
    private final ObjectProperty<LayoutDirection> layoutDirection = new StyleableObjectProperty<LayoutDirection>(DEFAULT_LAYOUT_DIRECTION){

        public CssMetaData<? extends Styleable, LayoutDirection> getCssMetaData() {
            return StyleableProperties.LAYOUT_DIRECTION;
        }

        public Object getBean() {
            return TreeNodeView.this;
        }

        public String getName() {
            return "layoutDirection";
        }
    };

    public TreeNodeView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.layoutDirection.addListener(it -> this.activateDirectionPseudoClass());
    }

    public TreeNodeView(TreeNode<T> root) {
        this();
        this.setRoot(root);
    }

    private void activateDirectionPseudoClass() {
        this.pseudoClassStateChanged(LTR_PSEUDOCLASS_STATE, this.getLayoutDirection() == LayoutDirection.LEFT_TO_RIGHT);
        this.pseudoClassStateChanged(RTL_PSEUDOCLASS_STATE, this.getLayoutDirection() == LayoutDirection.RIGHT_TO_LEFT);
        this.pseudoClassStateChanged(TTB_PSEUDOCLASS_STATE, this.getLayoutDirection() == LayoutDirection.TOP_TO_BOTTOM);
        this.pseudoClassStateChanged(BTT_PSEUDOCLASS_STATE, this.getLayoutDirection() == LayoutDirection.BOTTOM_TO_TOP);
    }

    protected Skin<?> createDefaultSkin() {
        return new TreeNodeViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("tree-view.css")).toExternalForm();
    }

    public final void setCellFactory(Callback<T, TreeNodeCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<T, TreeNodeCell<T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<T, TreeNodeCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public TreeNode<T> getRoot() {
        return (TreeNode)this.root.get();
    }

    public ObjectProperty<TreeNode<T>> rootProperty() {
        return this.root;
    }

    public void setRoot(TreeNode<T> root) {
        this.root.set(root);
    }

    public VPos getRowAlignment() {
        return (VPos)this.rowAlignment.get();
    }

    public ObjectProperty<VPos> rowAlignmentProperty() {
        return this.rowAlignment;
    }

    public void setRowAlignment(VPos rowAlignment) {
        this.rowAlignment.set((Object)rowAlignment);
    }

    public HPos getColumnAlignment() {
        return (HPos)this.columnAlignment.get();
    }

    public ObjectProperty<HPos> columnAlignmentProperty() {
        return this.columnAlignment;
    }

    public void setColumnAlignment(HPos columnAlignment) {
        this.columnAlignment.set((Object)columnAlignment);
    }

    public double getCellWidth() {
        return this.cellWidth.get();
    }

    public DoubleProperty cellWidthProperty() {
        return this.cellWidth;
    }

    public void setCellWidth(double cellWidth) {
        this.cellWidth.set(cellWidth);
    }

    public double getCellHeight() {
        return this.cellHeight.get();
    }

    public DoubleProperty cellHeightProperty() {
        return this.cellHeight;
    }

    public void setCellHeight(double cellHeight) {
        this.cellHeight.set(cellHeight);
    }

    public double getHgap() {
        return this.hgap.get();
    }

    public DoubleProperty hgapProperty() {
        return this.hgap;
    }

    public void setHgap(double hgap) {
        this.hgap.set(hgap);
    }

    public double getVgap() {
        return this.vgap.get();
    }

    public DoubleProperty vgapProperty() {
        return this.vgap;
    }

    public void setVgap(double vgap) {
        this.vgap.set(vgap);
    }

    public double getNodeLineGap() {
        return this.nodeLineGap.get();
    }

    public DoubleProperty nodeLineGapProperty() {
        return this.nodeLineGap;
    }

    public void setNodeLineGap(double nodeLineGap) {
        this.nodeLineGap.set(nodeLineGap);
    }

    public Node getPlaceholder() {
        return (Node)this.placeholder.get();
    }

    public ObjectProperty<Node> placeholderProperty() {
        return this.placeholder;
    }

    public void setPlaceholder(Node placeholder) {
        this.placeholder.set((Object)placeholder);
    }

    public LinkStrategy<T> getLinkStrategy() {
        return (LinkStrategy)this.linkStrategy.get();
    }

    public ObjectProperty<LinkStrategy<T>> linkStrategyProperty() {
        return this.linkStrategy;
    }

    public void setLinkStrategy(LinkStrategy<T> linkStrategy) {
        this.linkStrategy.set(linkStrategy);
    }

    private Node createDefaultPlaceholder() {
        Label label = new Label("No tree root.");
        label.getStyleClass().add((Object)"default-placeholder");
        return label;
    }

    public LayoutType getLayoutType() {
        return (LayoutType)((Object)this.layoutType.get());
    }

    public ObjectProperty<LayoutType> layoutTypeProperty() {
        return this.layoutType;
    }

    public void setLayoutType(LayoutType layoutType) {
        this.layoutType.set((Object)layoutType);
    }

    public LayoutDirection getLayoutDirection() {
        return (LayoutDirection)((Object)this.layoutDirection.get());
    }

    public ObjectProperty<LayoutDirection> layoutDirectionProperty() {
        return this.layoutDirection;
    }

    public void setLayoutDirection(LayoutDirection layoutDirection) {
        this.layoutDirection.set((Object)layoutDirection);
    }

    public void refresh() {
        Skin skin = this.getSkin();
        if (skin instanceof TreeNodeViewSkin) {
            TreeNodeViewSkin treeNodeSkin = (TreeNodeViewSkin)skin;
            treeNodeSkin.refresh();
        }
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TreeNodeView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public static enum LayoutType {
        REGULAR,
        COMPACT;

    }

    public static enum LayoutDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }

    private static class StyleableProperties {
        public static final CssMetaData<TreeNodeView<?>, HPos> COLUMN_ALIGNMENT = new CssMetaData<TreeNodeView<?>, HPos>("-fx-column-alignment", (StyleConverter)new EnumConverter(HPos.class), DEFAULT_COLUMN_ALIGNMENT){

            public boolean isSettable(TreeNodeView<?> n) {
                return !n.columnAlignment.isBound();
            }

            public StyleableProperty<HPos> getStyleableProperty(TreeNodeView<?> n) {
                return (StyleableProperty)n.columnAlignmentProperty();
            }
        };
        public static final CssMetaData<TreeNodeView<?>, LayoutType> LAYOUT_TYPE = new CssMetaData<TreeNodeView<?>, LayoutType>("-fx-layout-type", (StyleConverter)new EnumConverter(LayoutType.class), DEFAULT_LAYOUT_TYPE){

            public boolean isSettable(TreeNodeView<?> styleable) {
                return !styleable.layoutType.isBound();
            }

            public StyleableProperty<LayoutType> getStyleableProperty(TreeNodeView<?> styleable) {
                return (StyleableProperty)styleable.layoutTypeProperty();
            }
        };
        private static final CssMetaData<TreeNodeView<?>, VPos> ROW_ALIGNMENT = new CssMetaData<TreeNodeView<?>, VPos>("-fx-row-alignment", (StyleConverter)new EnumConverter(VPos.class), DEFAULT_ROW_ALIGNMENT){

            public boolean isSettable(TreeNodeView<?> n) {
                return !n.rowAlignment.isBound();
            }

            public StyleableProperty<VPos> getStyleableProperty(TreeNodeView<?> n) {
                return (StyleableProperty)n.rowAlignmentProperty();
            }
        };
        public static final CssMetaData<TreeNodeView<?>, Number> CELL_WIDTH = new CssMetaData<TreeNodeView<?>, Number>("-fx-cell-width", SizeConverter.getInstance(), 60){

            public boolean isSettable(TreeNodeView<?> styleable) {
                return !styleable.cellWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TreeNodeView<?> styleable) {
                return (StyleableProperty)styleable.cellWidthProperty();
            }
        };
        public static final CssMetaData<TreeNodeView<?>, Number> CELL_HEIGHT = new CssMetaData<TreeNodeView<?>, Number>("-fx-cell-height", SizeConverter.getInstance(), 30){

            public boolean isSettable(TreeNodeView<?> styleable) {
                return !styleable.cellHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TreeNodeView<?> styleable) {
                return (StyleableProperty)styleable.cellHeightProperty();
            }
        };
        public static final CssMetaData<TreeNodeView<?>, Number> H_GAP = new CssMetaData<TreeNodeView<?>, Number>("-fx-hgap", SizeConverter.getInstance(), 20.0){

            public boolean isSettable(TreeNodeView<?> styleable) {
                return !styleable.hgap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TreeNodeView<?> styleable) {
                return (StyleableProperty)styleable.hgapProperty();
            }
        };
        public static final CssMetaData<TreeNodeView<?>, Number> V_GAP = new CssMetaData<TreeNodeView<?>, Number>("-fx-vgap", SizeConverter.getInstance(), 50.0){

            public boolean isSettable(TreeNodeView<?> styleable) {
                return !styleable.vgap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TreeNodeView<?> styleable) {
                return (StyleableProperty)styleable.vgapProperty();
            }
        };
        public static final CssMetaData<TreeNodeView<?>, Number> NODE_LINE_GAP = new CssMetaData<TreeNodeView<?>, Number>("-fx-node-line-gap", SizeConverter.getInstance(), 10.0){

            public boolean isSettable(TreeNodeView<?> styleable) {
                return !styleable.nodeLineGap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TreeNodeView<?> styleable) {
                return (StyleableProperty)styleable.nodeLineGapProperty();
            }
        };
        public static final CssMetaData<TreeNodeView<?>, LayoutDirection> LAYOUT_DIRECTION = new CssMetaData<TreeNodeView<?>, LayoutDirection>("-fx-layout-direction", (StyleConverter)new EnumConverter(LayoutDirection.class), DEFAULT_LAYOUT_DIRECTION){

            public boolean isSettable(TreeNodeView<?> styleable) {
                return !styleable.layoutDirection.isBound();
            }

            public StyleableProperty<LayoutDirection> getStyleableProperty(TreeNodeView<?> styleable) {
                return (StyleableProperty)styleable.layoutDirectionProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, ROW_ALIGNMENT, COLUMN_ALIGNMENT, CELL_WIDTH, CELL_HEIGHT, H_GAP, V_GAP, NODE_LINE_GAP, LAYOUT_TYPE, LAYOUT_DIRECTION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

