/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;

class AbstractResourceReader {
    private final String file;
    private final String resource;
    private final String strings;

    protected AbstractResourceReader(String file, String resource, String strings) {
        this.file = file;
        this.resource = resource;
        this.strings = strings;
    }

    protected List<Reader> getReaders() {
        if (this.strings != null) {
            return Collections.singletonList(new StringReader(this.strings));
        }
        if (this.file != null) {
            try {
                String string = this.file;
                FileInputStream fileInputStream = new FileInputStream(string);
                FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (String)string, (String)"org.openjdk.jmh.runner.AbstractResourceReader");
                return Collections.singletonList(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("ERROR: Could not find resource", e);
            }
        }
        if (this.resource != null) {
            Enumeration<URL> urls;
            try {
                urls = this.getClass().getClassLoader().getResources(this.resource.startsWith("/") ? this.resource.substring(1) : this.resource);
            }
            catch (IOException e) {
                throw new RuntimeException("ERROR: While obtaining resource: " + this.resource, e);
            }
            if (urls.hasMoreElements()) {
                ArrayList<Reader> readers = new ArrayList<Reader>();
                URL url = null;
                try {
                    while (urls.hasMoreElements()) {
                        url = urls.nextElement();
                        InputStream stream = url.openStream();
                        readers.add(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    }
                }
                catch (IOException e) {
                    for (Reader r : readers) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw new RuntimeException("ERROR: While opening resource: " + url, e);
                }
                return readers;
            }
            throw new RuntimeException("ERROR: Unable to find the resource: " + this.resource);
        }
        throw new IllegalStateException();
    }
}

