/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.undo.impl;

import java.util.NoSuchElementException;
import org.fxmisc.undo.impl.ChangeQueue;
import org.fxmisc.undo.impl.RevisionedChange;

public class FixedSizeChangeQueue<C>
implements ChangeQueue<C> {
    private final RevisionedChange<C>[] changes;
    private final int capacity;
    private int start = 0;
    private int size = 0;
    private int currentPosition = 0;
    private long revision;
    private long zeroPositionRevision = this.revision = 0L;

    public FixedSizeChangeQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.capacity = capacity;
        this.changes = new RevisionedChange[capacity];
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.size;
    }

    @Override
    public boolean hasPrev() {
        return this.currentPosition > 0;
    }

    @Override
    public C peekNext() {
        if (this.currentPosition < this.size) {
            return this.fetch(this.currentPosition).getChange();
        }
        throw new NoSuchElementException();
    }

    @Override
    public C next() {
        C c = this.peekNext();
        ++this.currentPosition;
        return c;
    }

    @Override
    public C peekPrev() {
        if (this.currentPosition > 0) {
            return this.fetch(this.currentPosition - 1).getChange();
        }
        throw new NoSuchElementException();
    }

    @Override
    public C prev() {
        C c = this.peekPrev();
        --this.currentPosition;
        return c;
    }

    @Override
    public void forgetHistory() {
        this.zeroPositionRevision = this.fetchRevisionForPosition(this.currentPosition);
        this.start = this.arrayIndex(this.currentPosition);
        this.size -= this.currentPosition;
        this.currentPosition = 0;
    }

    @Override
    @SafeVarargs
    public final void push(C ... changes) {
        RevisionedChange<C> lastOverwrittenChange = null;
        for (C c : changes) {
            RevisionedChange<C> revC = new RevisionedChange<C>(c, ++this.revision);
            lastOverwrittenChange = this.put(this.currentPosition++, revC);
        }
        if (this.currentPosition > this.capacity) {
            this.start = this.arrayIndex(this.currentPosition);
            this.currentPosition = this.capacity;
            this.size = this.capacity;
            this.zeroPositionRevision = lastOverwrittenChange.getRevision();
        } else {
            this.size = this.currentPosition;
        }
    }

    @Override
    public ChangeQueue.QueuePosition getCurrentPosition() {
        long rev = this.fetchRevisionForPosition(this.currentPosition);
        return new QueuePositionImpl(this.arrayIndex(this.currentPosition), rev);
    }

    private long fetchRevisionForPosition(int position) {
        if (position == 0) {
            return this.zeroPositionRevision;
        }
        return this.fetch(position - 1).getRevision();
    }

    private RevisionedChange<C> fetch(int position) {
        return this.changes[this.arrayIndex(position)];
    }

    private RevisionedChange<C> put(int position, RevisionedChange<C> c) {
        RevisionedChange<C> old = this.changes[this.arrayIndex(position)];
        this.changes[this.arrayIndex((int)position)] = c;
        return old;
    }

    private int arrayIndex(int queuePosition) {
        return (this.start + queuePosition) % this.capacity;
    }

    private int relativize(int arrayPos) {
        return (arrayPos - this.start + this.capacity) % this.capacity;
    }

    private class QueuePositionImpl
    implements ChangeQueue.QueuePosition {
        private final int arrayPos;
        private final long rev;

        QueuePositionImpl(int arrayPos, long rev) {
            this.arrayPos = arrayPos;
            this.rev = rev;
        }

        @Override
        public boolean isValid() {
            int pos = FixedSizeChangeQueue.this.relativize(this.arrayPos);
            if (pos <= FixedSizeChangeQueue.this.size) {
                return this.rev == FixedSizeChangeQueue.this.fetchRevisionForPosition(pos) || pos == 0 && FixedSizeChangeQueue.this.size == FixedSizeChangeQueue.this.capacity && this.rev == FixedSizeChangeQueue.this.fetchRevisionForPosition(FixedSizeChangeQueue.this.capacity);
            }
            return false;
        }

        public boolean equals(Object other) {
            if (other instanceof QueuePositionImpl) {
                QueuePositionImpl otherPos = (QueuePositionImpl)other;
                return this.getQueue() == otherPos.getQueue() && this.rev == otherPos.rev;
            }
            return false;
        }

        private FixedSizeChangeQueue<C> getQueue() {
            return FixedSizeChangeQueue.this;
        }
    }
}

