/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.util.Optional;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.extensions.CompileModuleOptions;
import org.javamodularity.moduleplugin.internal.CompileModuleInfoHelper;
import org.javamodularity.moduleplugin.tasks.AbstractCompileTask;
import org.javamodularity.moduleplugin.tasks.CompileJavaTaskMutator;
import org.javamodularity.moduleplugin.tasks.MergeClassesHelper;

public class CompileTask
extends AbstractCompileTask {
    private static final Logger LOGGER = Logging.getLogger(CompileTask.class);

    public CompileTask(Project project) {
        super(project);
    }

    public void configureCompileJava() {
        this.enforceJarForCompilation();
        this.helper().findTask("compileJava", JavaCompile.class).ifPresent(this::configureCompileJava);
    }

    private void configureCompileJava(JavaCompile compileJava) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            compileJava.getModularity().getInferModulePath().set((Object)false);
        }
        CompileModuleOptions moduleOptions = (CompileModuleOptions)compileJava.getExtensions().create("moduleOptions", CompileModuleOptions.class, new Object[]{this.project});
        this.project.afterEvaluate(p -> {
            this.adjustMainClass(compileJava);
            MergeClassesHelper.POST_JAVA_COMPILE_TASK_NAMES.stream().map(name -> this.helper().findTask((String)name, AbstractCompile.class)).flatMap(Optional::stream).filter(task -> !task.getSource().isEmpty()).findAny().ifPresent(task -> moduleOptions.setCompileModuleInfoSeparately(true));
            if (moduleOptions.getCompileModuleInfoSeparately()) {
                compileJava.exclude(new String[]{"module-info.java"});
            } else {
                this.configureModularityForCompileJava(compileJava, moduleOptions);
            }
        });
    }

    private void adjustMainClass(JavaCompile compileJava) {
        int idx;
        Property mainClassProp;
        String mainClass;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0 && (mainClass = (String)(mainClassProp = compileJava.getOptions().getJavaModuleMainClass()).getOrNull()) != null && (idx = mainClass.indexOf(47)) >= 0) {
            mainClassProp.set((Object)mainClass.substring(idx + 1));
        }
    }

    private void enforceJarForCompilation() {
        Configuration config = this.project.getConfigurations().getByName("compileClasspath");
        config.attributes((Action)new Action<AttributeContainer>(){

            public void execute(AttributeContainer attributeContainer) {
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.6")) < 0) {
                    LOGGER.warn("Cannot enforce using JARs for compilation. Please upgrade to Gradle 5.6 or newer.");
                    return;
                }
                attributeContainer.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)CompileTask.this.project.getObjects().named(LibraryElements.class, "jar")));
            }
        });
    }

    void configureModularityForCompileJava(final JavaCompile compileJava, CompileModuleOptions moduleOptions) {
        CompileModuleInfoHelper.dependOnOtherCompileModuleInfoJavaTasks(compileJava);
        final CompileJavaTaskMutator mutator = this.createCompileJavaTaskMutator(compileJava, moduleOptions);
        compileJava.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                mutator.modularizeJavaCompileTask(compileJava);
            }
        });
    }
}

