/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx.skins;

import com.dlsc.pickerfx.DurationPicker;
import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.skins.PickerSkinBase;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class DurationPickerSkin
extends PickerSkinBase<DurationPicker> {
    private final Map<ChronoUnit, Segment<Duration, Long>> segmentMap = new HashMap<ChronoUnit, Segment<Duration, Long>>();
    private boolean updatingValue;

    public DurationPickerSkin(DurationPicker picker) {
        super(picker);
        picker.valueProperty().addListener(it -> this.updateSegmentValues());
        InvalidationListener buildListener = it -> this.buildView();
        picker.getFields().addListener(buildListener);
        picker.minimumDurationProperty().addListener(buildListener);
        picker.maximumDurationProperty().addListener(buildListener);
        this.buildView();
        this.updateSegmentValues();
    }

    private Label createColon() {
        Label colon = new Label();
        colon.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        colon.setText(":");
        colon.getStyleClass().add((Object)"colon");
        colon.setAlignment(Pos.CENTER);
        return colon;
    }

    private void buildView() {
        Pane container = this.getContainer();
        container.getChildren().clear();
        ObservableList<ChronoUnit> fields = ((DurationPicker)this.getSkinnable()).getFields();
        for (int i = 0; i < fields.size(); ++i) {
            ChronoUnit chronoUnit = (ChronoUnit)fields.get(i);
            Segment<Duration, Long> segment = this.createSegment(chronoUnit);
            segment.valueProperty().addListener(it -> this.updateValue());
            this.segmentMap.put(chronoUnit, segment);
            container.getChildren().add(segment);
            HBox.setHgrow(segment, (Priority)Priority.ALWAYS);
            VBox.setVgrow(segment, (Priority)Priority.ALWAYS);
            if (i >= fields.size() - 1) continue;
            container.getChildren().add((Object)new PickerSkinBase.SegmentSeparator());
            container.getChildren().add((Object)this.createColon());
            container.getChildren().add((Object)new PickerSkinBase.SegmentSeparator());
        }
    }

    private Segment<Duration, Long> createSegment(ChronoUnit unit) {
        Segment<Duration, Long> field = new Segment<Duration, Long>((Picker)this.getSkinnable());
        Duration maximumDuration = ((DurationPicker)this.getSkinnable()).getMaximumDuration();
        switch (unit) {
            default: {
                this.addItems(field, maximumDuration.toDaysPart());
                break;
            }
            case HOURS: {
                if (maximumDuration.toDays() > 0L) {
                    this.addItems(field, 23L);
                    break;
                }
                this.addItems(field, maximumDuration.toHoursPart());
                break;
            }
            case MINUTES: {
                if (maximumDuration.toHours() > 0L) {
                    this.addItems(field, 59L);
                    break;
                }
                this.addItems(field, maximumDuration.toMinutesPart());
                break;
            }
            case SECONDS: {
                if (maximumDuration.toMinutes() > 0L) {
                    this.addItems(field, 59L);
                    break;
                }
                this.addItems(field, maximumDuration.toSecondsPart());
                break;
            }
            case MILLIS: {
                if (maximumDuration.toSeconds() > 0L) {
                    this.addItems(field, 999L);
                    break;
                }
                this.addItems(field, maximumDuration.toMillisPart());
            }
        }
        field.setValue(0L);
        return field;
    }

    private void addItems(Segment<Duration, Long> fieldSegment, long maxValue) {
        fieldSegment.getItems().clear();
        for (long i = 0L; i <= maxValue; ++i) {
            fieldSegment.getItems().add((Object)i);
        }
    }

    private void updateSegmentValues() {
        if (this.updatingValue) {
            return;
        }
        Duration duration = (Duration)((DurationPicker)this.getSkinnable()).getValue();
        if (duration != null) {
            for (ChronoUnit unit : ((DurationPicker)this.getSkinnable()).getFields()) {
                Segment<Duration, Long> segment = this.segmentMap.get(unit);
                switch (unit) {
                    case DAYS: {
                        segment.setValue(duration.toDaysPart());
                        break;
                    }
                    case HOURS: {
                        segment.setValue(Long.valueOf(duration.toHoursPart()));
                        break;
                    }
                    case MINUTES: {
                        segment.setValue(Long.valueOf(duration.toMinutesPart()));
                        break;
                    }
                    case SECONDS: {
                        segment.setValue(Long.valueOf(duration.toSecondsPart()));
                        break;
                    }
                    case MILLIS: {
                        segment.setValue(Long.valueOf(duration.toMillisPart()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        this.updatingValue = true;
        try {
            Duration duration = Duration.ZERO;
            for (ChronoUnit unit : ((DurationPicker)this.getSkinnable()).getFields()) {
                Segment<Duration, Long> segment = this.segmentMap.get(unit);
                Long value = segment.getValue();
                if (value == null) continue;
                duration = duration.plus((long)value, unit);
            }
            ((DurationPicker)this.getSkinnable()).setValue(duration);
        }
        finally {
            this.updatingValue = false;
        }
    }
}

