/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx;

import com.dlsc.pickerfx.util.ControlsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;

public abstract class Picker<T>
extends Control {
    private static final PseudoClass PSEUDO_CLASS_VERTICAL = PseudoClass.getPseudoClass((String)"vertical");
    private static final PseudoClass PSEUDO_CLASS_HORIZONTAL = PseudoClass.getPseudoClass((String)"horizontal");
    private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value");
    private final ReadOnlyBooleanWrapper invalid = new ReadOnlyBooleanWrapper((Object)this, "invalid");
    private final BooleanProperty readOnly = new SimpleBooleanProperty((Object)this, "readOnly");
    private final BooleanProperty showIndicator = new SimpleBooleanProperty((Object)this, "showIndicator", true);
    private DoubleProperty indicatorSize;
    private ObjectProperty<Orientation> orientation;
    private DoubleProperty cellSize;

    protected Picker() {
        this.getStyleClass().add((Object)"picker");
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.listenForInvalidChanges();
        ControlsUtil.bindBooleanToPseudoclass((Node)this, (ObservableValue<Boolean>)this.invalid, PseudoClass.getPseudoClass((String)"invalid"));
        ControlsUtil.bindBooleanToPseudoclass((Node)this, (ObservableValue<Boolean>)this.readOnly, PseudoClass.getPseudoClass((String)"disabled"));
        this.pseudoClassStateChanged(PSEUDO_CLASS_VERTICAL, true);
    }

    public final ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final T getValue() {
        return (T)this.valueProperty().get();
    }

    public final void setValue(T value) {
        this.valueProperty().set(value);
    }

    public final ReadOnlyBooleanProperty invalidProperty() {
        return this.invalid.getReadOnlyProperty();
    }

    public final boolean isInvalid() {
        return this.invalid.get();
    }

    private void setInvalid(boolean invalid) {
        this.invalid.set(invalid);
    }

    public final BooleanProperty readOnlyProperty() {
        return this.readOnly;
    }

    public final boolean isReadOnly() {
        return this.readOnlyProperty().get();
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnlyProperty().set(readOnly);
    }

    public boolean isShowIndicator() {
        return this.showIndicator.get();
    }

    public BooleanProperty showIndicatorProperty() {
        return this.showIndicator;
    }

    public void setShowIndicator(boolean showIndicator) {
        this.showIndicator.set(showIndicator);
    }

    public final DoubleProperty indicatorSizeProperty() {
        if (this.indicatorSize == null) {
            this.indicatorSize = new StyleableDoubleProperty(20.0){

                public void invalidated() {
                    Picker.this.requestLayout();
                }

                public Object getBean() {
                    return Picker.this;
                }

                public String getName() {
                    return "indicatorSize";
                }

                public CssMetaData<Picker, Number> getCssMetaData() {
                    return StyleableProperties.INDICATOR_SIZE;
                }
            };
        }
        return this.indicatorSize;
    }

    public final void setIndicatorSize(double value) {
        this.indicatorSizeProperty().set(value);
    }

    public final double getIndicatorSize() {
        return this.indicatorSize == null ? 70.0 : this.indicatorSize.get();
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set((Object)value);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.VERTICAL : (Orientation)this.orientation.get();
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(Orientation.VERTICAL){

                public void invalidated() {
                    boolean active = this.get() == Orientation.VERTICAL;
                    Picker.this.pseudoClassStateChanged(PSEUDO_CLASS_VERTICAL, active);
                    Picker.this.pseudoClassStateChanged(PSEUDO_CLASS_HORIZONTAL, !active);
                }

                public CssMetaData<Picker<?>, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                public Object getBean() {
                    return Picker.this;
                }

                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final DoubleProperty cellSizeProperty() {
        if (this.cellSize == null) {
            this.cellSize = new StyleableDoubleProperty(){

                public void invalidated() {
                    Picker.this.requestLayout();
                }

                public Object getBean() {
                    return Picker.this;
                }

                public String getName() {
                    return "cellSize";
                }

                public CssMetaData<Picker, Number> getCssMetaData() {
                    return StyleableProperties.CELL_SIZE;
                }
            };
        }
        return this.cellSize;
    }

    public final void setCellSize(double value) {
        this.cellSizeProperty().set(value);
    }

    public final double getCellSize() {
        return this.cellSize == null ? 50.0 : this.cellSize.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Picker.getClassCssMetaData();
    }

    private void listenForInvalidChanges() {
        this.getProperties().addListener(change -> {
            if (change.getKey().equals("invalid")) {
                Boolean value = (Boolean)change.getValueAdded();
                this.setInvalid(Boolean.TRUE.equals(value));
            }
        });
    }

    private static class StyleableProperties {
        private static final CssMetaData<Picker, Number> CELL_SIZE = new CssMetaData<Picker, Number>("-fx-cell-size", SizeConverter.getInstance(), (Number)50.0){

            public boolean isSettable(Picker node) {
                return node.cellSize == null || !node.cellSize.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(Picker node) {
                return (StyleableProperty)node.cellSizeProperty();
            }
        };
        private static final CssMetaData<Picker, Number> INDICATOR_SIZE = new CssMetaData<Picker, Number>("-fx-indicator-size", SizeConverter.getInstance(), (Number)30.0){

            public boolean isSettable(Picker node) {
                return node.indicatorSize == null || !node.indicatorSize.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(Picker node) {
                return (StyleableProperty)node.indicatorSizeProperty();
            }
        };
        private static final CssMetaData<Picker<?>, Orientation> ORIENTATION = new CssMetaData<Picker<?>, Orientation>("-fx-orientation", (StyleConverter)new EnumConverter(Orientation.class), Orientation.VERTICAL){

            public Orientation getInitialValue(Picker<?> node) {
                return node.getOrientation();
            }

            public boolean isSettable(Picker<?> n) {
                return n.orientation == null || !n.orientation.isBound();
            }

            public StyleableProperty<Orientation> getStyleableProperty(Picker<?> n) {
                return (StyleableProperty)n.orientationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Control.getClassCssMetaData());
            styleables.add(CELL_SIZE);
            styleables.add(INDICATOR_SIZE);
            styleables.add(ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

