/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.math.BigInteger;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class AlphanumComparator
implements Comparator<CharSequence> {
    private final Collator collator;

    public AlphanumComparator(Locale locale) {
        this.collator = Collator.getInstance(locale);
    }

    private int findNextNumber(CharSequence s, int start) {
        while (start < s.length() && !Character.isDigit(s.charAt(start))) {
            ++start;
        }
        return start;
    }

    private int findNumberEnd(CharSequence s, int start) {
        while (start < s.length() && Character.isDigit(s.charAt(start))) {
            ++start;
        }
        return start;
    }

    @Override
    public int compare(CharSequence a, CharSequence b) {
        int lastEndA = 0;
        int lastEndB = 0;
        while (lastEndA < a.length() && lastEndB < b.length()) {
            Number ib;
            Number ia;
            int c;
            CharSequence subB;
            CharSequence subA;
            int c2;
            int startA = this.findNextNumber(a, lastEndA);
            int startB = this.findNextNumber(b, lastEndB);
            if (startA == a.length() || startB == b.length()) break;
            if ((lastEndA < startA || lastEndB < startB) && (c2 = this.collator.compare(subA = a.subSequence(lastEndA, startA), subB = b.subSequence(lastEndB, startB))) != 0) {
                return c2;
            }
            int endA = this.findNumberEnd(a, startA);
            int endB = this.findNumberEnd(b, startB);
            CharSequence subA2 = a.subSequence(startA, endA);
            CharSequence subB2 = b.subSequence(startB, endB);
            if (subA2.length() > 9 || subB2.length() > 9 ? (c = ((BigInteger)(ia = new BigInteger(subA2.toString()))).compareTo((BigInteger)(ib = new BigInteger(subB2.toString())))) != 0 : (c = ((Long)(ia = Long.valueOf(Long.parseLong(subA2.toString())))).compareTo((Long)(ib = Long.valueOf(Long.parseLong(subB2.toString()))))) != 0) {
                return c;
            }
            lastEndA = endA;
            lastEndB = endB;
        }
        if (lastEndA == 0 && lastEndB == 0) {
            return this.collator.compare(a, b);
        }
        if (lastEndA < a.length() || lastEndB < b.length()) {
            CharSequence subA = a.subSequence(lastEndA, a.length());
            CharSequence subB = b.subSequence(lastEndB, b.length());
            return this.collator.compare(subA, subB);
        }
        return 0;
    }
}

