/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeReference;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.CommonUtils;

public class ObjectListDialog<T extends DBPObject>
extends AbstractPopupPanel {
    private static final String DIALOG_ID = "DBeaver.SelectDatabaseObjectDialog";
    private String listId;
    private boolean singleSelection;
    protected List<T> objects;
    protected List<T> selectedObjects = new ArrayList<T>();
    protected DatabaseObjectListControl<T> objectList;

    public ObjectListDialog(Shell parentShell, String title, boolean singleSelection, String listId, Collection<T> objects, Collection<T> selected) {
        super(parentShell, title);
        this.singleSelection = singleSelection;
        this.listId = listId;
        this.objects = new ArrayList<T>(objects);
        if (selected != null) {
            this.selectedObjects.addAll(selected);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite group = super.createDialogArea(parent);
        group.setLayoutData((Object)new GridData(1808));
        this.createUpperControls(group);
        this.objectList = ObjectListDialog.createObjectSelector(group, this.singleSelection, this.listId, this.selectedObjects, false, new DBRRunnableWithResult<List<T>>(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = ObjectListDialog.this.getObjects(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        this.objectList.createProgressPanel();
        GridData gd = new GridData(1808);
        gd.minimumHeight = 300;
        gd.minimumWidth = 500;
        this.objectList.setLayoutData(gd);
        this.objectList.getSelectionProvider().addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.selectedObjects.clear();
            this.selectedObjects.addAll(selection.toList());
            if (!this.isModeless()) {
                this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
            }
        });
        this.objectList.setDoubleClickHandler(event -> {
            if (this.isModeless() || this.getButton(0).isEnabled()) {
                this.okPressed();
            }
        });
        this.objectList.loadData();
        this.closeOnFocusLost(new Control[]{this.objectList.getItemsViewer().getControl(), this.objectList.getSearchTextControl()});
        return group;
    }

    @NotNull
    protected static <T extends DBPObject> DatabaseObjectListControl<T> createObjectSelector(Composite group, boolean singleSelection, String listId, List<T> selectedObjects, DBRRunnableWithResult<List<T>> objectReader) {
        return ObjectListDialog.createObjectSelector(group, singleSelection, listId, selectedObjects, true, objectReader);
    }

    @NotNull
    private static <T extends DBPObject> DatabaseObjectListControl<T> createObjectSelector(Composite group, boolean singleSelection, String listId, List<T> selectedObjects, boolean isSetFocusAfterLoad, DBRRunnableWithResult<List<T>> objectReader) {
        return new DialogObjectListControl<T>(group, singleSelection, listId, objectReader, isSetFocusAfterLoad, selectedObjects);
    }

    protected List<T> getObjects(DBRProgressMonitor monitor) throws DBException {
        return this.objects;
    }

    protected void createUpperControls(Composite composite) {
    }

    public int open() {
        return super.open();
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        if (!this.isModeless()) {
            this.getButton(0).setEnabled(false);
        }
        return ctl;
    }

    public List<T> getSelectedObjects() {
        return this.selectedObjects;
    }

    public T getSelectedObject() {
        return (T)(this.selectedObjects.isEmpty() ? null : (DBPObject)this.selectedObjects.get(0));
    }

    public static <T extends DBPObject> T selectObject(Shell parentShell, String title, String listId, Collection<T> objects) {
        ObjectListDialog<T> scDialog = new ObjectListDialog<T>(parentShell, title, true, listId, objects, null);
        if (scDialog.open() == 0) {
            List<T> selectedObjects = scDialog.getSelectedObjects();
            return (T)(CommonUtils.isEmpty(selectedObjects) ? null : (DBPObject)selectedObjects.get(0));
        }
        return null;
    }

    private static class DialogObjectListControl<T extends DBPObject>
    extends DatabaseObjectListControl<T>
    implements DBNNodeReference {
        private final Composite group;
        private final String listId;
        private final DBRRunnableWithResult<List<T>> objectReader;
        private final boolean isSetFocusAfterLoad;
        private final List<T> selectedObjects;
        private Font boldFont;
        private final ISearchExecutor searcher;

        public DialogObjectListControl(Composite group, boolean singleSelection, String listId, DBRRunnableWithResult<List<T>> objectReader, boolean isSetFocusAfterLoad, List<T> selectedObjects) {
            super(group, singleSelection ? 4 : 2, null, (IContentProvider)new ListContentProvider());
            this.group = group;
            this.listId = listId;
            this.objectReader = objectReader;
            this.isSetFocusAfterLoad = isSetFocusAfterLoad;
            this.selectedObjects = selectedObjects;
            this.searcher = new ObjectListControl.SearcherFilter();
        }

        @Override
        @NotNull
        protected String getListConfigId(List<Class<?>> classList) {
            return this.listId;
        }

        @Override
        protected LoadingJob<Collection<T>> createLoadService(boolean forUpdate) {
            return LoadingJob.createService((ILoadService)new AbstractLoadService<Collection<T>>(){

                public Collection<T> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    objectReader.run(monitor);
                    return (Collection)objectReader.getResult();
                }

                public Object getFamily() {
                    return ObjectListDialog.class;
                }
            }, (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer(this){

                public void completeLoading(Collection<T> items) {
                    super.completeLoading(items);
                    this.performSearch(ISearchContextProvider.SearchType.NONE, false);
                    if (isSetFocusAfterLoad) {
                        this.getItemsViewer().getControl().setFocus();
                    }
                }
            });
        }

        @Override
        protected CellLabelProvider getColumnLabelProvider(ObjectListControl.ObjectColumn objectColumn) {
            return new ObjectLabelProvider(objectColumn);
        }

        @Override
        protected Object getObjectValue(@NotNull T item) {
            if (item instanceof DBSWrapper) {
                return ((DBSWrapper)item).getObject();
            }
            return super.getObjectValue(item);
        }

        @Override
        protected DBPImage getObjectImage(T item) {
            if (item instanceof DBNNode) {
                DBNNode node = (DBNNode)item;
                return node.getNodeIcon();
            }
            if (item instanceof DBPImageProvider) {
                DBPImageProvider imageProvider = (DBPImageProvider)item;
                return imageProvider.getObjectImage();
            }
            return null;
        }

        @Override
        protected void setListData(Collection<T> items, boolean append, boolean forUpdate) {
            super.setListData(items, append, forUpdate);
            if (this.selectedObjects != null) {
                this.getItemsViewer().setSelection((ISelection)new StructuredSelection(this.selectedObjects), true);
            }
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            this.addColumnConfigAction(contributionManager);
        }

        protected void addSearchAction(IContributionManager contributionManager) {
            contributionManager.add((IAction)new Action("Filter objects", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SEARCH)){

                public void run() {
                    this.performSearch(ISearchContextProvider.SearchType.NONE);
                }
            });
        }

        protected ISearchExecutor getSearchRunner() {
            return this.searcher;
        }

        public DBNNode getReferencedNode() {
            DBNNode node;
            DBPObject dBPObject;
            return this.selectedObjects.isEmpty() ? null : ((dBPObject = (DBPObject)this.selectedObjects.get(0)) instanceof DBNNode ? (node = (DBNNode)dBPObject) : null);
        }

        class ObjectLabelProvider
        extends ObjectListControl.ObjectColumnLabelProvider
        implements IFontProvider {
            ObjectLabelProvider(ObjectListControl.ObjectColumn objectColumn) {
                super(objectColumn);
            }

            public Font getFont(Object element) {
                if (DialogObjectListControl.this.selectedObjects.contains(element)) {
                    if (DialogObjectListControl.this.boldFont == null) {
                        DialogObjectListControl.this.boldFont = UIUtils.makeBoldFont((Font)DialogObjectListControl.this.group.getFont());
                        DialogObjectListControl.this.group.addDisposeListener(e -> DialogObjectListControl.this.boldFont.dispose());
                    }
                    return DialogObjectListControl.this.boldFont;
                }
                return null;
            }
        }
    }
}

