package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrafficMirrorSessionAttribute invokes the vpc.UpdateTrafficMirrorSessionAttribute API synchronously
func (client *Client) UpdateTrafficMirrorSessionAttribute(request *UpdateTrafficMirrorSessionAttributeRequest) (response *UpdateTrafficMirrorSessionAttributeResponse, err error) {
	response = CreateUpdateTrafficMirrorSessionAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrafficMirrorSessionAttributeWithChan invokes the vpc.UpdateTrafficMirrorSessionAttribute API asynchronously
func (client *Client) UpdateTrafficMirrorSessionAttributeWithChan(request *UpdateTrafficMirrorSessionAttributeRequest) (<-chan *UpdateTrafficMirrorSessionAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateTrafficMirrorSessionAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrafficMirrorSessionAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrafficMirrorSessionAttributeWithCallback invokes the vpc.UpdateTrafficMirrorSessionAttribute API asynchronously
func (client *Client) UpdateTrafficMirrorSessionAttributeWithCallback(request *UpdateTrafficMirrorSessionAttributeRequest, callback func(response *UpdateTrafficMirrorSessionAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrafficMirrorSessionAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrafficMirrorSessionAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrafficMirrorSessionAttributeRequest is the request struct for api UpdateTrafficMirrorSessionAttribute
type UpdateTrafficMirrorSessionAttributeRequest struct {
	*requests.RpcRequest
	TrafficMirrorTargetType         string           `position:"Query" name:"TrafficMirrorTargetType"`
	ResourceOwnerId                 requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                     string           `position:"Query" name:"ClientToken"`
	Enabled                         requests.Boolean `position:"Query" name:"Enabled"`
	TrafficMirrorSessionName        string           `position:"Query" name:"TrafficMirrorSessionName"`
	TrafficMirrorSessionDescription string           `position:"Query" name:"TrafficMirrorSessionDescription"`
	DryRun                          requests.Boolean `position:"Query" name:"DryRun"`
	TrafficMirrorSessionId          string           `position:"Query" name:"TrafficMirrorSessionId"`
	ResourceOwnerAccount            string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                    string           `position:"Query" name:"OwnerAccount"`
	Priority                        requests.Integer `position:"Query" name:"Priority"`
	OwnerId                         requests.Integer `position:"Query" name:"OwnerId"`
	TrafficMirrorTargetId           string           `position:"Query" name:"TrafficMirrorTargetId"`
	TrafficMirrorFilterId           string           `position:"Query" name:"TrafficMirrorFilterId"`
	VirtualNetworkId                requests.Integer `position:"Query" name:"VirtualNetworkId"`
}

// UpdateTrafficMirrorSessionAttributeResponse is the response struct for api UpdateTrafficMirrorSessionAttribute
type UpdateTrafficMirrorSessionAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTrafficMirrorSessionAttributeRequest creates a request to invoke UpdateTrafficMirrorSessionAttribute API
func CreateUpdateTrafficMirrorSessionAttributeRequest() (request *UpdateTrafficMirrorSessionAttributeRequest) {
	request = &UpdateTrafficMirrorSessionAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateTrafficMirrorSessionAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTrafficMirrorSessionAttributeResponse creates a response to parse from UpdateTrafficMirrorSessionAttribute response
func CreateUpdateTrafficMirrorSessionAttributeResponse() (response *UpdateTrafficMirrorSessionAttributeResponse) {
	response = &UpdateTrafficMirrorSessionAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
