package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSmarttagTemplate invokes the mts.DeleteSmarttagTemplate API synchronously
func (client *Client) DeleteSmarttagTemplate(request *DeleteSmarttagTemplateRequest) (response *DeleteSmarttagTemplateResponse, err error) {
	response = CreateDeleteSmarttagTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSmarttagTemplateWithChan invokes the mts.DeleteSmarttagTemplate API asynchronously
func (client *Client) DeleteSmarttagTemplateWithChan(request *DeleteSmarttagTemplateRequest) (<-chan *DeleteSmarttagTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteSmarttagTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSmarttagTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSmarttagTemplateWithCallback invokes the mts.DeleteSmarttagTemplate API asynchronously
func (client *Client) DeleteSmarttagTemplateWithCallback(request *DeleteSmarttagTemplateRequest, callback func(response *DeleteSmarttagTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSmarttagTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteSmarttagTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSmarttagTemplateRequest is the request struct for api DeleteSmarttagTemplate
type DeleteSmarttagTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId           string           `position:"Query" name:"TemplateId"`
}

// DeleteSmarttagTemplateResponse is the response struct for api DeleteSmarttagTemplate
type DeleteSmarttagTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSmarttagTemplateRequest creates a request to invoke DeleteSmarttagTemplate API
func CreateDeleteSmarttagTemplateRequest() (request *DeleteSmarttagTemplateRequest) {
	request = &DeleteSmarttagTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "DeleteSmarttagTemplate", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSmarttagTemplateResponse creates a response to parse from DeleteSmarttagTemplate response
func CreateDeleteSmarttagTemplateResponse() (response *DeleteSmarttagTemplateResponse) {
	response = &DeleteSmarttagTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
