package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBodyPerson invokes the facebody.DeleteBodyPerson API synchronously
func (client *Client) DeleteBodyPerson(request *DeleteBodyPersonRequest) (response *DeleteBodyPersonResponse, err error) {
	response = CreateDeleteBodyPersonResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBodyPersonWithChan invokes the facebody.DeleteBodyPerson API asynchronously
func (client *Client) DeleteBodyPersonWithChan(request *DeleteBodyPersonRequest) (<-chan *DeleteBodyPersonResponse, <-chan error) {
	responseChan := make(chan *DeleteBodyPersonResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBodyPerson(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBodyPersonWithCallback invokes the facebody.DeleteBodyPerson API asynchronously
func (client *Client) DeleteBodyPersonWithCallback(request *DeleteBodyPersonRequest, callback func(response *DeleteBodyPersonResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBodyPersonResponse
		var err error
		defer close(result)
		response, err = client.DeleteBodyPerson(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBodyPersonRequest is the request struct for api DeleteBodyPerson
type DeleteBodyPersonRequest struct {
	*requests.RpcRequest
	PersonId requests.Integer `position:"Body" name:"PersonId"`
	DbId     requests.Integer `position:"Body" name:"DbId"`
}

// DeleteBodyPersonResponse is the response struct for api DeleteBodyPerson
type DeleteBodyPersonResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateDeleteBodyPersonRequest creates a request to invoke DeleteBodyPerson API
func CreateDeleteBodyPersonRequest() (request *DeleteBodyPersonRequest) {
	request = &DeleteBodyPersonRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DeleteBodyPerson", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteBodyPersonResponse creates a response to parse from DeleteBodyPerson response
func CreateDeleteBodyPersonResponse() (response *DeleteBodyPersonResponse) {
	response = &DeleteBodyPersonResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
