package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstance invokes the elasticsearch.ListInstance API synchronously
func (client *Client) ListInstance(request *ListInstanceRequest) (response *ListInstanceResponse, err error) {
	response = CreateListInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceWithChan invokes the elasticsearch.ListInstance API asynchronously
func (client *Client) ListInstanceWithChan(request *ListInstanceRequest) (<-chan *ListInstanceResponse, <-chan error) {
	responseChan := make(chan *ListInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceWithCallback invokes the elasticsearch.ListInstance API asynchronously
func (client *Client) ListInstanceWithCallback(request *ListInstanceRequest, callback func(response *ListInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceResponse
		var err error
		defer close(result)
		response, err = client.ListInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceRequest is the request struct for api ListInstance
type ListInstanceRequest struct {
	*requests.RoaRequest
	Description      string           `position:"Query" name:"description"`
	InstanceCategory string           `position:"Query" name:"instanceCategory"`
	Tags             string           `position:"Query" name:"tags"`
	ResourceGroupId  string           `position:"Query" name:"resourceGroupId"`
	InstanceId       string           `position:"Query" name:"instanceId"`
	Size             requests.Integer `position:"Query" name:"size"`
	EsVersion        string           `position:"Query" name:"esVersion"`
	VpcId            string           `position:"Query" name:"vpcId"`
	ZoneId           string           `position:"Query" name:"zoneId"`
	Page             requests.Integer `position:"Query" name:"page"`
	PaymentType      string           `position:"Query" name:"paymentType"`
}

// ListInstanceResponse is the response struct for api ListInstance
type ListInstanceResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Headers   Headers    `json:"Headers" xml:"Headers"`
	Result    []Instance `json:"Result" xml:"Result"`
}

// CreateListInstanceRequest creates a request to invoke ListInstance API
func CreateListInstanceRequest() (request *ListInstanceRequest) {
	request = &ListInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListInstance", "/openapi/instances", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListInstanceResponse creates a response to parse from ListInstance response
func CreateListInstanceResponse() (response *ListInstanceResponse) {
	response = &ListInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
