package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySqlAnalysisData invokes the das.QuerySqlAnalysisData API synchronously
func (client *Client) QuerySqlAnalysisData(request *QuerySqlAnalysisDataRequest) (response *QuerySqlAnalysisDataResponse, err error) {
	response = CreateQuerySqlAnalysisDataResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySqlAnalysisDataWithChan invokes the das.QuerySqlAnalysisData API asynchronously
func (client *Client) QuerySqlAnalysisDataWithChan(request *QuerySqlAnalysisDataRequest) (<-chan *QuerySqlAnalysisDataResponse, <-chan error) {
	responseChan := make(chan *QuerySqlAnalysisDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySqlAnalysisData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySqlAnalysisDataWithCallback invokes the das.QuerySqlAnalysisData API asynchronously
func (client *Client) QuerySqlAnalysisDataWithCallback(request *QuerySqlAnalysisDataRequest, callback func(response *QuerySqlAnalysisDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySqlAnalysisDataResponse
		var err error
		defer close(result)
		response, err = client.QuerySqlAnalysisData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySqlAnalysisDataRequest is the request struct for api QuerySqlAnalysisData
type QuerySqlAnalysisDataRequest struct {
	*requests.RpcRequest
	ConsoleContext string           `position:"Query" name:"ConsoleContext"`
	TaskId         string           `position:"Body" name:"TaskId"`
	SqlIdList      string           `position:"Body" name:"SqlIdList"`
	Type           string           `position:"Body" name:"Type"`
	SqlTextFeature string           `position:"Body" name:"SqlTextFeature"`
	SqlType        string           `position:"Body" name:"SqlType"`
	PageNo         requests.Integer `position:"Body" name:"PageNo"`
	PageSize       requests.Integer `position:"Body" name:"PageSize"`
}

// QuerySqlAnalysisDataResponse is the response struct for api QuerySqlAnalysisData
type QuerySqlAnalysisDataResponse struct {
	*responses.BaseResponse
	Message   string                     `json:"Message" xml:"Message"`
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Code      int64                      `json:"Code" xml:"Code"`
	Success   bool                       `json:"Success" xml:"Success"`
	Data      DataInQuerySqlAnalysisData `json:"Data" xml:"Data"`
}

// CreateQuerySqlAnalysisDataRequest creates a request to invoke QuerySqlAnalysisData API
func CreateQuerySqlAnalysisDataRequest() (request *QuerySqlAnalysisDataRequest) {
	request = &QuerySqlAnalysisDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "QuerySqlAnalysisData", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySqlAnalysisDataResponse creates a response to parse from QuerySqlAnalysisData response
func CreateQuerySqlAnalysisDataResponse() (response *QuerySqlAnalysisDataResponse) {
	response = &QuerySqlAnalysisDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
