/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.MutableType;
import net.sf.hibernate.type.SerializationException;
import org.apache.commons.lang.SerializationUtils;

public class SerializableType
extends MutableType {
    private final Class serializableClass;
    static /* synthetic */ Class class$java$io$Serializable;

    public SerializableType(Class serializableClass) {
        this.serializableClass = serializableClass;
    }

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        Hibernate.BINARY.set(st, this.toBytes(value), index);
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        byte[] bytes = (byte[])Hibernate.BINARY.get(rs, name);
        if (bytes == null) {
            return null;
        }
        return this.fromBytes(bytes);
    }

    public Class getReturnedClass() {
        return this.serializableClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return Hibernate.BINARY.equals(this.toBytes(x), this.toBytes(y));
    }

    public String toXML(Object value) throws HibernateException {
        return value == null ? null : Hibernate.BINARY.toXML(this.toBytes(value));
    }

    public String getName() {
        return this.serializableClass == (class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableType.class$("java.io.Serializable")) : class$java$io$Serializable) ? "serializable" : this.serializableClass.getName();
    }

    public Object deepCopyNotNull(Object value) throws HibernateException {
        return this.fromBytes(this.toBytes(value));
    }

    private byte[] toBytes(Object object) throws SerializationException {
        try {
            return SerializationUtils.serialize((Serializable)((Serializable)object));
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize a serializable property: ", e);
        }
    }

    private Object fromBytes(byte[] bytes) throws SerializationException {
        try {
            return SerializationUtils.deserialize((byte[])bytes);
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize a serializable property: ", e);
        }
    }

    public int sqlType() {
        return Hibernate.BINARY.sqlType();
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return cached == null ? null : this.fromBytes((byte[])cached);
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return value == null ? null : this.toBytes(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

