// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies a page-level location within a document, providing positioning information for cited content using page numbers.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DocumentPageLocation {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub document_index: ::std::option::Option<i32>,
    /// <p>The starting page number of the cited content within the document.</p>
    pub start: ::std::option::Option<i32>,
    /// <p>The ending page number of the cited content within the document.</p>
    pub end: ::std::option::Option<i32>,
}
impl DocumentPageLocation {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn document_index(&self) -> ::std::option::Option<i32> {
        self.document_index
    }
    /// <p>The starting page number of the cited content within the document.</p>
    pub fn start(&self) -> ::std::option::Option<i32> {
        self.start
    }
    /// <p>The ending page number of the cited content within the document.</p>
    pub fn end(&self) -> ::std::option::Option<i32> {
        self.end
    }
}
impl DocumentPageLocation {
    /// Creates a new builder-style object to manufacture [`DocumentPageLocation`](crate::types::DocumentPageLocation).
    pub fn builder() -> crate::types::builders::DocumentPageLocationBuilder {
        crate::types::builders::DocumentPageLocationBuilder::default()
    }
}

/// A builder for [`DocumentPageLocation`](crate::types::DocumentPageLocation).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DocumentPageLocationBuilder {
    pub(crate) document_index: ::std::option::Option<i32>,
    pub(crate) start: ::std::option::Option<i32>,
    pub(crate) end: ::std::option::Option<i32>,
}
impl DocumentPageLocationBuilder {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn document_index(mut self, input: i32) -> Self {
        self.document_index = ::std::option::Option::Some(input);
        self
    }
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn set_document_index(mut self, input: ::std::option::Option<i32>) -> Self {
        self.document_index = input;
        self
    }
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn get_document_index(&self) -> &::std::option::Option<i32> {
        &self.document_index
    }
    /// <p>The starting page number of the cited content within the document.</p>
    pub fn start(mut self, input: i32) -> Self {
        self.start = ::std::option::Option::Some(input);
        self
    }
    /// <p>The starting page number of the cited content within the document.</p>
    pub fn set_start(mut self, input: ::std::option::Option<i32>) -> Self {
        self.start = input;
        self
    }
    /// <p>The starting page number of the cited content within the document.</p>
    pub fn get_start(&self) -> &::std::option::Option<i32> {
        &self.start
    }
    /// <p>The ending page number of the cited content within the document.</p>
    pub fn end(mut self, input: i32) -> Self {
        self.end = ::std::option::Option::Some(input);
        self
    }
    /// <p>The ending page number of the cited content within the document.</p>
    pub fn set_end(mut self, input: ::std::option::Option<i32>) -> Self {
        self.end = input;
        self
    }
    /// <p>The ending page number of the cited content within the document.</p>
    pub fn get_end(&self) -> &::std::option::Option<i32> {
        &self.end
    }
    /// Consumes the builder and constructs a [`DocumentPageLocation`](crate::types::DocumentPageLocation).
    pub fn build(self) -> crate::types::DocumentPageLocation {
        crate::types::DocumentPageLocation {
            document_index: self.document_index,
            start: self.start,
            end: self.end,
        }
    }
}
