/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.BorderData;
import org.eclipse.swt.layout.BorderLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionContext;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionHelper;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryObjectDataModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.ui.AbstractPartListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;
import org.jkiss.dbeaver.ui.editors.sql.util.AnnotationsInformationView;
import org.jkiss.dbeaver.ui.editors.sql.util.ObjectInformationView;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLAnnotationHover;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLInformationProvider
implements IInformationProvider,
IInformationProviderExtension,
IInformationProviderExtension2 {
    private static final Set<SQLQuerySymbolClass> ignoredSymbolClassDescription = Set.of(SQLQuerySymbolClass.ERROR, SQLQuerySymbolClass.UNKNOWN, SQLQuerySymbolClass.QUOTED);
    protected SQLEditorBase editor;
    private final SQLContextInformer contextInformer;
    private IPartListener partListener;
    private String currentPerspective;
    @NotNull
    protected SQLAnnotationHover annotationHover;
    private IInformationControlCreator informationControlCreator;

    public SQLInformationProvider(@NotNull SQLEditorBase editor, @NotNull SQLContextInformer contextInformer) {
        this.editor = editor;
        this.contextInformer = contextInformer;
        this.annotationHover = new SQLAnnotationHover(editor);
        if (this.editor instanceof SQLEditor) {
            this.partListener = new EditorWatcher();
            IWorkbenchWindow window = this.editor.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener(this.partListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor perspective;
        IWorkbenchWindow window = this.editor.getSite().getWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            String perspectiveId = perspective.getId();
            if (this.currentPerspective == null || !this.currentPerspective.equals(perspectiveId)) {
                this.currentPerspective = perspectiveId;
                this.annotationHover.setEditor((IEditorPart)this.editor);
            }
        }
    }

    public IRegion getSubject(@NotNull ITextViewer textViewer, int offset) {
        Point selectedRange = textViewer.getSelectedRange();
        IRegion hoverRegion = this.annotationHover.getHoverRegion(textViewer, offset);
        SQLDocumentSyntaxContext context = this.editor.getSyntaxContext();
        SQLQuerySymbolEntry symbolEntry = context == null ? null : context.findToken(offset);
        Region symbolRegion = symbolEntry == null ? null : new Region(context.getLastAccessedTokenOffset(), symbolEntry.getInterval().length());
        this.contextInformer.searchInformation((IRegion)new Region(offset, 0));
        SQLIdentifierDetector.WordRegion wordRegion = this.contextInformer.getWordRegion();
        return new SubjectRegion((IRegion)(selectedRange.y > 1 ? new Region(selectedRange.x, selectedRange.y) : null), hoverRegion, symbolEntry, (IRegion)symbolRegion, wordRegion == null || wordRegion.isEmpty() ? null : wordRegion);
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        Object information = this.getInformation2(textViewer, subject);
        return information == null ? null : information.toString();
    }

    public Object getInformation2(@NotNull ITextViewer textViewer, @NotNull IRegion subject) {
        Object info;
        Object message;
        AnnotationsInformationView.AnnotationsHoverInfo annotationsInfo;
        SubjectRegion subjectRegion;
        if (subject instanceof SubjectRegion && (subjectRegion = (SubjectRegion)subject).isEmpty()) {
            return null;
        }
        if (subject instanceof SubjectRegion) {
            SubjectRegion subjectRegion2 = (SubjectRegion)subject;
            AnnotationsInformationView.AnnotationsHoverInfo annotationsHoverInfo = annotationsInfo = subjectRegion2.hoverRegion != null && (subjectRegion2.selectionRegion == null || SQLInformationProvider.equalRegions(subjectRegion2.hoverRegion, subjectRegion2.selectionRegion)) ? this.annotationHover.getAnnotationsHoverInfo(textViewer, subjectRegion2.hoverRegion, null, true) : null;
            if (subjectRegion2.symbolEntry != null && (subjectRegion2.selectionRegion == null || SQLInformationProvider.equalRegions(subjectRegion2.symbolRegion, subjectRegion2.selectionRegion))) {
                DBSObject dbObject;
                SQLQuerySymbolDefinition sQLQuerySymbolDefinition;
                SQLQuerySymbolEntry symbolEntry = subjectRegion2.symbolEntry;
                while ((sQLQuerySymbolDefinition = symbolEntry.getDefinition()) instanceof SQLQuerySymbolEntry) {
                    SQLQuerySymbolEntry def = (SQLQuerySymbolEntry)sQLQuerySymbolDefinition;
                    if (symbolEntry.getDefinition() == def) break;
                    symbolEntry = def;
                }
                SQLQuerySymbolDefinition sQLQuerySymbolDefinition2 = symbolEntry.getDefinition();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SQLQueryObjectDataModel.class, SQLQuerySymbolByDbObjectDefinition.class, SQLQueryRowsTableDataModel.class, SQLQueryResultPseudoColumn.class, SQLQuerySymbolEntry.class}, (Object)sQLQuerySymbolDefinition2, n)) {
                    case 0: {
                        SQLQueryObjectDataModel byObjDataRefDef = (SQLQueryObjectDataModel)sQLQuerySymbolDefinition2;
                        dbObject = byObjDataRefDef.getObject();
                        break;
                    }
                    case 1: {
                        SQLQuerySymbolByDbObjectDefinition byObjDef = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition2;
                        dbObject = byObjDef.getDbObject();
                        break;
                    }
                    case 2: {
                        SQLQueryRowsTableDataModel byTableRefDef = (SQLQueryRowsTableDataModel)sQLQuerySymbolDefinition2;
                        dbObject = byTableRefDef.getImmediateTargetObject();
                        break;
                    }
                    case 3: {
                        SQLQueryResultPseudoColumn pseudoColumn = (SQLQueryResultPseudoColumn)sQLQuerySymbolDefinition2;
                        dbObject = null;
                        message = pseudoColumn.description + "\nPseudo-column" + (String)(pseudoColumn.source == null ? "" : " derived from the " + (pseudoColumn.realSource == null ? "query part: \n" + pseudoColumn.source.getSyntaxNode().getTextContent() : pseudoColumn.realSource.getName() + SQLQuerySemanticUtils.getObjectTypeName((DBSObject)pseudoColumn.realSource)));
                        break;
                    }
                    case 4: {
                        SQLQuerySymbolEntry defSymbolEntry = (SQLQuerySymbolEntry)sQLQuerySymbolDefinition2;
                        dbObject = null;
                        break;
                    }
                    case -1: {
                        dbObject = null;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not implemented");
                    }
                }
                if (dbObject != null) {
                    info = dbObject;
                    DBNModel navModel = dbObject.getDataSource().getContainer().getProject().getNavigatorModel();
                    if (navModel != null) {
                        navModel.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), dbObject, true);
                    }
                    message = null;
                } else {
                    info = null;
                    message = SQLCompletionHelper.readAdditionalProposalInfo(null, (SQLCompletionContext)this.editor.getCompletionContext(), (DBPNamedObject)dbObject, (String[])this.contextInformer.getKeywords(), (DBPKeywordType)this.contextInformer.getKeywordType());
                }
                if (message == null || ((String)message).equals(symbolEntry.getRawName()) || this.contextInformer.getKeywords().length > 0 && ((String)message).equals(this.contextInformer.getKeywords()[0])) {
                    message = ignoredSymbolClassDescription.contains(symbolEntry.getSymbolClass()) ? null : symbolEntry.getSymbolClass().getDescription();
                }
            } else {
                info = this.prepareInformerAdditionalInfo();
                message = null;
            }
        } else {
            annotationsInfo = this.annotationHover.getAnnotationsHoverInfo(textViewer, subject, null, true);
            this.contextInformer.searchInformation(subject);
            info = this.prepareInformerAdditionalInfo();
            message = null;
        }
        if (info instanceof String) {
            String text = (String)info;
            message = text;
            info = null;
        }
        if (annotationsInfo == null) {
            annotationsInfo = new AnnotationsInformationView.AnnotationsHoverInfo(Collections.emptyList(), subject, -1);
        }
        return new SubjectInformation(annotationsInfo, (String)message, info);
    }

    @Nullable
    private Object prepareInformerAdditionalInfo() {
        DBSObject object = null;
        if (this.contextInformer.hasObjects() && this.contextInformer.getKeywordType() != DBPKeywordType.KEYWORD) {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            DBSObjectReference objectRef = this.contextInformer.getObjectReferences().getFirst();
            try {
                object = objectRef.resolveObject((DBRProgressMonitor)monitor);
            }
            catch (DBException e) {
                return e.getMessage();
            }
        } else if (ArrayUtils.isEmpty((Object[])this.contextInformer.getKeywords())) {
            return null;
        }
        if (object != null) {
            DBNModel navModel = object.getDataSource().getContainer().getProject().getNavigatorModel();
            if (navModel != null) {
                navModel.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), object, true);
            }
            return object;
        }
        String info = SQLCompletionHelper.readAdditionalProposalInfo(null, (SQLCompletionContext)this.editor.getCompletionContext(), object, (String[])this.contextInformer.getKeywords(), (DBPKeywordType)this.contextInformer.getKeywordType());
        if (info == null || this.contextInformer.getKeywords().length > 0 && info.equals(this.contextInformer.getKeywords()[0])) {
            DBPKeywordType keywordType = this.contextInformer.getKeywordType();
            if (keywordType != null) {
                info = switch (keywordType) {
                    case DBPKeywordType.KEYWORD -> "Keyword";
                    case DBPKeywordType.FUNCTION -> "Function";
                    default -> null;
                };
            } else {
                info = null;
            }
        }
        return info;
    }

    @NotNull
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.informationControlCreator == null) {
            this.informationControlCreator = shell -> new SQLSymbolInformationControl(shell);
        }
        return this.informationControlCreator;
    }

    private static boolean equalRegions(@NotNull IRegion a, @NotNull IRegion b) {
        return a.getOffset() == b.getOffset() && a.getLength() == b.getLength();
    }

    class EditorWatcher
    extends AbstractPartListener {
        EditorWatcher() {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == SQLInformationProvider.this.editor) {
                SQLInformationProvider.this.editor.getSite().getWorkbenchWindow().getPartService().removePartListener(SQLInformationProvider.this.partListener);
                SQLInformationProvider.this.partListener = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            SQLInformationProvider.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            SQLInformationProvider.this.update();
        }
    }

    private class SQLSymbolInformationControl
    extends DefaultInformationControl
    implements IInformationControlExtension2 {
        private Composite contentParent;
        private AnnotationsInformationView annotationsInfoView;
        private ObjectInformationView objectInformationView;
        private Boolean hasContents;

        public SQLSymbolInformationControl(Shell shell) {
            super(shell, true);
            this.hasContents = null;
        }

        protected void createContent(@NotNull Composite parent) {
            this.contentParent = parent;
            super.createContent(parent);
            BorderLayout layout = new BorderLayout();
            parent.setLayout((Layout)layout);
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setLayoutData((Object)new BorderData(0x1000000));
                ++n2;
            }
            parent.getShell().setMinimumSize(this.computeSizeConstraints(60, 6));
            this.annotationsInfoView = new AnnotationsInformationView((AbstractInformationControl)this, SQLInformationProvider.this.editor);
            this.annotationsInfoView.setForceAnnotationIcon(true);
            this.annotationsInfoView.createControl(parent).setLayoutData((Object)new BorderData(128));
        }

        public boolean hasContents() {
            return this.hasContents != null ? this.hasContents.booleanValue() : super.hasContents();
        }

        public void setInput(@NotNull Object input) {
            if (input instanceof SubjectInformation) {
                SubjectInformation info = (SubjectInformation)input;
                this.annotationsInfoView.setLinksInformation(info.annotationsInfo);
                this.hasContents = !info.annotationsInfo.annotationsGroups().isEmpty();
                if (info.info instanceof DBPNamedObject) {
                    DBPNamedObject object = (DBPNamedObject)info.info;
                    this.objectInformationView = new ObjectInformationView();
                    this.objectInformationView.createContent(this.contentParent).setLayoutData((Object)new BorderData(0x1000000));
                    this.objectInformationView.setInput(object);
                    this.hasContents = true;
                    this.setInformation(null);
                }
                this.setInformation(info.message);
                this.hasContents = this.hasContents | CommonUtils.isNotEmpty((String)info.message);
            } else {
                super.setInformation(CommonUtils.toString((Object)input));
            }
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.annotationsInfoView.show();
            }
            super.setVisible(visible);
        }
    }

    private record SubjectInformation(@NotNull AnnotationsInformationView.AnnotationsHoverInfo annotationsInfo, @Nullable String message, @Nullable Object info) {
    }

    private record SubjectRegion(@Nullable IRegion selectionRegion, @Nullable IRegion hoverRegion, @Nullable SQLQuerySymbolEntry symbolEntry, @Nullable IRegion symbolRegion, @Nullable SQLIdentifierDetector.WordRegion wordRegion) implements IRegion
    {
        public boolean isEmpty() {
            return this.selectionRegion == null && this.hoverRegion == null && this.symbolEntry == null && this.symbolRegion == null && this.wordRegion == null;
        }

        public int getLength() {
            return IntStream.of(this.selectionRegion == null ? Integer.MIN_VALUE : this.selectionRegion.getOffset() + this.selectionRegion.getLength(), this.hoverRegion == null ? Integer.MIN_VALUE : this.hoverRegion.getOffset() + this.hoverRegion.getLength(), this.symbolRegion == null ? Integer.MIN_VALUE : this.symbolRegion.getOffset() + this.symbolRegion.getLength(), this.wordRegion == null ? Integer.MIN_VALUE : this.wordRegion.identEnd).max().orElse(Integer.MIN_VALUE) - this.getOffset();
        }

        public int getOffset() {
            return IntStream.of(this.selectionRegion == null ? Integer.MAX_VALUE : this.selectionRegion.getOffset(), this.hoverRegion == null ? Integer.MAX_VALUE : this.hoverRegion.getOffset(), this.symbolRegion == null ? Integer.MAX_VALUE : this.symbolRegion.getOffset(), this.wordRegion == null ? Integer.MAX_VALUE : this.wordRegion.identStart).min().orElse(Integer.MAX_VALUE);
        }
    }
}

