/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.handlers.WidgetMethodHandler;

public class TraversePageHandler
extends WidgetMethodHandler {
    private static final Class<?>[] METHOD_PARAMETERS = new Class[]{Integer.TYPE};

    @Override
    public final Object execute(ExecutionEvent event) {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl != null) {
            boolean forward = "next".equals(this.methodName);
            int traversalDirection = this.translateToTraversalDirection(forward);
            Control control = focusControl;
            do {
                CTabFolder folder;
                if (control instanceof CTabFolder && this.isFinalItemInCTabFolder(folder = (CTabFolder)control, forward) && !this.hasHiddenItem(folder)) {
                    this.loopToFirstOrLastItem(folder, forward);
                    traversalDirection = this.translateToTraversalDirection(!forward);
                }
                if (control.traverse(traversalDirection)) {
                    return null;
                }
                if (!(control instanceof Shell)) continue;
                return null;
            } while ((control = control.getParent()) != null);
        }
        return null;
    }

    private boolean hasHiddenItem(CTabFolder folder) {
        return Arrays.stream(folder.getItems()).anyMatch(i -> !i.isShowing());
    }

    private int translateToTraversalDirection(boolean forward) {
        return forward ? 512 : 256;
    }

    private void loopToFirstOrLastItem(CTabFolder folder, boolean forward) {
        if (forward) {
            folder.showItem(folder.getItem(0));
            folder.setSelection(1);
        } else {
            int itemCount = folder.getItemCount();
            folder.setSelection(itemCount - 2);
        }
    }

    private boolean isFinalItemInCTabFolder(CTabFolder folder, boolean forward) {
        CTabItem currentFolder = folder.getSelection();
        CTabItem lastFolder = null;
        if (forward) {
            int itemCount = folder.getItemCount();
            lastFolder = folder.getItem(itemCount - 1);
        } else {
            lastFolder = folder.getItem(0);
        }
        return currentFolder.equals(lastFolder);
    }

    @Override
    protected Method getMethodToExecute() {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl != null) {
            try {
                return focusControl.getClass().getMethod("traverse", METHOD_PARAMETERS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

